/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.java.JavaObject;
import com.oracle.truffle.api.interop.java.MapRemoveNodeGen;
import com.oracle.truffle.api.nodes.Node;
import java.util.Map;

abstract class MapRemoveNode
extends Node {
    MapRemoveNode() {
    }

    protected abstract Object executeWithTarget(JavaObject var1, String var2);

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"isMap(receiver)"})
    protected Object doMapGeneric(JavaObject receiver, String name) {
        Map map = (Map)receiver.obj;
        if (!map.containsKey(name)) {
            throw UnknownIdentifierException.raise(name);
        }
        map.remove(name);
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"!isMap(receiver)"})
    protected static Object notMap(JavaObject receiver, String name) {
        throw UnsupportedMessageException.raise(Message.REMOVE);
    }

    static boolean isMap(JavaObject receiver) {
        return receiver.obj instanceof Map;
    }

    static MapRemoveNode create() {
        return MapRemoveNodeGen.create();
    }
}

