/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.java.JavaObject;
import com.oracle.truffle.api.interop.java.MapRemoveNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=MapRemoveNode.class)
final class MapRemoveNodeGen
extends MapRemoveNode {
    @CompilerDirectives.CompilationFinal
    private int state_;

    private MapRemoveNodeGen() {
    }

    @Override
    protected Object executeWithTarget(JavaObject arg0Value, String arg1Value) {
        int state = this.state_;
        if (state != 0) {
            if ((state & 1) != 0 && MapRemoveNode.isMap(arg0Value)) {
                return this.doMapGeneric(arg0Value, arg1Value);
            }
            if ((state & 2) != 0 && !MapRemoveNode.isMap(arg0Value)) {
                return MapRemoveNode.notMap(arg0Value, arg1Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value);
    }

    private Object executeAndSpecialize(JavaObject arg0Value, String arg1Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            if (MapRemoveNode.isMap(arg0Value)) {
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                Object object = this.doMapGeneric(arg0Value, arg1Value);
                return object;
            }
            if (!MapRemoveNode.isMap(arg0Value)) {
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                Object object = MapRemoveNode.notMap(arg0Value, arg1Value);
                return object;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new UnsupportedSpecializationException(this, new Node[]{null, null}, arg0Value, arg1Value);
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static MapRemoveNode create() {
        return new MapRemoveNodeGen();
    }
}

