/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.interop.java.JavaMethodDesc;
import com.oracle.truffle.api.interop.java.SingleMethodDesc;
import java.util.StringJoiner;

class OverloadedMethodDesc
implements JavaMethodDesc {
    private final SingleMethodDesc[] overloads;

    OverloadedMethodDesc(SingleMethodDesc[] overloads) {
        this.overloads = overloads;
        assert (overloads.length >= 2);
    }

    public SingleMethodDesc[] getOverloads() {
        return this.overloads;
    }

    @Override
    public String getName() {
        return this.getOverloads()[0].getName();
    }

    @Override
    public boolean isMethod() {
        return this.getOverloads()[0].isMethod();
    }

    @Override
    public boolean isConstructor() {
        return this.getOverloads()[0].isConstructor();
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(", ", "Method[", "]");
        for (SingleMethodDesc overload : this.getOverloads()) {
            sj.add(overload.getReflectionMethod().toString());
        }
        return sj.toString();
    }

    @Override
    public boolean isInternal() {
        for (SingleMethodDesc overload : this.overloads) {
            if (overload.isInternal()) continue;
            return false;
        }
        return true;
    }
}

