/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.KeyInfo;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.interop.java.JavaInteropErrors;
import com.oracle.truffle.api.interop.java.JavaInteropReflect;
import com.oracle.truffle.api.interop.java.MethodMessage;
import com.oracle.truffle.api.interop.java.ToJavaNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

@ImportStatic(value={Message.class, JavaInteropReflect.class})
abstract class ProxyInvokeNode
extends Node {
    protected static final int LIMIT = Integer.MAX_VALUE;
    @CompilerDirectives.CompilationFinal
    private boolean invokeFailed;

    ProxyInvokeNode() {
    }

    public abstract Object execute(Object var1, TruffleObject var2, Method var3, Object[] var4);

    @Specialization(guards={"cachedMethod.equals(method)"}, limit="LIMIT")
    protected Object doCachedMethod(Object languageContext, TruffleObject receiver, Method method, Object[] arguments, @Cached(value="method") Method cachedMethod, @Cached(value="method.getName()") String name, @Cached(value="getMethodReturnType(method)") Class<?> returnClass, @Cached(value="getMethodGenericReturnType(method)") Type returnType, @Cached(value="createInvoke(0).createNode()") Node invokeNode, @Cached(value="KEY_INFO.createNode()") Node keyInfoNode, @Cached(value="READ.createNode()") Node readNode, @Cached(value="IS_EXECUTABLE.createNode()") Node isExecutableNode, @Cached(value="createExecute(0).createNode()") Node executeNode, @Cached(value="createBinaryProfile()") ConditionProfile branchProfile, @Cached(value="create()") ToJavaNode toJava, @Cached(value="findMessage(method)") Message message, @Cached(value="maybeCreateNode(message)") Node messageNode) {
        Object result;
        if (message == null) {
            result = this.invokeOrExecute(languageContext, receiver, arguments, name, invokeNode, keyInfoNode, readNode, isExecutableNode, executeNode, branchProfile);
        } else {
            try {
                result = ProxyInvokeNode.handleMessage(message, messageNode, receiver, name, arguments);
            }
            catch (InteropException e) {
                CompilerDirectives.transferToInterpreter();
                throw e.raise();
            }
        }
        return toJava.execute(result, returnClass, returnType, languageContext);
    }

    protected static Node maybeCreateNode(Message message) {
        return message == null ? null : message.createNode();
    }

    private static Object handleMessage(Message message, Node messageNode, TruffleObject obj, String name, Object[] args) throws InteropException {
        if (message == Message.WRITE) {
            ForeignAccess.sendWrite(messageNode, obj, name, args[0]);
            return null;
        }
        if (message == Message.HAS_SIZE || message == Message.IS_BOXED || message == Message.IS_EXECUTABLE || message == Message.IS_NULL || message == Message.GET_SIZE) {
            return ForeignAccess.send(messageNode, obj, new Object[0]);
        }
        if (message == Message.KEY_INFO) {
            return ForeignAccess.sendKeyInfo(messageNode, obj, name);
        }
        if (message == Message.READ) {
            return ForeignAccess.sendRead(messageNode, obj, name);
        }
        if (message == Message.UNBOX) {
            return ForeignAccess.sendUnbox(messageNode, obj);
        }
        if (Message.createExecute(0).equals(message)) {
            return ForeignAccess.sendExecute(messageNode, obj, args);
        }
        if (Message.createInvoke(0).equals(message)) {
            return ForeignAccess.sendInvoke(messageNode, obj, name, args);
        }
        if (Message.createNew(0).equals(message)) {
            return ForeignAccess.sendNew(messageNode, obj, args);
        }
        CompilerDirectives.transferToInterpreter();
        throw UnsupportedMessageException.raise(message);
    }

    protected static Message findMessage(Method method) {
        CompilerAsserts.neverPartOfCompilation();
        MethodMessage mm = method.getAnnotation(MethodMessage.class);
        if (mm == null) {
            return null;
        }
        Message message = Message.valueOf(mm.message());
        if (message == Message.WRITE && method.getParameterTypes().length != 1) {
            throw new IllegalStateException("Method needs to have a single argument to handle WRITE message " + method);
        }
        return message;
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean guardReturnType(Method method, Type returnType) {
        return method.getGenericReturnType().equals(returnType);
    }

    private Object invokeOrExecute(Object polyglotContext, TruffleObject receiver, Object[] arguments, String name, Node invokeNode, Node keyInfoNode, Node readNode, Node isExecutableNode, Node executeNode, ConditionProfile invokeOrReadAndExecuteProfile) {
        try {
            if (!this.invokeFailed) {
                try {
                    return ForeignAccess.sendInvoke(invokeNode, receiver, name, arguments);
                }
                catch (UnknownIdentifierException | UnsupportedMessageException e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.invokeFailed = true;
                }
            }
            if (this.invokeFailed) {
                int keyInfo = ForeignAccess.sendKeyInfo(keyInfoNode, receiver, name);
                if (invokeOrReadAndExecuteProfile.profile(KeyInfo.isInvocable(keyInfo))) {
                    try {
                        return ForeignAccess.sendInvoke(invokeNode, receiver, name, arguments);
                    }
                    catch (UnsupportedMessageException e) {
                        CompilerDirectives.transferToInterpreter();
                    }
                } else if (KeyInfo.isReadable(keyInfo)) {
                    TruffleObject truffleReadValue;
                    Object readValue = ForeignAccess.sendRead(readNode, receiver, name);
                    if (readValue instanceof TruffleObject && ForeignAccess.sendIsExecutable(isExecutableNode, truffleReadValue = (TruffleObject)readValue)) {
                        return ForeignAccess.sendExecute(executeNode, truffleReadValue, arguments);
                    }
                    if (arguments.length == 0) {
                        return readValue;
                    }
                }
            }
            CompilerDirectives.transferToInterpreter();
            throw JavaInteropErrors.invokeUnsupported(polyglotContext, receiver, name);
        }
        catch (UnknownIdentifierException e) {
            CompilerDirectives.transferToInterpreter();
            throw JavaInteropErrors.invokeUnsupported(polyglotContext, receiver, name);
        }
        catch (UnsupportedTypeException e) {
            CompilerDirectives.transferToInterpreter();
            throw JavaInteropErrors.invalidExecuteArgumentType(polyglotContext, receiver, e.getSuppliedValues());
        }
        catch (ArityException e) {
            CompilerDirectives.transferToInterpreter();
            throw JavaInteropErrors.invalidExecuteArity(polyglotContext, receiver, arguments, e.getExpectedArity(), e.getActualArity());
        }
        catch (UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreter();
            throw JavaInteropErrors.invokeUnsupported(polyglotContext, receiver, name);
        }
    }
}

