/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.java.JavaFieldDesc;
import com.oracle.truffle.api.interop.java.JavaInteropAccessor;
import com.oracle.truffle.api.interop.java.JavaObject;
import com.oracle.truffle.api.interop.java.ReadFieldNodeGen;
import com.oracle.truffle.api.interop.java.SingleFieldDesc;
import com.oracle.truffle.api.nodes.Node;
import java.util.function.BiFunction;

abstract class ReadFieldNode
extends Node {
    static final int LIMIT = 3;

    ReadFieldNode() {
    }

    static ReadFieldNode create() {
        return ReadFieldNodeGen.create();
    }

    public abstract Object execute(JavaFieldDesc var1, JavaObject var2);

    protected static BiFunction<Object, Object, Object> createToGuestValue() {
        return JavaInteropAccessor.ACCESSOR.engine().createToGuestValueNode();
    }

    @Specialization(guards={"field == cachedField"}, limit="LIMIT")
    static Object doCached(SingleFieldDesc field, JavaObject object, @Cached(value="field") SingleFieldDesc cachedField, @Cached(value="createToGuestValue()") BiFunction<Object, Object, Object> toGuest) {
        Object val = cachedField.get(object.obj);
        return toGuest.apply(object.languageContext, val);
    }

    @Specialization(replaces={"doCached"})
    static Object doUncached(SingleFieldDesc field, JavaObject object, @Cached(value="createToGuestValue()") BiFunction<Object, Object, Object> toGuest) {
        Object val = field.get(object.obj);
        return toGuest.apply(object.languageContext, val);
    }
}

