/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.KeyInfo;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.interop.java.HostEntryRootNode;
import com.oracle.truffle.api.interop.java.JavaInteropAccessor;
import com.oracle.truffle.api.interop.java.JavaInteropErrors;
import com.oracle.truffle.api.interop.java.ToJavaNode;
import com.oracle.truffle.api.interop.java.TruffleExecuteNode;
import com.oracle.truffle.api.interop.java.TruffleList;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

class TruffleMap<K, V>
extends AbstractMap<K, V> {
    final Object languageContext;
    final TruffleObject guestObject;
    final TruffleMapCache cache;
    private final boolean includeInternal;

    TruffleMap(Object languageContext, TruffleObject obj, Class<K> keyClass, Class<V> valueClass, Type valueType) {
        this.guestObject = obj;
        this.languageContext = languageContext;
        this.includeInternal = false;
        this.cache = TruffleMapCache.lookup(languageContext, obj.getClass(), keyClass, valueClass, valueType);
    }

    private TruffleMap(TruffleMap<K, V> map, boolean includeInternal) {
        this.guestObject = map.guestObject;
        this.cache = map.cache;
        this.languageContext = map.languageContext;
        this.includeInternal = includeInternal;
    }

    static <K, V> Map<K, V> create(Object languageContext, TruffleObject foreignObject, boolean implementsFunction, Class<K> keyClass, Class<V> valueClass, Type valueType) {
        if (implementsFunction) {
            return new FunctionTruffleMap<K, V>(languageContext, foreignObject, keyClass, valueClass, valueType);
        }
        return new TruffleMap<K, V>(languageContext, foreignObject, keyClass, valueClass, valueType);
    }

    TruffleMap<K, V> cloneInternal(boolean includeInternalKeys) {
        return new TruffleMap<K, V>(this, includeInternalKeys);
    }

    @Override
    public boolean containsKey(Object key) {
        return (Boolean)this.cache.containsKey.call(this.languageContext, this.guestObject, key);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return (Set)this.cache.entrySet.call(this.languageContext, this.guestObject, this, this.includeInternal);
    }

    @Override
    public V get(Object key) {
        return (V)this.cache.get.call(this.languageContext, this.guestObject, key);
    }

    @Override
    public V put(K key, V value) {
        return (V)this.cache.put.call(this.languageContext, this.guestObject, key, value);
    }

    @Override
    public V remove(Object key) {
        return (V)this.cache.remove.call(this.languageContext, this.guestObject, key);
    }

    static final class TruffleMapCache {
        final Class<?> receiverClass;
        final Class<?> keyClass;
        final Class<?> valueClass;
        final Type valueType;
        final boolean memberKey;
        final boolean numberKey;
        final CallTarget entrySet;
        final CallTarget get;
        final CallTarget put;
        final CallTarget remove;
        final CallTarget removeBoolean;
        final CallTarget containsKey;
        final CallTarget apply;

        TruffleMapCache(Class<?> receiverClass, Class<?> keyClass, Class<?> valueClass, Type valueType) {
            this.receiverClass = receiverClass;
            this.keyClass = keyClass;
            this.valueClass = valueClass;
            this.valueType = valueType;
            this.memberKey = keyClass == Object.class || keyClass == String.class || keyClass == CharSequence.class;
            this.numberKey = keyClass == Object.class || keyClass == Number.class || keyClass == Integer.class || keyClass == Long.class || keyClass == Short.class || keyClass == Byte.class;
            this.get = TruffleMapCache.initializeCall(new Get(this));
            this.containsKey = TruffleMapCache.initializeCall(new ContainsKey(this));
            this.entrySet = TruffleMapCache.initializeCall(new EntrySet(this));
            this.put = TruffleMapCache.initializeCall(new Put(this));
            this.remove = TruffleMapCache.initializeCall(new Remove(this));
            this.removeBoolean = TruffleMapCache.initializeCall(new RemoveBoolean(this));
            this.apply = TruffleMapCache.initializeCall(new Apply(this));
        }

        private static CallTarget initializeCall(TruffleMapNode node) {
            return HostEntryRootNode.createTarget(node);
        }

        static TruffleMapCache lookup(Object languageContext, Class<?> receiverClass, Class<?> keyClass, Class<?> valueClass, Type valueType) {
            Accessor.EngineSupport engine = JavaInteropAccessor.ACCESSOR.engine();
            if (engine == null) {
                return new TruffleMapCache(receiverClass, keyClass, valueClass, valueType);
            }
            Key cacheKey = new Key(receiverClass, keyClass, valueType);
            TruffleMapCache cache = engine.lookupJavaInteropCodeCache(languageContext, cacheKey, TruffleMapCache.class);
            if (cache == null) {
                cache = engine.installJavaInteropCodeCache(languageContext, cacheKey, new TruffleMapCache(receiverClass, keyClass, valueClass, valueType), TruffleMapCache.class);
            }
            assert (cache.receiverClass == receiverClass);
            assert (cache.keyClass == keyClass);
            assert (cache.valueClass == valueClass);
            assert (cache.valueType == valueType);
            return cache;
        }

        private static class Apply
        extends TruffleMapNode {
            @Node.Child
            private TruffleExecuteNode apply = new TruffleExecuteNode();

            Apply(TruffleMapCache cache) {
                super(cache);
            }

            @Override
            protected String getOperationName() {
                return "apply";
            }

            @Override
            protected Object executeImpl(Object languageContext, TruffleObject function, Object[] args, int offset) {
                return this.apply.execute(languageContext, function, args[offset], Object.class, (Type)((Object)Object.class));
            }
        }

        private static class RemoveBoolean
        extends TruffleMapNode {
            @Node.Child
            private Node keyInfo = Message.KEY_INFO.createNode();
            @Node.Child
            private Node read = Message.READ.createNode();
            @Node.Child
            private Node remove = Message.REMOVE.createNode();
            @Node.Child
            private ToJavaNode toHost = ToJavaNode.create();

            RemoveBoolean(TruffleMapCache cache) {
                super(cache);
            }

            @Override
            protected String getOperationName() {
                return "remove";
            }

            @Override
            protected Object executeImpl(Object languageContext, TruffleObject receiver, Object[] args, int offset) {
                Object key = args[offset];
                if (this.isValidKey(receiver, key)) {
                    if (args.length > offset + 1) {
                        Object value = args[offset + 1];
                        Object result = null;
                        int info = ForeignAccess.sendKeyInfo(this.keyInfo, receiver, key);
                        if (KeyInfo.isReadable(info)) {
                            try {
                                result = this.toHost.execute(ForeignAccess.sendRead(this.read, receiver, key), this.cache.valueClass, this.cache.valueType, languageContext);
                            }
                            catch (UnknownIdentifierException unknownIdentifierException) {
                            }
                            catch (UnsupportedMessageException unsupportedMessageException) {
                                // empty catch block
                            }
                        }
                        if (!Objects.equals(value, result)) {
                            return false;
                        }
                    }
                    try {
                        return ForeignAccess.sendRemove(this.remove, receiver, key);
                    }
                    catch (UnknownIdentifierException e) {
                        return false;
                    }
                    catch (UnsupportedMessageException e) {
                        CompilerDirectives.transferToInterpreter();
                        throw JavaInteropErrors.mapUnsupported(languageContext, receiver, this.cache.keyClass, this.cache.valueType, "remove");
                    }
                }
                CompilerDirectives.transferToInterpreter();
                if (this.cache.keyClass.isInstance(key) && (key instanceof Number || key instanceof String)) {
                    throw JavaInteropErrors.mapUnsupported(languageContext, receiver, this.cache.keyClass, this.cache.valueType, "remove");
                }
                return false;
            }
        }

        private static class Remove
        extends TruffleMapNode {
            @Node.Child
            private Node keyInfo = Message.KEY_INFO.createNode();
            @Node.Child
            private Node read = Message.READ.createNode();
            @Node.Child
            private Node remove = Message.REMOVE.createNode();
            @Node.Child
            private ToJavaNode toHost = ToJavaNode.create();

            Remove(TruffleMapCache cache) {
                super(cache);
            }

            @Override
            protected String getOperationName() {
                return "remove";
            }

            @Override
            protected Object executeImpl(Object languageContext, TruffleObject receiver, Object[] args, int offset) {
                Object key = args[offset];
                Object result = null;
                if (this.isValidKey(receiver, key)) {
                    int info = ForeignAccess.sendKeyInfo(this.keyInfo, receiver, key);
                    if (KeyInfo.isReadable(info)) {
                        try {
                            result = this.toHost.execute(ForeignAccess.sendRead(this.read, receiver, key), this.cache.valueClass, this.cache.valueType, languageContext);
                        }
                        catch (UnknownIdentifierException unknownIdentifierException) {
                        }
                        catch (UnsupportedMessageException unsupportedMessageException) {
                            // empty catch block
                        }
                    }
                    try {
                        boolean success = ForeignAccess.sendRemove(this.remove, receiver, key);
                        if (!success) {
                            return null;
                        }
                    }
                    catch (UnknownIdentifierException e) {
                        return null;
                    }
                    catch (UnsupportedMessageException e) {
                        CompilerDirectives.transferToInterpreter();
                        throw JavaInteropErrors.mapUnsupported(languageContext, receiver, this.cache.keyClass, this.cache.valueType, "remove");
                    }
                    return this.cache.valueClass.cast(result);
                }
                CompilerDirectives.transferToInterpreter();
                if (this.cache.keyClass.isInstance(key) && (key instanceof Number || key instanceof String)) {
                    throw JavaInteropErrors.mapUnsupported(languageContext, receiver, this.cache.keyClass, this.cache.valueType, "remove");
                }
                return null;
            }
        }

        private static class Put
        extends TruffleMapNode {
            @Node.Child
            private Node keyInfo = Message.KEY_INFO.createNode();
            @Node.Child
            private Node getSize = Message.GET_SIZE.createNode();
            @Node.Child
            private Node read = Message.READ.createNode();
            @Node.Child
            private Node write = Message.WRITE.createNode();
            @Node.Child
            private ToJavaNode toHost = ToJavaNode.create();
            private final BiFunction<Object, Object, Object> toGuest = Put.createToGuestValueNode();

            Put(TruffleMapCache cache) {
                super(cache);
            }

            @Override
            protected String getOperationName() {
                return "put";
            }

            @Override
            protected Object executeImpl(Object languageContext, TruffleObject receiver, Object[] args, int offset) {
                Object key = args[offset];
                Object result = null;
                if (this.isValidKey(receiver, key)) {
                    Object value = args[offset + 1];
                    int info = ForeignAccess.sendKeyInfo(this.keyInfo, receiver, key);
                    if (!KeyInfo.isExisting(info) || KeyInfo.isWritable(info) && KeyInfo.isReadable(info)) {
                        if (KeyInfo.isExisting(info)) {
                            try {
                                result = this.toHost.execute(ForeignAccess.sendRead(this.read, receiver, key), this.cache.valueClass, this.cache.valueType, languageContext);
                            }
                            catch (UnknownIdentifierException unknownIdentifierException) {
                            }
                            catch (UnsupportedMessageException unsupportedMessageException) {
                                // empty catch block
                            }
                        }
                        Object guestValue = this.toGuest.apply(languageContext, value);
                        try {
                            ForeignAccess.sendWrite(this.write, receiver, key, guestValue);
                        }
                        catch (UnknownIdentifierException e) {
                            CompilerDirectives.transferToInterpreter();
                            throw JavaInteropErrors.invalidMapIdentifier(languageContext, receiver, this.cache.keyClass, this.cache.valueType, key);
                        }
                        catch (UnsupportedMessageException e) {
                            CompilerDirectives.transferToInterpreter();
                            throw JavaInteropErrors.mapUnsupported(languageContext, receiver, this.cache.keyClass, this.cache.valueType, "put");
                        }
                        catch (UnsupportedTypeException e) {
                            CompilerDirectives.transferToInterpreter();
                            throw JavaInteropErrors.invalidMapValue(languageContext, receiver, this.cache.keyClass, this.cache.valueType, key, guestValue);
                        }
                        return this.cache.valueClass.cast(result);
                    }
                }
                CompilerDirectives.transferToInterpreter();
                if (this.cache.keyClass.isInstance(key) && (key instanceof Number || key instanceof String)) {
                    throw JavaInteropErrors.mapUnsupported(languageContext, receiver, this.cache.keyClass, this.cache.valueType, "put");
                }
                throw JavaInteropErrors.invalidMapIdentifier(languageContext, receiver, this.cache.keyClass, this.cache.valueType, key);
            }
        }

        private static class Get
        extends TruffleMapNode {
            @Node.Child
            private Node keyInfo = Message.KEY_INFO.createNode();
            @Node.Child
            private Node getSize = Message.GET_SIZE.createNode();
            @Node.Child
            private Node read = Message.READ.createNode();
            @Node.Child
            private ToJavaNode toHost = ToJavaNode.create();

            Get(TruffleMapCache cache) {
                super(cache);
            }

            @Override
            protected String getOperationName() {
                return "get";
            }

            @Override
            protected Object executeImpl(Object languageContext, TruffleObject receiver, Object[] args, int offset) {
                Object key = args[offset];
                Object result = null;
                if (this.isValidKey(receiver, key) && KeyInfo.isReadable(ForeignAccess.sendKeyInfo(this.keyInfo, receiver, key))) {
                    try {
                        result = this.toHost.execute(ForeignAccess.sendRead(this.read, receiver, key), this.cache.valueClass, this.cache.valueType, languageContext);
                    }
                    catch (ClassCastException | NullPointerException e) {
                        throw e;
                    }
                    catch (UnknownIdentifierException e) {
                        return null;
                    }
                    catch (UnsupportedMessageException e) {
                        return null;
                    }
                }
                return result;
            }
        }

        private static class EntrySet
        extends TruffleMapNode {
            @Node.Child
            private Node getSize = Message.GET_SIZE.createNode();
            @Node.Child
            private Node keysNode = Message.KEYS.createNode();

            EntrySet(TruffleMapCache cache) {
                super(cache);
            }

            @Override
            protected Object executeImpl(Object languageContext, TruffleObject receiver, Object[] args, int offset) {
                List<String> keys = null;
                int keysSize = 0;
                int elemSize = 0;
                TruffleMap originalMap = (TruffleMap)args[offset];
                boolean includeInternal = (Boolean)args[offset + 1];
                if (this.cache.memberKey && ForeignAccess.sendHasKeys(this.hasKeys, receiver)) {
                    TruffleObject truffleKeys;
                    try {
                        truffleKeys = ForeignAccess.sendKeys(this.keysNode, receiver, includeInternal);
                    }
                    catch (UnsupportedMessageException e) {
                        CompilerDirectives.transferToInterpreter();
                        return Collections.emptySet();
                    }
                    keys = TruffleList.create(languageContext, truffleKeys, false, String.class, null);
                    keysSize = keys.size();
                } else if (this.cache.numberKey && ForeignAccess.sendHasSize(this.hasSize, receiver)) {
                    try {
                        elemSize = ((Number)ForeignAccess.sendGetSize(this.getSize, receiver)).intValue();
                    }
                    catch (UnsupportedMessageException e) {
                        elemSize = 0;
                    }
                }
                TruffleMap truffleMap = originalMap;
                truffleMap.getClass();
                return truffleMap.new LazyEntries(keys, keysSize, elemSize);
            }

            @Override
            protected String getOperationName() {
                return "entrySet";
            }
        }

        private class ContainsKey
        extends TruffleMapNode {
            @Node.Child
            private Node keyInfo;
            @Node.Child
            private Node getSize;

            ContainsKey(TruffleMapCache cache) {
                super(cache);
                this.keyInfo = Message.KEY_INFO.createNode();
                this.getSize = Message.GET_SIZE.createNode();
            }

            @Override
            protected Object executeImpl(Object languageContext, TruffleObject receiver, Object[] args, int offset) {
                Object key = args[offset];
                if (this.isValidKey(receiver, key)) {
                    return KeyInfo.isReadable(ForeignAccess.sendKeyInfo(this.keyInfo, receiver, key));
                }
                return false;
            }

            @Override
            protected String getOperationName() {
                return "containsKey";
            }
        }

        private static abstract class TruffleMapNode
        extends HostEntryRootNode<TruffleObject>
        implements Supplier<String> {
            final TruffleMapCache cache;
            @Node.Child
            protected Node hasSize = Message.HAS_SIZE.createNode();
            @Node.Child
            protected Node hasKeys = Message.HAS_KEYS.createNode();
            private final ConditionProfile condition = ConditionProfile.createBinaryProfile();

            TruffleMapNode(TruffleMapCache cache) {
                this.cache = cache;
            }

            @Override
            protected Class<? extends TruffleObject> getReceiverType() {
                return this.cache.receiverClass;
            }

            @Override
            public final String get() {
                return "TruffleMap<" + this.cache.receiverClass + ", " + this.cache.keyClass + ", " + this.cache.valueType + ">." + this.getOperationName();
            }

            protected final boolean isValidKey(TruffleObject receiver, Object key) {
                return this.cache.keyClass.isInstance(key) && (this.cache.memberKey && this.condition.profile(ForeignAccess.sendHasKeys(this.hasKeys, receiver)) ? key instanceof String : this.cache.numberKey && key instanceof Number && ForeignAccess.sendHasSize(this.hasSize, receiver));
            }

            protected abstract String getOperationName();
        }

        private static final class Key {
            final Class<?> receiverClass;
            final Class<?> keyClass;
            final Type valueType;

            Key(Class<?> receiverClass, Class<?> keyClass, Type valueType) {
                assert (receiverClass != null);
                assert (keyClass != null);
                this.receiverClass = receiverClass;
                this.keyClass = keyClass;
                this.valueType = valueType;
            }

            public int hashCode() {
                return 31 * (31 * (31 + this.keyClass.hashCode()) + (this.valueType == null ? 0 : this.valueType.hashCode())) + this.receiverClass.hashCode();
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null || this.getClass() != obj.getClass()) {
                    return false;
                }
                Key other = (Key)obj;
                return this.keyClass == other.keyClass && this.valueType == other.valueType && this.receiverClass == other.receiverClass;
            }
        }
    }

    static class FunctionTruffleMap<K, V>
    extends TruffleMap<K, V>
    implements Function<Object[], Object> {
        FunctionTruffleMap(Object languageContext, TruffleObject obj, Class<K> keyClass, Class<V> valueClass, Type valueType) {
            super(languageContext, obj, keyClass, valueClass, valueType);
        }

        @Override
        public final Object apply(Object[] arguments) {
            return this.cache.apply.call(this.languageContext, this.guestObject, arguments);
        }
    }

    private final class TruffleEntry
    implements Map.Entry<K, V> {
        private final K key;

        TruffleEntry(K key) {
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return TruffleMap.this.get(this.key);
        }

        @Override
        public V setValue(V value) {
            return TruffleMap.this.put(this.key, value);
        }
    }

    private final class LazyEntries
    extends AbstractSet<Map.Entry<K, V>> {
        private final List<?> props;
        private final int keysSize;
        private final int elemSize;

        LazyEntries(List<?> keys, int keysSize, int elemSize) {
            assert (keys != null || keysSize == 0);
            this.props = keys;
            this.keysSize = keysSize;
            this.elemSize = elemSize;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            if (this.keysSize > 0 && this.elemSize > 0) {
                return new CombinedIterator();
            }
            if (this.keysSize > 0) {
                return new LazyKeysIterator();
            }
            return new ElementsIterator();
        }

        @Override
        public int size() {
            return (this.props != null ? this.props.size() : this.keysSize) + this.elemSize;
        }

        @Override
        public boolean contains(Object o) {
            return TruffleMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                return (Boolean)TruffleMap.this.cache.removeBoolean.call(TruffleMap.this.languageContext, TruffleMap.this.guestObject, e.getKey(), e.getValue());
            }
            return false;
        }

        private final class CombinedIterator
        implements Iterator<Map.Entry<K, V>> {
            private final Iterator<Map.Entry<K, V>> elemIter;
            private final Iterator<Map.Entry<K, V>> keysIter;
            private boolean isElemCurrent;

            private CombinedIterator() {
                this.elemIter = new ElementsIterator();
                this.keysIter = new LazyKeysIterator();
            }

            @Override
            public boolean hasNext() {
                return this.elemIter.hasNext() || this.keysIter.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                if (this.elemIter.hasNext()) {
                    this.isElemCurrent = true;
                    return this.elemIter.next();
                }
                if (this.keysIter.hasNext()) {
                    this.isElemCurrent = false;
                    return this.keysIter.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                if (this.isElemCurrent) {
                    this.elemIter.remove();
                } else {
                    this.keysIter.remove();
                }
            }
        }

        private final class ElementsIterator
        implements Iterator<Map.Entry<K, V>> {
            private int index = 0;
            private boolean hasCurrentEntry;

            ElementsIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.index < LazyEntries.this.elemSize;
            }

            @Override
            public Map.Entry<K, V> next() {
                if (this.hasNext()) {
                    Number key = TruffleMap.this.cache.keyClass == Long.class ? (Number)Long.valueOf(this.index) : (Number)this.index;
                    ++this.index;
                    this.hasCurrentEntry = true;
                    return new TruffleEntry(TruffleMap.this.cache.keyClass.cast(key));
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                if (!this.hasCurrentEntry) {
                    throw new IllegalStateException("No current entry.");
                }
                TruffleMap.this.cache.removeBoolean.call(TruffleMap.this.languageContext, TruffleMap.this.guestObject, TruffleMap.this.cache.keyClass.cast(this.index - 1));
                this.hasCurrentEntry = false;
            }
        }

        private final class LazyKeysIterator
        implements Iterator<Map.Entry<K, V>> {
            private final int size;
            private int index;
            private int currentIndex = -1;

            LazyKeysIterator() {
                this.size = LazyEntries.this.props != null ? LazyEntries.this.props.size() : LazyEntries.this.keysSize;
                this.index = 0;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            @Override
            public Map.Entry<K, V> next() {
                if (this.hasNext()) {
                    this.currentIndex = this.index;
                    Object key = LazyEntries.this.props.get(this.index++);
                    return new TruffleEntry(key);
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                if (this.currentIndex >= 0) {
                    LazyEntries.this.props.remove(this.currentIndex);
                    this.currentIndex = -1;
                    --this.index;
                } else {
                    throw new IllegalStateException("No current entry.");
                }
            }
        }
    }
}

