/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.java.JavaFieldDesc;
import com.oracle.truffle.api.interop.java.JavaObject;
import com.oracle.truffle.api.interop.java.SingleFieldDesc;
import com.oracle.truffle.api.interop.java.WriteFieldNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=WriteFieldNode.class)
final class WriteFieldNodeGen
extends WriteFieldNode {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @CompilerDirectives.CompilationFinal
    private CachedData cached_cache;

    private WriteFieldNodeGen() {
    }

    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    public void execute(JavaFieldDesc arg0Value, JavaObject arg1Value, Object arg2Value) {
        int state = this.state_;
        if (state != 0 && arg0Value instanceof SingleFieldDesc) {
            SingleFieldDesc arg0Value_ = (SingleFieldDesc)arg0Value;
            if ((state & 1) != 0) {
                CachedData s1_ = this.cached_cache;
                while (s1_ != null) {
                    if (arg0Value_ == s1_.cachedField_) {
                        this.doCached(arg0Value_, arg1Value, arg2Value, s1_.cachedField_);
                        return;
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state & 2) != 0) {
                this.doUncached(arg0Value_, arg1Value, arg2Value);
                return;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
    }

    private void executeAndSpecialize(JavaFieldDesc arg0Value, JavaObject arg1Value, Object arg2Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (arg0Value instanceof SingleFieldDesc) {
                SingleFieldDesc arg0Value_ = (SingleFieldDesc)arg0Value;
                if (exclude == 0) {
                    int count1_ = 0;
                    CachedData s1_ = this.cached_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null && arg0Value_ != s1_.cachedField_) {
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && count1_ < 3) {
                        s1_ = new CachedData(this.cached_cache);
                        s1_.cachedField_ = arg0Value_;
                        this.cached_cache = s1_;
                        this.state_ = state |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        this.doCached(arg0Value_, arg1Value, arg2Value, s1_.cachedField_);
                        return;
                    }
                }
                this.exclude_ = exclude |= 1;
                this.cached_cache = null;
                state &= 0xFFFFFFFE;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                this.doUncached(arg0Value_, arg1Value, arg2Value);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new UnsupportedSpecializationException(this, new Node[]{null, null, null}, arg0Value, arg1Value, arg2Value);
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        CachedData s1_;
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0 && ((s1_ = this.cached_cache) == null || s1_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static WriteFieldNode create() {
        return new WriteFieldNodeGen();
    }

    @GeneratedBy(value=WriteFieldNode.class)
    private static final class CachedData {
        @CompilerDirectives.CompilationFinal
        CachedData next_;
        @CompilerDirectives.CompilationFinal
        SingleFieldDesc cachedField_;

        CachedData(CachedData next_) {
            this.next_ = next_;
        }
    }
}

