/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.object;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.object.DynamicObject;

public class ObjectType {
    public boolean equals(DynamicObject object, Object other) {
        return object == other;
    }

    public int hashCode(DynamicObject object) {
        return System.identityHashCode(object);
    }

    @CompilerDirectives.TruffleBoundary
    public String toString(DynamicObject object) {
        return "DynamicObject<" + this.toString() + ">@" + Integer.toHexString(this.hashCode(object));
    }

    public ForeignAccess getForeignAccessFactory(DynamicObject object) {
        return ObjectType.createDefaultForeignAccess();
    }

    static ForeignAccess createDefaultForeignAccess() {
        return ForeignAccess.create(new ForeignAccess.Factory(){

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean canHandle(TruffleObject obj) {
                throw new IllegalArgumentException(obj.toString() + " cannot be shared");
            }

            @Override
            public CallTarget accessMessage(Message tree) {
                throw UnsupportedMessageException.raise(tree);
            }
        });
    }
}

