/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.source;

import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.source.Source;
import java.io.File;
import java.io.IOException;
import java.util.Collection;

final class SourceAccessor
extends Accessor {
    static final SourceAccessor ACCESSOR = new SourceAccessor();

    protected SourceAccessor() {
    }

    @Override
    protected Accessor.SourceSupport sourceSupport() {
        return new SourceSupportImpl();
    }

    @Override
    protected Accessor.LanguageSupport languageSupport() {
        return super.languageSupport();
    }

    static Collection<ClassLoader> allLoaders() {
        return ACCESSOR.loaders();
    }

    static byte[] readTruffleFile(File file) throws IOException {
        return ACCESSOR.languageSupport().truffleFileContent(file);
    }

    static boolean isTruffleFile(File file) {
        return ACCESSOR.languageSupport().checkTruffleFile(file);
    }

    static final class SourceSupportImpl
    extends Accessor.SourceSupport {
        SourceSupportImpl() {
        }

        @Override
        public Source copySource(Source source) {
            return source.copy();
        }

        @Override
        public Object getSourceIdentifier(Source source) {
            return source.getSourceId();
        }
    }
}

