/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.source;

import com.oracle.truffle.api.source.Source;
import java.net.URI;
import java.net.URL;
import java.util.Objects;

final class SourceImpl
extends Source {
    private final Key key;
    private final Object sourceId;

    private SourceImpl(Key key) {
        this.key = key;
        this.sourceId = new SourceId(key.hashCode());
    }

    private SourceImpl(Key key, Object sourceId) {
        this.key = key;
        this.sourceId = sourceId;
    }

    @Override
    protected Object getSourceId() {
        return this.sourceId;
    }

    @Override
    public CharSequence getCharacters() {
        return this.key.characters;
    }

    @Override
    Source copy() {
        return new SourceImpl(this.key, this.sourceId);
    }

    @Override
    public boolean isCached() {
        return this.key.cached;
    }

    @Override
    public String getName() {
        return this.key.name;
    }

    @Override
    public String getPath() {
        return this.key.path;
    }

    @Override
    public boolean isInternal() {
        return this.key.internal;
    }

    @Override
    public boolean isInteractive() {
        return this.key.interactive;
    }

    @Override
    public URL getURL() {
        return this.key.url;
    }

    @Override
    public URI getOriginalURI() {
        return this.key.uri;
    }

    @Override
    public String getMimeType() {
        return this.key.mimeType;
    }

    @Override
    public String getLanguage() {
        return this.key.language;
    }

    Key toKey() {
        return this.key;
    }

    static final class Key {
        final CharSequence characters;
        final URI uri;
        final URL url;
        final String name;
        final String mimeType;
        final String language;
        final String path;
        final boolean internal;
        final boolean interactive;
        final boolean cached;

        Key(CharSequence characters, String mimeType, String languageId, URL url, URI uri, String name, String path, boolean internal, boolean interactive, boolean cached) {
            this.characters = characters;
            this.mimeType = mimeType;
            this.language = languageId;
            this.name = name;
            this.path = path;
            this.internal = internal;
            this.interactive = interactive;
            this.cached = cached;
            this.url = url;
            this.uri = uri;
        }

        public int hashCode() {
            int result = 31 + (this.characters == null ? 0 : this.characters.hashCode());
            result = 31 * result + (this.interactive ? 1231 : 1237);
            result = 31 * result + (this.internal ? 1231 : 1237);
            result = 31 * result + (this.cached ? 1231 : 1237);
            result = 31 * result + (this.language == null ? 0 : this.language.hashCode());
            result = 31 * result + (this.mimeType == null ? 0 : this.mimeType.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
            result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            assert (this.characters != null);
            Key other = (Key)obj;
            return Objects.equals(this.language, other.language) && Objects.equals(this.mimeType, other.mimeType) && Objects.equals(this.name, other.name) && Objects.equals(this.path, other.path) && Objects.equals(this.uri, other.uri) && Objects.equals(this.url, other.url) && this.interactive == other.interactive && this.internal == other.internal && this.cached == other.cached && this.compareCharacters(other);
        }

        private boolean compareCharacters(Key other) {
            CharSequence otherCharacters = other.characters;
            if (this.characters == otherCharacters) {
                return true;
            }
            if (this.characters == null) {
                return false;
            }
            if (this.characters.length() != otherCharacters.length()) {
                return false;
            }
            assert (otherCharacters != null);
            return Objects.equals(this.characters.toString(), otherCharacters.toString());
        }

        SourceImpl toSource() {
            return new SourceImpl(this);
        }
    }

    private static final class SourceId {
        final int hash;

        SourceId(int hash) {
            this.hash = hash;
        }

        public boolean equals(Object obj) {
            return this == obj;
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

