/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.source;

import com.oracle.truffle.api.source.Source;

public final class SourceSection {
    private final Source source;
    private final int charIndex;
    private final int charLength;

    SourceSection(Source source, int charIndex, int charLength) {
        this.source = source;
        this.charIndex = charIndex;
        this.charLength = charLength;
    }

    public boolean isAvailable() {
        return this.charLength != -1;
    }

    boolean isValid() {
        return this.isAvailable() ? this.charIndex + this.charLength <= this.getSource().getCharacters().length() : false;
    }

    public Source getSource() {
        return this.source;
    }

    public int getStartLine() {
        if (this.source == null) {
            return -1;
        }
        if (!this.isValid()) {
            return 1;
        }
        return this.source.getLineNumber(this.getCharIndex());
    }

    public int getStartColumn() {
        if (this.source == null) {
            return -1;
        }
        if (!this.isValid()) {
            return 1;
        }
        return this.source.getColumnNumber(this.getCharIndex());
    }

    public int getEndLine() {
        if (this.source == null) {
            return -1;
        }
        if (!this.isValid()) {
            return 1;
        }
        return this.source.getLineNumber(this.getCharIndex() + Math.max(0, this.getCharLength() - 1));
    }

    public int getEndColumn() {
        if (this.source == null) {
            return -1;
        }
        if (!this.isValid()) {
            return 1;
        }
        return this.source.getColumnNumber(this.getCharIndex() + Math.max(0, this.getCharLength() - 1));
    }

    public int getCharIndex() {
        return this.charIndex;
    }

    public int getCharLength() {
        if (this.source == null) {
            return -1;
        }
        return this.charLength == -1 ? 0 : this.charLength;
    }

    public int getCharEndIndex() {
        if (this.source == null) {
            return -1;
        }
        return this.getCharIndex() + this.getCharLength();
    }

    public CharSequence getCharacters() {
        if (!this.isValid()) {
            return "";
        }
        return this.source.getCharacters().subSequence(this.getCharIndex(), this.getCharEndIndex());
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SourceSection(source=").append(this.getSource().getName());
        if (this.isAvailable()) {
            b.append(", index=").append(this.getCharIndex());
            b.append(", length=").append(this.getCharLength());
            if (this.isValid()) {
                b.append(", characters=").append(this.getCharacters().toString().replaceAll("\\n", "\\\\n"));
            } else {
                b.append(", valid=false");
            }
        } else {
            b.append(" available=false");
        }
        b.append(")");
        return b.toString();
    }

    public int hashCode() {
        if (!this.isAvailable()) {
            return System.identityHashCode(this);
        }
        int prime = 31;
        int result = 1;
        result = 31 * result + this.charIndex;
        result = 31 * result + this.charLength;
        result = 31 * result + this.source.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceSection)) {
            return false;
        }
        SourceSection other = (SourceSection)obj;
        if (!this.isAvailable()) {
            return this == obj;
        }
        if (this.charIndex != other.charIndex) {
            return false;
        }
        if (this.charLength != other.charLength) {
            return false;
        }
        return !(this.source == null ? other.source != null : !this.source.equals(other.source));
    }
}

