/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.vm;

import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.java.JavaInterop;

final class ConvertedObject
implements TruffleObject {
    private static final TruffleObject NULL = JavaInterop.asTruffleObject(null);
    private final TruffleObject original;
    private final Object value;

    ConvertedObject(TruffleObject obj, Object newValue) {
        this.original = obj;
        this.value = newValue == null ? NULL : newValue;
    }

    static Object original(Object obj) {
        if (obj instanceof ConvertedObject) {
            return ((ConvertedObject)obj).original;
        }
        return obj;
    }

    static Object value(Object obj) {
        if (obj instanceof ConvertedObject) {
            return ((ConvertedObject)obj).value;
        }
        return obj;
    }

    static boolean isNull(Object result) {
        return NULL == result;
    }

    static <T> boolean isInstance(Class<T> representation, Object obj) {
        if (representation.isInstance(obj)) {
            return true;
        }
        if (obj instanceof ConvertedObject) {
            return representation.isInstance(((ConvertedObject)obj).value);
        }
        return false;
    }

    static <T> T cast(Class<T> representation, Object obj) {
        if (obj instanceof ConvertedObject) {
            return representation.cast(((ConvertedObject)obj).value);
        }
        return representation.cast(obj);
    }

    @Override
    public ForeignAccess getForeignAccess() {
        throw new IllegalStateException();
    }
}

