/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.vm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Scope;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.vm.ArguentsArrayMessageResolutionForeign;
import com.oracle.truffle.api.vm.EmptyGlobalBindingsResolutionForeign;
import com.oracle.truffle.api.vm.NullValueForeign;
import com.oracle.truffle.api.vm.VMAccessor;
import com.oracle.truffle.api.vm.VariableNamesMessageResolutionForeign;
import com.oracle.truffle.api.vm.VariablesMapMessageResolutionForeign;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

final class DefaultScope {
    DefaultScope() {
    }

    static Iterable<Scope> topScope(Object global) {
        TruffleObject globalObject = global instanceof TruffleObject && DefaultScope.hasKeys((TruffleObject)global) ? (TruffleObject)global : new EmptyGlobalBindings();
        return Collections.singletonList(Scope.newBuilder("global", globalObject).build());
    }

    static Iterable<Scope> lexicalScope(Node node, Frame frame) {
        RootNode root = node.getRootNode();
        String name = root.getName();
        if (name == null) {
            name = "local";
        }
        return Collections.singletonList(Scope.newBuilder(name, DefaultScope.getVariables(root, frame)).node(root).arguments(DefaultScope.getArguments(frame)).build());
    }

    private static boolean hasKeys(TruffleObject object) {
        try {
            TruffleObject keys = ForeignAccess.sendKeys(Message.KEYS.createNode(), object);
            if (keys == null) {
                return false;
            }
            return ForeignAccess.sendHasSize(Message.HAS_SIZE.createNode(), keys);
        }
        catch (UnsupportedMessageException ex) {
            return false;
        }
    }

    private static boolean isInternal(FrameSlot slot) {
        Object identifier = slot.getIdentifier();
        if (identifier == null) {
            return true;
        }
        return VMAccessor.INSTRUMENT.isInputValueSlotIdentifier(identifier);
    }

    /*
     * WARNING - void declaration
     */
    private static Object getVariables(RootNode root, Frame frame) {
        Map<Object, Object> slotsMap;
        List<? extends FrameSlot> slots;
        if (frame == null) {
            slots = root.getFrameDescriptor().getSlots();
        } else {
            void var5_8;
            slots = frame.getFrameDescriptor().getSlots();
            ArrayList<? extends FrameSlot> nonNulls = null;
            int lastI = 0;
            boolean bl = false;
            while (var5_8 < slots.size()) {
                FrameSlot slot = slots.get((int)var5_8);
                if (frame.getValue(slot) == null || DefaultScope.isInternal(slot)) {
                    if (nonNulls == null) {
                        nonNulls = new ArrayList<FrameSlot>(slots.size());
                    }
                    nonNulls.addAll(slots.subList(lastI, (int)var5_8));
                    lastI = var5_8 + true;
                }
                ++var5_8;
            }
            if (nonNulls != null) {
                if (lastI < slots.size()) {
                    nonNulls.addAll(slots.subList(lastI, slots.size()));
                }
                slots = nonNulls;
            }
        }
        if (slots.isEmpty()) {
            slotsMap = Collections.emptyMap();
        } else if (slots.size() == 1) {
            FrameSlot slot = slots.get(0);
            slotsMap = Collections.singletonMap(Objects.toString(slot.getIdentifier()), slot);
        } else {
            slotsMap = new LinkedHashMap(slots.size());
            for (FrameSlot frameSlot : slots) {
                slotsMap.put(Objects.toString(frameSlot.getIdentifier()), frameSlot);
            }
        }
        return new VariablesMapObject(slotsMap, frame);
    }

    private static Object getArguments(Frame frame) {
        Object[] args = frame == null ? new Object[]{} : frame.getArguments();
        return new ArgumentsArrayObject(args);
    }

    static class EmptyGlobalBindings
    implements TruffleObject {
        EmptyGlobalBindings() {
        }

        @Override
        public ForeignAccess getForeignAccess() {
            return EmptyGlobalBindingsResolutionForeign.ACCESS;
        }

        public static boolean isInstance(TruffleObject obj) {
            return obj instanceof EmptyGlobalBindings;
        }

        static class EmptyGlobalBindingsResolution {
            EmptyGlobalBindingsResolution() {
            }

            static abstract class ReadNode
            extends Node {
                ReadNode() {
                }

                @CompilerDirectives.TruffleBoundary
                public Object access(EmptyGlobalBindings obj, String name) {
                    throw UnknownIdentifierException.raise(name);
                }
            }

            static abstract class SymbolsKeyInfoNode
            extends Node {
                SymbolsKeyInfoNode() {
                }

                public Object access(EmptyGlobalBindings obj, String name) {
                    return 0;
                }
            }

            static abstract class SymbolsKeysNode
            extends Node {
                SymbolsKeysNode() {
                }

                public Object access(EmptyGlobalBindings obj) {
                    return VariableNamesObject.EMPTY;
                }
            }

            static abstract class SymbolsHasKeysNode
            extends Node {
                SymbolsHasKeysNode() {
                }

                public Object access(EmptyGlobalBindings obj) {
                    return true;
                }
            }
        }
    }

    static final class ArgumentsArrayObject
    implements TruffleObject {
        final Object[] args;

        ArgumentsArrayObject(Object[] args) {
            this.args = args;
        }

        @Override
        public ForeignAccess getForeignAccess() {
            return ArguentsArrayMessageResolutionForeign.ACCESS;
        }

        public static boolean isInstance(TruffleObject obj) {
            return obj instanceof ArgumentsArrayObject;
        }

        static final class ArguentsArrayMessageResolution {
            ArguentsArrayMessageResolution() {
            }

            static abstract class ArgsArrWriteNode
            extends Node {
                ArgsArrWriteNode() {
                }

                @CompilerDirectives.TruffleBoundary
                public Object access(ArgumentsArrayObject argsArr, int index, Object value) {
                    try {
                        argsArr.args[index] = value;
                        return value;
                    }
                    catch (IndexOutOfBoundsException ioob) {
                        throw UnknownIdentifierException.raise(Integer.toString(index));
                    }
                }
            }

            static abstract class ArgsArrReadNode
            extends Node {
                ArgsArrReadNode() {
                }

                @CompilerDirectives.TruffleBoundary
                public Object access(ArgumentsArrayObject argsArr, int index) {
                    try {
                        return argsArr.args[index];
                    }
                    catch (IndexOutOfBoundsException ioob) {
                        throw UnknownIdentifierException.raise(Integer.toString(index));
                    }
                }
            }

            static abstract class ArgsArrGetSizeNode
            extends Node {
                ArgsArrGetSizeNode() {
                }

                public Object access(ArgumentsArrayObject argsArr) {
                    return argsArr.args.length;
                }
            }

            static abstract class ArgsArrHasSizeNode
            extends Node {
                ArgsArrHasSizeNode() {
                }

                public Object access(ArgumentsArrayObject argsArr) {
                    return true;
                }
            }
        }
    }

    static final class VariableNamesObject
    implements TruffleObject {
        static final VariableNamesObject EMPTY = new VariableNamesObject(Collections.emptySet());
        final List<String> names;

        VariableNamesObject(Set<String> names) {
            this.names = new ArrayList<String>(names);
        }

        @Override
        public ForeignAccess getForeignAccess() {
            return VariableNamesMessageResolutionForeign.ACCESS;
        }

        public static boolean isInstance(TruffleObject obj) {
            return obj instanceof VariableNamesObject;
        }

        static final class VariableNamesMessageResolution {
            VariableNamesMessageResolution() {
            }

            static abstract class VarNamesReadNode
            extends Node {
                VarNamesReadNode() {
                }

                @CompilerDirectives.TruffleBoundary
                public Object access(VariableNamesObject varNames, int index) {
                    try {
                        return varNames.names.get(index);
                    }
                    catch (IndexOutOfBoundsException ioob) {
                        throw UnknownIdentifierException.raise(Integer.toString(index));
                    }
                }
            }

            static abstract class VarNamesGetSizeNode
            extends Node {
                VarNamesGetSizeNode() {
                }

                public Object access(VariableNamesObject varNames) {
                    return varNames.names.size();
                }
            }

            static abstract class VarNamesHasSizeNode
            extends Node {
                VarNamesHasSizeNode() {
                }

                public Object access(VariableNamesObject varNames) {
                    return true;
                }
            }
        }
    }

    static final class NullValue
    implements TruffleObject {
        private static final NullValue INSTANCE = new NullValue();

        NullValue() {
        }

        @Override
        public ForeignAccess getForeignAccess() {
            return NullValueForeign.ACCESS;
        }

        static boolean isInstance(TruffleObject array) {
            return array instanceof NullValue;
        }

        static abstract class IsNull
        extends Node {
            IsNull() {
            }

            public Object access(NullValue receiver) {
                return true;
            }
        }
    }

    static final class VariablesMapObject
    implements TruffleObject {
        final Map<String, ? extends FrameSlot> slots;
        final Frame frame;

        private VariablesMapObject(Map<String, ? extends FrameSlot> slots, Frame frame) {
            this.slots = slots;
            this.frame = frame;
        }

        @Override
        public ForeignAccess getForeignAccess() {
            return VariablesMapMessageResolutionForeign.ACCESS;
        }

        public static boolean isInstance(TruffleObject obj) {
            return obj instanceof VariablesMapObject;
        }

        static class VariablesMapMessageResolution {
            VariablesMapMessageResolution() {
            }

            static abstract class VarsMapWriteNode
            extends Node {
                VarsMapWriteNode() {
                }

                @CompilerDirectives.TruffleBoundary
                public Object access(VariablesMapObject varMap, String name, Object value) {
                    if (varMap.frame == null) {
                        throw UnsupportedMessageException.raise(Message.WRITE);
                    }
                    FrameSlot slot = varMap.slots.get(name);
                    if (slot == null) {
                        throw UnknownIdentifierException.raise(name);
                    }
                    varMap.frame.setObject(slot, value);
                    return value;
                }
            }

            static abstract class VarsMapReadNode
            extends Node {
                VarsMapReadNode() {
                }

                @CompilerDirectives.TruffleBoundary
                public Object access(VariablesMapObject varMap, String name) {
                    if (varMap.frame == null) {
                        return NullValue.INSTANCE;
                    }
                    FrameSlot slot = varMap.slots.get(name);
                    if (slot == null) {
                        throw UnknownIdentifierException.raise(name);
                    }
                    return varMap.frame.getValue(slot);
                }
            }

            static abstract class VarsMapKeyInfoNode
            extends Node {
                VarsMapKeyInfoNode() {
                }

                @CompilerDirectives.TruffleBoundary
                public Object access(VariablesMapObject varMap, String name) {
                    if (varMap.slots.containsKey(name)) {
                        if (varMap.frame == null) {
                            return 2;
                        }
                        return 6;
                    }
                    return 0;
                }
            }

            static abstract class VarsMapKeysNode
            extends Node {
                VarsMapKeysNode() {
                }

                @CompilerDirectives.TruffleBoundary
                public Object access(VariablesMapObject varMap) {
                    return new VariableNamesObject(varMap.slots.keySet());
                }
            }

            static abstract class VarsMapHasKeysNode
            extends Node {
                VarsMapHasKeysNode() {
                }

                public Object access(VariablesMapObject varMap) {
                    return true;
                }
            }
        }
    }
}

