/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.vm;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Scope;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleException;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.vm.ClassNamesMessageResolutionForeign;
import com.oracle.truffle.api.vm.HostClassLoader;
import com.oracle.truffle.api.vm.PolyglotContextImpl;
import com.oracle.truffle.api.vm.PolyglotImpl;
import com.oracle.truffle.api.vm.PolyglotLanguageContext;
import com.oracle.truffle.api.vm.PolyglotProxy;
import com.oracle.truffle.api.vm.TopScopeObjectMessageResolutionForeign;
import com.oracle.truffle.api.vm.VMAccessor;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.graalvm.polyglot.proxy.Proxy;

class HostLanguage
extends TruffleLanguage<HostContext> {
    HostLanguage() {
    }

    @Override
    protected boolean isObjectOfLanguage(Object object) {
        if (object instanceof TruffleObject) {
            return PolyglotProxy.isProxyGuestObject((TruffleObject)object) || VMAccessor.JAVAINTEROP.isHostObject(object) || VMAccessor.JAVAINTEROP.isHostFunction(object);
        }
        return false;
    }

    @Override
    protected CallTarget parse(TruffleLanguage.ParsingRequest request) throws Exception {
        final String sourceString = request.getSource().getCharacters().toString();
        return Truffle.getRuntime().createCallTarget(new RootNode(this){

            @Override
            public Object execute(VirtualFrame frame) {
                HostContext context = (HostContext)HostLanguage.this.getContextReference().get();
                Class<?> allTarget = context.findClass(sourceString);
                return VMAccessor.JAVAINTEROP.toGuestObject(allTarget, ((HostContext)HostLanguage.this.getContextReference().get()).internalContext);
            }
        });
    }

    @Override
    protected void disposeContext(HostContext context) {
        HostClassLoader cl = context.classloader;
        if (cl != null) {
            try {
                cl.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            context.classloader = null;
        }
        super.disposeContext(context);
    }

    @Override
    protected HostContext createContext(TruffleLanguage.Env env) {
        return new HostContext(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Iterable<Scope> findTopScopes(HostContext context) {
        Set<Scope> topScopes = context.topScopes;
        if (topScopes == null) {
            HostContext hostContext = context;
            synchronized (hostContext) {
                topScopes = context.topScopes;
                if (topScopes == null) {
                    topScopes = Collections.singleton(Scope.newBuilder("Hosting top scope", new TopScopeObject(context)).build());
                    context.topScopes = topScopes;
                }
            }
        }
        return topScopes;
    }

    @Override
    protected boolean isThreadAccessAllowed(Thread thread, boolean singleThreaded) {
        return true;
    }

    private String arrayToString(HostContext context, Object array, int level) {
        if (array == null) {
            return "null";
        }
        if (level > 0) {
            return "[...]";
        }
        int iMax = Array.getLength(array) - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(this.toStringImpl(context, Array.get(array, i), level + 1));
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    @Override
    protected String toString(HostContext context, Object value) {
        return this.toStringImpl(context, value, 0);
    }

    private String toStringImpl(HostContext context, Object value, int level) {
        if (value instanceof TruffleObject) {
            TruffleObject to = (TruffleObject)value;
            if (VMAccessor.JAVAINTEROP.isHostObject(to)) {
                Object javaObject = VMAccessor.JAVAINTEROP.asHostObject(to);
                try {
                    if (javaObject == null) {
                        return "null";
                    }
                    if (javaObject.getClass().isArray()) {
                        return this.arrayToString(context, javaObject, level);
                    }
                    if (javaObject instanceof Class) {
                        return ((Class)javaObject).getTypeName();
                    }
                    return Objects.toString(javaObject);
                }
                catch (Throwable t) {
                    throw PolyglotImpl.wrapHostException(context.internalContext, t);
                }
            }
            if (PolyglotProxy.isProxyGuestObject(to)) {
                Proxy proxy = PolyglotProxy.toProxyHostObject(to);
                try {
                    return proxy.toString();
                }
                catch (Throwable t) {
                    throw PolyglotImpl.wrapHostException(context.internalContext, t);
                }
            }
            if (VMAccessor.JAVAINTEROP.isHostFunction(value)) {
                return VMAccessor.JAVAINTEROP.javaGuestFunctionToString(value);
            }
            return "Foreign Object";
        }
        return value.toString();
    }

    @Override
    protected Object findMetaObject(HostContext context, Object value) {
        if (value instanceof TruffleObject) {
            TruffleObject to = (TruffleObject)value;
            if (VMAccessor.JAVAINTEROP.isHostObject(to)) {
                Object javaObject = VMAccessor.JAVAINTEROP.asHostObject(to);
                Class javaType = javaObject == null ? Void.class : javaObject.getClass();
                return HostLanguage.javaClassToGuestObject(javaType, context.internalContext);
            }
            if (PolyglotProxy.isProxyGuestObject(to)) {
                Proxy proxy = PolyglotProxy.toProxyHostObject(to);
                return HostLanguage.javaClassToGuestObject(proxy.getClass(), context.internalContext);
            }
            if (VMAccessor.JAVAINTEROP.isHostFunction(value)) {
                return "Bound Method";
            }
            return "Foreign Object";
        }
        return HostLanguage.javaClassToGuestObject(value.getClass(), context.internalContext);
    }

    private static Object javaClassToGuestObject(Class<?> clazz, Object context) {
        return VMAccessor.JAVAINTEROP.toGuestObject(clazz, context);
    }

    static final class ClassNamesObject
    implements TruffleObject {
        final List<String> names;

        private ClassNamesObject(Set<String> names) {
            this.names = new ArrayList<String>(names);
        }

        @Override
        public ForeignAccess getForeignAccess() {
            return ClassNamesMessageResolutionForeign.ACCESS;
        }

        public static boolean isInstance(TruffleObject obj) {
            return obj instanceof ClassNamesObject;
        }

        static final class ClassNamesMessageResolution {
            ClassNamesMessageResolution() {
            }

            static abstract class ClassNamesReadNode
            extends Node {
                ClassNamesReadNode() {
                }

                @CompilerDirectives.TruffleBoundary
                public Object access(ClassNamesObject varNames, int index) {
                    try {
                        return varNames.names.get(index);
                    }
                    catch (IndexOutOfBoundsException ioob) {
                        throw UnknownIdentifierException.raise(Integer.toString(index));
                    }
                }
            }

            static abstract class ClassNamesGetSizeNode
            extends Node {
                ClassNamesGetSizeNode() {
                }

                public Object access(ClassNamesObject varNames) {
                    return varNames.names.size();
                }
            }

            static abstract class ClassNamesHasSizeNode
            extends Node {
                ClassNamesHasSizeNode() {
                }

                public Object access(ClassNamesObject varNames) {
                    return true;
                }
            }
        }
    }

    static final class TopScopeObject
    implements TruffleObject {
        private final HostContext context;

        private TopScopeObject(HostContext context) {
            this.context = context;
        }

        @Override
        public ForeignAccess getForeignAccess() {
            return TopScopeObjectMessageResolutionForeign.ACCESS;
        }

        public static boolean isInstance(TruffleObject obj) {
            return obj instanceof TopScopeObject;
        }

        static class TopScopeObjectMessageResolution {
            TopScopeObjectMessageResolution() {
            }

            static abstract class VarsMapReadNode
            extends Node {
                VarsMapReadNode() {
                }

                @CompilerDirectives.TruffleBoundary
                public Object access(TopScopeObject ts, String name) {
                    return VMAccessor.JAVAINTEROP.asStaticClassObject(ts.context.findClass(name), ((TopScopeObject)ts).context.internalContext);
                }
            }

            static abstract class VarsMapInfoNode
            extends Node {
                VarsMapInfoNode() {
                }

                @CompilerDirectives.TruffleBoundary
                public Object access(TopScopeObject ts, String name) {
                    Class<?> clazz = ts.context.findClass(name);
                    if (clazz != null) {
                        return 2;
                    }
                    return 0;
                }
            }

            static abstract class VarsMapKeysNode
            extends Node {
                VarsMapKeysNode() {
                }

                @CompilerDirectives.TruffleBoundary
                public Object access(TopScopeObject ts) {
                    return new ClassNamesObject(((TopScopeObject)ts).context.classCache.keySet());
                }
            }

            static abstract class VarsMapHasKeysNode
            extends Node {
                VarsMapHasKeysNode() {
                }

                public Object access(TopScopeObject ts) {
                    return true;
                }
            }
        }
    }

    private static class HostLanguageException
    extends RuntimeException
    implements TruffleException {
        HostLanguageException(String message) {
            super(message);
        }

        @Override
        public Node getLocation() {
            return null;
        }
    }

    static final class HostContext {
        final TruffleLanguage.Env env;
        volatile PolyglotLanguageContext internalContext;
        final Map<String, Class<?>> classCache = new HashMap();
        private volatile Iterable<Scope> topScopes;
        private volatile HostClassLoader classloader;

        HostContext(TruffleLanguage.Env env) {
            this.env = env;
        }

        @CompilerDirectives.TruffleBoundary
        Class<?> findClass(String className) {
            this.lookupInternalContext();
            this.checkHostAccessAllowed();
            if (TruffleOptions.AOT) {
                throw new HostLanguageException(String.format("The host class %s is not accessible in native mode.", className));
            }
            Class<?> loadedClass = this.classCache.get(className);
            if (loadedClass == null) {
                loadedClass = this.findClassImpl(className);
                this.classCache.put(className, loadedClass);
            }
            assert (loadedClass != null);
            return loadedClass;
        }

        private void checkHostAccessAllowed() {
            if (!this.internalContext.context.hostAccessAllowed) {
                throw new HostLanguageException(String.format("Host class access is not allowed.", new Object[0]));
            }
        }

        private HostClassLoader getClassloader() {
            if (this.classloader == null) {
                this.classloader = new HostClassLoader(this, this.internalContext.getEngine().contextClassLoader);
            }
            return this.classloader;
        }

        private void lookupInternalContext() {
            if (this.internalContext == null) {
                this.internalContext = PolyglotContextImpl.current().getHostContext();
            }
        }

        private Class<?> findClassImpl(String className) {
            this.lookupInternalContext();
            this.validateClass(className);
            if (className.endsWith("[]")) {
                Class<?> componentType = this.findClass(className.substring(0, className.length() - 2));
                return Array.newInstance(componentType, 0).getClass();
            }
            Class<?> primitiveType = HostContext.getPrimitiveTypeByName(className);
            if (primitiveType != null) {
                return primitiveType;
            }
            try {
                return this.getClassloader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new HostLanguageException(String.format("Access to host class %s is not allowed or does not exist.", className));
            }
        }

        void validateClass(String className) {
            Predicate<String> classFilter = this.internalContext.context.classFilter;
            if (classFilter != null && !classFilter.test(className)) {
                throw new HostLanguageException(String.format("Access to host class %s is not allowed.", className));
            }
        }

        private static Class<?> getPrimitiveTypeByName(String className) {
            switch (className) {
                case "boolean": {
                    return Boolean.TYPE;
                }
                case "byte": {
                    return Byte.TYPE;
                }
                case "char": {
                    return Character.TYPE;
                }
                case "double": {
                    return Double.TYPE;
                }
                case "float": {
                    return Float.TYPE;
                }
                case "int": {
                    return Integer.TYPE;
                }
                case "long": {
                    return Long.TYPE;
                }
                case "short": {
                    return Short.TYPE;
                }
            }
            return null;
        }

        public void addToHostClasspath(TruffleFile classpathEntry) {
            URL url;
            this.lookupInternalContext();
            this.checkHostAccessAllowed();
            if (TruffleOptions.AOT) {
                throw new HostLanguageException(String.format("Cannot add classpath entry %s in native mode.", classpathEntry.getName()));
            }
            if (!this.internalContext.context.hostClassLoadingAllowed) {
                throw new HostLanguageException(String.format("Host class loading is not allowed.", new Object[0]));
            }
            try {
                url = classpathEntry.toUri().toURL();
            }
            catch (MalformedURLException e) {
                throw new HostLanguageException("Invalid host classpath entry " + classpathEntry.getPath() + ".");
            }
            this.getClassloader().addURL(url);
        }
    }
}

