/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.vm;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.vm.PolyglotEngine;
import com.oracle.truffle.api.vm.VMAccessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

final class LanguageCache
implements Comparable<LanguageCache> {
    private static final Map<String, LanguageCache> nativeImageCache;
    private static volatile Map<String, LanguageCache> runtimeCache;
    private final String className;
    private final Set<String> mimeTypes;
    private final Set<String> dependentLanguages;
    private final String id;
    private final String name;
    private final String implementationName;
    private final String version;
    private final boolean interactive;
    private final boolean internal;
    private final ClassLoader loader;
    private String languageHome;
    final TruffleLanguage<?> singletonLanguage;
    private volatile Class<? extends TruffleLanguage<?>> languageClass;

    private LanguageCache(String id, String prefix, Properties info, ClassLoader loader, String url) {
        this.loader = loader;
        this.className = info.getProperty(prefix + "className");
        this.name = info.getProperty(prefix + "name");
        this.implementationName = info.getProperty(prefix + "implementationName");
        this.version = info.getProperty(prefix + "version");
        this.mimeTypes = LanguageCache.parseList(info, prefix + "mimeType");
        this.dependentLanguages = LanguageCache.parseList(info, prefix + "dependentLanguage");
        this.id = id;
        this.interactive = Boolean.valueOf(info.getProperty(prefix + "interactive"));
        this.internal = Boolean.valueOf(info.getProperty(prefix + "internal"));
        this.languageHome = url;
        if (TruffleOptions.AOT) {
            this.languageClass = this.loadLanguageClass();
            this.singletonLanguage = LanguageCache.readSingleton(this.languageClass);
        } else {
            this.languageClass = null;
            this.singletonLanguage = null;
        }
    }

    private static TreeSet<String> parseList(Properties info, String prefix) {
        String mt;
        TreeSet<String> mimeTypesSet = new TreeSet<String>();
        int i = 0;
        while ((mt = info.getProperty(prefix + "." + i)) != null) {
            mimeTypesSet.add(mt);
            ++i;
        }
        return mimeTypesSet;
    }

    LanguageCache(String id, Set<String> mimeTypes, String name, String implementationName, String version, boolean interactive, boolean internal, TruffleLanguage<?> instance) {
        this.id = id;
        this.className = instance.getClass().getName();
        this.mimeTypes = mimeTypes;
        this.implementationName = implementationName;
        this.name = name;
        this.version = version;
        this.interactive = interactive;
        this.internal = internal;
        this.dependentLanguages = Collections.emptySet();
        this.loader = instance.getClass().getClassLoader();
        this.singletonLanguage = instance;
        this.languageClass = instance.getClass();
        this.languageHome = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Map<String, LanguageCache> languages() {
        if (TruffleOptions.AOT) {
            return nativeImageCache;
        }
        if (runtimeCache != null) return runtimeCache;
        Class<LanguageCache> clazz = LanguageCache.class;
        synchronized (LanguageCache.class) {
            if (runtimeCache != null) return runtimeCache;
            runtimeCache = LanguageCache.createLanguages(null);
            // ** MonitorExit[var0] (shouldn't be in output)
            return runtimeCache;
        }
    }

    private static Map<String, LanguageCache> createLanguages(ClassLoader additionalLoader) {
        ArrayList<LanguageCache> caches = new ArrayList<LanguageCache>();
        for (ClassLoader loader : VMAccessor.allLoaders()) {
            LanguageCache.collectLanguages(loader, caches);
        }
        if (additionalLoader != null) {
            LanguageCache.collectLanguages(additionalLoader, caches);
        }
        HashMap<String, LanguageCache> cacheToMimeType = new HashMap<String, LanguageCache>();
        for (LanguageCache languageCache : caches) {
            for (String mimeType : languageCache.getMimeTypes()) {
                cacheToMimeType.put(mimeType, languageCache);
            }
        }
        return cacheToMimeType;
    }

    private static void collectLanguages(ClassLoader loader, List<LanguageCache> list) {
        Enumeration<URL> en;
        if (loader == null) {
            return;
        }
        try {
            en = loader.getResources("META-INF/truffle/language");
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot read list of Truffle languages", ex);
        }
        while (en.hasMoreElements()) {
            String prefix;
            String name;
            URLConnection connection;
            Properties p;
            URL u = en.nextElement();
            try {
                p = new Properties();
                connection = u.openConnection();
                try (InputStream is = connection.getInputStream();){
                    p.load(is);
                }
            }
            catch (IOException ex) {
                PrintStream out = System.err;
                out.println("Cannot process " + u + " as language definition");
                ex.printStackTrace();
                continue;
            }
            int cnt = 1;
            while ((name = p.getProperty((prefix = "language" + cnt + ".") + "name")) != null) {
                String languageHome;
                String id = p.getProperty(prefix + "id");
                if (id == null) {
                    id = LanguageCache.defaultId(name, p.getProperty(prefix + "className"));
                }
                if ((languageHome = System.getProperty(id + ".home")) == null && connection instanceof JarURLConnection) {
                    Path path = Paths.get(((JarURLConnection)connection).getJarFileURL().getPath(), new String[0]);
                    languageHome = path.getParent().toString();
                }
                list.add(new LanguageCache(id, prefix, p, loader, languageHome));
                ++cnt;
            }
        }
    }

    private static String defaultId(String name, String className) {
        String resolvedId;
        if (name.isEmpty()) {
            int lastIndex = className.lastIndexOf(36);
            if (lastIndex == -1) {
                lastIndex = className.lastIndexOf(46);
            }
            resolvedId = className.substring(lastIndex + 1, className.length());
        } else {
            resolvedId = name.length() == 1 ? name : name.toLowerCase();
        }
        return resolvedId;
    }

    @Override
    public int compareTo(LanguageCache o) {
        return this.id.compareTo(o.id);
    }

    String getId() {
        return this.id;
    }

    Set<String> getMimeTypes() {
        return this.mimeTypes;
    }

    String getName() {
        return this.name;
    }

    String getImplementationName() {
        return this.implementationName;
    }

    Set<String> getDependentLanguages() {
        return this.dependentLanguages;
    }

    String getVersion() {
        return this.version;
    }

    String getClassName() {
        return this.className;
    }

    boolean isInternal() {
        return this.internal;
    }

    boolean isInteractive() {
        return this.interactive;
    }

    String getLanguageHome() {
        if (this.languageHome == null) {
            this.languageHome = System.getProperty(this.id + ".home");
        }
        return this.languageHome;
    }

    LoadedLanguage loadLanguage() {
        TruffleLanguage<?> instance;
        boolean singleton = true;
        try {
            if (TruffleOptions.AOT) {
                instance = this.singletonLanguage;
                if (instance == null) {
                    instance = this.languageClass.newInstance();
                    singleton = false;
                }
            } else {
                Class<TruffleLanguage<?>> clazz = this.loadLanguageClass();
                instance = LanguageCache.readSingleton(clazz);
                if (instance == null) {
                    instance = clazz.newInstance();
                    singleton = false;
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create instance of " + this.name + " language implementation. Public default constructor expected in " + this.className + ".", e);
        }
        return new LoadedLanguage(instance, singleton);
    }

    Class<? extends TruffleLanguage<?>> getLanguageClass() {
        if (TruffleOptions.AOT) {
            TruffleLanguage<?> instance = this.singletonLanguage;
            if (instance != null) {
                return instance.getClass();
            }
            return this.languageClass;
        }
        return this.loadLanguageClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<? extends TruffleLanguage<?>> loadLanguageClass() {
        if (this.languageClass == null) {
            LanguageCache languageCache = this;
            synchronized (languageCache) {
                if (this.languageClass == null) {
                    try {
                        this.languageClass = Class.forName(this.className, true, this.loader);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Cannot load language " + this.name + ". Language implementation class " + this.className + " failed to load.", e);
                    }
                }
            }
        }
        return this.languageClass;
    }

    public String toString() {
        return "LanguageCache [id=" + this.id + ", name=" + this.name + ", implementationName=" + this.implementationName + ", version=" + this.version + ", className=" + this.className + "]";
    }

    private static TruffleLanguage<?> readSingleton(Class<?> languageClass) {
        try {
            return (TruffleLanguage)languageClass.getField("INSTANCE").get(null);
        }
        catch (Exception ex) {
            return null;
        }
    }

    static void resetNativeImageCacheLanguageHomes() {
        for (LanguageCache languageCache : LanguageCache.languages().values()) {
            languageCache.languageHome = null;
        }
    }

    private static void initializeNativeImageState(ClassLoader imageClassLoader) {
        assert (TruffleOptions.AOT) : "Only supported during image generation";
        nativeImageCache.putAll(LanguageCache.createLanguages(imageClassLoader));
    }

    private static void resetNativeImageState() {
        assert (TruffleOptions.AOT) : "Only supported during image generation";
        nativeImageCache.clear();
    }

    private static void removeLanguageFromNativeImage(String languageMime) {
        assert (TruffleOptions.AOT) : "Only supported during image generation";
        assert (nativeImageCache.containsKey(languageMime));
        nativeImageCache.remove(languageMime);
    }

    private static Collection<Class<?>> getLanguageClasses() {
        assert (TruffleOptions.AOT) : "Only supported during image generation";
        ArrayList list = new ArrayList();
        for (LanguageCache cache : nativeImageCache.values()) {
            assert (cache.languageClass != null);
            list.add(cache.languageClass);
        }
        return list;
    }

    static {
        HashMap hashMap = nativeImageCache = TruffleOptions.AOT ? new HashMap() : null;
        if (VMAccessor.SPI == null) {
            VMAccessor.initialize(new PolyglotEngine.LegacyEngineImpl());
        }
    }

    static final class LoadedLanguage {
        private final TruffleLanguage<?> language;
        private final boolean singleton;

        LoadedLanguage(TruffleLanguage<?> language, boolean singleton) {
            this.singleton = singleton;
            this.language = language;
        }

        TruffleLanguage<?> getLanguage() {
            return this.language;
        }

        boolean isSingleton() {
            return this.singleton;
        }
    }
}

