/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.vm;

import com.oracle.truffle.api.vm.PolyglotBindings;
import com.oracle.truffle.api.vm.PolyglotLanguageContext;
import com.oracle.truffle.api.vm.PolyglotValue;
import java.util.Map;
import java.util.Set;
import org.graalvm.polyglot.TypeLiteral;
import org.graalvm.polyglot.Value;

final class PolyglotBindingsValue
extends PolyglotValue {
    final Value delegateBindings;
    final Map<String, Value> values;

    PolyglotBindingsValue(PolyglotLanguageContext context) {
        super(context);
        this.values = context.context.polyglotBindings;
        this.delegateBindings = context.toHostValue(new PolyglotBindings(context, this.values));
    }

    public Value getMember(Object receiver, String key) {
        return this.values.get(key);
    }

    public Set<String> getMemberKeys(Object receiver) {
        return this.values.keySet();
    }

    public boolean removeMember(Object receiver, String key) {
        Value result = this.values.remove(key);
        return result != null;
    }

    public void putMember(Object receiver, String key, Object member) {
        this.values.put(key, this.languageContext.context.asValue(member));
    }

    public boolean hasMembers(Object receiver) {
        return true;
    }

    public boolean hasMember(Object receiver, String key) {
        return this.values.containsKey(key);
    }

    public <T> T as(Object receiver, Class<T> targetType) {
        return (T)this.delegateBindings.as(targetType);
    }

    public <T> T as(Object receiver, TypeLiteral<T> targetType) {
        return (T)this.delegateBindings.as(targetType);
    }

    @Override
    public String toString(Object receiver) {
        return this.delegateBindings.toString();
    }

    @Override
    public Value getMetaObject(Object receiver) {
        return this.delegateBindings.getMetaObject();
    }
}

