/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.vm;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.vm.ContextThreadLocal;
import com.oracle.truffle.api.vm.FileSystems;
import com.oracle.truffle.api.vm.FinalIntMap;
import com.oracle.truffle.api.vm.HostLanguage;
import com.oracle.truffle.api.vm.OptionValuesImpl;
import com.oracle.truffle.api.vm.PolyglotBindingsValue;
import com.oracle.truffle.api.vm.PolyglotEngineImpl;
import com.oracle.truffle.api.vm.PolyglotEngineOptions;
import com.oracle.truffle.api.vm.PolyglotIllegalStateException;
import com.oracle.truffle.api.vm.PolyglotImpl;
import com.oracle.truffle.api.vm.PolyglotLanguage;
import com.oracle.truffle.api.vm.PolyglotLanguageContext;
import com.oracle.truffle.api.vm.PolyglotThreadInfo;
import com.oracle.truffle.api.vm.VMAccessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.graalvm.polyglot.io.FileSystem;

final class PolyglotContextImpl
extends AbstractPolyglotImpl.AbstractContextImpl
implements PolyglotImpl.VMObject {
    @CompilerDirectives.CompilationFinal
    private static SingleContextState singleContextState = new SingleContextState();
    private final Assumption singleThreaded = Truffle.getRuntime().createAssumption("Single threaded");
    private final Assumption singleThreadedConstant = Truffle.getRuntime().createAssumption("Single threaded constant thread");
    private final Map<Thread, PolyglotThreadInfo> threads = new HashMap<Thread, PolyglotThreadInfo>();
    private volatile PolyglotThreadInfo currentThreadInfo = PolyglotThreadInfo.NULL;
    @CompilerDirectives.CompilationFinal
    private volatile PolyglotThreadInfo constantCurrentThreadInfo = PolyglotThreadInfo.NULL;
    volatile boolean cancelling;
    private volatile Thread closingThread;
    volatile boolean closed;
    final PolyglotEngineImpl engine;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    final PolyglotLanguageContext[] contexts;
    Context creatorApi;
    Context currentApi;
    final TruffleContext truffleContext;
    final PolyglotContextImpl parent;
    OutputStream out;
    OutputStream err;
    InputStream in;
    final Map<String, Value> polyglotBindings;
    final Value polyglotHostBindings;
    Predicate<String> classFilter;
    boolean hostAccessAllowed;
    boolean hostClassLoadingAllowed;
    boolean nativeAccessAllowed;
    @CompilerDirectives.CompilationFinal
    boolean createThreadAllowed;
    @CompilerDirectives.CompilationFinal
    private FinalIntMap languageIndexMap;
    Set<String> allowedPublicLanguages;
    Map<String, String[]> applicationArguments;
    private final List<PolyglotContextImpl> childContexts = new ArrayList<PolyglotContextImpl>();
    boolean inContextPreInitialization;
    FileSystem fileSystem;

    static void resetSingleContextState() {
        singleContextState = new SingleContextState();
    }

    private PolyglotContextImpl() {
        super(null);
        this.engine = null;
        this.contexts = null;
        this.truffleContext = null;
        this.parent = null;
        this.polyglotHostBindings = null;
        this.polyglotBindings = null;
    }

    PolyglotContextImpl(PolyglotEngineImpl engine, OutputStream out, OutputStream err, InputStream in, boolean hostAccessAllowed, boolean nativeAccessAllowed, boolean createThreadAllowed, boolean hostClassLoadingAllowed, Predicate<String> classFilter, Map<String, String> options, Map<String, String[]> applicationArguments, Set<String> allowedPublicLanguages, FileSystem fileSystem) {
        super((AbstractPolyglotImpl)engine.impl);
        PolyglotLanguageContext hostContext;
        this.parent = null;
        this.engine = engine;
        this.fileSystem = fileSystem;
        this.patchInstance(out, err, in, hostAccessAllowed, nativeAccessAllowed, createThreadAllowed, hostClassLoadingAllowed, classFilter, applicationArguments, allowedPublicLanguages);
        Collection<PolyglotLanguage> languages = engine.idToLanguage.values();
        this.contexts = new PolyglotLanguageContext[languages.size() + 1];
        this.contexts[0] = hostContext = new PolyglotLanguageContext(this, engine.hostLanguage, null, applicationArguments.get("host"), Collections.emptyMap(), false);
        for (PolyglotLanguage language : languages) {
            PolyglotLanguageContext languageContext;
            this.contexts[language.index] = languageContext = new PolyglotLanguageContext(this, language, null, applicationArguments.get(language.getId()), Collections.emptyMap(), true);
        }
        for (String optionKey : options.keySet()) {
            PolyglotLanguage language = this.findLanguageForOption(optionKey);
            this.contexts[language.index].getOptionValues().put(optionKey, options.get(optionKey));
        }
        hostContext.ensureInitialized(null);
        PolyglotContextImpl.initializeStaticContext(this);
        this.polyglotBindings = new ConcurrentHashMap<String, Value>();
        this.polyglotHostBindings = this.getAPIAccess().newValue(this.polyglotBindings, (AbstractPolyglotImpl.AbstractValueImpl)new PolyglotBindingsValue(hostContext));
        this.truffleContext = VMAccessor.LANGUAGE.createTruffleContext(this);
        VMAccessor.INSTRUMENT.notifyContextCreated(engine, this.truffleContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initializeStaticContext(PolyglotContextImpl context) {
        SingleContextState state = singleContextState;
        if (state.singleContextAssumption.isValid()) {
            SingleContextState singleContextState = state;
            synchronized (singleContextState) {
                if (state.singleContextAssumption.isValid()) {
                    if (state.singleContext != null) {
                        state.singleContextAssumption.invalidate();
                        state.singleContext = null;
                    } else {
                        state.singleContext = context;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disposeStaticContext(PolyglotContextImpl context) {
        SingleContextState state = singleContextState;
        if (state.singleContextAssumption.isValid()) {
            SingleContextState singleContextState = state;
            synchronized (singleContextState) {
                if (state.singleContextAssumption.isValid()) {
                    assert (state.singleContext == context);
                    state.singleContext = null;
                }
            }
        }
    }

    PolyglotContextImpl(PolyglotLanguageContext creator, Map<String, Object> config, TruffleContext spiContext) {
        super((AbstractPolyglotImpl)creator.getEngine().impl);
        PolyglotLanguageContext hostContext;
        PolyglotContextImpl parent = creator.context;
        this.parent = creator.context;
        this.hostAccessAllowed = parent.hostAccessAllowed;
        this.hostClassLoadingAllowed = parent.hostClassLoadingAllowed;
        this.nativeAccessAllowed = parent.nativeAccessAllowed;
        this.createThreadAllowed = parent.createThreadAllowed;
        this.applicationArguments = parent.applicationArguments;
        this.classFilter = parent.classFilter;
        this.out = parent.out;
        this.err = parent.err;
        this.in = parent.in;
        this.allowedPublicLanguages = parent.allowedPublicLanguages;
        this.engine = parent.engine;
        Collection<PolyglotLanguage> languages = this.engine.idToLanguage.values();
        this.contexts = new PolyglotLanguageContext[languages.size() + 1];
        this.contexts[0] = hostContext = new PolyglotLanguageContext(this, this.engine.hostLanguage, null, this.applicationArguments.get("host"), Collections.emptyMap(), false);
        for (PolyglotLanguage language : languages) {
            PolyglotLanguageContext languageContext;
            OptionValuesImpl values = parent.contexts[language.index].optionValues;
            if (values != null) {
                values = values.copy();
            }
            Map<String, Object> languageConfig = creator.language == language ? config : new HashMap<String, Object>();
            this.contexts[language.index] = languageContext = new PolyglotLanguageContext(this, language, values, this.applicationArguments.get(language.getId()), languageConfig, true);
        }
        this.parent.addChildContext(this);
        this.truffleContext = spiContext;
        hostContext.ensureInitialized(null);
        this.polyglotBindings = new ConcurrentHashMap<String, Value>();
        this.polyglotHostBindings = this.getAPIAccess().newValue(this.polyglotBindings, (AbstractPolyglotImpl.AbstractValueImpl)new PolyglotBindingsValue(hostContext));
        PolyglotContextImpl.initializeStaticContext(this);
    }

    void notifyContextCreated() {
        VMAccessor.INSTRUMENT.notifyContextCreated(this.engine, this.truffleContext);
    }

    private synchronized void addChildContext(PolyglotContextImpl child) {
        if (this.closingThread != null) {
            throw new IllegalStateException("Adding child context into a closing context.");
        }
        this.childContexts.add(child);
    }

    Predicate<String> getClassFilter() {
        return this.classFilter;
    }

    static PolyglotContextImpl current() {
        if (singleContextState.singleContextAssumption.isValid()) {
            if (singleContextState.contextThreadLocal.isSet()) {
                return singleContextState.singleContext;
            }
            CompilerDirectives.transferToInterpreter();
            return null;
        }
        return (PolyglotContextImpl)singleContextState.contextThreadLocal.get();
    }

    static PolyglotContextImpl requireContext() {
        PolyglotContextImpl context = PolyglotContextImpl.current();
        if (context == null) {
            CompilerDirectives.transferToInterpreter();
            context = PolyglotContextImpl.current();
            if (context == null) {
                throw new AssertionError((Object)"No current context available.");
            }
        }
        return context;
    }

    public synchronized void explicitEnter(Context sourceContext) {
        this.checkCreatorAccess(sourceContext, "entered");
        Object prev = this.enter();
        PolyglotThreadInfo current = this.getCurrentThreadInfo();
        assert (current.thread == Thread.currentThread());
        current.explicitContextStack.addLast(prev);
    }

    public synchronized void explicitLeave(Context sourceContext) {
        this.checkCreatorAccess(sourceContext, "left");
        PolyglotThreadInfo current = this.getCurrentThreadInfo();
        LinkedList<Object> stack = current.explicitContextStack;
        if (stack.isEmpty() || current.thread == null) {
            throw new IllegalStateException("The context is not entered explicity. A context can only be left if it was previously entered.");
        }
        this.leave(stack.removeLast());
    }

    private void checkCreatorAccess(Context context, String operation) {
        if (context != this.creatorApi) {
            throw new IllegalStateException(String.format("Context instances that were received using Context.get() cannot be %s.", operation));
        }
    }

    boolean needsEnter() {
        if (singleContextState.singleContextAssumption.isValid()) {
            return !singleContextState.contextThreadLocal.isSet();
        }
        return PolyglotContextImpl.current() != this;
    }

    PolyglotThreadInfo getCachedThreadInfo() {
        return this.singleThreadedConstant.isValid() ? this.constantCurrentThreadInfo : this.currentThreadInfo;
    }

    Object enter() {
        Object context;
        PolyglotThreadInfo info = this.getCachedThreadInfo();
        if (CompilerDirectives.injectBranchProbability(0.75, info.thread == Thread.currentThread())) {
            context = singleContextState.contextThreadLocal.setReturnParent(this);
            info.enter();
        } else {
            if (this.singleThreaded.isValid()) {
                CompilerDirectives.transferToInterpreter();
            }
            context = this.enterThreadChanged();
        }
        assert (this == PolyglotContextImpl.current());
        return context;
    }

    void leave(Object prev) {
        assert (PolyglotContextImpl.current() == this) : "Cannot leave context that is currently not entered. Forgot to enter or leave a context?";
        PolyglotThreadInfo info = this.getCachedThreadInfo();
        if (CompilerDirectives.injectBranchProbability(0.75, info.thread == Thread.currentThread())) {
            info.leave();
        } else {
            if (this.singleThreaded.isValid()) {
                CompilerDirectives.transferToInterpreter();
            }
            this.leaveThreadChanged();
        }
        singleContextState.contextThreadLocal.set(prev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    PolyglotContextImpl enterThreadChanged() {
        PolyglotContextImpl prev;
        Thread current = Thread.currentThread();
        boolean needsInitialization = false;
        PolyglotContextImpl polyglotContextImpl = this;
        synchronized (polyglotContextImpl) {
            boolean transitionToMultiThreading;
            this.engine.checkState();
            this.checkClosed();
            PolyglotThreadInfo threadInfo = this.getCurrentThreadInfo();
            assert (threadInfo != null);
            threadInfo = this.threads.get(current);
            if (threadInfo == null) {
                threadInfo = this.createThreadInfo(current);
                needsInitialization = !this.inContextPreInitialization;
            }
            boolean bl = transitionToMultiThreading = this.singleThreaded.isValid() && this.hasActiveOtherThread(true);
            if (transitionToMultiThreading) {
                this.checkAllThreadAccesses();
            }
            Thread closing = this.closingThread;
            if (needsInitialization) {
                if (closing != null && closing != current) {
                    throw new PolyglotIllegalStateException("Can not create new threads in closing context.");
                }
                this.threads.put(current, threadInfo);
            }
            prev = (PolyglotContextImpl)singleContextState.contextThreadLocal.setReturnParent(this);
            threadInfo.enter();
            if (transitionToMultiThreading) {
                this.transitionToMultiThreaded();
            }
            if (needsInitialization) {
                this.initializeNewThread(current);
            }
            if (!this.closed && closing == null) {
                this.setCachedThreadInfo(threadInfo);
            }
        }
        if (needsInitialization) {
            VMAccessor.INSTRUMENT.notifyThreadStarted(this.engine, this.truffleContext, current);
        }
        return prev;
    }

    private void setCachedThreadInfo(PolyglotThreadInfo info) {
        assert (Thread.holdsLock(this));
        if (this.constantCurrentThreadInfo != info) {
            if (this.constantCurrentThreadInfo.thread == null) {
                this.constantCurrentThreadInfo = info;
            } else {
                this.constantCurrentThreadInfo = PolyglotThreadInfo.NULL;
                this.singleThreadedConstant.invalidate();
            }
        }
        this.constantCurrentThreadInfo = info;
        this.currentThreadInfo = info;
    }

    private void checkAllThreadAccesses() {
        Thread current = Thread.currentThread();
        ArrayList<PolyglotLanguage> deniedLanguages = null;
        for (PolyglotLanguageContext context : this.contexts) {
            if (!context.isInitialized()) continue;
            boolean accessAllowed = true;
            if (!VMAccessor.LANGUAGE.isThreadAccessAllowed(context.language.info, current, false)) {
                accessAllowed = false;
            }
            if (accessAllowed) {
                for (PolyglotThreadInfo seenThread : this.threads.values()) {
                    if (VMAccessor.LANGUAGE.isThreadAccessAllowed(context.language.info, seenThread.thread, false)) continue;
                    accessAllowed = false;
                    break;
                }
            }
            if (accessAllowed) continue;
            if (deniedLanguages == null) {
                deniedLanguages = new ArrayList<PolyglotLanguage>();
            }
            deniedLanguages.add(context.language);
        }
        if (deniedLanguages != null) {
            throw PolyglotContextImpl.throwDeniedThreadAccess(current, false, deniedLanguages);
        }
    }

    @CompilerDirectives.TruffleBoundary
    synchronized PolyglotThreadInfo leaveThreadChanged() {
        Thread current = Thread.currentThread();
        this.setCachedThreadInfo(PolyglotThreadInfo.NULL);
        PolyglotThreadInfo threadInfo = this.threads.get(current);
        assert (threadInfo != null);
        PolyglotThreadInfo info = threadInfo;
        if (this.cancelling && info.isLastActive()) {
            this.notifyThreadClosed();
        }
        info.leave();
        if (!this.closed && !this.cancelling) {
            this.setCachedThreadInfo(threadInfo);
        }
        return info;
    }

    private void initializeNewThread(Thread thread) {
        for (PolyglotLanguageContext context : this.contexts) {
            if (!context.isInitialized()) continue;
            VMAccessor.LANGUAGE.initializeThread(context.env, thread);
        }
    }

    private void transitionToMultiThreaded() {
        assert (this.singleThreaded.isValid());
        assert (Thread.holdsLock(this));
        for (PolyglotLanguageContext context : this.contexts) {
            if (!context.isInitialized()) continue;
            VMAccessor.LANGUAGE.initializeMultiThreading(context.env);
        }
        this.singleThreaded.invalidate();
        this.singleThreadedConstant.invalidate();
    }

    private PolyglotThreadInfo createThreadInfo(Thread current) {
        assert (Thread.holdsLock(this));
        PolyglotThreadInfo threadInfo = new PolyglotThreadInfo(current);
        boolean singleThread = this.isSingleThreaded();
        ArrayList<PolyglotLanguage> deniedLanguages = null;
        for (PolyglotLanguageContext context : this.contexts) {
            if (!context.isInitialized() || VMAccessor.LANGUAGE.isThreadAccessAllowed(context.language.info, current, singleThread)) continue;
            if (deniedLanguages == null) {
                deniedLanguages = new ArrayList<PolyglotLanguage>();
            }
            deniedLanguages.add(context.language);
        }
        if (deniedLanguages != null) {
            throw PolyglotContextImpl.throwDeniedThreadAccess(current, singleThread, deniedLanguages);
        }
        return threadInfo;
    }

    static RuntimeException throwDeniedThreadAccess(Thread current, boolean accessSingleThreaded, List<PolyglotLanguage> deniedLanguages) {
        StringBuilder languagesString = new StringBuilder("");
        for (PolyglotLanguage language : deniedLanguages) {
            if (languagesString.length() != 0) {
                languagesString.append(", ");
            }
            languagesString.append(language.getId());
        }
        String message = accessSingleThreaded ? String.format("Single threaded access requested by thread %s but is not allowed for language(s) %s.", current, languagesString) : String.format("Multi threaded access requested by thread %s but is not allowed for language(s) %s.", current, languagesString);
        throw new PolyglotIllegalStateException(message);
    }

    Value findLegacyExportedSymbol(String symbolName) {
        Value legacySymbol = this.findLegacyExportedSymbol(symbolName, true);
        if (legacySymbol != null) {
            return legacySymbol;
        }
        return this.findLegacyExportedSymbol(symbolName, false);
    }

    private Value findLegacyExportedSymbol(String name, boolean onlyExplicit) {
        for (PolyglotLanguageContext languageContext : this.contexts) {
            Object s;
            TruffleLanguage.Env env = languageContext.env;
            if (env == null || (s = VMAccessor.LANGUAGE.findExportedSymbol(env, name, onlyExplicit)) == null) continue;
            return languageContext.toHostValue(s);
        }
        return null;
    }

    public Value getBindings(String languageId) {
        return this.contexts[this.requirePublicLanguage((String)languageId).index].getHostBindings();
    }

    public Value getPolyglotBindings() {
        this.checkClosed();
        return this.polyglotHostBindings;
    }

    private void checkClosed() {
        if (this.closed) {
            throw new PolyglotIllegalStateException("The Context is already closed.");
        }
    }

    PolyglotLanguageContext getHostContext() {
        return this.contexts[0];
    }

    HostLanguage.HostContext getHostContextImpl() {
        return (HostLanguage.HostContext)this.getHostContext().getContextImpl();
    }

    PolyglotLanguageContext findLanguageContext(String languageId, String mimeType, boolean failIfNotFound) {
        PolyglotLanguage language;
        assert (languageId != null || mimeType != null) : Objects.toString(languageId) + ", " + Objects.toString(mimeType);
        if (languageId != null && (language = this.engine.idToLanguage.get(languageId)) != null) {
            return this.contexts[language.index];
        }
        if (mimeType != null) {
            language = this.engine.idToLanguage.get(mimeType);
            if (language != null) {
                return this.contexts[language.index];
            }
            for (PolyglotLanguageContext context : this.contexts) {
                if (!context.language.cache.getMimeTypes().contains(mimeType)) continue;
                return context;
            }
        }
        if (failIfNotFound) {
            if (languageId != null) {
                LinkedHashSet<String> ids = new LinkedHashSet<String>();
                for (PolyglotLanguage language2 : this.engine.idToLanguage.values()) {
                    ids.add(language2.cache.getId());
                }
                throw new IllegalStateException("No language for id " + languageId + " found. Supported languages are: " + ids);
            }
            LinkedHashSet<String> mimeTypes = new LinkedHashSet<String>();
            for (PolyglotLanguageContext language3 : this.contexts) {
                mimeTypes.addAll(language3.language.cache.getMimeTypes());
            }
            throw new IllegalStateException("No language for MIME type " + mimeType + " found. Supported languages are: " + mimeTypes);
        }
        return null;
    }

    PolyglotLanguageContext findLanguageContext(Class<? extends TruffleLanguage> languageClazz, boolean failIfNotFound) {
        for (PolyglotLanguageContext lang : this.contexts) {
            TruffleLanguage.Env env = lang.env;
            if (env == null) continue;
            TruffleLanguage<?> language = VMAccessor.NODES.getLanguageSpi(lang.language.info);
            if (languageClazz == TruffleLanguage.class || !languageClazz.isInstance(language)) continue;
            return lang;
        }
        if (failIfNotFound) {
            HashSet<String> languageNames = new HashSet<String>();
            for (PolyglotLanguageContext lang : this.contexts) {
                if (lang.env == null) continue;
                languageNames.add(lang.language.cache.getClassName());
            }
            throw new IllegalStateException("Cannot find language " + languageClazz + " among " + languageNames);
        }
        return null;
    }

    @Override
    public PolyglotEngineImpl getEngine() {
        return this.engine;
    }

    PolyglotLanguageContext getLanguageContext(Class<? extends TruffleLanguage<?>> languageClass) {
        if (CompilerDirectives.isPartialEvaluationConstant(this)) {
            return this.getLanguageContextImpl(languageClass);
        }
        return this.getLanguageContextBoundary(languageClass);
    }

    @CompilerDirectives.TruffleBoundary
    private PolyglotLanguageContext getLanguageContextBoundary(Class<? extends TruffleLanguage<?>> languageClass) {
        return this.getLanguageContextImpl(languageClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PolyglotLanguageContext getLanguageContextImpl(Class<? extends TruffleLanguage<?>> languageClass) {
        int indexValue;
        FinalIntMap map = this.languageIndexMap;
        int n = indexValue = map != null ? map.get(languageClass) : -1;
        if (indexValue == -1) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            PolyglotContextImpl polyglotContextImpl = this;
            synchronized (polyglotContextImpl) {
                if (this.languageIndexMap == null) {
                    this.languageIndexMap = new FinalIntMap();
                }
                if ((indexValue = this.languageIndexMap.get(languageClass)) == -1) {
                    PolyglotLanguageContext context = this.findLanguageContext(languageClass, true);
                    indexValue = context.language.index;
                    this.languageIndexMap.put(languageClass, indexValue);
                }
            }
        }
        PolyglotLanguageContext context = this.contexts[indexValue];
        return context;
    }

    public boolean initializeLanguage(String languageId) {
        PolyglotLanguage language = this.requirePublicLanguage(languageId);
        PolyglotLanguageContext languageContext = this.contexts[language.index];
        languageContext.checkAccess(null);
        Object prev = languageContext.enter();
        try {
            boolean bl = languageContext.ensureInitialized(null);
            return bl;
        }
        catch (Throwable t) {
            throw PolyglotImpl.wrapGuestException(languageContext, t);
        }
        finally {
            languageContext.leave(prev);
        }
    }

    public Value eval(String languageId, Object sourceImpl) {
        PolyglotLanguage language = this.requirePublicLanguage(languageId);
        Object prev = this.enter();
        PolyglotLanguageContext languageContext = this.contexts[language.index];
        try {
            languageContext.checkAccess(null);
            Source source = (Source)sourceImpl;
            CallTarget target = languageContext.parseCached(null, source, null);
            Object result = target.call(PolyglotImpl.EMPTY_ARGS);
            if (source.isInteractive()) {
                PolyglotContextImpl.printResult(languageContext, result);
            }
            Value value = languageContext.toHostValue(result);
            return value;
        }
        catch (Throwable e) {
            throw PolyglotImpl.wrapGuestException(languageContext, e);
        }
        finally {
            this.leave(prev);
        }
    }

    private PolyglotLanguage requirePublicLanguage(String languageId) {
        PolyglotLanguage language = this.engine.idToLanguage.get(languageId);
        if (language == null || language.cache.isInternal()) {
            this.engine.requirePublicLanguage(languageId);
            assert (false);
            return null;
        }
        return language;
    }

    @CompilerDirectives.TruffleBoundary
    private static void printResult(PolyglotLanguageContext languageContext, Object result) {
        String stringResult = VMAccessor.LANGUAGE.toStringIfVisible(languageContext.env, result, true);
        if (stringResult != null) {
            try {
                OutputStream out = languageContext.context.out;
                out.write(stringResult.getBytes(StandardCharsets.UTF_8));
                out.write(System.getProperty("line.separator").getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException ioex) {
                throw new IllegalStateException(ioex);
            }
        }
    }

    public Engine getEngineImpl(Context sourceContext) {
        return sourceContext == this.creatorApi ? this.engine.creatorApi : this.engine.currentApi;
    }

    public void close(Context sourceContext, boolean cancelIfExecuting) {
        this.checkCreatorAccess(sourceContext, "closed");
        boolean closeCompleted = this.closeImpl(cancelIfExecuting, cancelIfExecuting);
        if (cancelIfExecuting) {
            this.engine.getCancelHandler().waitForClosing(this);
        } else if (!closeCompleted) {
            throw new PolyglotIllegalStateException(String.format("The context is currently executing on another thread. Set cancelIfExecuting to true to stop the execution on this thread.", new Object[0]));
        }
        if (this.engine.boundEngine && this.parent == null) {
            try {
                this.engine.ensureClosed(cancelIfExecuting, false);
            }
            catch (Throwable t) {
                throw PolyglotImpl.wrapGuestException(this.engine, t);
            }
        }
    }

    public Value asValue(Object hostValue) {
        if (hostValue instanceof Value) {
            return (Value)hostValue;
        }
        PolyglotLanguageContext hostContext = this.getHostContext();
        return hostContext.toHostValue(hostContext.toGuestValue(hostValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForClose() {
        while (!this.closeImpl(false, true)) {
            try {
                PolyglotContextImpl polyglotContextImpl = this;
                synchronized (polyglotContextImpl) {
                    this.wait(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    boolean isSingleThreaded() {
        return this.singleThreaded.isValid();
    }

    Map<Thread, PolyglotThreadInfo> getSeenThreads() {
        assert (Thread.holdsLock(this));
        return this.threads;
    }

    synchronized boolean isActive() {
        this.setCachedThreadInfo(PolyglotThreadInfo.NULL);
        for (PolyglotThreadInfo seenTinfo : this.threads.values()) {
            if (!seenTinfo.isActive()) continue;
            return true;
        }
        return false;
    }

    PolyglotThreadInfo getFirstActiveOtherThread(boolean includePolyglotThread) {
        assert (Thread.holdsLock(this));
        this.setCachedThreadInfo(PolyglotThreadInfo.NULL);
        for (PolyglotThreadInfo otherInfo : this.threads.values()) {
            if (!includePolyglotThread && otherInfo.isPolyglotThread(this) || otherInfo.isCurrent() || !otherInfo.isActive()) continue;
            return otherInfo;
        }
        return null;
    }

    boolean hasActiveOtherThread(boolean includePolyglotThreads) {
        return this.getFirstActiveOtherThread(includePolyglotThreads) != null;
    }

    synchronized void notifyThreadClosed() {
        PolyglotThreadInfo currentTInfo = this.getCurrentThreadInfo();
        if (currentTInfo != PolyglotThreadInfo.NULL) {
            currentTInfo.cancelled = true;
            Thread.interrupted();
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    boolean closeImpl(boolean cancelIfExecuting, boolean waitForPolyglotThreads) {
        Thread[] remainingThreads;
        boolean success;
        block50: {
            success = false;
            remainingThreads = null;
            PolyglotContextImpl[] childrenToClose = null;
            try {
                block52: {
                    block53: {
                        PolyglotContextImpl polyglotContextImpl;
                        PolyglotThreadInfo threadInfo;
                        block54: {
                            PolyglotContextImpl polyglotContextImpl2 = this;
                            synchronized (polyglotContextImpl2) {
                                block49: {
                                    if (this.closed) break block54;
                                    threadInfo = this.getCurrentThreadInfo();
                                    this.setCachedThreadInfo(PolyglotThreadInfo.NULL);
                                    if (!threadInfo.explicitContextStack.isEmpty()) {
                                        throw new IllegalStateException("The context is explicitely entered on the current thread. Call leave() before closing the context to resolve this.");
                                    }
                                    childrenToClose = this.childContexts.toArray(new PolyglotContextImpl[this.childContexts.size()]);
                                    if (cancelIfExecuting) {
                                        this.cancelling = true;
                                        if (threadInfo != PolyglotThreadInfo.NULL) {
                                            threadInfo.cancelled = true;
                                            Thread.interrupted();
                                        }
                                    }
                                    if (!this.hasActiveOtherThread(waitForPolyglotThreads)) break block49;
                                    boolean bl = false;
                                    return bl;
                                }
                                this.closingThread = Thread.currentThread();
                            }
                        }
                        if (childrenToClose == null) break block50;
                        Object prev = this.enter();
                        try {
                            boolean finalizationPerformed;
                            void var9_18;
                            threadInfo = childrenToClose;
                            int n = ((PolyglotThreadInfo)threadInfo).length;
                            boolean bl = false;
                            while (var9_18 < n) {
                                PolyglotThreadInfo polyglotThreadInfo = threadInfo[var9_18];
                                ((PolyglotContextImpl)((Object)polyglotThreadInfo)).closeImpl(cancelIfExecuting, waitForPolyglotThreads);
                                ++var9_18;
                            }
                            do {
                                finalizationPerformed = false;
                                for (int i = this.contexts.length - 1; i >= 0; --i) {
                                    PolyglotLanguageContext polyglotLanguageContext = this.contexts[i];
                                    try {
                                        finalizationPerformed |= polyglotLanguageContext.finalizeContext();
                                        continue;
                                    }
                                    catch (Error | Exception throwable) {
                                        throw PolyglotImpl.wrapGuestException(polyglotLanguageContext, throwable);
                                    }
                                }
                            } while (finalizationPerformed);
                            this.closed = true;
                            ArrayList<PolyglotLanguageContext> disposedContexts = new ArrayList<PolyglotLanguageContext>(this.contexts.length);
                            try {
                                PolyglotContextImpl polyglotContextImpl2 = this;
                                synchronized (polyglotContextImpl2) {
                                    void var10_27;
                                    int n2 = this.contexts.length - 1;
                                    while (var10_27 >= 0) {
                                        PolyglotLanguageContext context2 = this.contexts[var10_27];
                                        try {
                                            boolean disposed = context2.dispose();
                                            if (disposed) {
                                                disposedContexts.add(context2);
                                            }
                                        }
                                        catch (Error | Exception ex) {
                                            throw PolyglotImpl.wrapGuestException(context2, ex);
                                        }
                                        --var10_27;
                                    }
                                }
                            }
                            finally {
                                for (PolyglotLanguageContext polyglotLanguageContext : disposedContexts) {
                                    polyglotLanguageContext.notifyDisposed();
                                }
                            }
                            assert (this.childContexts.isEmpty());
                            success = true;
                            this.leave(prev);
                            if (!success) break block52;
                            if (this.parent == null) break block53;
                            polyglotContextImpl = this.parent;
                        }
                        catch (Throwable throwable) {
                            this.leave(prev);
                            if (success) {
                                PolyglotContextImpl polyglotContextImpl3;
                                if (this.parent != null) {
                                    polyglotContextImpl3 = this.parent;
                                    synchronized (polyglotContextImpl3) {
                                        this.parent.childContexts.remove(this);
                                    }
                                } else {
                                    this.engine.removeContext(this);
                                }
                                polyglotContextImpl3 = this;
                                synchronized (polyglotContextImpl3) {
                                    remainingThreads = this.threads.keySet().toArray(new Thread[0]);
                                }
                            }
                            this.closed = success;
                            if (success && this.engine.boundEngine) {
                                PolyglotContextImpl.disposeStaticContext(this);
                            }
                            this.cancelling = false;
                            throw throwable;
                        }
                        synchronized (polyglotContextImpl) {
                            this.parent.childContexts.remove(this);
                        }
                    }
                    this.engine.removeContext(this);
                    PolyglotContextImpl polyglotContextImpl = this;
                    synchronized (polyglotContextImpl) {
                        remainingThreads = this.threads.keySet().toArray(new Thread[0]);
                    }
                }
                this.closed = success;
                if (success && this.engine.boundEngine) {
                    PolyglotContextImpl.disposeStaticContext(this);
                }
                this.cancelling = false;
            }
            finally {
                this.closingThread = null;
            }
        }
        if (success) {
            for (PolyglotContextImpl polyglotContextImpl : remainingThreads) {
                VMAccessor.INSTRUMENT.notifyThreadFinished(this.engine, this.truffleContext, (Thread)((Object)polyglotContextImpl));
            }
            VMAccessor.INSTRUMENT.notifyContextClosed(this.engine, this.truffleContext);
        }
        return true;
    }

    synchronized void sendInterrupt() {
        if (!this.cancelling) {
            return;
        }
        for (PolyglotThreadInfo threadInfo : this.threads.values()) {
            if (threadInfo.isCurrent() || !threadInfo.isActive()) continue;
            threadInfo.thread.interrupt();
        }
    }

    PolyglotThreadInfo getCurrentThreadInfo() {
        PolyglotThreadInfo currentTInfo = this.currentThreadInfo;
        if (currentTInfo.thread != Thread.currentThread() && (currentTInfo = this.threads.get(Thread.currentThread())) == null) {
            currentTInfo = PolyglotThreadInfo.NULL;
        }
        assert (currentTInfo.thread == null || currentTInfo.thread == Thread.currentThread());
        return currentTInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean patch(OutputStream newOut, OutputStream newErr, InputStream newIn, boolean newHostAccessAllowed, boolean newNativeAccessAllowed, boolean newCreateThreadAllowed, boolean newHostClassLoadingAllowed, Predicate<String> newClassFilter, Map<String, String> newOptions, Map<String, String[]> newApplicationArguments, Set<String> newAllowedPublicLanguages, FileSystem newFileSystem) {
        CompilerAsserts.neverPartOfCompilation();
        this.patchInstance(newOut, newErr, newIn, newHostAccessAllowed, newNativeAccessAllowed, newCreateThreadAllowed, newHostClassLoadingAllowed, newClassFilter, newApplicationArguments, newAllowedPublicLanguages);
        ((FileSystems.PreInitializeContextFileSystem)this.fileSystem).patchDelegate(newFileSystem);
        HashMap<String, HashMap<String, String>> optionsByLanguage = new HashMap<String, HashMap<String, String>>();
        for (String optionKey : newOptions.keySet()) {
            PolyglotLanguage language = this.findLanguageForOption(optionKey);
            HashMap<String, String> languageOptions = (HashMap<String, String>)optionsByLanguage.get(language.getId());
            if (languageOptions == null) {
                languageOptions = new HashMap<String, String>();
                optionsByLanguage.put(language.getId(), languageOptions);
            }
            languageOptions.put(optionKey, newOptions.get(optionKey));
        }
        PolyglotContextImpl.initializeStaticContext(this);
        Object prev = this.enter();
        try {
            for (int i = 1; i < this.contexts.length; ++i) {
                PolyglotLanguageContext context = this.contexts[i];
                if (context.patch((Map)optionsByLanguage.get(context.language.getId()), newApplicationArguments.get(context.language.getId()))) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.leave(prev);
        }
        return true;
    }

    private void patchInstance(OutputStream newOut, OutputStream newErr, InputStream newIn, boolean newHostAccessAllowed, boolean newNativeAccessAllowed, boolean newCreateThreadAllowed, boolean newHostClassLoadingAllowed, Predicate<String> newClassFilter, Map<String, String[]> newApplicationArguments, Set<String> newAllowedPublicLanguages) {
        this.hostAccessAllowed = newHostAccessAllowed;
        this.nativeAccessAllowed = newNativeAccessAllowed;
        this.createThreadAllowed = newCreateThreadAllowed;
        this.hostClassLoadingAllowed = newHostClassLoadingAllowed;
        this.applicationArguments = newApplicationArguments;
        this.classFilter = newClassFilter;
        this.out = newOut == null || newOut == VMAccessor.INSTRUMENT.getOut(this.engine.out) ? this.engine.out : VMAccessor.INSTRUMENT.createDelegatingOutput(newOut, this.engine.out);
        this.err = newErr == null || newErr == VMAccessor.INSTRUMENT.getOut(this.engine.err) ? this.engine.err : VMAccessor.INSTRUMENT.createDelegatingOutput(newErr, this.engine.err);
        this.in = newIn == null ? this.engine.in : newIn;
        this.allowedPublicLanguages = newAllowedPublicLanguages;
    }

    private PolyglotLanguage findLanguageForOption(String optionKey) {
        String group = PolyglotEngineImpl.parseOptionGroup(optionKey);
        PolyglotLanguage language = this.engine.idToLanguage.get(group);
        if (language == null) {
            if (this.engine.isEngineGroup(group) && this.engine.getAllOptions().get(optionKey) != null) {
                throw new IllegalArgumentException("Option " + optionKey + " is an engine option. Engine level options can only be configured for contexts without a shared engine set. To resolve this, configure the option when creating the Engine or create a context without a shared engine.");
            }
            throw OptionValuesImpl.failNotFound(this.engine.getAllOptions(), optionKey);
        }
        assert (!this.engine.isEngineGroup(group));
        return language;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PolyglotContextImpl preInitialize(PolyglotEngineImpl engine) {
        FileSystems.PreInitializeContextFileSystem fs = new FileSystems.PreInitializeContextFileSystem();
        PolyglotContextImpl context = new PolyglotContextImpl(engine, null, null, null, false, false, false, false, null, Collections.emptyMap(), Collections.emptyMap(), engine.getLanguages().keySet(), fs);
        String optionValue = engine.engineOptionValues.get(PolyglotEngineOptions.PreinitializeContexts);
        if (optionValue != null && !optionValue.isEmpty()) {
            HashSet languagesToPreinitialize = new HashSet();
            Collections.addAll(languagesToPreinitialize, optionValue.split(","));
            context.inContextPreInitialization = true;
            try {
                Object prev = context.enter();
                try {
                    for (String languageId : engine.getLanguages().keySet()) {
                        PolyglotLanguageContext languageContext;
                        if (languagesToPreinitialize.contains(languageId) && (languageContext = context.findLanguageContext(languageId, null, false)) != null) {
                            languageContext.preInitialize();
                        }
                        PolyglotLanguage language = engine.idToLanguage.get(languageId);
                        language.clearOptionValues();
                    }
                }
                finally {
                    context.leave(prev);
                }
            }
            finally {
                context.inContextPreInitialization = false;
                fs.patchDelegate(FileSystems.newNoIOFileSystem(null));
            }
        }
        context.currentThreadInfo = PolyglotThreadInfo.NULL;
        context.constantCurrentThreadInfo = PolyglotThreadInfo.NULL;
        PolyglotContextImpl.disposeStaticContext(context);
        return context;
    }

    static final class SingleContextState {
        private final ContextThreadLocal contextThreadLocal = new ContextThreadLocal();
        private final Assumption singleContextAssumption = Truffle.getRuntime().createAssumption("Single Context");
        @CompilerDirectives.CompilationFinal
        private volatile PolyglotContextImpl singleContext;

        SingleContextState() {
        }
    }
}

