/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.vm;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.InstrumentInfo;
import com.oracle.truffle.api.Scope;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.impl.DispatchOutputStream;
import com.oracle.truffle.api.impl.FindContextNode;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.java.JavaInterop;
import com.oracle.truffle.api.nodes.ExecutableNode;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.vm.ComputeInExecutor;
import com.oracle.truffle.api.vm.ConvertedObject;
import com.oracle.truffle.api.vm.DefaultScope;
import com.oracle.truffle.api.vm.EngineTruffleObject;
import com.oracle.truffle.api.vm.FileSystems;
import com.oracle.truffle.api.vm.FinalIntMap;
import com.oracle.truffle.api.vm.FindContextNodeImpl;
import com.oracle.truffle.api.vm.HostException;
import com.oracle.truffle.api.vm.InstrumentCache;
import com.oracle.truffle.api.vm.OptionValuesImpl;
import com.oracle.truffle.api.vm.PolyglotArrayIndexOutOfBoundsException;
import com.oracle.truffle.api.vm.PolyglotCache;
import com.oracle.truffle.api.vm.PolyglotClassCastException;
import com.oracle.truffle.api.vm.PolyglotEngineProfile;
import com.oracle.truffle.api.vm.PolyglotIllegalArgumentException;
import com.oracle.truffle.api.vm.PolyglotImpl;
import com.oracle.truffle.api.vm.PolyglotRootNode;
import com.oracle.truffle.api.vm.PolyglotRuntime;
import com.oracle.truffle.api.vm.PolyglotUnsupportedException;
import com.oracle.truffle.api.vm.VMAccessor;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.graalvm.options.OptionValues;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.io.FileSystem;

@Deprecated
public class PolyglotEngine {
    static final PolyglotEngine UNUSABLE_ENGINE = new PolyglotEngine();
    static final PolyglotEngineProfile GLOBAL_PROFILE;
    static final Object UNSET_CONTEXT;
    private final Thread initThread;
    private final PolyglotCache cachedTargets;
    private final Map<PolyglotRuntime.LanguageShared, Language> sharedToLanguage;
    private final Map<String, Language> mimeTypeToLanguage;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    final Language[] languageArray;
    final PolyglotRuntime runtime;
    final InputStream in;
    final DispatchOutputStream err;
    final DispatchOutputStream out;
    final ComputeInExecutor.Info executor;
    private volatile boolean disposed;
    static final boolean JDK8OrEarlier;
    private List<Object[]> config;
    private HashMap<String, DirectValue> globals;
    private final Map<Object, Object> javaInteropCodeCache = new ConcurrentHashMap<Object, Object>();
    private final FinalIntMap languageIndexMap = new FinalIntMap();

    static void ensureInitialized() {
        if (VMAccessor.SPI == null || !(VMAccessor.SPI.engineSupport() instanceof LegacyEngineImpl)) {
            VMAccessor.initialize(new LegacyEngineImpl());
        }
    }

    PolyglotEngine() {
        PolyglotEngine.assertNoCompilation();
        PolyglotEngine.ensureInitialized();
        this.initThread = null;
        this.runtime = null;
        this.cachedTargets = null;
        this.languageArray = null;
        this.sharedToLanguage = null;
        this.mimeTypeToLanguage = null;
        this.in = null;
        this.out = null;
        this.err = null;
        this.executor = null;
    }

    PolyglotEngine(PolyglotRuntime runtime, Executor executor, InputStream in, DispatchOutputStream out, DispatchOutputStream err, Map<String, Object> globals, List<Object[]> config) {
        PolyglotEngine.assertNoCompilation();
        this.initThread = Thread.currentThread();
        this.runtime = runtime;
        this.languageArray = new Language[runtime.getLanguages().size()];
        this.cachedTargets = new PolyglotCache(this);
        this.sharedToLanguage = new HashMap<PolyglotRuntime.LanguageShared, Language>();
        this.mimeTypeToLanguage = new HashMap<String, Language>();
        this.in = in;
        this.out = out;
        this.err = err;
        this.executor = ComputeInExecutor.wrap(executor);
        this.globals = new HashMap();
        for (Map.Entry<String, Object> entry : globals.entrySet()) {
            this.globals.put(entry.getKey(), new DirectValue(null, entry.getValue()));
        }
        this.config = config;
        this.initLanguages();
        runtime.notifyEngineCreated();
    }

    private void initLanguages() {
        for (PolyglotRuntime.LanguageShared languageShared : this.runtime.getLanguages()) {
            Language newLanguage = new Language(languageShared);
            this.sharedToLanguage.put(languageShared, newLanguage);
            assert (this.languageArray[languageShared.languageId] == null) : "attempting to overwrite language";
            this.languageArray[languageShared.languageId] = newLanguage;
            for (String mimeType : languageShared.cache.getMimeTypes()) {
                this.mimeTypeToLanguage.put(mimeType, newLanguage);
            }
        }
    }

    DirectValue findLegacyExportedSymbol(String symbolName) {
        DirectValue value = this.globals.get(symbolName);
        if (value != null) {
            return value;
        }
        DirectValue legacySymbol = this.findLegacyExportedSymbol(symbolName, true);
        if (legacySymbol != null) {
            return legacySymbol;
        }
        return this.findLegacyExportedSymbol(symbolName, false);
    }

    private DirectValue findLegacyExportedSymbol(String name, boolean onlyExplicit) {
        Collection<? extends Language> uniqueLang = this.getLanguages().values();
        for (Language language : uniqueLang) {
            Object s;
            TruffleLanguage.Env env = language.env;
            if (env == null || (s = VMAccessor.LANGUAGE.findExportedSymbol(env, name, onlyExplicit)) == null) continue;
            return new DirectValue(language, s);
        }
        return null;
    }

    PolyglotEngine enter() {
        return this.runtime.engineProfile.enter(this);
    }

    void leave(Object prev) {
        this.runtime.engineProfile.leave((PolyglotEngine)prev);
    }

    ComputeInExecutor.Info executor() {
        return this.executor;
    }

    private boolean isCurrentVM() {
        return this == this.runtime.engineProfile.get();
    }

    public static Builder newBuilder() {
        PolyglotEngine engine = new PolyglotEngine();
        return engine.new Builder();
    }

    @Deprecated
    public static Builder buildNew() {
        return PolyglotEngine.newBuilder();
    }

    public Map<String, ? extends Language> getLanguages() {
        return Collections.unmodifiableMap(this.mimeTypeToLanguage);
    }

    @Deprecated
    public Map<String, Instrument> getInstruments() {
        return this.runtime.instruments;
    }

    public PolyglotRuntime getRuntime() {
        return this.runtime;
    }

    public Value eval(com.oracle.truffle.api.source.Source source) {
        PolyglotEngine.assertNoCompilation();
        assert (this.checkThread());
        return this.evalImpl(this.findLanguage(source.getMimeType(), true), source);
    }

    private Value evalImpl(final Language l, final com.oracle.truffle.api.source.Source source) {
        assert (this.checkThread());
        ComputeInExecutor<Object> compute = new ComputeInExecutor<Object>(this.executor()){

            @Override
            protected Object compute() {
                CallTarget evalTarget = (CallTarget)l.parserCache.get(source);
                if (evalTarget == null) {
                    evalTarget = PolyglotRootNode.createEval(PolyglotEngine.this, l, source);
                    l.parserCache.put(source, evalTarget);
                }
                return evalTarget.call(new Object[0]);
            }
        };
        compute.perform();
        return new ExecutorValue(l, compute);
    }

    public void dispose() {
        assert (this.checkThread());
        PolyglotEngine.assertNoCompilation();
        this.disposed = true;
        ComputeInExecutor<Void> compute = new ComputeInExecutor<Void>(this.executor()){

            @Override
            protected Void compute() {
                PolyglotEngine prev = PolyglotEngine.this.enter();
                try {
                    PolyglotEngine.this.disposeImpl();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    PolyglotEngine.this.leave(prev);
                }
            }
        };
        compute.get();
    }

    private void disposeImpl() {
        for (Language language : this.getLanguages().values()) {
            language.disposeContext();
        }
        this.runtime.notifyEngineDisposed();
    }

    private Object[] debugger() {
        return this.runtime.debugger;
    }

    public Value findGlobalSymbol(final String globalName) {
        assert (this.checkThread());
        PolyglotEngine.assertNoCompilation();
        ComputeInExecutor<DirectValue> compute = new ComputeInExecutor<DirectValue>(this.executor()){

            @Override
            protected DirectValue compute() {
                PolyglotEngine prev = PolyglotEngine.this.enter();
                try {
                    DirectValue directValue = PolyglotEngine.this.findLegacyExportedSymbol(globalName);
                    return directValue;
                }
                finally {
                    PolyglotEngine.this.leave(prev);
                }
            }
        };
        return (Value)compute.get();
    }

    public Iterable<Value> findGlobalSymbols(String globalName) {
        assert (this.checkThread());
        PolyglotEngine.assertNoCompilation();
        DirectValue value = this.globals.get(globalName);
        if (value == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(value);
    }

    private static void assertNoCompilation() {
        CompilerAsserts.neverPartOfCompilation("Methods of PolyglotEngine must not be compiled by Truffle. Use Truffle interoperability or a @TruffleBoundary instead.");
    }

    private boolean checkThread() {
        if (this.initThread != Thread.currentThread()) {
            throw new IllegalStateException("PolyglotEngine created on " + this.initThread.getName() + " but used on " + Thread.currentThread().getName());
        }
        if (this.disposed) {
            throw new IllegalStateException("Engine has already been disposed");
        }
        return true;
    }

    private Language findLanguage(String mimeType, boolean failOnError) {
        Language l = this.mimeTypeToLanguage.get(mimeType);
        if (failOnError && l == null) {
            throw new IllegalStateException("No language for MIME type " + mimeType + " found. Supported types: " + this.mimeTypeToLanguage.keySet());
        }
        return l;
    }

    Language findLanguage(PolyglotRuntime.LanguageShared env) {
        return this.sharedToLanguage.get(env);
    }

    Language getLanguage(Class<? extends TruffleLanguage<?>> languageClass) {
        if (CompilerDirectives.isPartialEvaluationConstant(this)) {
            return this.getLanguageImpl(languageClass);
        }
        return this.getLanguageBoundary(languageClass);
    }

    @CompilerDirectives.TruffleBoundary
    private Language getLanguageBoundary(Class<? extends TruffleLanguage<?>> languageClass) {
        return this.getLanguageImpl(languageClass);
    }

    private Language getLanguageImpl(Class<? extends TruffleLanguage<?>> languageClass) {
        int indexValue = this.languageIndexMap.get(languageClass);
        if (indexValue == -1) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Language language = this.findLanguage(languageClass, false, true);
            indexValue = language.shared.languageId;
            this.languageIndexMap.put(languageClass, indexValue);
        }
        return this.languageArray[indexValue];
    }

    Language findLanguage(Class<? extends TruffleLanguage> languageClazz, boolean onlyInitialized, boolean failIfNotFound) {
        for (Language lang : this.languageArray) {
            TruffleLanguage<?> spi;
            assert (lang.shared.language != null);
            if (onlyInitialized && lang.getEnv(false) == null || !languageClazz.isInstance(spi = VMAccessor.NODES.getLanguageSpi(lang.shared.language))) continue;
            return lang;
        }
        if (failIfNotFound) {
            HashSet<String> languageNames = new HashSet<String>();
            for (Language lang : this.languageArray) {
                languageNames.add(lang.shared.cache.getClassName());
            }
            throw new IllegalStateException("Cannot find language " + languageClazz + " among " + languageNames);
        }
        return null;
    }

    TruffleLanguage.Env findEnv(Class<? extends TruffleLanguage> languageClazz, boolean failIfNotFound) {
        Language language = this.findLanguage(languageClazz, true, failIfNotFound);
        if (language != null) {
            return language.getEnv(false);
        }
        return null;
    }

    static {
        PolyglotEngine.ensureInitialized();
        GLOBAL_PROFILE = new PolyglotEngineProfile(null);
        UNSET_CONTEXT = new Object();
        JDK8OrEarlier = System.getProperty("java.specification.version").compareTo("1.9") < 0;
        try {
            Class.forName(TruffleInstrument.class.getName(), true, TruffleInstrument.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    static final class LegacyEngineImpl
    extends Accessor.EngineSupport {
        LegacyEngineImpl() {
        }

        @Override
        public boolean isDisposed(Object vmObject) {
            return ((Language)vmObject).engine().disposed;
        }

        @Override
        public Object getCurrentContext(Object vmObject) {
            return LegacyEngineImpl.findVMObject(vmObject).getCurrentContext();
        }

        @Override
        public CallTarget parseForLanguage(Object vmObject, com.oracle.truffle.api.source.Source source, String[] argumentNames) {
            TruffleLanguage.Env env = ((Language)vmObject).engine().findLanguage(source.getMimeType(), true).getEnv(true);
            CallTarget target = VMAccessor.LANGUAGE.parse(env, source, null, argumentNames);
            if (target == null) {
                throw new NullPointerException("Parsing has not produced a CallTarget for " + source);
            }
            return target;
        }

        @Override
        public OptionValues getCompilerOptionValues(RootNode rootNode) {
            return null;
        }

        @Override
        public boolean isHostAccessAllowed(Object vmObject, TruffleLanguage.Env env) {
            return false;
        }

        @Override
        public boolean isNativeAccessAllowed(Object vmObject, TruffleLanguage.Env env) {
            return true;
        }

        @Override
        public Object asBoxedGuestValue(Object guestObject, Object vmObject) {
            return guestObject;
        }

        @Override
        public Object lookupHostSymbol(Object vmObject, TruffleLanguage.Env env, String symbolName) {
            return null;
        }

        @Override
        public Object findMetaObjectForLanguage(Object vmObject, Object value) {
            return null;
        }

        @Override
        public Object getVMFromLanguageObject(Object engineObject) {
            return ((PolyglotRuntime.LanguageShared)engineObject).runtime;
        }

        @Override
        public TruffleLanguage.Env getEnvForInstrument(Object vmObject, String languageId, String mimeType) {
            PolyglotEngine currentVM = ((Instrument)vmObject).getRuntime().currentVM();
            if (currentVM == null) {
                throw new IllegalStateException("No current engine found.");
            }
            Language lang = currentVM.findLanguage(mimeType, true);
            TruffleLanguage.Env env = lang.getEnv(true);
            assert (env != null);
            return env;
        }

        @Override
        public Object getPolyglotBindingsForLanguage(Object vmObject) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T lookup(InstrumentInfo info, Class<T> serviceClass) {
            Object vmObject = VMAccessor.LANGUAGE.getVMObject(info);
            Instrument instrument = (Instrument)vmObject;
            return instrument.lookup(serviceClass);
        }

        @Override
        public void addToHostClassPath(Object vmObject, TruffleFile entries) {
        }

        @Override
        public <S> S lookup(LanguageInfo language, Class<S> type) {
            PolyglotRuntime.LanguageShared cache = (PolyglotRuntime.LanguageShared)VMAccessor.NODES.getEngineObject(language);
            return VMAccessor.LANGUAGE.lookup(cache.getLanguageEnsureInitialized(), type);
        }

        @Override
        public <C, T extends TruffleLanguage<C>> C getCurrentContext(Class<T> languageClass) {
            PolyglotEngine engine = GLOBAL_PROFILE.get();
            if (engine == null) {
                CompilerDirectives.transferToInterpreter();
                throw new IllegalStateException("No current context available.");
            }
            Language language = engine.getLanguage(languageClass);
            if (language.env == null || language.context == UNSET_CONTEXT) {
                CompilerDirectives.transferToInterpreter();
                throw new IllegalStateException("No current context available.");
            }
            return (C)language.context;
        }

        @Override
        public TruffleContext getPolyglotContext(Object vmObject) {
            throw new UnsupportedOperationException("Polyglot contexts are not supported within PolygotEngine.");
        }

        @Override
        public <T extends TruffleLanguage<?>> T getCurrentLanguage(Class<T> languageClass) {
            PolyglotEngine engine = GLOBAL_PROFILE.get();
            if (engine == null) {
                CompilerDirectives.transferToInterpreter();
                throw new IllegalStateException("No current language available.");
            }
            Language language = engine.getLanguage(languageClass);
            return (T)((TruffleLanguage)languageClass.cast(VMAccessor.NODES.getLanguageSpi(language.shared.language)));
        }

        @Override
        public Map<String, LanguageInfo> getLanguages(Object vmObject) {
            PolyglotRuntime vm;
            if (vmObject instanceof Language) {
                vm = ((Language)vmObject).shared.getRuntime();
            } else if (vmObject instanceof Instrument) {
                vm = ((Instrument)vmObject).getRuntime();
            } else {
                throw new AssertionError();
            }
            return vm.languageInfos;
        }

        @Override
        public Map<String, InstrumentInfo> getInstruments(Object vmObject) {
            PolyglotRuntime vm;
            if (vmObject instanceof Language) {
                vm = ((Language)vmObject).shared.getRuntime();
            } else if (vmObject instanceof Instrument) {
                vm = ((Instrument)vmObject).getRuntime();
            } else {
                throw new AssertionError();
            }
            return vm.instrumentInfos;
        }

        @Override
        public TruffleLanguage.Env getEnvForInstrument(LanguageInfo language) {
            return ((PolyglotRuntime.LanguageShared)VMAccessor.NODES.getEngineObject(language)).currentLanguage().getEnv(true);
        }

        @Override
        public TruffleLanguage.Env getExistingEnvForInstrument(LanguageInfo language) {
            return ((PolyglotRuntime.LanguageShared)VMAccessor.NODES.getEngineObject(language)).currentLanguage().getEnv(false);
        }

        @Override
        public LanguageInfo getObjectLanguage(Object obj, Object vmObject) {
            for (PolyglotRuntime.LanguageShared ls : ((Instrument)vmObject).getRuntime().getLanguages()) {
                TruffleLanguage.Env env;
                if (!ls.initialized || (env = ls.currentLanguage().getEnv(false)) == null || !VMAccessor.LANGUAGE.isObjectOfLanguage(env, obj)) continue;
                return ls.language;
            }
            return null;
        }

        @Override
        public Object getCurrentVM() {
            return GLOBAL_PROFILE.get();
        }

        @Override
        public boolean isEvalRoot(RootNode target) {
            if (target instanceof PolyglotRootNode.EvalRootNode) {
                PolyglotEngine engine = ((PolyglotRootNode.EvalRootNode)target).getEngine();
                return engine.isCurrentVM();
            }
            return false;
        }

        @Override
        public boolean isMimeTypeSupported(Object vmObject, String mimeType) {
            return ((Language)vmObject).engine().findLanguage(mimeType, false) != null;
        }

        @Override
        public TruffleLanguage.Env findEnv(Object vmObject, Class<? extends TruffleLanguage> languageClass, boolean failIfNotFound) {
            return ((PolyglotEngine)vmObject).findEnv(languageClass, failIfNotFound);
        }

        @Override
        public Object getInstrumentationHandler(Object vmObject) {
            return ((PolyglotRuntime.LanguageShared)vmObject).getRuntime().instrumentationHandler;
        }

        @Override
        public Object importSymbol(Object vmObject, TruffleLanguage.Env env, String symbolName) {
            DirectValue symbol = ((Language)vmObject).engine().findLegacyExportedSymbol(symbolName);
            if (symbol != null) {
                return ((Value)symbol).value();
            }
            return null;
        }

        @Override
        public void exportSymbol(Object vmObject, String symbolName, Object value) {
            Language language = (Language)vmObject;
            HashMap global = language.engine().globals;
            if (value == null) {
                global.remove(symbolName);
            } else {
                PolyglotEngine polyglotEngine = language.engine();
                polyglotEngine.getClass();
                global.put(symbolName, polyglotEngine.new DirectValue(language, value));
            }
        }

        public Map<String, ?> getExportedSymbols(final Object vmObject) {
            Instrument instrument = (Instrument)vmObject;
            final HashMap globals = instrument.getRuntime().currentVM().globals;
            return new AbstractMap<String, Object>(){

                @Override
                public Set<Map.Entry<String, Object>> entrySet() {
                    LinkedHashSet<AbstractMap.SimpleImmutableEntry<String, Object>> valueEntries = new LinkedHashSet<AbstractMap.SimpleImmutableEntry<String, Object>>(globals.size());
                    for (Map.Entry entry : globals.entrySet()) {
                        String name = (String)entry.getKey();
                        Object value = this.toGuestValue(((DirectValue)entry.getValue()).value, vmObject);
                        AbstractMap.SimpleImmutableEntry<String, Object> valueEntry = new AbstractMap.SimpleImmutableEntry<String, Object>(name, value);
                        valueEntries.add(valueEntry);
                    }
                    return Collections.unmodifiableSet(valueEntries);
                }

                @Override
                public org.graalvm.polyglot.Value remove(Object key) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public BiFunction<Object, Object, Object> createToGuestValueNode() {
            return new BiFunction<Object, Object, Object>(){

                @Override
                @CompilerDirectives.TruffleBoundary
                public Object apply(Object t, Object u) {
                    return this.toGuestValue(u, t);
                }
            };
        }

        @Override
        public BiFunction<Object, Object[], Object[]> createToGuestValuesNode() {
            return new BiFunction<Object, Object[], Object[]>(){

                @Override
                @CompilerDirectives.TruffleBoundary
                public Object[] apply(Object t, Object[] u) {
                    for (int i = 0; i < u.length; ++i) {
                        u[i] = this.toGuestValue(u[i], t);
                    }
                    return u;
                }
            };
        }

        @Override
        public RootNode wrapHostBoundary(final ExecutableNode executableNode, final Supplier<String> name) {
            final PolyglotEngine engine = GLOBAL_PROFILE.get();
            return new RootNode(null){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object execute(VirtualFrame frame) {
                    PolyglotEngine prev = null;
                    if (engine != null) {
                        prev = engine.enter();
                    }
                    try {
                        Object object = executableNode.execute(frame);
                        return object;
                    }
                    finally {
                        if (engine != null) {
                            engine.leave(prev);
                        }
                    }
                }

                @Override
                public String getName() {
                    return (String)name.get();
                }
            };
        }

        @Override
        public <C> FindContextNode<C> createFindContextNode(TruffleLanguage<C> lang) {
            Object vm = this.getCurrentVM();
            if (vm == null) {
                throw new IllegalStateException("Cannot access current vm.");
            }
            return new FindContextNodeImpl(this.findEnv(vm, lang.getClass(), true));
        }

        @Override
        public void registerDebugger(Object vm, Object debugger) {
            PolyglotEngine engine = (PolyglotEngine)vm;
            assert (engine.debugger()[0] == null || engine.debugger()[0] == debugger);
            ((PolyglotEngine)engine).debugger()[0] = debugger;
        }

        @Override
        public Object findOriginalObject(Object truffleObject) {
            if (truffleObject instanceof EngineTruffleObject) {
                return ((EngineTruffleObject)truffleObject).getDelegate();
            }
            return truffleObject;
        }

        @Override
        public NullPointerException newNullPointerException(String message, Throwable cause) {
            NullPointerException npe = new NullPointerException(message);
            npe.initCause(cause);
            return npe;
        }

        @Override
        public <T> T installJavaInteropCodeCache(Object languageContext, Object key, T value, Class<T> expectedType) {
            PolyglotEngine engine = (PolyglotEngine)languageContext;
            if (engine == null) {
                engine = GLOBAL_PROFILE.get();
            }
            if (engine == null) {
                return value;
            }
            T result = expectedType.cast(engine.javaInteropCodeCache.putIfAbsent(key, value));
            if (result != null) {
                return result;
            }
            return value;
        }

        @Override
        public <T> T lookupJavaInteropCodeCache(Object languageContext, Object key, Class<T> expectedType) {
            PolyglotEngine engine = (PolyglotEngine)languageContext;
            if (engine == null) {
                engine = GLOBAL_PROFILE.get();
            }
            if (engine == null) {
                return null;
            }
            return expectedType.cast(engine.javaInteropCodeCache.get(key));
        }

        private static PolyglotRuntime.LanguageShared findVMObject(Object obj) {
            return (PolyglotRuntime.LanguageShared)obj;
        }

        @Override
        public Object toGuestValue(Object obj, Object languageContext) {
            return JavaInterop.asTruffleValue(obj);
        }

        @Override
        public org.graalvm.polyglot.Value toHostValue(Object obj, Object languageContext) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterable<Scope> createDefaultLexicalScope(Node node, Frame frame) {
            return DefaultScope.lexicalScope(node, frame);
        }

        @Override
        public Iterable<Scope> createDefaultTopScope(Object global) {
            return DefaultScope.topScope(global);
        }

        @Override
        public void reportAllLanguageContexts(Object vmObject, Object contextsListener) {
            throw new UnsupportedOperationException("Internal contexts are not supported within PolygotEngine.");
        }

        @Override
        public void reportAllContextThreads(Object vmObject, Object threadsListener) {
            throw new UnsupportedOperationException("Internal contexts are not supported within PolygotEngine.");
        }

        @Override
        public TruffleContext getParentContext(Object impl) {
            throw new UnsupportedOperationException("Internal contexts are not supported within PolygotEngine.");
        }

        @Override
        public void closeInternalContext(Object impl) {
            throw new UnsupportedOperationException("Internal contexts are not supported within PolygotEngine.");
        }

        @Override
        public Object createInternalContext(Object vmObject, Map<String, Object> config, TruffleContext context) {
            throw new UnsupportedOperationException("Internal contexts are not supported within PolygotEngine.");
        }

        @Override
        public void initializeInternalContext(Object vmObject, Object contextImpl) {
            throw new UnsupportedOperationException("Internal contexts are not supported within PolygotEngine.");
        }

        @Override
        public Object enterInternalContext(Object impl) {
            throw new UnsupportedOperationException("Internal contexts are not supported within PolygotEngine.");
        }

        @Override
        public void leaveInternalContext(Object impl, Object prev) {
            throw new UnsupportedOperationException("Internal contexts are not supported within PolygotEngine.");
        }

        @Override
        public boolean isCreateThreadAllowed(Object vmObject) {
            return false;
        }

        @Override
        public RuntimeException wrapHostException(Object languageContext, Throwable exception) {
            return PolyglotImpl.wrapHostException(null, exception);
        }

        @Override
        public boolean isHostException(Throwable exception) {
            return exception instanceof HostException;
        }

        @Override
        public Throwable asHostException(Throwable exception) {
            return ((HostException)exception).getOriginal();
        }

        @Override
        public ClassCastException newClassCastException(String message, Throwable cause) {
            return cause == null ? new PolyglotClassCastException(message) : new PolyglotClassCastException(message, cause);
        }

        @Override
        public IllegalArgumentException newIllegalArgumentException(String message, Throwable cause) {
            return cause == null ? new PolyglotIllegalArgumentException(message) : new PolyglotIllegalArgumentException(message, cause);
        }

        @Override
        public UnsupportedOperationException newUnsupportedOperationException(String message, Throwable cause) {
            return cause == null ? new PolyglotUnsupportedException(message) : new PolyglotUnsupportedException(message, cause);
        }

        @Override
        public ArrayIndexOutOfBoundsException newArrayIndexOutOfBounds(String message, Throwable cause) {
            return cause == null ? new PolyglotArrayIndexOutOfBoundsException(message) : new PolyglotArrayIndexOutOfBoundsException(message, cause);
        }

        @Override
        public Object getCurrentHostContext() {
            return null;
        }

        @Override
        public PolyglotException wrapGuestException(String languageId, Throwable e) {
            throw new UnsupportedOperationException("Not supported in legacy engine.");
        }

        @Override
        public Object legacyTckEnter(Object vm) {
            return ((PolyglotEngine)vm).enter();
        }

        @Override
        public void legacyTckLeave(Object vm, Object prev) {
            ((PolyglotEngine)vm).leave(prev);
        }

        @Override
        public <T> T getOrCreateRuntimeData(Object sourceVM, Supplier<T> constructor) {
            return null;
        }

        @Override
        public Thread createThread(Object vmObject, Runnable runnable, Object context) {
            throw new IllegalStateException("createThread is not supported.");
        }

        @Override
        public org.graalvm.polyglot.SourceSection createSourceSection(Object vmObject, Source source, SourceSection sectionImpl) {
            throw new UnsupportedOperationException("Not supported in legacy engine.");
        }

        @Override
        public String getValueInfo(Object languageContext, Object value) {
            return Objects.toString(value);
        }

        @Override
        public Class<? extends TruffleLanguage<?>> getLanguageClass(LanguageInfo language) {
            return ((PolyglotRuntime.LanguageShared)VMAccessor.NODES.getEngineObject((LanguageInfo)language)).cache.getLanguageClass();
        }

        @Override
        public boolean isDefaultFileSystem(FileSystem fs) {
            return false;
        }

        @Override
        public String getLanguageHome(Object engineObject) {
            return ((PolyglotRuntime.LanguageShared)engineObject).cache.getLanguageHome();
        }

        @Override
        public boolean isInstrumentExceptionsAreThrown(Object vmObject) {
            return false;
        }
    }

    @Deprecated
    public class Language {
        private volatile TruffleLanguage.Env env;
        final PolyglotRuntime.LanguageShared shared;
        @CompilerDirectives.CompilationFinal
        volatile Object context = UNSET_CONTEXT;
        private final Map<com.oracle.truffle.api.source.Source, CallTarget> parserCache;

        Language(PolyglotRuntime.LanguageShared shared) {
            this.shared = shared;
            this.parserCache = new WeakHashMap<com.oracle.truffle.api.source.Source, CallTarget>();
        }

        PolyglotEngine engine() {
            return PolyglotEngine.this;
        }

        Object context() {
            return this.context;
        }

        public Set<String> getMimeTypes() {
            return this.shared.cache.getMimeTypes();
        }

        public String getName() {
            return this.shared.cache.getName();
        }

        public String getVersion() {
            return this.shared.cache.getVersion();
        }

        public boolean isInteractive() {
            return this.shared.cache.isInteractive();
        }

        public Value eval(com.oracle.truffle.api.source.Source source) {
            PolyglotEngine.assertNoCompilation();
            return PolyglotEngine.this.evalImpl(this, source);
        }

        public Value getGlobalObject() {
            assert (PolyglotEngine.this.checkThread());
            ComputeInExecutor<Value> compute = new ComputeInExecutor<Value>(PolyglotEngine.this.executor()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected Value compute() {
                    PolyglotEngine prev = PolyglotEngine.this.enter();
                    try {
                        Object res = VMAccessor.LANGUAGE.languageGlobal(Language.this.getEnv(true));
                        if (res == null) {
                            Value value = null;
                            return value;
                        }
                        DirectValue directValue = new DirectValue(Language.this, res);
                        return directValue;
                    }
                    finally {
                        PolyglotEngine.this.leave(prev);
                    }
                }
            };
            return (Value)compute.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void disposeContext() {
            if (this.env != null) {
                Language language = this;
                synchronized (language) {
                    TruffleLanguage.Env localEnv = this.env;
                    assert (localEnv != null);
                    if (localEnv != null) {
                        try {
                            VMAccessor.LANGUAGE.dispose(localEnv);
                        }
                        catch (Error | Exception ex) {
                            ex.printStackTrace();
                        }
                        this.env = null;
                        this.context = UNSET_CONTEXT;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TruffleLanguage.Env getEnv(boolean create) {
            TruffleLanguage.Env localEnv = this.env;
            if (localEnv == null && create) {
                Language language = this;
                synchronized (language) {
                    localEnv = this.env;
                    if (localEnv == null && create) {
                        this.env = localEnv = VMAccessor.LANGUAGE.createEnv(this, this.shared.getLanguageEnsureInitialized(), this.engine().out, this.engine().err, this.engine().in, this.getArgumentsForLanguage(), new OptionValuesImpl(null, this.shared.options), new String[0], FileSystems.newNoIOFileSystem(null));
                        this.context = VMAccessor.LANGUAGE.createEnvContext(localEnv);
                        VMAccessor.LANGUAGE.postInitEnv(localEnv);
                    }
                }
            }
            return localEnv;
        }

        public String toString() {
            return "[" + this.getName() + "@ " + this.getVersion() + " for " + this.getMimeTypes() + "]";
        }

        private Map<String, Object> getArgumentsForLanguage() {
            if (PolyglotEngine.this.config == null) {
                return Collections.emptyMap();
            }
            HashMap<String, Object> forLanguage = new HashMap<String, Object>();
            for (Object[] mimeKeyValue : PolyglotEngine.this.config) {
                if (!this.shared.cache.getMimeTypes().contains(mimeKeyValue[0])) continue;
                forLanguage.put((String)mimeKeyValue[1], mimeKeyValue[2]);
            }
            return Collections.unmodifiableMap(forLanguage);
        }
    }

    @Deprecated
    public final class Instrument
    extends PolyglotRuntime.Instrument {
        Instrument(PolyglotRuntime runtime, InstrumentCache cache) {
            PolyglotRuntime polyglotRuntime = runtime;
            polyglotRuntime.getClass();
            super(polyglotRuntime, cache);
        }
    }

    private class ExecutorValue
    extends Value {
        private final ComputeInExecutor<Object> compute;

        ExecutorValue(Language language, ComputeInExecutor<Object> compute) {
            super(language);
            this.compute = compute;
        }

        @Override
        boolean isDirect() {
            return false;
        }

        @Override
        Object value() {
            return this.compute.get();
        }

        public String toString() {
            return "PolyglotEngine.Value[" + this.compute + "]";
        }
    }

    private class DirectValue
    extends Value {
        private final Object value;

        DirectValue(Language language, Object value) {
            super(language);
            this.value = value;
            assert (value != null);
        }

        @Override
        boolean isDirect() {
            return true;
        }

        @Override
        Object value() {
            return this.value;
        }

        public String toString() {
            return "PolyglotEngine.Value[value=" + this.value + ",computed=true,exception=null]";
        }
    }

    @Deprecated
    public abstract class Value {
        private final Language language;
        private CallTarget executeTarget;
        private CallTarget asJavaObjectTarget;

        Value(Language language) {
            this.language = language;
        }

        abstract boolean isDirect();

        abstract Object value();

        private <T> T unwrapJava(Object value) {
            CallTarget unwrapTarget = PolyglotEngine.this.cachedTargets.lookupAsJava(value.getClass());
            return (T)unwrapTarget.call(value, Object.class);
        }

        private <T> T asJavaObject(Class<T> type, Object value) {
            if (this.asJavaObjectTarget == null) {
                this.asJavaObjectTarget = PolyglotEngine.this.cachedTargets.lookupAsJava(value == null ? Void.TYPE : value.getClass());
            }
            return (T)this.asJavaObjectTarget.call(value, type);
        }

        private Object executeDirect(Object[] args) {
            Object value = this.value();
            if (this.executeTarget == null) {
                this.executeTarget = PolyglotEngine.this.cachedTargets.lookupExecute(value.getClass());
            }
            return this.executeTarget.call(value, args);
        }

        public Object get() {
            Object result = this.waitForSymbol();
            if (result instanceof TruffleObject && (result = this.unwrapJava(ConvertedObject.value(result))) instanceof TruffleObject) {
                result = EngineTruffleObject.wrap(PolyglotEngine.this, result);
            }
            return ConvertedObject.isNull(result) ? null : result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T as(Class<T> representation) {
            Object original;
            Object unwrapped = original = this.waitForSymbol();
            if (original instanceof TruffleObject) {
                Object realOrig = ConvertedObject.original(original);
                unwrapped = new ConvertedObject((TruffleObject)realOrig, this.unwrapJava(realOrig));
            }
            if (representation == String.class) {
                String string;
                Object unwrappedConverted = ConvertedObject.original(unwrapped);
                if (this.language != null) {
                    PolyglotEngine prev = PolyglotEngine.this.enter();
                    try {
                        string = VMAccessor.LANGUAGE.toStringIfVisible(this.language.getEnv(false), unwrappedConverted, false);
                    }
                    finally {
                        PolyglotEngine.this.leave(prev);
                    }
                } else {
                    string = unwrappedConverted.toString();
                }
                return representation.cast(string);
            }
            if (ConvertedObject.isInstance(representation, unwrapped)) {
                return ConvertedObject.cast(representation, unwrapped);
            }
            if (original instanceof TruffleObject) {
                original = EngineTruffleObject.wrap(PolyglotEngine.this, original);
            }
            T javaValue = this.asJavaObject(representation, original);
            if (representation.isPrimitive()) {
                return javaValue;
            }
            return representation.cast(javaValue);
        }

        @Deprecated
        public Value invoke(Object thiz, Object ... args) {
            return this.execute(args);
        }

        public Value execute(final Object ... args) {
            if (this.isDirect()) {
                Object ret = this.executeDirect(args);
                return new DirectValue(this.language, ret);
            }
            PolyglotEngine.assertNoCompilation();
            this.get();
            ComputeInExecutor<Object> invokeCompute = new ComputeInExecutor<Object>(PolyglotEngine.this.executor()){

                @Override
                protected Object compute() {
                    return Value.this.executeDirect(args);
                }
            };
            invokeCompute.perform();
            return new ExecutorValue(this.language, invokeCompute);
        }

        private Object waitForSymbol() {
            PolyglotEngine.assertNoCompilation();
            assert (PolyglotEngine.this.checkThread());
            Object value = this.value();
            assert (value != null);
            assert (!(value instanceof EngineTruffleObject));
            return value;
        }

        public Value getMetaObject() {
            if (this.language == null) {
                return null;
            }
            ComputeInExecutor<Object> invokeCompute = new ComputeInExecutor<Object>(PolyglotEngine.this.executor()){

                @Override
                protected Object compute() {
                    PolyglotEngine prev = PolyglotEngine.this.enter();
                    try {
                        Object object = VMAccessor.LANGUAGE.findMetaObject(Value.this.language.getEnv(true), ConvertedObject.original(Value.this.value()));
                        return object;
                    }
                    finally {
                        PolyglotEngine.this.leave(prev);
                    }
                }
            };
            Object value = invokeCompute.get();
            if (value != null) {
                return new DirectValue(this.language, value);
            }
            return null;
        }

        public SourceSection getSourceLocation() {
            if (this.language == null) {
                return null;
            }
            ComputeInExecutor<SourceSection> invokeCompute = new ComputeInExecutor<SourceSection>(PolyglotEngine.this.executor()){

                @Override
                protected SourceSection compute() {
                    PolyglotEngine prev = PolyglotEngine.this.enter();
                    try {
                        SourceSection sourceSection = VMAccessor.LANGUAGE.findSourceLocation(Value.this.language.getEnv(true), ConvertedObject.original(Value.this.value()));
                        return sourceSection;
                    }
                    finally {
                        PolyglotEngine.this.leave(prev);
                    }
                }
            };
            return (SourceSection)invokeCompute.get();
        }
    }

    @Deprecated
    public class Builder {
        private OutputStream out;
        private OutputStream err;
        private InputStream in;
        private PolyglotRuntime runtime;
        private final Map<String, Object> globals = new HashMap<String, Object>();
        private Executor executor;
        private List<Object[]> arguments;

        Builder() {
        }

        public Builder setOut(OutputStream os) {
            this.out = os;
            return this;
        }

        public Builder setErr(OutputStream os) {
            this.err = os;
            return this;
        }

        public Builder setIn(InputStream is) {
            this.in = is;
            return this;
        }

        public Builder config(String mimeType, String key, Object value) {
            if (this.arguments == null) {
                this.arguments = new ArrayList<Object[]>();
            }
            this.arguments.add(new Object[]{mimeType, key, value});
            return this;
        }

        public Builder globalSymbol(String name, Object obj) {
            Object truffleReady = JavaInterop.asTruffleValue(obj);
            this.globals.put(name, truffleReady);
            return this;
        }

        public Builder executor(Executor executor) {
            this.executor = executor;
            return this;
        }

        public Builder runtime(PolyglotRuntime polyglotRuntime) {
            this.checkRuntime(polyglotRuntime);
            this.runtime = polyglotRuntime;
            return this;
        }

        public PolyglotEngine build() {
            DispatchOutputStream realErr;
            DispatchOutputStream realOut;
            InputStream realIn;
            PolyglotEngine.assertNoCompilation();
            PolyglotRuntime realRuntime = this.runtime;
            if (realRuntime == null) {
                realRuntime = PolyglotRuntime.newBuilder().setIn(this.in).setOut(this.out).setErr(this.err).build(true);
                realIn = realRuntime.in;
                realOut = realRuntime.out;
                realErr = realRuntime.err;
            } else {
                this.checkRuntime(realRuntime);
                if (this.out == null) {
                    realOut = realRuntime.out;
                } else {
                    realOut = VMAccessor.INSTRUMENT.createDispatchOutput(this.out);
                    VMAccessor.engine().attachOutputConsumer(realOut, realRuntime.out);
                }
                if (this.err == null) {
                    realErr = realRuntime.err;
                } else {
                    realErr = VMAccessor.INSTRUMENT.createDispatchOutput(this.err);
                    VMAccessor.engine().attachOutputConsumer(realErr, realRuntime.err);
                }
                realIn = this.in == null ? realRuntime.in : this.in;
            }
            return new PolyglotEngine(realRuntime, this.executor, realIn, realOut, realErr, this.globals, this.arguments);
        }

        private void checkRuntime(PolyglotRuntime realRuntime) {
            if (realRuntime.disposed) {
                throw new IllegalArgumentException("Given runtime already disposed.");
            }
            if (realRuntime.automaticDispose) {
                throw new IllegalArgumentException("Cannot reuse private/create runtime of another engine. Please usine an explicitely created PolyglotRuntime instead.");
            }
        }
    }
}

