/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.vm;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.vm.PolyglotEngine;
import java.lang.ref.WeakReference;

final class PolyglotEngineProfile {
    private final Assumption constantStoreAssumption = Truffle.getRuntime().createAssumption("dynamic context store");
    private final Assumption dynamicStoreAssumption = Truffle.getRuntime().createAssumption("constant context store");
    @CompilerDirectives.CompilationFinal
    private WeakReference<PolyglotEngine> constantStore;
    @CompilerDirectives.CompilationFinal
    private int constantEntered;
    private volatile PolyglotEngine dynamicStore;
    @CompilerDirectives.CompilationFinal
    private volatile Thread singleThread;
    private volatile ThreadLocal<PolyglotEngine> threadStore;

    PolyglotEngineProfile(PolyglotEngine initialStore) {
        this.constantStore = new WeakReference<PolyglotEngine>(initialStore);
    }

    Assumption getConstantStoreAssumption() {
        return this.constantStoreAssumption;
    }

    PolyglotEngine get() {
        PolyglotEngine store = this.constantStoreAssumption.isValid() ? (CompilerDirectives.inCompiledCode() || this.constantEntered > 0 ? (PolyglotEngine)this.constantStore.get() : null) : (this.dynamicStoreAssumption.isValid() ? this.dynamicStore : PolyglotEngineProfile.getThreadLocalStore(this.threadStore));
        return store;
    }

    void leave(PolyglotEngine prev) {
        if (this.constantStoreAssumption.isValid()) {
            assert (prev == null);
            --this.constantEntered;
        } else if (this.dynamicStoreAssumption.isValid()) {
            this.dynamicStore = prev;
            assert (this.singleThread == Thread.currentThread());
        } else {
            ThreadLocal<PolyglotEngine> tlstore = this.threadStore;
            assert (tlstore != null);
            PolyglotEngineProfile.setThreadLocalStore(tlstore, prev);
        }
    }

    PolyglotEngine enter(PolyglotEngine store) {
        assert (store != null);
        if (this.constantStoreAssumption.isValid()) {
            if (this.constantStore.get() == store) {
                ++this.constantEntered;
                return null;
            }
        } else if (this.dynamicStoreAssumption.isValid()) {
            PolyglotEngine prevStore = this.dynamicStore;
            if (Thread.currentThread() == this.singleThread) {
                this.dynamicStore = store;
                return prevStore;
            }
        } else {
            ThreadLocal<PolyglotEngine> tlstore = this.threadStore;
            assert (tlstore != null);
            PolyglotEngine currentstore = PolyglotEngineProfile.getThreadLocalStore(tlstore);
            if (currentstore != store) {
                PolyglotEngineProfile.setThreadLocalStore(tlstore, store);
            }
            return currentstore;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.slowPathProfile(store);
    }

    @CompilerDirectives.TruffleBoundary
    private static void setThreadLocalStore(ThreadLocal<PolyglotEngine> tlstore, PolyglotEngine store) {
        tlstore.set(store);
    }

    @CompilerDirectives.TruffleBoundary
    private synchronized PolyglotEngine slowPathProfile(PolyglotEngine engine) {
        PolyglotEngine prev = null;
        if (this.constantStoreAssumption.isValid()) {
            if (this.constantStore.get() == null) {
                this.constantStore = new WeakReference<PolyglotEngine>(engine);
                this.singleThread = Thread.currentThread();
                ++this.constantEntered;
                return null;
            }
            this.constantStoreAssumption.invalidate();
            prev = (PolyglotEngine)this.constantStore.get();
            this.constantStore.clear();
        }
        if (this.dynamicStoreAssumption.isValid()) {
            Thread currentThread = Thread.currentThread();
            if (this.dynamicStore == null && this.singleThread == currentThread) {
                this.dynamicStore = engine;
                return prev;
            }
            final PolyglotEngine initialEngine = this.dynamicStore == null ? prev : this.dynamicStore;
            this.threadStore = new ThreadLocal<PolyglotEngine>(){

                @Override
                protected PolyglotEngine initialValue() {
                    return initialEngine;
                }
            };
            this.threadStore.set(engine);
            this.dynamicStoreAssumption.invalidate();
            prev = initialEngine;
        }
        this.dynamicStore = null;
        assert (!this.constantStoreAssumption.isValid());
        assert (!this.dynamicStoreAssumption.isValid());
        assert (this.threadStore != null);
        return prev;
    }

    @CompilerDirectives.TruffleBoundary
    private static PolyglotEngine getThreadLocalStore(ThreadLocal<PolyglotEngine> tls) {
        return tls.get();
    }
}

