/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.vm;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Scope;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.vm.OptionValuesImpl;
import com.oracle.truffle.api.vm.PolyglotBindings;
import com.oracle.truffle.api.vm.PolyglotContextImpl;
import com.oracle.truffle.api.vm.PolyglotEngineImpl;
import com.oracle.truffle.api.vm.PolyglotIllegalStateException;
import com.oracle.truffle.api.vm.PolyglotImpl;
import com.oracle.truffle.api.vm.PolyglotLanguage;
import com.oracle.truffle.api.vm.PolyglotLanguageBindings;
import com.oracle.truffle.api.vm.PolyglotProxy;
import com.oracle.truffle.api.vm.PolyglotSourceCache;
import com.oracle.truffle.api.vm.PolyglotThread;
import com.oracle.truffle.api.vm.PolyglotThreadInfo;
import com.oracle.truffle.api.vm.PolyglotValue;
import com.oracle.truffle.api.vm.VMAccessor;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.graalvm.polyglot.proxy.Proxy;

final class PolyglotLanguageContext
implements PolyglotImpl.VMObject {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    final PolyglotContextImpl context;
    final PolyglotLanguage language;
    volatile PolyglotSourceCache sourceCache;
    final Map<String, Object> config;
    final boolean eventsEnabled;
    volatile Map<Class<?>, PolyglotValue> valueCache;
    volatile PolyglotValue defaultValueCache;
    volatile OptionValuesImpl optionValues;
    volatile Value nullValue;
    String[] applicationArguments;
    final Set<PolyglotThread> activePolyglotThreads = new HashSet<PolyglotThread>();
    volatile boolean creating;
    volatile boolean initialized;
    volatile boolean finalized;
    private volatile Object guestBindings;
    @CompilerDirectives.CompilationFinal
    private volatile Object polyglotGuestBindings;
    private volatile Value hostBindings;
    @CompilerDirectives.CompilationFinal
    volatile TruffleLanguage.Env env;
    final Thread.UncaughtExceptionHandler uncaughtExceptionHandler = new PolyglotUncaughtExceptionHandler();

    PolyglotLanguageContext(PolyglotContextImpl context, PolyglotLanguage language, OptionValuesImpl optionValues, String[] applicationArguments, Map<String, Object> config, boolean eventsEnabled) {
        this.context = context;
        this.language = language;
        this.config = config;
        this.eventsEnabled = eventsEnabled;
        this.optionValues = optionValues;
        this.setApplicationArguments(applicationArguments);
    }

    private void initializeCaches() {
        assert (Thread.holdsLock(this.context));
        this.valueCache = new ConcurrentHashMap();
        PolyglotValue.createDefaultValueCaches(this);
        this.nullValue = this.toHostValue(this.toGuestValue(null));
        this.defaultValueCache = new PolyglotValue.Default(this);
        assert (this.language.isInitialized());
        PolyglotSourceCache languageSourceCache = this.language.sourceCache;
        this.sourceCache = languageSourceCache != null ? languageSourceCache : new PolyglotSourceCache();
    }

    Object getContextImpl() {
        if (this.env != null) {
            return VMAccessor.LANGUAGE.getContext(this.env);
        }
        return null;
    }

    Value getHostBindings() {
        Value bindings = this.hostBindings;
        if (bindings == null) {
            Object prev = this.enter();
            try {
                this.initializeLanguageBindings();
            }
            catch (Throwable e) {
                throw PolyglotImpl.wrapGuestException(this, e);
            }
            finally {
                this.leave(prev);
            }
            bindings = this.hostBindings;
            assert (bindings != null);
        }
        return bindings;
    }

    Object getPolyglotGuestBindings() {
        Object bindings = this.polyglotGuestBindings;
        if (bindings == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.initializeLanguageBindings();
            bindings = this.polyglotGuestBindings;
            assert (bindings != null);
        }
        return bindings;
    }

    private void initializeLanguageBindings() {
        this.ensureInitialized(null);
        Iterable<Scope> scopes = VMAccessor.LANGUAGE.findTopScopes(this.env);
        this.guestBindings = new PolyglotLanguageBindings(scopes);
        this.polyglotGuestBindings = new PolyglotBindings(this, this.context.polyglotBindings);
        this.hostBindings = this.toHostValue(this.guestBindings);
    }

    boolean isInitialized() {
        return this.env != null && this.initialized;
    }

    CallTarget parseCached(PolyglotLanguage accessingLanguage, Source source, String[] argumentNames) throws AssertionError {
        this.ensureInitialized(accessingLanguage);
        PolyglotSourceCache cache = this.sourceCache;
        assert (cache != null);
        return cache.parseCached(this, source, argumentNames);
    }

    TruffleLanguage.Env requireEnv() {
        TruffleLanguage.Env localEnv = this.env;
        if (localEnv == null) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError((Object)"No language context is active on this thread.");
        }
        return localEnv;
    }

    Object enter() {
        return this.context.enter();
    }

    void leave(Object prev) {
        this.context.leave(prev);
    }

    boolean finalizeContext() {
        TruffleLanguage.Env localEnv = this.env;
        if (localEnv != null && !this.finalized) {
            this.finalized = true;
            VMAccessor.LANGUAGE.finalizeContext(localEnv);
            if (this.eventsEnabled) {
                VMAccessor.INSTRUMENT.notifyLanguageContextFinalized(this.context.engine, this.context.truffleContext, this.language.info);
            }
            return true;
        }
        return false;
    }

    boolean dispose() {
        assert (Thread.holdsLock(this.context));
        TruffleLanguage.Env localEnv = this.env;
        if (localEnv != null) {
            if (!this.activePolyglotThreads.isEmpty()) {
                throw new AssertionError((Object)("The language did not complete all polyglot threads but should have: " + this.activePolyglotThreads));
            }
            for (PolyglotThreadInfo threadInfo : this.context.getSeenThreads().values()) {
                assert (threadInfo.thread != null);
                if (threadInfo.isPolyglotThread(this.context)) continue;
                VMAccessor.LANGUAGE.disposeThread(localEnv, threadInfo.thread);
            }
            VMAccessor.LANGUAGE.dispose(localEnv);
            this.env = null;
            return true;
        }
        return false;
    }

    void notifyDisposed() {
        if (this.eventsEnabled) {
            VMAccessor.INSTRUMENT.notifyLanguageContextDisposed(this.context.engine, this.context.truffleContext, this.language.info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object enterThread(PolyglotThread thread) {
        assert (Thread.currentThread() == thread);
        PolyglotContextImpl polyglotContextImpl = this.context;
        synchronized (polyglotContextImpl) {
            this.activePolyglotThreads.add(thread);
            return this.enter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void leaveThread(Object prev, PolyglotThread thread) {
        assert (Thread.currentThread() == thread);
        PolyglotContextImpl polyglotContextImpl = this.context;
        synchronized (polyglotContextImpl) {
            Map<Thread, PolyglotThreadInfo> seenThreads = this.context.getSeenThreads();
            PolyglotThreadInfo info = seenThreads.get(thread);
            if (info == null) {
                return;
            }
            for (PolyglotLanguageContext languageContext : this.context.contexts) {
                if (!languageContext.isInitialized()) continue;
                VMAccessor.LANGUAGE.disposeThread(languageContext.env, thread);
            }
            this.activePolyglotThreads.remove(thread);
            this.context.leave(prev);
            seenThreads.remove(thread);
        }
        VMAccessor.INSTRUMENT.notifyThreadFinished(this.context.engine, this.context.truffleContext, thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureCreated(PolyglotLanguage accessingLanguage) {
        this.language.ensureInitialized();
        if (this.creating) {
            throw new PolyglotIllegalStateException(String.format("Cyclic access to language context for language %s. The context is currently being created.", this.language.getId()));
        }
        boolean created = false;
        if (this.env == null) {
            PolyglotContextImpl polyglotContextImpl = this.context;
            synchronized (polyglotContextImpl) {
                if (this.env == null) {
                    this.checkAccess(accessingLanguage);
                    boolean singleThreaded = this.context.isSingleThreaded();
                    Thread firstFailingThread = null;
                    for (PolyglotThreadInfo threadInfo : this.context.getSeenThreads().values()) {
                        if (VMAccessor.LANGUAGE.isThreadAccessAllowed(this.language.info, threadInfo.thread, singleThreaded)) continue;
                        firstFailingThread = threadInfo.thread;
                        break;
                    }
                    if (firstFailingThread != null) {
                        throw PolyglotContextImpl.throwDeniedThreadAccess(firstFailingThread, singleThreaded, Arrays.asList(this.language));
                    }
                    this.creating = true;
                    try {
                        this.initializeCaches();
                        try {
                            TruffleLanguage.Env createdEnv = this.env = VMAccessor.LANGUAGE.createEnv(this, this.language.info, this.context.out, this.context.err, this.context.in, this.config, this.getOptionValues(), this.applicationArguments, this.context.fileSystem);
                            VMAccessor.LANGUAGE.createEnvContext(createdEnv);
                            this.language.requireProfile().notifyContextCreate(createdEnv);
                        }
                        finally {
                            this.creating = false;
                        }
                        created = true;
                    }
                    catch (Throwable e) {
                        this.env = null;
                        throw e;
                    }
                }
            }
        }
        if (created && this.eventsEnabled) {
            VMAccessor.INSTRUMENT.notifyLanguageContextCreated(this.context.engine, this.context.truffleContext, this.language.info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean ensureInitialized(PolyglotLanguage accessingLanguage) {
        boolean wasInitialized = false;
        if (!this.initialized) {
            this.ensureCreated(accessingLanguage);
            PolyglotContextImpl polyglotContextImpl = this.context;
            synchronized (polyglotContextImpl) {
                if (!this.initialized) {
                    this.initialized = true;
                    try {
                        if (!this.context.inContextPreInitialization) {
                            VMAccessor.LANGUAGE.initializeThread(this.env, Thread.currentThread());
                        }
                        VMAccessor.LANGUAGE.postInitEnv(this.env);
                        if (!this.context.isSingleThreaded()) {
                            VMAccessor.LANGUAGE.initializeMultiThreading(this.env);
                        }
                        for (PolyglotThreadInfo threadInfo : this.context.getSeenThreads().values()) {
                            if (threadInfo.thread == Thread.currentThread()) continue;
                            VMAccessor.LANGUAGE.initializeThread(this.env, threadInfo.thread);
                        }
                        wasInitialized = true;
                    }
                    catch (Throwable e) {
                        this.initialized = false;
                        throw e;
                    }
                }
            }
        }
        if (wasInitialized && this.eventsEnabled) {
            VMAccessor.INSTRUMENT.notifyLanguageContextInitialized(this.context.engine, this.context.truffleContext, this.language.info);
        }
        return wasInitialized;
    }

    OptionValuesImpl getOptionValues() {
        if (this.optionValues == null) {
            this.optionValues = this.language.getOptionValues().copy();
        }
        return this.optionValues;
    }

    void checkAccess(PolyglotLanguage accessingLanguage) {
        boolean accessPermitted;
        this.context.engine.checkState();
        if (this.context.closed) {
            throw new PolyglotIllegalStateException("The Context is already closed.");
        }
        boolean bl = accessPermitted = this.language.isHost() || this.language.cache.isInternal() || this.context.allowedPublicLanguages.contains(this.language.info.getId()) || accessingLanguage != null && accessingLanguage.dependsOn(this.language);
        if (!accessPermitted) {
            throw new PolyglotIllegalStateException(String.format("Access to language '%s' is not permitted. ", this.language.getId()));
        }
        RuntimeException initError = this.language.initError;
        if (initError != null) {
            throw new PolyglotIllegalStateException(String.format("Initialization error: %s", initError.getMessage()), initError);
        }
    }

    @Override
    public PolyglotEngineImpl getEngine() {
        return this.context.getEngine();
    }

    @CompilerDirectives.TruffleBoundary
    static Object[] toGuestValues(Object languageContext, Object[] args) {
        Object[] newArgs = args;
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            Object newArg = PolyglotLanguageContext.toGuestValue(languageContext, arg);
            if (newArg == arg) continue;
            if (newArgs == args) {
                newArgs = Arrays.copyOf(args, args.length);
            }
            newArgs[i] = newArg;
        }
        return newArgs;
    }

    void preInitialize() {
        this.ensureInitialized(null);
    }

    boolean patch(Map<String, String> newOptions, String[] newApplicationArguments) {
        boolean preInitialized = this.isInitialized();
        if (preInitialized) {
            this.optionValues = null;
        }
        if (newOptions != null) {
            this.getOptionValues().putAll(newOptions);
        }
        this.setApplicationArguments(newApplicationArguments);
        if (preInitialized) {
            try {
                TruffleLanguage.Env newEnv = VMAccessor.LANGUAGE.patchEnvContext(this.env, this.context.out, this.context.err, this.context.in, this.config, this.getOptionValues(), newApplicationArguments, this.context.fileSystem);
                if (newEnv != null) {
                    this.env = newEnv;
                    return true;
                }
                return false;
            }
            catch (Throwable t) {
                if (t instanceof ThreadDeath) {
                    throw t;
                }
                throw PolyglotImpl.wrapGuestException(this, t);
            }
        }
        return true;
    }

    private void setApplicationArguments(String[] newApplicationArguments) {
        this.applicationArguments = newApplicationArguments == null ? EMPTY_STRING_ARRAY : newApplicationArguments;
    }

    static Object toGuestValue(Object originalLanguageContext, Object receiver) {
        PolyglotLanguageContext languageContext = (PolyglotLanguageContext)originalLanguageContext;
        if (receiver instanceof Value) {
            Value receiverValue = (Value)receiver;
            PolyglotValue valueImpl = (PolyglotValue)languageContext.getAPIAccess().getImpl(receiverValue);
            if (valueImpl.languageContext.context != languageContext.context) {
                CompilerDirectives.transferToInterpreter();
                throw PolyglotImpl.engineError(new IllegalArgumentException(String.format("Values cannot be passed from one context to another. The current value originates from context 0x%s and the argument originates from context 0x%s.", Integer.toHexString(languageContext.context.hashCode()), Integer.toHexString(valueImpl.languageContext.context.hashCode()))));
            }
            return languageContext.getAPIAccess().getReceiver(receiverValue);
        }
        if (PolyglotImpl.isGuestPrimitive(receiver)) {
            return receiver;
        }
        if (receiver instanceof Proxy) {
            return PolyglotProxy.toProxyGuestObject(languageContext, (Proxy)receiver);
        }
        return VMAccessor.JAVAINTEROP.toGuestObject(receiver, languageContext);
    }

    static ToGuestValueNode createToGuestValue() {
        return new ToGuestValueNode();
    }

    @CompilerDirectives.TruffleBoundary
    Value toHostValue(Object value) {
        assert (value != null);
        assert (!(value instanceof Value));
        Object receiver = value;
        PolyglotValue cache = this.valueCache.get(receiver.getClass());
        if (cache == null) {
            receiver = this.convertToInterop(receiver);
            cache = this.lookupValueCache(receiver);
        }
        return this.getAPIAccess().newValue(receiver, (AbstractPolyglotImpl.AbstractValueImpl)cache);
    }

    TruffleObject convertToInterop(Object receiver) {
        if (receiver instanceof Proxy) {
            return PolyglotProxy.toProxyGuestObject(this, (Proxy)receiver);
        }
        return (TruffleObject)VMAccessor.JAVAINTEROP.toGuestObject(receiver, this);
    }

    synchronized PolyglotValue lookupValueCache(Object value) {
        assert (value instanceof TruffleObject);
        PolyglotValue cache = this.valueCache.get(value.getClass());
        if (cache == null) {
            cache = PolyglotValue.createInteropValueCache(this, (TruffleObject)value, value.getClass());
            this.valueCache.put(value.getClass(), cache);
        }
        return cache;
    }

    ToHostValueNode createToHostValue() {
        return new ToHostValueNode();
    }

    Object toGuestValue(Object receiver) {
        return PolyglotLanguageContext.toGuestValue(this, receiver);
    }

    @CompilerDirectives.TruffleBoundary
    Value[] toHostValues(Object[] values, int startIndex) {
        Value[] args = new Value[values.length - startIndex];
        for (int i = startIndex; i < values.length; ++i) {
            args[i - startIndex] = this.toHostValue(values[i]);
        }
        return args;
    }

    @CompilerDirectives.TruffleBoundary
    Value[] toHostValues(Object[] values) {
        Value[] args = new Value[values.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.toHostValue(values[i]);
        }
        return args;
    }

    public String toString() {
        return "PolyglotLanguageContext [language=" + this.language + ", initialized=" + (this.env != null) + "]";
    }

    private class PolyglotUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private PolyglotUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            TruffleLanguage.Env currentEnv = PolyglotLanguageContext.this.env;
            if (currentEnv != null) {
                try {
                    e.printStackTrace(new PrintStream(currentEnv.err()));
                }
                catch (Throwable exc) {
                    e.printStackTrace();
                }
            } else {
                e.printStackTrace();
            }
        }
    }

    final class ToHostValueNode {
        final AbstractPolyglotImpl.APIAccess apiAccess;
        @CompilerDirectives.CompilationFinal
        Class<?> cachedClass;
        @CompilerDirectives.CompilationFinal
        PolyglotValue cachedValue;
        @CompilerDirectives.CompilationFinal
        Class<?> cachedFallbackClass;
        @CompilerDirectives.CompilationFinal
        PolyglotValue cachedFallbackValue;

        private ToHostValueNode() {
            this.apiAccess = PolyglotLanguageContext.this.context.engine.impl.getAPIAccess();
        }

        Value execute(Object value) {
            Object receiver = value;
            Class<?> cachedClassLocal = this.cachedClass;
            if (cachedClassLocal == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.cachedClass = receiver.getClass();
                PolyglotValue cache = this.cachedValue = PolyglotLanguageContext.this.valueCache.get(this.cachedClass);
                if (this.cachedValue == null) {
                    receiver = PolyglotLanguageContext.this.convertToInterop(receiver);
                    this.cachedFallbackClass = receiver.getClass();
                    cache = this.cachedFallbackValue = PolyglotLanguageContext.this.lookupValueCache(receiver);
                }
                return this.apiAccess.newValue(receiver, (AbstractPolyglotImpl.AbstractValueImpl)cache);
            }
            if (cachedClassLocal != Generic.class) {
                if (cachedClassLocal.isInstance(value)) {
                    receiver = cachedClassLocal.cast(receiver);
                    PolyglotValue cache = this.cachedValue;
                    if (cache == null) {
                        if (this.cachedFallbackClass.isInstance(receiver = PolyglotLanguageContext.this.convertToInterop(receiver))) {
                            cache = this.cachedFallbackValue;
                        } else {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            this.cachedClass = Generic.class;
                            cache = PolyglotLanguageContext.this.lookupValueCache(receiver.getClass());
                        }
                    }
                    return this.apiAccess.newValue(receiver, (AbstractPolyglotImpl.AbstractValueImpl)cache);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.cachedClass = Generic.class;
            }
            return PolyglotLanguageContext.this.toHostValue(value);
        }
    }

    static final class ToGuestValueNode
    implements BiFunction<Object, Object, Object> {
        @CompilerDirectives.CompilationFinal
        private Class<?> cachedClass;

        private ToGuestValueNode() {
        }

        @Override
        public Object apply(Object languageContext, Object receiver) {
            Class<Object> cachedClassLocal = this.cachedClass;
            if (cachedClassLocal == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                if (receiver == null) {
                    cachedClassLocal = Generic.class;
                    this.cachedClass = Generic.class;
                } else {
                    cachedClassLocal = receiver.getClass();
                    this.cachedClass = cachedClassLocal;
                }
            }
            if (cachedClassLocal != Generic.class) {
                assert (cachedClassLocal != null);
                if (cachedClassLocal.isInstance(receiver)) {
                    return PolyglotLanguageContext.toGuestValue(languageContext, cachedClassLocal.cast(receiver));
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                cachedClassLocal = Generic.class;
                this.cachedClass = Generic.class;
            }
            return ToGuestValueNode.slowPath(languageContext, receiver);
        }

        @CompilerDirectives.TruffleBoundary
        private static Object slowPath(Object languageContext, Object receiver) {
            return PolyglotLanguageContext.toGuestValue(languageContext, receiver);
        }

        static ToGuestValueNode create() {
            return new ToGuestValueNode();
        }
    }

    static final class Generic {
        private Generic() {
            throw new AssertionError((Object)"no instances");
        }
    }

    static final class ToGuestValuesNode
    implements BiFunction<Object, Object[], Object[]> {
        @CompilerDirectives.CompilationFinal
        private int cachedLength = -1;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private ToGuestValueNode[] toGuestValue;
        @CompilerDirectives.CompilationFinal
        private boolean needsCopy = false;

        private ToGuestValuesNode() {
        }

        @Override
        public Object[] apply(Object languageContext, Object[] args) {
            if (this.cachedLength == -1) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.cachedLength = args.length;
                this.toGuestValue = new ToGuestValueNode[this.cachedLength];
                for (int i = 0; i < this.cachedLength; ++i) {
                    this.toGuestValue[i] = PolyglotLanguageContext.createToGuestValue();
                }
            }
            if (args.length == 0) {
                return args;
            }
            if (this.cachedLength == args.length) {
                Object[] newArgs = this.fastToGuestValuesUnroll(languageContext, args);
                return newArgs;
            }
            if (this.cachedLength != -2) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.cachedLength = -2;
                this.toGuestValue = Arrays.copyOf(this.toGuestValue, 1);
                if (this.toGuestValue[0] == null) {
                    this.toGuestValue[0] = PolyglotLanguageContext.createToGuestValue();
                }
            }
            return this.fastToGuestValues(languageContext, args);
        }

        @ExplodeLoop
        private Object[] fastToGuestValuesUnroll(Object languageContext, Object[] args) {
            Object[] newArgs = this.needsCopy ? new Object[this.toGuestValue.length] : args;
            for (int i = 0; i < this.toGuestValue.length; ++i) {
                Object arg = args[i];
                Object newArg = this.toGuestValue[i].apply(languageContext, arg);
                if (this.needsCopy) {
                    newArgs[i] = newArg;
                    continue;
                }
                if (arg == newArg) continue;
                CompilerDirectives.transferToInterpreterAndInvalidate();
                newArgs = Arrays.copyOf(args, args.length);
                newArgs[i] = newArg;
                this.needsCopy = true;
            }
            return newArgs;
        }

        private Object[] fastToGuestValues(Object languageContext, Object[] args) {
            assert (this.toGuestValue[0] != null);
            Object[] newArgs = this.needsCopy ? new Object[args.length] : args;
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                Object newArg = this.toGuestValue[0].apply(languageContext, arg);
                if (this.needsCopy) {
                    newArgs[i] = newArg;
                    continue;
                }
                if (arg == newArg) continue;
                CompilerDirectives.transferToInterpreterAndInvalidate();
                newArgs = Arrays.copyOf(args, args.length);
                newArgs[i] = newArg;
                this.needsCopy = true;
            }
            return newArgs;
        }

        static ToGuestValuesNode create() {
            return new ToGuestValuesNode();
        }
    }
}

