/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.vm;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.impl.DispatchOutputStream;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.java.JavaInterop;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.vm.ConvertedObject;
import com.oracle.truffle.api.vm.EngineTruffleObject;
import com.oracle.truffle.api.vm.PolyglotEngine;
import com.oracle.truffle.api.vm.VMAccessor;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

abstract class PolyglotRootNode
extends RootNode {
    private static RootCallTarget voidCallTarget = Truffle.getRuntime().createCallTarget(new VoidRootNode());
    final PolyglotEngine engine;

    private static void resetNativeImageState() {
        voidCallTarget = null;
    }

    PolyglotRootNode(PolyglotEngine engine) {
        super(null);
        this.engine = engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object execute(VirtualFrame frame) {
        PolyglotEngine prev = this.engine.enter();
        try {
            Object object = this.executeImpl(frame);
            return object;
        }
        finally {
            this.engine.leave(prev);
        }
    }

    protected abstract Object executeImpl(VirtualFrame var1);

    static CallTarget createExecuteSymbol(PolyglotEngine engine, Class<?> type) {
        if (PolyglotRootNode.isPrimitiveType(type)) {
            return voidCallTarget;
        }
        ForeignExecuteRootNode symbolNode = new ForeignExecuteRootNode(engine, type);
        return Truffle.getRuntime().createCallTarget(symbolNode);
    }

    static CallTarget createAsJava(PolyglotEngine engine, Class<?> type) {
        if (PolyglotRootNode.isPrimitiveType(type)) {
            return voidCallTarget;
        }
        AsJavaRootNode symbolNode = new AsJavaRootNode(engine, type);
        return Truffle.getRuntime().createCallTarget(symbolNode);
    }

    private static boolean isPrimitiveType(Class<?> type) {
        return type == String.class || type == Boolean.class || type == Byte.class || type == Short.class || type == Integer.class || type == Long.class || type == Character.class || type == Float.class || type == Double.class;
    }

    static void unwrapArgs(PolyglotEngine engine, Object[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof EngineTruffleObject) {
                EngineTruffleObject engineObject = (EngineTruffleObject)args[i];
                engineObject.assertEngine(engine);
                args[i] = engineObject.getDelegate();
            }
            if (args[i] == null || PolyglotRootNode.isPrimitiveType(args[i].getClass())) continue;
            args[i] = JavaInterop.asTruffleObject(args[i]);
        }
    }

    static CallTarget createSend(PolyglotEngine engine, Message message) {
        return Truffle.getRuntime().createCallTarget(new ForeignSendRootNode(engine, message));
    }

    static CallTarget createEval(PolyglotEngine engine, PolyglotEngine.Language language, Source source) {
        return Truffle.getRuntime().createCallTarget(new EvalRootNode(engine, language, source));
    }

    private static final class VoidRootNode
    extends RootNode {
        VoidRootNode() {
            super(null);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return frame.getArguments()[0];
        }
    }

    private static final class ConvertNode
    extends Node {
        @Node.Child
        private Node isNull;
        @Node.Child
        private Node isBoxed;
        @Node.Child
        private Node unbox;
        private final ConditionProfile isBoxedProfile = ConditionProfile.createBinaryProfile();

        ConvertNode() {
            this.isNull = Message.IS_NULL.createNode();
            this.isBoxed = Message.IS_BOXED.createNode();
            this.unbox = Message.UNBOX.createNode();
        }

        Object convert(Object obj) {
            if (obj instanceof TruffleObject) {
                return this.convert((TruffleObject)obj);
            }
            return obj;
        }

        private Object convert(TruffleObject obj) {
            boolean isBoxedResult = ForeignAccess.sendIsBoxed(this.isBoxed, obj);
            if (this.isBoxedProfile.profile(isBoxedResult)) {
                try {
                    Object newValue = ForeignAccess.sendUnbox(this.unbox, obj);
                    return new ConvertedObject(obj, newValue);
                }
                catch (UnsupportedMessageException e) {
                    return new ConvertedObject(obj, null);
                }
            }
            boolean isNullResult = ForeignAccess.sendIsNull(this.isNull, obj);
            if (isNullResult) {
                return new ConvertedObject(obj, null);
            }
            return obj;
        }
    }

    static final class EvalRootNode
    extends PolyglotRootNode {
        private static final Object[] EMPTY_ARRAY = new Object[0];
        @Node.Child
        private DirectCallNode call;
        private final PolyglotEngine.Language language;
        private final Source source;
        private static final Object NULL_VALUE = JavaInterop.asTruffleValue(null);

        private EvalRootNode(PolyglotEngine engine, PolyglotEngine.Language language, Source source) {
            super(engine);
            this.source = source;
            this.language = language;
        }

        @Override
        protected Object executeImpl(VirtualFrame frame) {
            Object result;
            if (this.call == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.initialize();
            }
            if ((result = this.call.call(EMPTY_ARRAY)) == null) {
                result = NULL_VALUE;
            }
            if (this.source.isInteractive()) {
                this.printResult(result);
            }
            return result;
        }

        @CompilerDirectives.TruffleBoundary
        private void printResult(Object result) {
            String stringResult = VMAccessor.LANGUAGE.toStringIfVisible(this.language.getEnv(false), result, true);
            if (stringResult != null) {
                try {
                    DispatchOutputStream out = this.language.engine().out;
                    ((OutputStream)out).write(stringResult.getBytes(StandardCharsets.UTF_8));
                    ((OutputStream)out).write(System.getProperty("line.separator").getBytes(StandardCharsets.UTF_8));
                }
                catch (IOException ioex) {
                    throw new IllegalStateException(ioex);
                }
            }
        }

        private void initialize() {
            CallTarget target = VMAccessor.LANGUAGE.parse(this.language.getEnv(true), this.source, null, new String[0]);
            if (target == null) {
                throw new NullPointerException("Parsing has not produced a CallTarget for " + this.source);
            }
            this.call = this.insert(DirectCallNode.create(target));
        }

        PolyglotEngine getEngine() {
            return this.engine;
        }
    }

    static final class ForeignExecuteRootNode
    extends PolyglotRootNode {
        @Node.Child
        private ConvertNode returnConvertNode;
        @Node.Child
        private Node executeNode;
        private final Class<? extends TruffleObject> receiverType;

        ForeignExecuteRootNode(PolyglotEngine engine, Class<? extends TruffleObject> receiverType) {
            super(engine);
            this.receiverType = receiverType;
            this.returnConvertNode = new ConvertNode();
        }

        @Override
        protected Object executeImpl(VirtualFrame frame) {
            Object[] callArgs = frame.getArguments();
            TruffleObject function = this.receiverType.cast(callArgs[0]);
            Object[] args = (Object[])callArgs[1];
            ForeignExecuteRootNode.unwrapArgs(this.engine, args);
            try {
                Object tmp;
                if (this.executeNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.executeNode = this.insert(Message.createExecute(0).createNode());
                }
                if ((tmp = ForeignAccess.sendExecute(this.executeNode, function, args)) == null) {
                    tmp = JavaInterop.asTruffleValue(null);
                }
                Object result = this.returnConvertNode.convert(tmp);
                return result;
            }
            catch (InteropException e) {
                CompilerDirectives.transferToInterpreter();
                throw e.raise();
            }
        }
    }

    private static final class AsJavaRootNode
    extends PolyglotRootNode {
        @Node.Child
        private Node toJavaNode;
        private final Class<? extends TruffleObject> receiverType;

        AsJavaRootNode(PolyglotEngine engine, Class<? extends TruffleObject> receiverType) {
            super(engine);
            this.receiverType = receiverType;
            this.toJavaNode = VMAccessor.JAVAINTEROP.createToJavaNode();
        }

        @Override
        protected Object executeImpl(VirtualFrame frame) {
            Object[] args = frame.getArguments();
            Class targetType = (Class)args[1];
            if (this.receiverType.isInstance(args[0])) {
                TruffleObject value = this.receiverType.cast(args[0]);
                return VMAccessor.JAVAINTEROP.toJava(this.toJavaNode, targetType, null, value, null);
            }
            throw new ClassCastException();
        }
    }

    private static final class ForeignSendRootNode
    extends PolyglotRootNode {
        @Node.Child
        private ConvertNode returnConvertNode = new ConvertNode();
        @Node.Child
        private Node messageNode;
        @Node.Child
        private Node toJavaNode;

        ForeignSendRootNode(PolyglotEngine engine, Message message) {
            super(engine);
            this.messageNode = message.createNode();
            this.toJavaNode = VMAccessor.JAVAINTEROP.createToJavaNode();
        }

        @Override
        protected Object executeImpl(VirtualFrame frame) {
            TruffleObject receiver = ForeignAccess.getReceiver(frame);
            Object[] args = ForeignAccess.getArguments(frame).toArray();
            ForeignSendRootNode.unwrapArgs(this.engine, args);
            Object tmp = ForeignAccess.execute(this.messageNode, null, receiver, args);
            return this.returnConvertNode.convert(tmp);
        }
    }
}

