/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.vm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.InstrumentInfo;
import com.oracle.truffle.api.impl.DispatchOutputStream;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.vm.InstrumentCache;
import com.oracle.truffle.api.vm.LanguageCache;
import com.oracle.truffle.api.vm.OptionValuesImpl;
import com.oracle.truffle.api.vm.PolyglotEngine;
import com.oracle.truffle.api.vm.PolyglotEngineProfile;
import com.oracle.truffle.api.vm.VMAccessor;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionValues;

@Deprecated
public final class PolyglotRuntime {
    private final List<LanguageShared> languages;
    final Object instrumentationHandler;
    final Map<String, PolyglotEngine.Instrument> instruments;
    final Object[] debugger = new Object[]{null};
    final PolyglotEngineProfile engineProfile;
    private final AtomicInteger instanceCount = new AtomicInteger(0);
    final DispatchOutputStream out;
    final DispatchOutputStream err;
    final InputStream in;
    volatile boolean disposed;
    final boolean automaticDispose;
    final Map<String, InstrumentInfo> instrumentInfos;
    final Map<String, LanguageInfo> languageInfos;

    private PolyglotRuntime() {
        this(null, null, null, false);
    }

    PolyglotRuntime(DispatchOutputStream out, DispatchOutputStream err, InputStream in, boolean automaticDispose) {
        PolyglotEngine.ensureInitialized();
        this.engineProfile = PolyglotEngine.GLOBAL_PROFILE;
        this.instrumentationHandler = VMAccessor.INSTRUMENT.createInstrumentationHandler(this, out, err, in);
        ArrayList<LanguageShared> languageList = new ArrayList<LanguageShared>();
        ArrayList<LanguageCache> convertedLanguages = new ArrayList<LanguageCache>(new HashSet<LanguageCache>(LanguageCache.languages().values()));
        Collections.sort(convertedLanguages);
        LinkedHashMap<String, LanguageInfo> langInfos = new LinkedHashMap<String, LanguageInfo>();
        LinkedHashMap<String, InstrumentInfo> instInfos = new LinkedHashMap<String, InstrumentInfo>();
        int languageIndex = 0;
        for (LanguageCache languageCache : convertedLanguages) {
            LanguageShared lang = new LanguageShared(this, languageCache, languageIndex++);
            languageList.add(lang);
            for (String mimeType : lang.language.getMimeTypes()) {
                langInfos.put(mimeType, lang.language);
            }
        }
        this.automaticDispose = automaticDispose;
        this.languages = languageList;
        this.instruments = this.createInstruments(InstrumentCache.load(VMAccessor.allLoaders()));
        for (Instrument instrument : this.instruments.values()) {
            instInfos.put(instrument.getId(), VMAccessor.LANGUAGE.createInstrument(instrument, instrument.getId(), instrument.getName(), instrument.getVersion()));
        }
        this.languageInfos = Collections.unmodifiableMap(langInfos);
        this.instrumentInfos = Collections.unmodifiableMap(instInfos);
        this.out = out;
        this.err = err;
        this.in = in;
    }

    PolyglotEngine currentVM() {
        return this.engineProfile.get();
    }

    List<LanguageShared> getLanguages() {
        return this.languages;
    }

    void notifyEngineDisposed() {
        this.instanceCount.decrementAndGet();
        if (this.automaticDispose) {
            this.dispose();
        }
    }

    void notifyEngineCreated() {
        this.instanceCount.incrementAndGet();
    }

    private Map<String, PolyglotEngine.Instrument> createInstruments(List<InstrumentCache> instrumentCaches) {
        LinkedHashMap<String, PolyglotEngine.Instrument> instr = new LinkedHashMap<String, PolyglotEngine.Instrument>();
        for (InstrumentCache cache : instrumentCaches) {
            PolyglotEngine polyglotEngine = PolyglotEngine.UNUSABLE_ENGINE;
            polyglotEngine.getClass();
            PolyglotEngine.Instrument instrument = polyglotEngine.new PolyglotEngine.Instrument(this, cache);
            instr.put(cache.getId(), instrument);
        }
        return Collections.unmodifiableMap(instr);
    }

    public Map<String, ? extends Instrument> getInstruments() {
        return this.instruments;
    }

    public synchronized void dispose() {
        if (this.instanceCount.get() > 0) {
            throw new IllegalStateException("Cannot dispose runtime if not all engine instances are disposed.");
        }
        if (!this.disposed) {
            this.disposed = true;
            for (Instrument instrument : this.getInstruments().values()) {
                try {
                    instrument.setEnabledImpl(false, false);
                }
                catch (Error | Exception ex) {
                    PrintStream ps = System.err;
                    ps.println("Error disposing " + instrument);
                    ex.printStackTrace();
                }
            }
        }
    }

    public static Builder newBuilder() {
        PolyglotRuntime polyglotRuntime = new PolyglotRuntime();
        polyglotRuntime.getClass();
        return polyglotRuntime.new Builder();
    }

    @Deprecated
    public class Instrument {
        private final InstrumentCache cache;
        private final Object instrumentLock = new Object();
        private volatile boolean enabled;
        OptionValues options;

        Instrument(InstrumentCache cache) {
            this.cache = cache;
        }

        public String getId() {
            return this.cache.getId();
        }

        public String getName() {
            return this.cache.getName();
        }

        public String getVersion() {
            return this.cache.getVersion();
        }

        InstrumentCache getCache() {
            return this.cache;
        }

        PolyglotRuntime getRuntime() {
            return PolyglotRuntime.this;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public <T> T lookup(Class<T> type) {
            if (PolyglotRuntime.this.disposed) {
                return null;
            }
            if (!this.isEnabled() && this.cache.supportsService(type)) {
                this.setEnabled(true);
            }
            return VMAccessor.INSTRUMENT.getInstrumentationHandlerService(PolyglotRuntime.this.instrumentationHandler, this, type);
        }

        public void setEnabled(boolean enabled) {
            this.setEnabledImpl(enabled, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setEnabledImpl(boolean enabled, boolean cleanup) {
            Object object = this.instrumentLock;
            synchronized (object) {
                if (this.enabled != enabled) {
                    if (enabled) {
                        if (PolyglotRuntime.this.disposed) {
                            return;
                        }
                        VMAccessor.INSTRUMENT.initializeInstrument(PolyglotRuntime.this.instrumentationHandler, this, this.getCache().getInstrumentationClass());
                        OptionDescriptors descriptors = VMAccessor.INSTRUMENT.describeOptions(this.getRuntime().instrumentationHandler, this, this.getId());
                        OptionValuesImpl values = new OptionValuesImpl(null, descriptors);
                        VMAccessor.INSTRUMENT.createInstrument(PolyglotRuntime.this.instrumentationHandler, this, this.cache.services(), values);
                    } else {
                        VMAccessor.INSTRUMENT.disposeInstrument(PolyglotRuntime.this.instrumentationHandler, this, cleanup);
                    }
                    this.enabled = enabled;
                }
            }
        }

        public String toString() {
            return "Instrument [id=" + this.getId() + ", name=" + this.getName() + ", version=" + this.getVersion() + ", enabled=" + this.enabled + "]";
        }
    }

    @Deprecated
    public final class Builder {
        private OutputStream out;
        private OutputStream err;
        private InputStream in;

        private Builder() {
        }

        public Builder setOut(OutputStream os) {
            this.out = os;
            return this;
        }

        public Builder setErr(OutputStream os) {
            this.err = os;
            return this;
        }

        public Builder setIn(InputStream is) {
            this.in = is;
            return this;
        }

        public PolyglotRuntime build() {
            DispatchOutputStream realOut = VMAccessor.INSTRUMENT.createDispatchOutput(this.out == null ? System.out : this.out);
            DispatchOutputStream realErr = VMAccessor.INSTRUMENT.createDispatchOutput(this.err == null ? System.err : this.err);
            InputStream realIn = this.in == null ? System.in : this.in;
            return new PolyglotRuntime(realOut, realErr, realIn, false);
        }

        PolyglotRuntime build(boolean autoDispose) {
            DispatchOutputStream realOut = VMAccessor.INSTRUMENT.createDispatchOutput(this.out == null ? System.out : this.out);
            DispatchOutputStream realErr = VMAccessor.INSTRUMENT.createDispatchOutput(this.err == null ? System.err : this.err);
            InputStream realIn = this.in == null ? System.in : this.in;
            return new PolyglotRuntime(realOut, realErr, realIn, autoDispose);
        }
    }

    static final class LanguageShared {
        final LanguageCache cache;
        final PolyglotRuntime runtime;
        final PolyglotEngineProfile engineProfile;
        final int languageId;
        final LanguageInfo language;
        OptionDescriptors options;
        volatile boolean initialized;

        LanguageShared(PolyglotRuntime engineShared, LanguageCache cache, int languageId) {
            this.runtime = engineShared;
            this.engineProfile = engineShared.engineProfile;
            assert (this.engineProfile != null);
            this.cache = cache;
            this.languageId = languageId;
            this.language = VMAccessor.NODES.createLanguage(this, cache.getId(), cache.getName(), cache.getVersion(), cache.getMimeTypes(), cache.isInternal());
        }

        PolyglotEngine.Language currentLanguage() {
            return this.runtime.currentVM().findLanguage(this);
        }

        Object getCurrentContext() {
            PolyglotEngine engine = this.engineProfile.get();
            Object context = PolyglotEngine.UNSET_CONTEXT;
            if (engine != null) {
                context = engine.languageArray[this.languageId].context;
            }
            if (context == PolyglotEngine.UNSET_CONTEXT) {
                CompilerDirectives.transferToInterpreter();
                throw new IllegalStateException("The language context is not yet initialized or already disposed. ");
            }
            return context;
        }

        PolyglotRuntime getRuntime() {
            return this.runtime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LanguageInfo getLanguageEnsureInitialized() {
            if (!this.initialized) {
                LanguageShared languageShared = this;
                synchronized (languageShared) {
                    if (!this.initialized) {
                        this.initialized = true;
                        LanguageCache.LoadedLanguage loadedLanguage = this.cache.loadLanguage();
                        VMAccessor.LANGUAGE.initializeLanguage(this.language, loadedLanguage.getLanguage(), loadedLanguage.isSingleton());
                        this.options = VMAccessor.LANGUAGE.describeOptions(loadedLanguage.getLanguage(), this.cache.getId());
                    }
                }
            }
            return this.language;
        }
    }
}

