/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationFactory;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.object.DynamicObjectImpl;
import com.oracle.truffle.object.LayoutImpl;
import com.oracle.truffle.object.Locations;
import com.oracle.truffle.object.PropertyMap;
import com.oracle.truffle.object.ShapeImpl;
import com.oracle.truffle.object.Transition;
import java.util.ArrayList;
import java.util.ListIterator;

public abstract class LayoutStrategy {
    private static final LocationFactory DEFAULT_LOCATION_FACTORY = new LocationFactory(){

        @Override
        public Location createLocation(Shape shape, Object value) {
            return ((ShapeImpl)shape).allocator().locationForValue(value, true, value != null);
        }
    };

    protected LayoutStrategy() {
    }

    protected LocationFactory getDefaultLocationFactory() {
        return DEFAULT_LOCATION_FACTORY;
    }

    protected abstract boolean updateShape(DynamicObject var1);

    protected abstract ShapeImpl ensureValid(ShapeImpl var1);

    protected abstract ShapeImpl ensureSpace(ShapeImpl var1, Location var2);

    public abstract ShapeImpl.BaseAllocator createAllocator(LayoutImpl var1);

    public abstract ShapeImpl.BaseAllocator createAllocator(ShapeImpl var1);

    protected ShapeImpl defineProperty(ShapeImpl shape, Object key, Object value, int flags, LocationFactory locationFactory) {
        ShapeImpl oldShape = shape;
        if (!oldShape.isValid()) {
            oldShape = this.ensureValid(oldShape);
        }
        Property existing = oldShape.getProperty(key);
        return this.defineProperty(oldShape, key, value, flags, locationFactory, existing);
    }

    protected ShapeImpl defineProperty(ShapeImpl oldShape, Object key, Object value, int flags, LocationFactory locationFactory, Property existing) {
        if (existing == null) {
            Property property = Property.create(key, locationFactory.createLocation(oldShape, value), flags);
            ShapeImpl newShape = oldShape.addProperty(property);
            return newShape;
        }
        if (existing.getFlags() == flags) {
            if (existing.getLocation().canSet(value)) {
                return oldShape;
            }
            return this.definePropertyGeneralize(oldShape, existing, value, locationFactory);
        }
        return this.definePropertyChangeFlags(oldShape, existing, value, flags);
    }

    protected ShapeImpl definePropertyGeneralize(ShapeImpl oldShape, Property oldProperty, Object value, LocationFactory locationFactory) {
        if (oldProperty.getLocation() instanceof Locations.DeclaredLocation) {
            Property property = oldProperty.relocate(locationFactory.createLocation(oldShape, value));
            return oldShape.replaceProperty(oldProperty, property);
        }
        return this.generalizeProperty(oldProperty, value, oldShape, oldShape);
    }

    protected ShapeImpl definePropertyChangeFlags(ShapeImpl oldShape, Property oldProperty, Object value, int flags) {
        Location oldLocation = oldProperty.getLocation();
        Location newLocation = oldLocation.canSet(value) ? oldLocation : oldShape.allocator().locationForValueUpcast(value, oldLocation);
        Property newProperty = Property.create(oldProperty.getKey(), newLocation, flags);
        ShapeImpl newShape = oldShape.replaceProperty(oldProperty, newProperty);
        return newShape;
    }

    protected ShapeImpl generalizeProperty(Property oldProperty, Object value, ShapeImpl currentShape, ShapeImpl nextShape) {
        Location oldLocation = oldProperty.getLocation();
        Location newLocation = currentShape.allocator().locationForValueUpcast(value, oldLocation);
        Property newProperty = oldProperty.relocate(newLocation);
        ShapeImpl newShape = nextShape.replaceProperty(oldProperty, newProperty);
        return newShape;
    }

    protected void propertySetFallback(Property property, DynamicObject store, Object value, ShapeImpl currentShape) {
        ShapeImpl oldShape = currentShape;
        ShapeImpl newShape = this.defineProperty(oldShape, property.getKey(), value, property.getFlags(), this.getDefaultLocationFactory());
        Property newProperty = newShape.getProperty(property.getKey());
        newProperty.setSafe(store, value, oldShape, newShape);
    }

    protected void propertySetWithShapeFallback(Property property, DynamicObject store, Object value, ShapeImpl currentShape, ShapeImpl nextShape) {
        ShapeImpl oldShape = currentShape;
        ShapeImpl newNextShape = this.generalizeProperty(property, value, oldShape, nextShape);
        Property newProperty = newNextShape.getProperty(property.getKey());
        newProperty.setSafe(store, value, oldShape, newNextShape);
    }

    protected void objectDefineProperty(DynamicObjectImpl object, Object key, Object value, int flags, LocationFactory locationFactory, ShapeImpl currentShape) {
        ShapeImpl oldShape = currentShape;
        Property oldProperty = oldShape.getProperty(key);
        ShapeImpl newShape = this.defineProperty(oldShape, key, value, flags, locationFactory, oldProperty);
        if (oldShape == newShape) {
            assert (oldProperty.equals(newShape.getProperty(key)));
            oldProperty.setSafe(object, value, oldShape);
        } else {
            Property newProperty = newShape.getProperty(key);
            newProperty.setSafe(object, value, oldShape, newShape);
        }
    }

    protected void objectRemoveProperty(DynamicObjectImpl object, Property property, ShapeImpl currentShape) {
        ShapeImpl oldShape = currentShape;
        ShapeImpl newShape = oldShape.removeProperty(property);
        this.reshapeAfterDelete(object, oldShape, newShape, ShapeImpl.findCommonAncestor(oldShape, newShape));
    }

    protected void reshapeAfterDelete(DynamicObjectImpl object, ShapeImpl oldShape, ShapeImpl newShape, ShapeImpl deletedParentShape) {
        DynamicObject original = object.cloneWithShape(oldShape);
        object.setShapeAndResize(newShape);
        object.copyProperties(original, deletedParentShape);
    }

    protected ShapeImpl replaceProperty(ShapeImpl shape, Property oldProperty, Property newProperty) {
        return this.directReplaceProperty(shape, oldProperty, newProperty);
    }

    protected ShapeImpl removeProperty(ShapeImpl shape, Property property) {
        assert (!shape.isShared());
        Transition.RemovePropertyTransition transition = new Transition.RemovePropertyTransition(property);
        ShapeImpl cachedShape = shape.queryTransition(transition);
        if (cachedShape != null) {
            return this.ensureValid(cachedShape);
        }
        ShapeImpl owningShape = LayoutStrategy.getShapeFromProperty(shape, property.getKey());
        if (owningShape != null) {
            ArrayList<Transition> transitionList = new ArrayList<Transition>();
            ShapeImpl current = shape;
            while (current != owningShape) {
                if (!(current.getTransitionFromParent() instanceof Transition.DirectReplacePropertyTransition) || !((Transition.DirectReplacePropertyTransition)current.getTransitionFromParent()).getPropertyBefore().getKey().equals(property.getKey())) {
                    transitionList.add(current.getTransitionFromParent());
                }
                current = current.parent;
            }
            ShapeImpl newShape = owningShape.parent;
            ListIterator iterator = transitionList.listIterator(transitionList.size());
            while (iterator.hasPrevious()) {
                Transition previous = (Transition)iterator.previous();
                newShape = this.applyTransition(newShape, previous, true);
            }
            shape.addIndirectTransition(transition, newShape);
            return newShape;
        }
        return null;
    }

    protected ShapeImpl directReplaceProperty(ShapeImpl shape, Property oldProperty, Property newProperty) {
        Transition.DirectReplacePropertyTransition replacePropertyTransition = new Transition.DirectReplacePropertyTransition(oldProperty, newProperty);
        ShapeImpl cachedShape = shape.queryTransition(replacePropertyTransition);
        if (cachedShape != null) {
            return this.ensureValid(cachedShape);
        }
        PropertyMap newPropertyMap = shape.getPropertyMap().replaceCopy(oldProperty, newProperty);
        ShapeImpl.BaseAllocator allocator = shape.allocator().addLocation(newProperty.getLocation());
        ShapeImpl newShape = shape.createShape(shape.getLayout(), shape.getSharedData(), shape, shape.getObjectType(), newPropertyMap, replacePropertyTransition, allocator, shape.getId());
        shape.addDirectTransition(replacePropertyTransition, newShape);
        return newShape;
    }

    protected ShapeImpl addProperty(ShapeImpl shape, Property property) {
        return this.addProperty(shape, property, true);
    }

    protected ShapeImpl addProperty(ShapeImpl shape, Property property, boolean ensureValid) {
        assert (!shape.hasProperty(property.getKey())) : "duplicate property " + property.getKey();
        Transition.AddPropertyTransition addTransition = new Transition.AddPropertyTransition(property);
        ShapeImpl cachedShape = shape.queryTransition(addTransition);
        if (cachedShape != null) {
            return ensureValid ? this.ensureValid(cachedShape) : cachedShape;
        }
        ShapeImpl oldShape = this.ensureSpace(shape, property.getLocation());
        ShapeImpl newShape = ShapeImpl.makeShapeWithAddedProperty(oldShape, addTransition);
        oldShape.addDirectTransition(addTransition, newShape);
        return newShape;
    }

    protected ShapeImpl applyTransition(ShapeImpl shape, Transition transition, boolean append) {
        if (transition instanceof Transition.AddPropertyTransition) {
            Property property = ((Transition.AddPropertyTransition)transition).getProperty();
            if (append) {
                return shape.append(property);
            }
            shape.onPropertyTransition(property);
            return this.addProperty(shape, property, false);
        }
        if (transition instanceof Transition.ObjectTypeTransition) {
            return shape.changeType(((Transition.ObjectTypeTransition)transition).getObjectType());
        }
        if (transition instanceof Transition.ReservePrimitiveArrayTransition) {
            return shape.reservePrimitiveExtensionArray();
        }
        if (transition instanceof Transition.DirectReplacePropertyTransition) {
            Property oldProperty = ((Transition.DirectReplacePropertyTransition)transition).getPropertyBefore();
            Property newProperty = ((Transition.DirectReplacePropertyTransition)transition).getPropertyAfter();
            if (append) {
                oldProperty = shape.getProperty(oldProperty.getKey());
                newProperty = newProperty.relocate(shape.allocator().moveLocation(newProperty.getLocation()));
            }
            return this.directReplaceProperty(shape, oldProperty, newProperty);
        }
        throw new UnsupportedOperationException(transition.getClass().getName());
    }

    protected ShapeImpl addPrimitiveExtensionArray(ShapeImpl shape) {
        LayoutImpl layout = shape.getLayout();
        assert (layout.hasPrimitiveExtensionArray() && !shape.hasPrimitiveArray());
        Transition.ReservePrimitiveArrayTransition transition = new Transition.ReservePrimitiveArrayTransition();
        ShapeImpl cachedShape = shape.queryTransition(transition);
        if (cachedShape != null) {
            return layout.getStrategy().ensureValid(cachedShape);
        }
        ShapeImpl oldShape = this.ensureSpace(shape, layout.getPrimitiveArrayLocation());
        ShapeImpl newShape = ShapeImpl.makeShapeWithPrimitiveExtensionArray(oldShape, transition);
        oldShape.addDirectTransition(transition, newShape);
        return newShape;
    }

    protected static ShapeImpl getShapeFromProperty(ShapeImpl shape, Object propertyName) {
        ShapeImpl root = shape.getRoot();
        for (ShapeImpl current = shape; current != root; current = current.getParent()) {
            if (!(current.getTransitionFromParent() instanceof Transition.AddPropertyTransition) || !((Transition.AddPropertyTransition)current.getTransitionFromParent()).getProperty().getKey().equals(propertyName)) continue;
            return current;
        }
        return null;
    }

    protected static ShapeImpl getShapeFromProperty(ShapeImpl shape, Property prop) {
        ShapeImpl current = shape;
        ShapeImpl root = shape.getRoot();
        while (current != root) {
            if (current.getTransitionFromParent() instanceof Transition.AddPropertyTransition && ((Transition.AddPropertyTransition)current.getTransitionFromParent()).getProperty().equals(prop)) {
                return current;
            }
            current = current.parent;
        }
        return null;
    }
}

