/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.applet.Applet;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.MenuItemUI;
import oracle.javatools.ui.MenuItemUIDecorator;

public class CloseableMenuItem
extends JMenuItem {
    public CloseableMenuItem(Icon icon) {
        super(icon);
    }

    public CloseableMenuItem(Action a) {
        super(a);
    }

    public CloseableMenuItem(String text, Icon icon) {
        super(text, icon);
    }

    public CloseableMenuItem(String text, int mnemonic) {
        super(text, mnemonic);
    }

    public CloseableMenuItem(String text) {
        super(text);
    }

    public CloseableMenuItem() {
    }

    @Override
    public void updateUI() {
        MenuItemUI baseUI = (MenuItemUI)UIManager.getUI(this);
        this.setUI(new CloseableMenuItemUI(baseUI));
    }

    protected void doClose() {
        JPopupMenu menu = this.getMenu();
        if (menu != null) {
            menu.remove(this);
            menu.pack();
        }
    }

    public JPopupMenu getMenu() {
        JPopupMenu menu = null;
        for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof JPopupMenu) {
                menu = (JPopupMenu)parent;
                break;
            }
            if (parent instanceof Window || parent instanceof Applet) break;
        }
        return menu;
    }

    private static class CloseableMenuItemUI
    extends MenuItemUIDecorator {
        private static int EXTRA_WIDTH = 10;
        private static int EXTRA_WIDTH_INSETS = 2;
        private Stroke stroke = new BasicStroke(1.5f, 1, 1);
        private MouseL mouseL = new MouseL();

        public CloseableMenuItemUI(MenuItemUI baseMenuItemUI) {
            super(baseMenuItemUI);
        }

        @Override
        public void uninstallUI(JComponent c) {
            super.uninstallUI(c);
            if (this.mouseL != null) {
                c.removeMouseListener(this.mouseL);
                c.removeMouseMotionListener(this.mouseL);
            }
            this.mouseL = null;
        }

        @Override
        public void installUI(JComponent c) {
            super.installUI(c);
            c.addMouseListener(this.mouseL);
            c.addMouseMotionListener(this.mouseL);
        }

        @Override
        public Dimension getPreferredSize(JComponent c) {
            Dimension d = super.getPreferredSize(c);
            d.width += EXTRA_WIDTH;
            return d;
        }

        @Override
        public void update(Graphics g, JComponent c) {
            this.paint(g, c);
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            super.paint(g, c);
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Point iconLocation = CloseableMenuItemUI.getCloseIconLocation((CloseableMenuItem)c);
            g2.translate(iconLocation.x, iconLocation.y);
            JMenuItem menuItem = (JMenuItem)c;
            g2.setColor(UIManager.getColor(menuItem.getModel().isArmed() ? "MenuItem.selectionForeground" : "Button.disabledText"));
            g2.setStroke(this.stroke);
            g2.drawLine(EXTRA_WIDTH_INSETS, EXTRA_WIDTH_INSETS, EXTRA_WIDTH - EXTRA_WIDTH_INSETS - EXTRA_WIDTH_INSETS, EXTRA_WIDTH - EXTRA_WIDTH_INSETS - EXTRA_WIDTH_INSETS);
            g2.drawLine(EXTRA_WIDTH_INSETS, EXTRA_WIDTH - EXTRA_WIDTH_INSETS - EXTRA_WIDTH_INSETS, EXTRA_WIDTH - EXTRA_WIDTH_INSETS - EXTRA_WIDTH_INSETS, EXTRA_WIDTH_INSETS);
            if (this.mouseL.isArmed) {
                g2.drawRoundRect(0, 0, EXTRA_WIDTH - EXTRA_WIDTH_INSETS, EXTRA_WIDTH - EXTRA_WIDTH_INSETS, 4, 4);
            }
        }

        private static Point getCloseIconLocation(CloseableMenuItem menuItem) {
            Point iconLocation = new Point();
            iconLocation.x = menuItem.getWidth() - EXTRA_WIDTH - menuItem.getBorder().getBorderInsets((Component)menuItem).right;
            iconLocation.y = menuItem.getHeight() / 2 - EXTRA_WIDTH / 2;
            return iconLocation;
        }

        static /* synthetic */ int access$200() {
            return EXTRA_WIDTH;
        }

        static /* synthetic */ int access$300() {
            return EXTRA_WIDTH_INSETS;
        }

        private static class MouseL
        extends MouseInputAdapter {
            private boolean isArmed = false;
            private static Rectangle hitRect = new Rectangle(1, 1, CloseableMenuItemUI.access$200() - CloseableMenuItemUI.access$300() + 1, CloseableMenuItemUI.access$200() - CloseableMenuItemUI.access$300() + 1);

            private MouseL() {
            }

            private void arm(MouseEvent e) {
                Point p = e.getPoint();
                CloseableMenuItem menuItem = (CloseableMenuItem)e.getSource();
                boolean wasArmed = this.isArmed;
                Point iconLocation = CloseableMenuItemUI.getCloseIconLocation(menuItem);
                p.translate(-iconLocation.x, -iconLocation.y);
                this.isArmed = hitRect.contains(p);
                if (wasArmed != this.isArmed) {
                    menuItem.repaint();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                this.arm(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.isArmed = false;
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                this.arm(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.arm(e);
                if (this.isArmed) {
                    ((CloseableMenuItem)e.getSource()).doClose();
                    e.consume();
                }
            }
        }
    }
}

