/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.metal.MetalLabelUI;
import oracle.bali.ewt.olaf2.OracleLookAndFeel;
import oracle.javatools.ui.StringUtils;

public final class Ellipses {
    private Ellipses() {
    }

    public static void setEllipsesLocation(JLabel label, int ellipsesLocation) {
        if (ellipsesLocation != 10 && ellipsesLocation != 0 && ellipsesLocation != 11) {
            throw new IllegalArgumentException("Incorrect ellipsesLocation: " + ellipsesLocation);
        }
        label.setUI(new TruncatedLabelUI(ellipsesLocation));
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel((LookAndFeel)new OracleLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            // empty catch block
        }
        JLabel left = new JLabel("This text is truncated to the left");
        JLabel right = new JLabel("This text is truncated to the right");
        JLabel center = new JLabel("This text is truncated in the center");
        Ellipses.setEllipsesLocation(left, 10);
        Ellipses.setEllipsesLocation(right, 11);
        Ellipses.setEllipsesLocation(center, 0);
        JFrame frame = new JFrame("UIC Component Test");
        frame.setLayout(new BorderLayout());
        frame.add((Component)left, "North");
        frame.add((Component)right, "Center");
        frame.add((Component)center, "South");
        frame.setDefaultCloseOperation(3);
        frame.setSize(150, 90);
        frame.setLocationRelativeTo(null);
        frame.getContentPane().setBackground(Color.WHITE);
        frame.setVisible(true);
    }

    private static final class TruncatedLabelUI
    extends MetalLabelUI {
        private final int ellipsesLocation;

        public TruncatedLabelUI(int ellipsesLocation) {
            this.ellipsesLocation = ellipsesLocation;
        }

        @Override
        protected String layoutCL(JLabel label, FontMetrics fontMetrics, String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR) {
            return StringUtils.layoutCompoundLabel(label, fontMetrics, text, icon, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), viewR, iconR, textR, label.getIconTextGap(), this.ellipsesLocation);
        }
    }
}

