/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.LayerUI;
import oracle.javatools.util.ModelUtil;

public class TextLayer<V extends JComponent>
extends LayerUI<V> {
    private String text = "";
    private boolean displayText = true;
    private Color foreground = UIManager.getColor("TextArea.inactiveForeground");
    private Font font;
    public static final Font REGULAR_FONT = UIManager.getFont("Label.font").deriveFont(1, 12.0f);
    public static final Font LARGE_FONT = UIManager.getFont("Label.font").deriveFont(1, 16.0f);

    public TextLayer(String text) {
        this.setText(text);
    }

    public TextLayer(String text, Font font) {
        this.setText(text);
        this.setFont(font);
    }

    public final void setText(String text) {
        this.text = text;
    }

    public final String getText() {
        return this.text;
    }

    public final void setTextVisible(boolean displayText) {
        this.displayText = displayText;
    }

    public final boolean isTextVisible() {
        return this.displayText;
    }

    public final void setForeground(Color foreground) {
        this.foreground = foreground;
    }

    public final Color getForeground() {
        return this.foreground;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        Graphics2D g2 = (Graphics2D)g;
        if (this.displayText && this.text != null) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Font f = this.getFont();
            if (f == null || REGULAR_FONT.equals(f)) {
                f = c.getFont().deriveFont(1, 12.0f);
                this.setFont(f);
            } else if (LARGE_FONT.equals(f)) {
                f = c.getFont().deriveFont(1, 16.0f);
                this.setFont(f);
            }
            ArrayList<TextLayout> layouts = new ArrayList<TextLayout>();
            String[] lines = this.getText().split("\\n");
            if (lines.length < 1) {
                return;
            }
            int h = 0;
            int maxWidth = c.getWidth() - 10;
            for (String line : lines) {
                if (!ModelUtil.hasLength((String)line)) {
                    line = " ";
                }
                AttributedString string = new AttributedString(line, f.getAttributes());
                LineBreakMeasurer lbMeasurer = new LineBreakMeasurer(string.getIterator(), g2.getFontRenderContext());
                TextLayout textLayout = lbMeasurer.nextLayout(maxWidth);
                while (textLayout != null) {
                    h = (int)((double)h + textLayout.getBounds().getHeight());
                    layouts.add(textLayout);
                    textLayout = lbMeasurer.nextLayout(maxWidth);
                }
            }
            int interlineGap = h / layouts.size() / 2;
            int y = c.getHeight() / 2 - (h += interlineGap * (layouts.size() - 1)) / 2;
            if (layouts.size() == 1) {
                y = (int)((float)y + ((TextLayout)layouts.get(0)).getAscent());
            }
            for (TextLayout layout : layouts) {
                Rectangle2D textBounds = layout.getBounds();
                int x = (int)((double)((maxWidth + 5) / 2) - textBounds.getWidth() / 2.0);
                g2.setColor(UIManager.getColor("TextArea.background"));
                layout.draw(g2, (float)x + 0.75f, (float)y + 0.75f);
                g2.setColor(this.foreground);
                layout.draw(g2, x, y);
                y = (int)((float)y + ((float)interlineGap + layout.getAscent()));
            }
        }
    }

    public final void setFont(Font font) {
        this.font = font;
    }

    public final Font getFont() {
        return this.font;
    }
}

