/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.builders;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import oracle.javatools.ui.builders.BuiltTable;
import oracle.javatools.ui.builders.ExAppBasicPanel;
import oracle.javatools.ui.builders.TableBuilder;
import oracle.javatools.ui.list.LabelListCellRenderer;
import oracle.javatools.ui.table.SimpleTableFormat;
import oracle.javatools.ui.table.SimpleTableModel;

class ExAppTablePanel
extends ExAppBasicPanel {
    private static BuiltTable tc;
    private Reorder reorder = new Reorder();
    private AutoSize autosize = new AutoSize();
    private Selection selection = new Selection();
    private Sorted sorted = new Sorted();
    private DefaultActions defaultactions = new DefaultActions();
    private HorizontalScrolling horizontalscrolling = new HorizontalScrolling();
    protected VisibleRows visiblerows = new VisibleRows();

    ExAppTablePanel() {
    }

    @Override
    protected JComponent createControlPanel() {
        JPanel controlPanel = new JPanel((LayoutManager)new MigLayout("aligny top, nogrid, ins 5 5 5 16, gapy 2"));
        JButton buildButton = new JButton("Build");
        buildButton.setFont(buildButton.getFont().deriveFont(1));
        buildButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ExAppTablePanel.this.build();
                }
                catch (UnsupportedOperationException e1) {
                    ExAppTablePanel.this.updateComponent(new JLabel("Error: See below"));
                    ExAppTablePanel.this.constructTextArea.setText("Error: " + e1.getMessage());
                    ExAppTablePanel.this.constructTextArea.setCaretPosition(0);
                    ExAppTablePanel.this.selectTextArea.setText("");
                }
            }
        });
        JButton dumpButton = new JButton("Dump");
        dumpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExAppTablePanel.this.dump();
            }
        });
        controlPanel.add((Component)new JLabel("Select your configuration, then press:"), "gapbottom 16, span, split");
        controlPanel.add((Component)buildButton, "wrap");
        controlPanel.add((Component)new JLabel("Model:"), "");
        controlPanel.add((Component)Model.combo, "wrap");
        controlPanel.add((Component)new JLabel("Selection Mode:"), "");
        controlPanel.add((Component)SelectionMode.combo, "wrap");
        controlPanel.add((Component)new JLabel("Row Header:"), "");
        controlPanel.add((Component)RowHeader.combo, "wrap");
        controlPanel.add((Component)RowSelectionAllowed.cb, "wrap");
        controlPanel.add((Component)ColumnSelectionAllowed.cb, "wrap");
        controlPanel.add((Component)this.rollover.cb, "span, wrap");
        controlPanel.add((Component)this.reorder.cb, "span, wrap");
        controlPanel.add((Component)this.resize.cb, "wrap");
        controlPanel.add((Component)this.checkable.cb, "");
        controlPanel.add((Component)this.checkable.b1, "");
        controlPanel.add((Component)this.checkable.b2, "span, wrap");
        controlPanel.add((Component)this.selection.cb, "span, wrap");
        controlPanel.add((Component)this.sorted.cb, "span, wrap");
        controlPanel.add((Component)this.autosize.cb, "span, wrap");
        controlPanel.add((Component)this.horizontalscrolling.cb, "span, wrap");
        controlPanel.add((Component)Tooltips.cb, "span, wrap");
        controlPanel.add((Component)HiddenColumnsAllowed.cb, "span, wrap");
        controlPanel.add((Component)HiddenColumns.cb, "span, wrap");
        controlPanel.add((Component)SelectAllAllowed.cb, "span, wrap");
        controlPanel.add((Component)this.doubleclick.cb, "span, wrap");
        controlPanel.add((Component)new JLabel("Visible Rows:"), "");
        controlPanel.add((Component)this.visiblerows.sp, "span, wrap");
        controlPanel.add((Component)this.actions.cb, "span, wrap");
        controlPanel.add((Component)this.moreactions.cb, "");
        controlPanel.add((Component)this.moreactions.tf, "span, wrap");
        controlPanel.add((Component)this.defaultactions.cb, "span, wrap");
        controlPanel.add((Component)this.emptytext.cb, "");
        controlPanel.add((Component)this.emptytext.tf, "");
        controlPanel.add((Component)this.emptytext.lcb, "wrap");
        controlPanel.add((Component)this.label.cb, "");
        controlPanel.add((Component)this.label.tf, "wrap");
        controlPanel.add((Component)this.titlebar.cb, "span, wrap");
        controlPanel.add((Component)this.selectionenabled.cb, "");
        controlPanel.add((Component)this.selectionenabled.b, "wrap");
        return controlPanel;
    }

    private void build() {
        TableBuilder builder = new TableBuilder();
        StringBuilder createSB = new StringBuilder("");
        StringBuilder selectSB = new StringBuilder("");
        Model.build(builder, createSB, selectSB);
        SelectionMode.build(builder, createSB, selectSB);
        RowSelectionAllowed.build(builder, createSB, selectSB);
        ColumnSelectionAllowed.build(builder, createSB, selectSB);
        this.resize.build(builder, createSB, selectSB);
        this.selection.build(builder, createSB, selectSB);
        this.rollover.build(builder, createSB, selectSB);
        this.checkable.build(builder, createSB, selectSB);
        if (this.checkable.cb.isSelected()) {
            this.checkable.b1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExAppTablePanel.this.checkable.checkedItems.add(((SimpleTableModel)tc.getTable().getModel()).getRow(0));
                }
            });
        }
        this.horizontalscrolling.build(builder, createSB, selectSB);
        this.visiblerows.build(builder, createSB, selectSB);
        this.emptytext.build(builder, createSB, selectSB);
        this.sorted.build(builder, createSB, false);
        this.autosize.build(builder, createSB, selectSB);
        this.doubleclick.build(builder, createSB, selectSB);
        this.label.build(builder, createSB, selectSB);
        this.titlebar.build(builder, createSB, selectSB);
        this.selectionenabled.build(builder, createSB, selectSB);
        this.actions.build(builder, createSB, selectSB);
        this.moreactions.build(builder, createSB, selectSB);
        this.defaultactions.build(builder, createSB, selectSB);
        this.reorder.build(builder, createSB, selectSB);
        Tooltips.build(builder, createSB, selectSB);
        HiddenColumnsAllowed.build(builder, createSB, selectSB);
        HiddenColumns.build(builder, createSB, selectSB);
        RowHeader.build(builder, createSB, selectSB);
        SelectAllAllowed.build(builder, createSB, selectSB);
        switch ((Model)((Object)Model.combo.getSelectedItem())) {
            case DEFAULT: {
                createSB.append("\nBuiltTable builtTable = builder.build();\n\nadd(builtTable.getGUI());");
                break;
            }
            case SIMPLE: 
            case LIST: {
                createSB.append("\nBuiltTable<Locale> builtTable = builder.build();\n\nadd(builtTable.getGUI());");
            }
        }
        this.constructTextArea.setText(createSB.toString());
        this.constructTextArea.setCaretPosition(0);
        this.selectTextArea.setText(selectSB.toString());
        this.selectTextArea.setCaretPosition(0);
        tc = builder.build();
        this.updateComponent(tc.getGUI());
    }

    @Override
    protected void dump() {
        if (tc == null) {
            return;
        }
        if (tc.getTable().getRowSelectionAllowed() && !tc.getTable().getColumnSelectionAllowed()) {
            switch ((Model)((Object)Model.combo.getSelectedItem())) {
                case DEFAULT: {
                    if (tc.getTable().getSelectionModel().getSelectionMode() == 0) {
                        System.out.println("Selected row: builtTable.getSelectedRow()");
                        System.out.println(tc.getSelectedRow());
                        System.out.println();
                        break;
                    }
                    System.out.println("Selected row: builtTable.getSelectedRows()");
                    System.out.println(tc.getSelectedRows());
                    System.out.println();
                    break;
                }
                case SIMPLE: 
                case LIST: {
                    if (tc.getTable().getSelectionModel().getSelectionMode() == 0) {
                        System.out.println("Selected item: builtTable.getSelectedValue()");
                        System.out.println(tc.getSelectedValue());
                        System.out.println();
                        break;
                    }
                    System.out.println("Selected item: builtTable.getSelectedValues()");
                    System.out.println(tc.getSelectedValues());
                    System.out.println();
                }
            }
        } else if (!tc.getTable().getRowSelectionAllowed() && tc.getTable().getColumnSelectionAllowed()) {
            if (tc.getTable().getSelectionModel().getSelectionMode() == 0) {
                System.out.println("Selected columns: builtTable.getTable().getSelectedColumn()");
                System.out.println(tc.getTable().getSelectedColumn());
                System.out.println();
            } else {
                System.out.println("Selected columns: builtTable.getTable().getSelectedColumns()");
                System.out.print("[");
                int j = 1;
                for (int i : tc.getTable().getSelectedColumns()) {
                    System.out.print(i);
                    if (j++ >= tc.getTable().getSelectedColumnCount()) continue;
                    System.out.print(", ");
                }
                System.out.println("]");
                System.out.println();
            }
        } else if (tc.getTable().getRowSelectionAllowed() && tc.getTable().getColumnSelectionAllowed()) {
            if (tc.getTable().getSelectionModel().getSelectionMode() == 0) {
                int rowIndex = tc.getTable().getSelectedRow();
                int colIndex = tc.getTable().getSelectedColumn();
                System.out.println("int rowIndex = builtTable.getTable().getSelectedRow();");
                System.out.println("int colIndex = builtTable.getTable().getSelectedColumn();");
                System.out.println("rowIndex = " + rowIndex + ", colIndex = " + colIndex);
                System.out.println();
            } else {
                System.out.println("List<Point> cells = builtTable.getSelectedCells();");
                System.out.println(tc.getSelectedCells());
                System.out.println();
            }
        }
        System.out.println("---------------------------------");
    }

    private static enum Model {
        DEFAULT,
        SIMPLE,
        LIST;

        private static JComboBox combo;
        private static String[] defaultModelColumns;
        private static String[][] defaultModelData;
        private static TableModel defaultModel;

        public String toString() {
            switch (this) {
                case LIST: {
                    return "java.util.List (or array) - No TableModel needed!";
                }
                case DEFAULT: {
                    return "DefaultTableModel of Music";
                }
                case SIMPLE: {
                    return "SimpleTableModel of Locales";
                }
            }
            return super.toString();
        }

        private static void build(TableBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            switch ((Model)((Object)combo.getSelectedItem())) {
                case DEFAULT: {
                    createSB.append("Object[][] defaultModelData = ...\n");
                    createSB.append("Object[] defaultModelColumns = ...\n");
                    createSB.append("DefaultTableModel model = new DefaultTableModel(defaultModelData, defaultModelColumns);\n\n");
                    createSB.append("TableBuilder builder = new TableBuilder<Locale>();\n");
                    createSB.append("builder.setModel(model);\n");
                    builder.setModel(defaultModel);
                    break;
                }
                case SIMPLE: {
                    createSB.append("SimpleTableModel<Locale> model =\n    new SimpleTableModel<Locale>(Locale.getAvailableLocales(), new LocaleFormat());\n\n");
                    createSB.append("TableBuilder<Locale> builder = new TableBuilder<Locale>();\n");
                    createSB.append("builder.setModel(model);\n");
                    SimpleTableModel<Locale> model = new SimpleTableModel<Locale>(Locale.getAvailableLocales(), new LocaleFormat());
                    builder.setModel(model);
                    break;
                }
                case LIST: {
                    createSB.append("TableBuilder<Locale> builder = new TableBuilder<Locale>();\n");
                    createSB.append("builder.setModel(Locale.getAvailableLocales());\n");
                    createSB.append("builder.addColumn(\"Country\", \"getDisplayCountry\");\n");
                    createSB.append("builder.addColumn(\"Language\", \"getDisplayLanguage\");\n");
                    createSB.append("builder.addColumn(\"Name\", \"getDisplayName\");\n");
                    createSB.append("builder.addColumn(\"Variant\", \"getDisplayVariant\");\n");
                    builder.setModel(Arrays.asList(Locale.getAvailableLocales()));
                    builder.addColumn("Country", "getDisplayCountry");
                    builder.addColumn("Language", "getDisplayLanguage");
                    builder.addColumn("Name", "getDisplayName");
                    builder.addColumn("Variant", "getDisplayVariant");
                }
            }
            if (RowSelectionAllowed.cb.isSelected() && !ColumnSelectionAllowed.cb.isSelected()) {
                switch ((Model)((Object)combo.getSelectedItem())) {
                    case DEFAULT: {
                        if (SelectionMode.combo.getSelectedItem() == SelectionMode.SINGLE) {
                            selectSB.append("int rowIndex = builtTable.getSelectedRow();");
                            break;
                        }
                        selectSB.append("List<Integer> rows = builtTable.getSelectedRows();");
                        break;
                    }
                    case SIMPLE: 
                    case LIST: {
                        if (SelectionMode.combo.getSelectedItem() == SelectionMode.SINGLE) {
                            selectSB.append("Locale locale = builtTable.getSelectedValue();");
                            break;
                        }
                        selectSB.append("List<Locale> locale builtTable.getSelectedValues();");
                    }
                }
            } else if (!RowSelectionAllowed.cb.isSelected() && ColumnSelectionAllowed.cb.isSelected()) {
                if (SelectionMode.combo.getSelectedItem() == SelectionMode.SINGLE) {
                    selectSB.append("int selectedCol = builtTable.getTable().getSelectedColumn();");
                } else {
                    selectSB.append("int[] selectedCols = builtTable.getTable().getSelectedColumns();");
                }
            } else if (RowSelectionAllowed.cb.isSelected() && ColumnSelectionAllowed.cb.isSelected()) {
                if (SelectionMode.combo.getSelectedItem() == SelectionMode.SINGLE) {
                    selectSB.append("int rowIndex = builtTable.getTable().getSelectedRow();\n");
                    selectSB.append("int colIndex = builtTable.getTable().getSelectedColumn();");
                } else {
                    selectSB.append("List<Point> cells = builtTable.getSelectedCells();");
                }
            }
        }

        static {
            combo = new JComboBox<Model>(Model.values());
            combo.setSelectedIndex(2);
            combo.setToolTipText("Set the model for the table: a SimpleTableModel is recommended as it is easy to create from a list or array and supports all of the features of the table builder");
            defaultModelColumns = new String[]{"Artist", "Album", "Genre", "Year", "Length"};
            defaultModelData = new String[][]{{"The White Stripes", "Elephant", "Rock", "2003", "45:02"}, {"Oasis", "Definitely Maybe", "Rock", "1995", "48:21"}, {"James Brown", "20 All-Time Greatest Hits", "Soul", "1978", "55:12"}, {"Ali Farka Toure", "Savane", "Blues", "2006", "54:54"}, {"Django Reinhardt", "Djangologie", "Jazz", "1937", "34:11"}, {"The Beatles", "Abbey Road", "Pop", "1970", "34:12"}, {"Primus", "Frizzle Fry", "Rock", "1997", "38:23"}, {"AIR", "Moon Safari", "Electronic", "2000", "46:42"}, {"Iron Maiden", "Live After Death", "Metal", "1984", "85:23"}, {"Zero-7", "In The Waiting Line", "Downtempo", "2006", "45:02"}, {"The Rolling Stones", "Let It Bleed", "Rock", "1972", "37:23"}, {"Aretha Franklin", "I Never Loved A Man", "Soul", "1966", "39:23"}, {"Rammstein", "Mutter", "Metal", "2002", "44:12"}, {"Coldplay", "Viva La Vida", "Pop", "2008", "51:00"}, {"Art Of Noise", "In Visible Silence", "Electronic", "1986", "39:12"}, {"New Order", "Bizarre Love Triangle", "Electronic", "1985", "43:23"}};
            defaultModel = new DefaultTableModel(defaultModelData, defaultModelColumns){

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
        }

        private static class LocaleFormat
        implements SimpleTableFormat<Locale> {
            private LocaleFormat() {
            }

            @Override
            public int getColumnCount() {
                return 4;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return String.class;
            }

            @Override
            public String getColumnName(int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return "Name";
                    }
                    case 1: {
                        return "Country";
                    }
                    case 2: {
                        return "Language";
                    }
                    case 3: {
                        return "Variant";
                    }
                }
                return "";
            }

            @Override
            public Object getValueAt(Locale rowValue, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return rowValue.getDisplayName();
                    }
                    case 1: {
                        return rowValue.getDisplayCountry();
                    }
                    case 2: {
                        return rowValue.getDisplayLanguage();
                    }
                    case 3: {
                        return rowValue.getDisplayVariant();
                    }
                }
                return null;
            }

            @Override
            public void setValueAt(Locale rowValue, Object value, int columnIndex) {
            }

            @Override
            public boolean isCellEditable(Locale rowValue, int columnIndex) {
                return false;
            }
        }
    }

    protected class VisibleRows {
        int def = -1;
        JSpinner sp = new JSpinner(new SpinnerNumberModel(this.def, -1, 20, -1));

        protected VisibleRows() {
            this.sp.setToolTipText("The default number of rows initially visible");
        }

        void build(TableBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            int i = (Integer)this.sp.getValue();
            if (i != this.def) {
                builder.setVisibleRows(i);
                createSB.append("builder.setVisibleRows(" + i + ");\n");
            }
        }
    }

    private class DefaultActions {
        JCheckBox cb = new JCheckBox("Default Toolbar Actions");

        private DefaultActions() {
            this.cb.setToolTipText("Add default types action to the toolbar. The builder will automatically take care of setting the correct icon, ordering and enabling them");
        }

        public void build(TableBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            if (!this.cb.isSelected()) {
                return;
            }
            builder.setActionsDefault(TableBuilder.DefaultAction.ADD, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println(e.getActionCommand());
                }
            });
            createSB.append("builder.setActionsDefault(TableBuilder.DefaultAction.ADD, addAction);\n");
            builder.setActionsDefault(TableBuilder.DefaultAction.DELETE, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println(e.getActionCommand());
                }
            });
            createSB.append("builder.setActionsDefault(TableBuilder.DefaultAction.DELETE, deleteAction);\n");
            builder.setActionsDefault(TableBuilder.DefaultAction.CLEAR, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println(e.getActionCommand());
                }
            });
            createSB.append("builder.setActionsDefault(TableBuilder.DefaultAction.CLEAR, clearAction);\n");
            builder.setActionsDefault(TableBuilder.DefaultAction.EDIT, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println(e.getActionCommand());
                }
            });
            createSB.append("builder.setActionsDefault(TableBuilder.DefaultAction.EDIT, editAction);\n");
            builder.setActionsDefault(TableBuilder.DefaultAction.BROWSE, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println(e.getActionCommand());
                }
            });
            createSB.append("builder.setActionsDefault(TableBuilder.DefaultAction.BROWSE, browseAction);\n");
        }
    }

    protected class Sorted {
        boolean def = true;
        JCheckBox cb = new JCheckBox("Sortable", this.def);

        protected Sorted() {
            this.cb.setToolTipText("The user can click on the column headers to sort the columns. Use the default sorting, or pass a custom RowSorter");
        }

        void build(TableBuilder builder, StringBuilder createSB, boolean comparator) {
            if (this.cb.isSelected() != this.def) {
                builder.setSortable(this.cb.isSelected());
                createSB.append("builder.setSorted(" + Boolean.toString(this.cb.isSelected()) + ");\n");
            }
        }
    }

    protected class Selection {
        JCheckBox cb = new JCheckBox("Selection");

        protected Selection() {
            this.cb.setToolTipText("Initially select the given items in the table - requires a SimpleTableModel");
        }

        void build(TableBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            if (this.cb.isSelected()) {
                switch ((Model)((Object)Model.combo.getSelectedItem())) {
                    case SIMPLE: {
                        builder.setSelection(Locale.FRENCH, Locale.ENGLISH);
                        createSB.append("builder.setSelection(Locale.FRENCH, Locale.ENGLISH);\n");
                        break;
                    }
                    case DEFAULT: {
                        builder.setSelection(2, 5);
                        createSB.append("builder.setSelection(2, 5);\n");
                    }
                }
            }
        }
    }

    private class HorizontalScrolling {
        boolean def = false;
        JCheckBox cb = new JCheckBox("Horizontal Scrolling", this.def);

        private HorizontalScrolling() {
            this.cb.setToolTipText("Allow the width of the table to be greater than the viewport - a horizontal scrollbar will appear. Same as setting setAutoResizeMode to 'Off'");
        }

        void build(TableBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            if (this.cb.isSelected() != this.def) {
                builder.setHorizontalScrolling(this.cb.isSelected());
                createSB.append("builder.setHorizontalScrolling(" + Boolean.toString(this.cb.isSelected()) + ");\n");
            }
        }
    }

    private static class HiddenColumns {
        static boolean def = false;
        static JCheckBox cb = new JCheckBox("Initally Hidden Columns", def);

        private HiddenColumns() {
        }

        static void build(TableBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            if (cb.isSelected()) {
                builder.setHiddenColumns(2, 3);
                createSB.append("builder.setHiddenColumns(2, 3);\n");
            }
        }

        static {
            cb.setToolTipText("Initially hide some columns from the user, the user can use the drop down in the top right to add the columns back into the table");
        }
    }

    private static class HiddenColumnsAllowed {
        static boolean def = true;
        static JCheckBox cb = new JCheckBox("Hidden Columns Allowed", def);

        private HiddenColumnsAllowed() {
        }

        static void build(TableBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            if (cb.isSelected() != def) {
                builder.setHiddenColumnsAllowed(true);
                createSB.append("builder.setHiddenColumnsAllowed(" + cb.isSelected() + ");\n");
            }
        }

        static {
            cb.setToolTipText("Allow hiding of columns by the user via a drop down in the top right");
        }
    }

    private static class Tooltips {
        static boolean def = true;
        static JCheckBox cb = new JCheckBox("Show Truncated Tooltips", def);

        private Tooltips() {
        }

        static void build(TableBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            if (cb.isSelected() != def) {
                builder.setShowToolTips(cb.isSelected());
                createSB.append("builder.setShowToolTips(" + Boolean.toString(cb.isSelected()) + ");\n");
            }
        }

        static {
            cb.setToolTipText("If the text in a table cell isn't completely visible then a tooltip will be available to show the whole value");
        }
    }

    private class AutoSize {
        boolean def = true;
        JCheckBox cb = new JCheckBox("AutoSizeColumns", this.def);

        private AutoSize() {
            this.cb.setToolTipText("When the table is first displayed the columns will be automatically sized to match their contents");
        }

        void build(TableBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            if (this.cb.isSelected() != this.def) {
                builder.setAutoSizeColumns(this.cb.isSelected());
                createSB.append("builder.setAutoSizeColumns(" + Boolean.toString(this.cb.isSelected()) + ");\n");
            }
        }
    }

    private class Reorder {
        boolean def = false;
        JCheckBox cb = new JCheckBox("Reorder", this.def);

        private Reorder() {
            this.cb.setToolTipText("Make the items reorderable by the user");
        }

        void build(TableBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            if (this.cb.isSelected() != this.def) {
                builder.setReorderable(this.cb.isSelected());
                createSB.append("builder.setReorderable(" + Boolean.toString(this.cb.isSelected()) + ");\n");
            }
        }
    }

    private static class SelectAllAllowed {
        static boolean def = true;
        static JCheckBox cb = new JCheckBox("Select All Allowed", def);

        private SelectAllAllowed() {
        }

        static void build(TableBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            if (cb.isSelected() != def) {
                builder.setSelectAllAllowed(cb.isSelected());
                createSB.append("builder.setSelectAllAllowed(" + Boolean.toString(cb.isSelected()) + ");\n");
            }
        }

        static {
            cb.setToolTipText("Add a button to the top left of the table that when clicked will select all items in the table. Only really useful for multi select tables");
        }
    }

    private static class ColumnSelectionAllowed {
        static boolean def = false;
        static JCheckBox cb = new JCheckBox("Column Selection Allowed", def);

        private ColumnSelectionAllowed() {
        }

        static void build(TableBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            if (cb.isSelected() != def) {
                builder.setColumnSelectionAllowed(cb.isSelected());
                createSB.append("builder.setColumnSelectionAllowed(" + Boolean.toString(cb.isSelected()) + ");\n");
            }
        }

        static {
            cb.setToolTipText("Allow selection to be column based - combine with row selection for cell based selection");
        }
    }

    private static class RowSelectionAllowed {
        static boolean def = true;
        static JCheckBox cb = new JCheckBox("Row Selection Allowed", def);

        private RowSelectionAllowed() {
        }

        static void build(TableBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            if (cb.isSelected() != def) {
                builder.setRowSelectionAllowed(cb.isSelected());
                createSB.append("builder.setRowSelectionAllowed(" + Boolean.toString(cb.isSelected()) + ");\n");
            }
        }

        static {
            cb.setToolTipText("Allow selection to be row based - combine with column selection for cell based selection");
        }
    }

    private static class RowHeader {
        static final TableBuilder.RowHeaderType def = TableBuilder.RowHeaderType.NONE;
        private static JComboBox combo = new JComboBox<TableBuilder.RowHeaderType>(TableBuilder.RowHeaderType.values());

        private RowHeader() {
        }

        public static String toString(TableBuilder.RowHeaderType rowHeader) {
            return "";
        }

        private static void build(TableBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            TableBuilder.RowHeaderType rowHeader = (TableBuilder.RowHeaderType)((Object)combo.getSelectedItem());
            if (def != rowHeader) {
                builder.setRowHeader(rowHeader);
                createSB.append("builder.setRowHeader(TableBuilder.RowHeader." + rowHeader.name() + ");\n");
            }
        }

        static {
            combo.setToolTipText("The row header appears on the left of the table, can contain a selection area, checkboxes, row numbers - or something custom");
            combo.setSelectedItem((Object)def);
            combo.setRenderer(new LabelListCellRenderer<TableBuilder.RowHeaderType>(){

                @Override
                public void formatLabel(JLabel label, JList list, TableBuilder.RowHeaderType value, int index, boolean isSelected, boolean cellHasFocus) {
                    switch (value) {
                        case NONE: {
                            label.setText("None");
                            return;
                        }
                        case GAP: {
                            label.setText("Gap");
                            return;
                        }
                        case NUMBERS: {
                            label.setText("Numbers");
                            return;
                        }
                    }
                }
            });
        }
    }

    private static enum SelectionMode {
        SINGLE(0),
        RANGE(1),
        MULTIPLE(2);

        int selectionMode;
        static JComboBox combo;

        private SelectionMode(int selectionMode) {
            this.selectionMode = selectionMode;
        }

        public String toString() {
            switch (this) {
                case SINGLE: {
                    return "Single";
                }
                case RANGE: {
                    return "Range";
                }
                case MULTIPLE: {
                    return "Multiple";
                }
            }
            return super.toString();
        }

        private static void build(TableBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            SelectionMode mode = (SelectionMode)((Object)combo.getSelectedItem());
            builder.setSelectionMode(mode.selectionMode);
            if (mode == RANGE) {
                createSB.append("builder.setSelectionMode(ListSelectionModel.SINGLE_INTERVAL_SELECTION);\n");
            } else if (mode == MULTIPLE) {
                createSB.append("builder.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);\n");
            }
        }

        static {
            combo = new JComboBox<SelectionMode>(SelectionMode.values());
            combo.setToolTipText("Set the ListSelectionModel type of selection for the table");
        }
    }
}

