/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.combo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.util.Arrays;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.javatools.ui.UIBundle;
import oracle.javatools.ui.combo.CheckComboModel;
import oracle.javatools.ui.combo.CheckComboText;
import oracle.javatools.ui.combo.JCustomComboBox;
import oracle.javatools.ui.internal.UICUtils;

public class JCheckCombo<T>
extends JCustomComboBox {
    private TableCombo table;
    private ListSelectionModel selList;
    private JScrollPane sp;
    private int visibleRowCount = 8;
    private SelListener selListener = new SelListener();
    private CheckComboText checkComboText;

    public JCheckCombo() {
        this.init();
    }

    public JCheckCombo(ListModel listModel, ListSelectionModel selModel) {
        this.init();
        this.setModel(listModel, selModel);
    }

    public JCheckCombo(ListModel listModel) {
        this.init();
        this.setModel(listModel);
    }

    public void setModel(ListModel listModel, ListSelectionModel selModel) {
        CheckComboModel model = new CheckComboModel(listModel, selModel);
        this.setModel(model);
    }

    public void setModel(ListModel listModel) {
        CheckComboModel model = new CheckComboModel(listModel);
        this.setModel(model);
    }

    public void setModel(CheckComboModel model) {
        if (this.selList != null) {
            this.selList.removeListSelectionListener(this.selListener);
        }
        this.selList = model.getSelectionModel();
        this.selList.addListSelectionListener(this.selListener);
        super.setModel(model);
        this.table.setModel(model);
        int colWidth = UIManager.getIcon("CheckBox.icon").getIconWidth();
        this.table.getColumnModel().getColumn(0).setMaxWidth(colWidth);
    }

    public void setPoppedRenderer(TableCellRenderer aRenderer) {
        this.table.setCellRenderer(aRenderer);
    }

    public void setCheckComboText(CheckComboText checkComboText) {
        this.checkComboText = checkComboText;
    }

    public CheckComboText getCheckComboText() {
        return this.checkComboText;
    }

    private void init() {
        JPanel panel = new JPanel(new BorderLayout());
        this.table = new TableCombo();
        this.table.setRowSelectionAllowed(true);
        this.table.setTableHeader(null);
        this.table.setShowHorizontalLines(false);
        this.table.setShowVerticalLines(false);
        this.table.setShowGrid(false);
        this.table.setFocusable(false);
        this.table.setSelectionMode(0);
        this.sp = new JScrollPane(this.table, 20, 30);
        this.sp.setBorder(BorderFactory.createEmptyBorder());
        panel.add((Component)this.sp, "North");
        this.setPopupComponent(panel);
        this.table.addMouseMotionListener(new ListMouseListener());
        this.table.addMouseListener(new TableClickListener());
        this.addKeyListener(new CheckComboKeyListener());
        this.setRenderer(new UnpoppedRenderer());
        this.setPoppedRenderer(new PoppedRenderer());
    }

    protected void updatePopupPreferredSize() {
        int prefW = this.table.getPreferredSize().width;
        Dimension newD = new Dimension(prefW += this.table.getRowCount() > this.visibleRowCount ? this.sp.getVerticalScrollBar().getPreferredSize().width : 6, this.table.getRowHeight() * Math.min(this.visibleRowCount, this.table.getRowCount()));
        if (prefW < this.getWidth()) {
            newD.width = Math.max(newD.width, this.getWidth() - 2);
            if (this.table.getRowCount() > this.visibleRowCount) {
                newD.width = Math.max(prefW, newD.width - this.sp.getVerticalScrollBar().getPreferredSize().width);
            }
        }
        this.sp.getViewport().setPreferredSize(newD);
    }

    @Override
    public void firePopupMenuWillBecomeVisible() {
        this.updatePopupPreferredSize();
        Object selObj = this.getSelectedItem();
        ((CheckComboModel)this.getModel()).setSelectedItem(selObj);
        super.firePopupMenuWillBecomeVisible();
    }

    @Override
    public void firePopupMenuWillBecomeInvisible() {
        super.firePopupMenuWillBecomeInvisible();
    }

    private void toggleSelection(int index) {
        if (this.selList.isSelectedIndex(index)) {
            this.selList.removeSelectionInterval(index, index);
        } else {
            this.selList.addSelectionInterval(index, index);
        }
        this.table.repaint();
        this.repaint();
    }

    public void setVisibleRowCount(int visibleRowCount) {
        this.visibleRowCount = visibleRowCount;
    }

    public int getVisibleRowCount() {
        return this.visibleRowCount;
    }

    public T[] getSelectedObjects() {
        Object o = this.getSelectedItem();
        if (o instanceof Object[]) {
            return (Object[])o;
        }
        return super.getSelectedObjects();
    }

    public ListSelectionModel getSelectionModel() {
        return this.selList;
    }

    public CheckComboModel getCheckModel() {
        return (CheckComboModel)this.table.getModel();
    }

    public ComboBoxModel getModel() {
        if (this.table == null) {
            return super.getModel();
        }
        return this.getCheckModel();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJCheckComboBox();
        }
        return this.accessibleContext;
    }

    protected String convertValueToText(int index) {
        assert (index >= -1);
        if (index == -1) {
            if (this.checkComboText != null) {
                return this.checkComboText.getSummaryText(this, Arrays.asList(this.getSelectedObjects()));
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                if (!this.selList.isSelectedIndex(i)) continue;
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                sb.append(this.table.getValueAt(i, 1));
            }
            return sb.toString();
        }
        Object value = this.table.getModel().getValueAt(index, 1);
        if (this.checkComboText != null) {
            return this.checkComboText.getItemText(this, value, index);
        }
        TableCellRenderer renderer = this.table.getCellRenderer(index, 1);
        Component comp = renderer.getTableCellRendererComponent(this.table, value, false, false, index, 1);
        if (comp instanceof JLabel) {
            return ((JLabel)comp).getText();
        }
        return comp.toString();
    }

    public static void main(String[] args) {
        JPanel p = new JPanel(new FlowLayout());
        DefaultListModel<String> model = new DefaultListModel<String>();
        model.addElement("Apples");
        model.addElement("Bananas");
        model.addElement("Cherries");
        model.addElement("Dates");
        model.addElement("Eggplants");
        JCheckCombo combo = new JCheckCombo(model);
        p.add(combo);
        UICUtils.runComponent(p);
    }

    public class PoppedRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (JCheckCombo.this.checkComboText != null) {
                value = JCheckCombo.this.checkComboText.getItemText(JCheckCombo.this, value, row);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    protected class AccessibleJCheckComboBox
    extends JComboBox.AccessibleJComboBox {
        private Accessible previousSelectedAccessible;

        AccessibleJCheckComboBox() {
            super(JCheckCombo.this);
            this.previousSelectedAccessible = null;
            AccessibleJCheckSelectionListener listener = new AccessibleJCheckSelectionListener();
            JCheckCombo.this.table.getSelectionModel().addListSelectionListener(listener);
            JCheckCombo.this.selList.addListSelectionListener(listener);
            JCheckCombo.this.addPopupMenuListener(new AccessibleJComboBoxPopupMenuListener());
        }

        @Override
        public String getAccessibleName() {
            String s = JCheckCombo.this.convertValueToText(-1);
            if (s.length() == 0) {
                s = UIBundle.get("EMPTY_CHECKABLE_COMBO");
            }
            return s;
        }

        private class AccessibleJComboBoxPopupMenuListener
        implements PopupMenuListener {
            private AccessibleJComboBoxPopupMenuListener() {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                int i = JCheckCombo.this.table.getSelectedRow();
                if (i < 0) {
                    return;
                }
                AccessibleJCheckComboBox.this.previousSelectedAccessible = JCheckCombo.this.table.getAccessibleContext().getAccessibleChild(i);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        }

        private class AccessibleJCheckSelectionListener
        implements ListSelectionListener {
            private AccessibleJCheckSelectionListener() {
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int i = JCheckCombo.this.table.getSelectedRow();
                if (i < 0) {
                    return;
                }
                int cellIndex = i * JCheckCombo.this.table.getColumnCount() + 1;
                Accessible selectedAccessible = JCheckCombo.this.table.getAccessibleContext().getAccessibleChild(cellIndex);
                if (selectedAccessible == null) {
                    return;
                }
                String name = JCheckCombo.this.convertValueToText(i);
                name = JCheckCombo.this.selList.isSelectedIndex(i) ? UIBundle.format("CHECKABLE_COMBO_CHECKED", name) : UIBundle.format("CHECKABLE_COMBO_UNCHECKED", name);
                selectedAccessible.getAccessibleContext().setAccessibleName(name);
                PropertyChangeEvent pce = null;
                if (AccessibleJCheckComboBox.this.previousSelectedAccessible != null) {
                    pce = new PropertyChangeEvent(AccessibleJCheckComboBox.this.previousSelectedAccessible, "AccessibleState", AccessibleState.FOCUSED, null);
                    AccessibleJCheckComboBox.this.firePropertyChange("AccessibleState", null, pce);
                }
                pce = new PropertyChangeEvent(selectedAccessible, "AccessibleState", null, AccessibleState.FOCUSED);
                AccessibleJCheckComboBox.this.firePropertyChange("AccessibleState", null, pce);
                AccessibleJCheckComboBox.this.firePropertyChange("AccessibleActiveDescendant", AccessibleJCheckComboBox.this.previousSelectedAccessible, selectedAccessible);
                AccessibleJCheckComboBox.this.previousSelectedAccessible = selectedAccessible;
            }
        }
    }

    private class SelListener
    implements ListSelectionListener {
        private SelListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            JCheckCombo.this.selectedItemChanged();
        }
    }

    public class UnpoppedRenderer
    extends DefaultListCellRenderer {
        private final Font emptyFont;

        public UnpoppedRenderer() {
            this.emptyFont = JCheckCombo.this.getFont().deriveFont(2);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            super.setFont(JCheckCombo.this.getFont());
            String s = JCheckCombo.this.convertValueToText(-1);
            if (s.length() == 0) {
                s = UIBundle.get("EMPTY_CHECKABLE_COMBO");
                super.setFont(this.emptyFont);
                this.setToolTipText(null);
            } else {
                JCheckCombo.this.setToolTipText(s);
            }
            label.setText(s);
            Dimension d = label.getPreferredSize();
            d.width = Math.max(d.width, ((JCheckCombo)JCheckCombo.this).table.getPreferredSize().width);
            label.setPreferredSize(d);
            return label;
        }

        @Override
        public void setFont(Font f) {
        }
    }

    private class CheckBoxCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public CheckBoxCellRenderer() {
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 0));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Boolean) {
                this.setSelected((Boolean)value);
            }
            return this;
        }
    }

    private class TableCombo
    extends JTable {
        private TableCellRenderer _renderer;

        private TableCombo() {
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            if (column == 0) {
                return new DefaultCellEditor(new JCheckBox());
            }
            return super.getCellEditor(row, column);
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            if (column == 0) {
                return new CheckBoxCellRenderer();
            }
            if (this._renderer != null) {
                return this._renderer;
            }
            return super.getCellRenderer(row, column);
        }

        public void setCellRenderer(TableCellRenderer renderer) {
            this._renderer = renderer;
        }
    }

    private class CheckComboKeyListener
    extends KeyAdapter {
        private CheckComboKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 40) {
                int newSel = JCheckCombo.this.table.getSelectedRow() + 1;
                if (newSel < JCheckCombo.this.table.getRowCount()) {
                    JCheckCombo.this.table.getSelectionModel().setSelectionInterval(newSel, newSel);
                    JCheckCombo.this.table.scrollRectToVisible(JCheckCombo.this.table.getCellRect(newSel, 2, true));
                }
            } else if (e.getKeyCode() == 38) {
                int newSel = JCheckCombo.this.table.getSelectedRow() - 1;
                if (newSel >= 0) {
                    JCheckCombo.this.table.getSelectionModel().setSelectionInterval(newSel, newSel);
                    JCheckCombo.this.table.scrollRectToVisible(JCheckCombo.this.table.getCellRect(newSel, 2, true));
                }
            } else if (e.getKeyCode() == 32) {
                int sel = JCheckCombo.this.table.getSelectedRow();
                JCheckCombo.this.toggleSelection(sel);
                e.consume();
            }
        }
    }

    private class TableClickListener
    extends MouseAdapter {
        private TableClickListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int index = JCheckCombo.this.table.rowAtPoint(e.getPoint());
            JCheckCombo.this.toggleSelection(index);
            e.consume();
        }
    }

    private class ListMouseListener
    extends MouseMotionAdapter {
        private ListMouseListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int index = JCheckCombo.this.table.rowAtPoint(e.getPoint());
            JCheckCombo.this.table.getSelectionModel().setSelectionInterval(index, index);
        }
    }
}

