/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.infotip;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.Icon;
import oracle.javatools.icons.IconScaler;
import oracle.javatools.ui.infotip.InfoTipUIConstants;
import oracle.javatools.ui.themes.LinearGradientPainter;

public enum InfoTipStyles {
    DEFAULT,
    CODE;


    public LinearGradientPainter getBackgroundPainter() {
        switch (this) {
            case CODE: {
                return InfoTipUIConstants.CODE_BACKGROUND_PAINTER;
            }
        }
        return InfoTipUIConstants.DEFAULT_BACKGROUND_PAINTER;
    }

    public Color getBackgroundBorderColor() {
        return InfoTipUIConstants.BACKGROUND_BORDER_COLOR;
    }

    public Color getInternalBorderColor() {
        return InfoTipUIConstants.INTERNAL_BORDER_COLOR;
    }

    public Icon scaleIcon(Icon originalIcon) {
        switch (this) {
            case CODE: {
                return IconScaler.scaleIcon((Icon)originalIcon, (int)12);
            }
        }
        return originalIcon;
    }

    public Font getItemTitleFont() {
        switch (this) {
            case CODE: {
                return InfoTipUIConstants.CODE_ITEM_TITLE_FONT;
            }
        }
        return InfoTipUIConstants.DEFAULT_ITEM_TITLE_FONT;
    }

    public Insets getItemTitleInsets() {
        switch (this) {
            case CODE: {
                return InfoTipUIConstants.CODE_TITLE_INSETS;
            }
        }
        return InfoTipUIConstants.DEFAULT_TITLE_INSETS;
    }

    public Insets getBorderInsets() {
        switch (this) {
            case CODE: {
                return InfoTipUIConstants.CODE_INSETS;
            }
        }
        return InfoTipUIConstants.DEFAULT_INSETS;
    }

    public Color getContentTextColor() {
        return InfoTipUIConstants.CONTENT_TEXT_COLOR;
    }

    public Color getItemTextColor() {
        return InfoTipUIConstants.ITEM_TEXT_COLOR;
    }

    public Color getMoreTextColor() {
        return InfoTipUIConstants.MORE_TEXT_COLOR;
    }

    public Color getHyperLinkTextColor(boolean isHover) {
        return isHover ? InfoTipUIConstants.HYPERLINK_TEXT_HOVER_COLOR : InfoTipUIConstants.HYPERLINK_TEXT_COLOR;
    }
}

