/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.infotip.templates;

import javax.swing.JComponent;
import javax.swing.JLabel;
import oracle.javatools.ui.UIBundle;
import oracle.javatools.ui.infotip.InfoTipStyles;
import oracle.javatools.ui.infotip.templates.Template;

public class StatusSummaryTemplate
implements Template {
    private int errors = 0;
    private int warnings = 0;
    private int incompletes = 0;
    private int advisories = 0;

    public StatusSummaryTemplate(int errors, int warnings, int incompletes, int advisories) {
        this.errors = errors;
        this.warnings = warnings;
        this.incompletes = incompletes;
        this.advisories = advisories;
    }

    public void setAdvisories(int advisories) {
        this.advisories = advisories;
    }

    public int getAdvisories() {
        return this.advisories;
    }

    public void setErrors(int errors) {
        this.errors = errors;
    }

    public int getErrors() {
        return this.errors;
    }

    public void setWarnings(int warnings) {
        this.warnings = warnings;
    }

    public int getWarnings() {
        return this.warnings;
    }

    public void setIncompletes(int incompletes) {
        this.incompletes = incompletes;
    }

    public int getIncompletes() {
        return this.incompletes;
    }

    @Override
    public JComponent getContent() {
        String tipText;
        if (this.errors + this.warnings + this.incompletes + this.advisories == 0) {
            tipText = UIBundle.get("INFOTIP_NO_ISSUES");
        } else {
            StringBuilder issueSummary = new StringBuilder();
            this.appendNonZero(issueSummary, "INFOTIP_STATUS_ERROR", this.errors);
            this.appendNonZero(issueSummary, "INFOTIP_STATUS_WARNING", this.warnings);
            this.appendNonZero(issueSummary, "INFOTIP_STATUS_INCOMPLETE", this.incompletes);
            this.appendNonZero(issueSummary, "INFOTIP_STATUS_ADVISORIE", this.advisories);
            tipText = "<html>" + issueSummary + "</html>";
        }
        JLabel statusLabel = new JLabel(tipText);
        statusLabel.setFont(InfoTipStyles.DEFAULT.getItemTitleFont());
        return statusLabel;
    }

    private void appendNonZero(StringBuilder message, String resourceKeyPrefix, int count) {
        if (count > 0) {
            if (message.length() > 0) {
                message.append("<br>");
            }
            message.append(UIBundle.format(count == 1 ? resourceKeyPrefix : resourceKeyPrefix + "S", count));
        }
    }
}

