/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.overview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import oracle.ide.hover.Hover;
import oracle.ide.hover.HoverEvent;
import oracle.ide.hover.HoverFlavor;
import oracle.ide.hover.HoverListener;
import oracle.ide.hover.Hoverable;
import oracle.ide.hover.HoverableRegistry;
import oracle.javatools.ui.infotip.InfoTipHover;
import oracle.javatools.ui.infotip.InfoTipOrientation;
import oracle.javatools.ui.infotip.InfoTipStyles;
import oracle.javatools.ui.infotip.templates.BasicTemplate;
import oracle.javatools.ui.infotip.templates.Template;
import oracle.javatools.ui.overview.OverviewComponent;
import oracle.javatools.ui.overview.OverviewMark;
import oracle.javatools.ui.overview.OverviewTipProvider;

final class OverviewHoverable<T extends Number, M extends OverviewMark<T>>
implements Hoverable {
    private final OverviewComponent<T, M> component;
    static final HoverFlavor HOVER_FLAVOR = HoverFlavor.getFlavor((String)"info");
    private Set<M> marksInHover = Collections.emptySet();
    private InfoTipHover hover = null;
    private OverviewTipProvider provider = null;

    OverviewHoverable(OverviewComponent<T, M> component) {
        this.component = component;
        component.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                HoverableRegistry.registerComponent((Component)OverviewHoverable.this.component, (Hoverable)OverviewHoverable.this);
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                HoverableRegistry.unregisterComponent((Component)OverviewHoverable.this.component, (Hoverable)OverviewHoverable.this);
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
    }

    void setProvider(OverviewTipProvider provider) {
        this.provider = provider;
    }

    public Hover hover(Point location, List<HoverFlavor> flavors) {
        if (this.provider == null || !flavors.contains(HOVER_FLAVOR)) {
            return null;
        }
        SwingUtilities.convertPointFromScreen(location, this.component);
        Set<M> marks = this.component.marksAtPoint(location);
        if (marks.isEmpty()) {
            return null;
        }
        ArrayList<M> sortedMarks = new ArrayList<M>(marks);
        Collections.sort(sortedMarks);
        this.hover = this.createInfoTipHover(sortedMarks);
        this.hover.showHover();
        this.marksInHover = marks;
        final MouseMotionListener mouseListener = new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                Set marks = OverviewHoverable.this.component.marksAtPoint(e.getPoint());
                if (marks.isEmpty()) {
                    OverviewHoverable.this.hover.hideHover();
                    return;
                }
                if (!marks.containsAll(OverviewHoverable.this.marksInHover) || !OverviewHoverable.this.marksInHover.containsAll(marks)) {
                    ArrayList sortedMarks = new ArrayList(marks);
                    Collections.sort(sortedMarks);
                    JComponent content = OverviewHoverable.this.provider.getTipContent(marks, OverviewHoverable.this.hover);
                    OverviewHoverable.this.hover.setContent(new BasicTemplate(content));
                    OverviewHoverable.this.hover.ensureVisible();
                }
            }
        };
        this.hover.addHoverListener(new HoverListener(){

            public void hoverChange(HoverEvent he) {
                if (he.isHidden()) {
                    OverviewHoverable.this.marksInHover = Collections.emptySet();
                    OverviewHoverable.this.hover.removeHoverListener(this);
                    OverviewHoverable.this.component.removeMouseMotionListener(mouseListener);
                    OverviewHoverable.this.hover = null;
                }
            }
        });
        this.component.addMouseMotionListener(mouseListener);
        return this.hover;
    }

    private InfoTipHover createInfoTipHover(Collection<M> marks) {
        InfoTipOrientation o;
        JPanel hoverComponent = new JPanel(new BorderLayout());
        hoverComponent.setOpaque(false);
        Iterator<M> it = marks.iterator();
        Rectangle r = this.component.markToRect((OverviewMark)it.next()).getBounds();
        while (it.hasNext()) {
            r.add(this.component.markToRect((OverviewMark)it.next()).getBounds());
        }
        InfoTipHover hover = new InfoTipHover((Template)new BasicTemplate(hoverComponent), InfoTipStyles.DEFAULT, this.component, r, HOVER_FLAVOR);
        JComponent content = this.provider.getTipContent(marks, hover);
        hoverComponent.add(content);
        switch (this.provider.getOrientation()) {
            case TOP_BOTTOM: {
                o = InfoTipOrientation.TOP_BOTTOM;
                break;
            }
            case LEFT_RIGHT: {
                o = InfoTipOrientation.LEFT_RIGHT;
                break;
            }
            case RIGHT_LEFT: {
                o = InfoTipOrientation.RIGHT_LEFT;
                break;
            }
            case BOTTOM_TOP: {
                o = InfoTipOrientation.BOTTOM_TOP;
                break;
            }
            default: {
                o = InfoTipOrientation.LEFT_RIGHT;
            }
        }
        hover.setOrientation(o);
        return hover;
    }
}

