/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.plaf.theme;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.PanelUI;
import oracle.javatools.ui.segmented.SegmentButton;
import oracle.javatools.ui.segmented.SegmentedControl;
import oracle.javatools.ui.themes.Themes;

public final class ThemedSegmentedControlUI
extends PanelUI {
    private static final ThemedSegmentedControlUI ui = new ThemedSegmentedControlUI();
    private static Insets insets = new Insets(0, 0, 0, 0);

    private ThemedSegmentedControlUI() {
    }

    private String getState(AbstractButton b) {
        String state = "default";
        if (!b.isEnabled()) {
            state = "disabled";
        }
        if (b.getModel().isArmed() && b.getModel().isPressed()) {
            state = "down";
        } else if (b.getModel().isSelected()) {
            state = "selected";
        } else if (b.getModel().isRollover()) {
            state = "over";
        }
        return state;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        SegmentedControl sc = (SegmentedControl)c;
        Graphics2D g2 = (Graphics2D)g.create();
        this.paintBackground(g2, sc);
        if (sc.hasFocus() && sc.getSelectionType() == SegmentedControl.SelectionType.MULTIPLE) {
            this.paintSegmentFocusBorder(g2, sc);
        }
        if (sc.hasFocus() && sc.getSelectionType() == SegmentedControl.SelectionType.SINGLE) {
            this.paintFocusBorder(g2, sc);
        }
    }

    protected void paintBackground(Graphics2D g, SegmentedControl c) {
        int x = ThemedSegmentedControlUI.insets.left;
        int y = 0;
        int w = 1;
        int h = c.getHeight();
        for (int i = 0; i < c.getComponentCount(); ++i) {
            SegmentButton b = (SegmentButton)c.getComponent(i);
            String state = this.getState(b);
            x = b.getX();
            w = b.getWidth();
            if (i == 0) {
                x = 0;
                w = b.getX() + b.getWidth();
                if (state.equals("selected")) {
                    Themes.getActiveTheme().getStateProperties("segmentedcontrol.edge1.left", state).getPainter("bg").paint(g, 0, y, w, h);
                } else {
                    Themes.getActiveTheme().getStateProperties("segmentedcontrol.edge1", state).getPainter("bg").paint(g, 0, y, w, h);
                }
                x = ThemedSegmentedControlUI.insets.left;
                w -= ThemedSegmentedControlUI.insets.left;
            }
            if (i == c.getComponentCount() - 1) {
                w = c.getWidth() - b.getX() - 1;
                if (state.equals("selected")) {
                    Themes.getActiveTheme().getStateProperties("segmentedcontrol.edge2.right", state).getPainter("bg").paint(g, x, y, w, h);
                } else {
                    Themes.getActiveTheme().getStateProperties("segmentedcontrol.edge2", state).getPainter("bg").paint(g, x, y, w, h);
                }
                w -= ThemedSegmentedControlUI.insets.right;
            }
            Themes.getActiveTheme().getStateProperties("segmentedcontrol.edge3", state).getPainter("bg").paint(g, x, y, w, h);
            Themes.getActiveTheme().getStateProperties("segmentedcontrol.edge4", state).getPainter("bg").paint(g, x, y, w, h);
            Themes.getActiveTheme().getStateProperties("segmentedcontrol.center", state).getPainter("bg").paint(g, x, ThemedSegmentedControlUI.insets.top, w, h - ThemedSegmentedControlUI.insets.top - ThemedSegmentedControlUI.insets.bottom);
            if (b.isSelected()) {
                if (i != 0) {
                    Themes.getActiveTheme().getStateProperties("segmentedcontrol.edge1", state).getPainter("bg").paint(g, x, y, w, h);
                }
                if (i < c.getComponentCount() - 1) {
                    Themes.getActiveTheme().getStateProperties("segmentedcontrol.edge2", state).getPainter("bg").paint(g, x, y, w, h);
                }
            }
            if (i >= c.getComponentCount() - 1) continue;
            x += w;
            w = 1;
            Themes.getActiveTheme().getPartProperties("segmentedcontrol.separator").getPainter("center").paint(g, x, y, w, h);
            Themes.getActiveTheme().getPartProperties("segmentedcontrol.separator").getPainter("top").paint(g, x, y, w, h);
            Themes.getActiveTheme().getPartProperties("segmentedcontrol.separator").getPainter("bottom").paint(g, x, y, w, h);
        }
    }

    protected void paintFocusBorder(Graphics2D g, SegmentedControl c) {
        Themes.getActiveTheme().getStateProperties("segmentedcontrol.edge1", "focus").getPainter("bg").paint(g, 0, 0, c.getWidth() - 1, c.getHeight());
        Themes.getActiveTheme().getStateProperties("segmentedcontrol.edge2", "focus").getPainter("bg").paint(g, 0, 0, c.getWidth() - 1, c.getHeight());
        Themes.getActiveTheme().getStateProperties("segmentedcontrol.edge3", "focus").getPainter("bg").paint(g, ThemedSegmentedControlUI.insets.left, 0, c.getWidth() - ThemedSegmentedControlUI.insets.left - ThemedSegmentedControlUI.insets.right - 1, c.getHeight());
        Themes.getActiveTheme().getStateProperties("segmentedcontrol.edge4", "focus").getPainter("bg").paint(g, ThemedSegmentedControlUI.insets.left, 0, c.getWidth() - ThemedSegmentedControlUI.insets.left - ThemedSegmentedControlUI.insets.right - 1, c.getHeight());
    }

    protected void paintSegmentFocusBorder(Graphics2D g, SegmentedControl c) {
        SegmentButton b = (SegmentButton)c.getComponent(0);
        int h = c.getHeight();
        if (b.hasFocus()) {
            Themes.getActiveTheme().getStateProperties("segmentedcontrol.edge1", "focus").getPainter("bg").paint(g, 0, 0, b.getWidth() - ThemedSegmentedControlUI.insets.left, h);
            Themes.getActiveTheme().getStateProperties("segmentedcontrol.edge3", "focus").getPainter("bg").paint(g, ThemedSegmentedControlUI.insets.left, 0, b.getWidth() + b.getX() - ThemedSegmentedControlUI.insets.left, h);
            Themes.getActiveTheme().getStateProperties("segmentedcontrol.edge4", "focus").getPainter("bg").paint(g, ThemedSegmentedControlUI.insets.left, 0, b.getWidth() + b.getX() - ThemedSegmentedControlUI.insets.left, h);
            Themes.getActiveTheme().getPartProperties("segmentedcontrol.separator.focus").getPainter("bg").paint(g, b.getX() + b.getWidth(), 0, 1, h);
        }
        for (int i = 1; i < c.getComponentCount() - 1; ++i) {
            b = (SegmentButton)c.getComponent(i);
            if (!b.hasFocus()) continue;
            Themes.getActiveTheme().getStateProperties("segmentedcontrol.edge3", "focus").getPainter("bg").paint(g, b.getX(), 0, b.getWidth(), h);
            Themes.getActiveTheme().getStateProperties("segmentedcontrol.edge4", "focus").getPainter("bg").paint(g, b.getX(), 0, b.getWidth(), h);
            Themes.getActiveTheme().getPartProperties("segmentedcontrol.separator.focus").getPainter("bg").paint(g, b.getX() - 1, 0, 1, h);
            Themes.getActiveTheme().getPartProperties("segmentedcontrol.separator.focus").getPainter("bg").paint(g, b.getX() + b.getWidth(), 0, 1, h);
        }
        b = (SegmentButton)c.getComponent(c.getComponentCount() - 1);
        if (b.hasFocus()) {
            int x = b.getX();
            int w = c.getWidth() - b.getX() - 1;
            Themes.getActiveTheme().getStateProperties("segmentedcontrol.edge2", "focus").getPainter("bg").paint(g, x, 0, w, h);
            Themes.getActiveTheme().getStateProperties("segmentedcontrol.edge3", "focus").getPainter("bg").paint(g, x, 0, w - ThemedSegmentedControlUI.insets.right, h);
            Themes.getActiveTheme().getStateProperties("segmentedcontrol.edge4", "focus").getPainter("bg").paint(g, x, 0, w - ThemedSegmentedControlUI.insets.right, h);
            Themes.getActiveTheme().getPartProperties("segmentedcontrol.separator.focus").getPainter("bg").paint(g, x, 0, 1, h);
        }
    }

    public static ComponentUI createUI(JComponent c) {
        return ui;
    }

    static {
        insets = Themes.getActiveTheme().getPartProperties("segmentedcontrol").getInsets("outermargin");
    }
}

