/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.popup;

import java.awt.AlphaComposite;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import oracle.javatools.ui.GraphicsUtils;

public class TransparentWindow
extends JWindow {
    private float fadeAmount = 1.0f;

    public TransparentWindow(Window parent) {
        super(parent);
        this.setupTemporaryHide();
    }

    protected void setupTemporaryHide() {
        KeyStroke hide = KeyStroke.getKeyStroke(18, 512);
        KeyStroke hideCtrl = KeyStroke.getKeyStroke(18, 640);
        String HIDE_KEY = "HIDE_KEY";
        Container container = this.getContentPane();
        if (container instanceof JComponent) {
            JComponent component = (JComponent)container;
            component.getInputMap(2).put(hide, HIDE_KEY);
            component.getInputMap(2).put(hideCtrl, HIDE_KEY);
            component.getActionMap().put(HIDE_KEY, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TransparentWindow.this.setTransparent(true);
                }
            });
            KeyStroke showUp = KeyStroke.getKeyStroke(18, 0, true);
            KeyStroke showUpShift = KeyStroke.getKeyStroke(18, 64, true);
            KeyStroke showUpCtrl = KeyStroke.getKeyStroke(18, 128, true);
            String SHOW_UP_KEY = "SHOW_UP_KEY";
            component.getInputMap(2).put(showUp, SHOW_UP_KEY);
            component.getInputMap(2).put(showUpShift, SHOW_UP_KEY);
            component.getInputMap(2).put(showUpCtrl, SHOW_UP_KEY);
            component.getActionMap().put(SHOW_UP_KEY, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TransparentWindow.this.setTransparent(false);
                }
            });
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.fadeAmount >= 0.0f && this.fadeAmount < 1.0f) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setComposite(AlphaComposite.getInstance(3, this.fadeAmount));
        }
        super.paint(g);
    }

    public void setTransparent(boolean transparent) {
        if (transparent) {
            GraphicsUtils.setWindowOpacity(this, 0.1f);
        } else {
            GraphicsUtils.setWindowOpacity(this, 0.96f);
        }
    }

    public boolean isTransparent() {
        return this.fadeAmount == 0.1f;
    }
}

