/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dbcart.config;

import java.io.IOException;
import java.net.URL;
import oracle.dbtools.common.config.IStorage;
import oracle.dbtools.common.ddl.DDLFormat;
import oracle.dbtools.common.ddl.TargetFormat;
import oracle.dbtools.dbcart.config.DbCartUserConfig;
import oracle.dbtools.extract.models.ExtractDataFormat;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.data.HashStructure;

public class DbCartUserCloudConfig
extends DbCartUserConfig {
    private static final String NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"cart-deploy-cloud");
    public static final String ROOT_TAG = "deploy_cloud_tool";
    public static final String CLOUD_CONN = "CLOUD_CONN";
    public static final String CLOUD_TITLE = "CLOUD_TITLE";
    public static final String CLOUD_SCHEMA = "CLOUD_SCHEMA";
    public static final String CLOUD_LOCATION = "CLOUD_LOCATION";
    public static final String CLOUD_CREDENTIAL = "CLOUD_CREDENTIAL";
    public static final String CLOUD_TRANSFER_FILE = "CLOUD_TRANSFER_FILE";
    public static final String DDL_DO_NOT_REPLACE = "DDL_DO_NOT_REPLACE";
    public static final String DDL_REPLACE = "DDL_REPLACE";
    public static final String EXPORT_DATA_FORMAT = "EXPORT_DATA_FORMAT";
    public static final String EXPORT_TRUNCATE = "EXPORT_TRUNCATE";
    public static final String EXPORT_DISABLE_CONSTRAINTS = "EXPORT_DISABLE_CONSTRAINTS";

    public DbCartUserCloudConfig() {
        this.init();
    }

    public DbCartUserCloudConfig(HashStructure hashStructure) {
        super(hashStructure);
        this.init();
    }

    private void init() {
    }

    public void exportTo(URL uRL) throws IOException {
        super.exportTo(uRL, NAMESPACE_URI, ROOT_TAG);
    }

    public static HashStructure importFrom(URL uRL) throws IOException {
        return DbCartUserCloudConfig.importFrom((URL)uRL, (String)NAMESPACE_URI, (String)ROOT_TAG);
    }

    public void copyToDDLFormat(DDLFormat dDLFormat) {
        dDLFormat.initFormat((IStorage)this);
    }

    public void copyFromDDLFormat(DDLFormat dDLFormat) {
        dDLFormat.saveFormat((IStorage)this);
    }

    public void copyToDataFormat(ExtractDataFormat extractDataFormat) {
        extractDataFormat.setFormat("LOADER".toLowerCase(), (IStorage)this);
        extractDataFormat.isDisableConstraints(this.getBoolean(EXPORT_DISABLE_CONSTRAINTS).booleanValue());
        extractDataFormat.isTruncate(this.getBoolean(EXPORT_TRUNCATE).booleanValue());
    }

    public void copyFromDataFormat(ExtractDataFormat extractDataFormat) {
        this.putString(EXPORT_DATA_FORMAT, extractDataFormat.getFormat());
        this.putBoolean(EXPORT_DISABLE_CONSTRAINTS, extractDataFormat.isDisableConstraints());
        this.putBoolean(EXPORT_TRUNCATE, extractDataFormat.isTruncate());
        extractDataFormat.setFormat(this.getString(EXPORT_DATA_FORMAT), false, (IStorage)this);
        extractDataFormat.saveFormatPreferences((IStorage)this);
    }

    public void copyToTargetFormat(TargetFormat targetFormat) {
        targetFormat.initFormat((IStorage)this);
    }

    public void copyFromTargetFormat(TargetFormat targetFormat) {
        targetFormat.saveFormat((IStorage)this);
    }
}

