/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dbcart.tools;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.dbcart.tools.DbCartCopyTool;
import oracle.dbtools.dbcart.tools.DbCartDeployCloudTool;
import oracle.dbtools.dbcart.tools.DbCartDiffTool;
import oracle.dbtools.dbcart.tools.DbCartExportTool;
import oracle.dbtools.dbcart.tools.DbCartNavLeftTool;
import oracle.dbtools.dbcart.tools.DbCartNavRightTool;
import oracle.dbtools.dbcart.tools.DbCartNewTool;
import oracle.dbtools.dbcart.tools.DbCartOpenTool;
import oracle.dbtools.dbcart.tools.DbCartRefreshTool;
import oracle.dbtools.dbcart.tools.DbCartSaveAllTool;
import oracle.dbtools.dbcart.tools.DbCartSaveAsTool;
import oracle.dbtools.dbcart.tools.DbCartSaveTool;
import oracle.dbtools.dbcart.tools.IDbCartTool;

public class DbCartToolRegistry {
    private static Map<String, IDbCartTool> s_registry = new LinkedHashMap<String, IDbCartTool>();

    public static synchronized void registerCartTool(IDbCartTool iDbCartTool) {
        s_registry.put(iDbCartTool.getType().toLowerCase(), iDbCartTool);
    }

    public static synchronized void unregisterCartTool(IDbCartTool iDbCartTool) {
        s_registry.remove(iDbCartTool.getType().toLowerCase());
    }

    public static synchronized IDbCartTool getTool(String string) {
        return s_registry.get(string.toLowerCase());
    }

    public static synchronized List<String> getTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(s_registry.keySet());
        return arrayList;
    }

    public static synchronized List<String> getTypes(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(s_registry.keySet());
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String string : arrayList) {
            IDbCartTool iDbCartTool = DbCartToolRegistry.getTool(string);
            if (iDbCartTool.getGroup() != n) continue;
            arrayList2.add(string);
        }
        return arrayList2;
    }

    static {
        DbCartToolRegistry.registerCartTool(new DbCartNewTool());
        DbCartToolRegistry.registerCartTool(new DbCartOpenTool());
        DbCartToolRegistry.registerCartTool(new DbCartSaveTool());
        DbCartToolRegistry.registerCartTool(new DbCartSaveAsTool());
        DbCartToolRegistry.registerCartTool(new DbCartSaveAllTool());
        DbCartToolRegistry.registerCartTool(new DbCartRefreshTool());
        DbCartToolRegistry.registerCartTool(new DbCartNavLeftTool());
        DbCartToolRegistry.registerCartTool(new DbCartNavRightTool());
        DbCartToolRegistry.registerCartTool(new DbCartDeployCloudTool());
        DbCartToolRegistry.registerCartTool(new DbCartExportTool());
        DbCartToolRegistry.registerCartTool(new DbCartDiffTool());
        DbCartToolRegistry.registerCartTool(new DbCartCopyTool());
    }
}

