/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml;

import java.util.ArrayList;
import java.util.List;
import oracle.security.xmlsec.saml.SAMLInitializer;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class SAMLUtils {
    SAMLUtils() {
    }

    static String collectTextFromChild(XMLElement contextElement, String namespaceURI, String localName) {
        NodeList list = XMLElement.getChildElementsByTagNameNS((Element)((Element)contextElement.getNode()), (String)namespaceURI, (String)localName);
        if (list.getLength() > 0) {
            return XMLUtils.collectText((Node)list.item(0));
        }
        return null;
    }

    static List collectTextFromChildren(XMLElement contextElement, String namespaceURI, String localName) {
        NodeList list = XMLElement.getChildElementsByTagNameNS((Element)((Element)contextElement.getNode()), (String)namespaceURI, (String)localName);
        ArrayList<String> result = new ArrayList<String>(list.getLength());
        int n = list.getLength();
        for (int i = 0; i < n; ++i) {
            result.add(XMLUtils.collectText((Node)list.item(i)));
        }
        return result;
    }

    static void insertChildElementWithText(XMLElement contextElement, String namespaceURI, String localName, String[] namespaceURIs, String[] localNames, String text, boolean replaceExisting) throws DOMException {
        Document doc = contextElement.getOwnerDocument();
        Element child = doc.createElementNS(namespaceURI, localName);
        child.appendChild(doc.createTextNode(text));
        XMLUtils.copyNSPrefix((Element)((Element)contextElement.getNode()), (Element)child);
        if (child.getPrefix() == null) {
            String prefix = XMLElement.getDefaultNSPrefix((String)namespaceURI);
            if (prefix != null) {
                XMLElement.addNSPrefixAttr((Element)child, (String)prefix, (String)namespaceURI);
                child.setPrefix(prefix);
            } else {
                child.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", namespaceURI);
            }
        }
        if (replaceExisting) {
            XMLUtils.removeChildren((Element)((Element)contextElement.getNode()), (String)namespaceURI, (String)localName);
        }
        XMLUtils.insertChild((Element)((Element)contextElement.getNode()), (Element)child, (String[])namespaceURIs, (String[])localNames);
    }

    static void appendChildElementWithText(XMLElement contextElement, String namespaceURI, String localName, String text) throws DOMException {
        Document doc = contextElement.getOwnerDocument();
        Element child = doc.createElementNS(namespaceURI, localName);
        child.appendChild(doc.createTextNode(text));
        XMLUtils.copyNSPrefix((Element)((Element)contextElement.getNode()), (Element)child);
        contextElement.appendChild((Node)child);
    }

    static void setChildElement(XMLElement contextElement, XMLElement element, String[] nsURIs, String[] localNames) {
        XMLUtils.removeChildren((Element)((Element)contextElement.getNode()), (String)element.getNamespaceURI(), (String)element.getLocalName());
        XMLUtils.insertChild((XMLElement)contextElement, (XMLElement)element, (String[])nsURIs, (String[])localNames);
    }

    static XMLElement getChildElement(XMLElement contextElement, String nsURI, String localName) {
        XMLElement element = null;
        NodeList nList = contextElement.getChildElementsByTagNameNS(nsURI, localName);
        if (nList.getLength() != 0 && (element = XMLUtils.getInstance((Element)((Element)nList.item(0)))) != null) {
            element.setSystemId(contextElement.getSystemId());
        }
        return element;
    }

    static List getChildElements(XMLElement contextElement, String nsURI, String localName) {
        NodeList nList = contextElement.getChildElementsByTagNameNS(nsURI, localName);
        ArrayList<XMLElement> result = new ArrayList<XMLElement>(nList.getLength());
        int n = nList.getLength();
        for (int i = 0; i < n; ++i) {
            XMLElement element = XMLUtils.getInstance((Element)((Element)nList.item(i)));
            if (element == null) continue;
            element.setSystemId(contextElement.getSystemId());
            result.add(element);
        }
        return result;
    }

    static {
        SAMLInitializer.initialize();
    }
}

