/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.view.View;

public final class Context {
    private final Map _hash = new ConcurrentHashMap();
    private static final String NULL_KEY = "null_key_12349123847123948712390487123904871239478";
    public static final String DATA_KEY = Context.class.getName();
    public static final String INTENTIONAL_NULL = "Context.INTENTIONAL_NULL";
    private static final String VIEW = "Context.VIEW";
    private static final String WORKSPACE = "Context.WORKSPACE";
    private static final String PROJECT = "Context.PROJECT";
    private static final String EVENT = "Context.EVENT";
    private static final String SELECTION = "Context.SELECTION";
    private static final Element[] EMPTY_SELECTION = new Element[0];
    private static final String NODE = "Context.NODE";

    public Context() {
    }

    public Context(Context originalContext) {
        if (originalContext != null) {
            this._hash.putAll(originalContext._hash);
        }
    }

    public Context(Element element) {
        this.setElement(element);
        if (element instanceof Node) {
            this.setNode((Node)element);
        }
    }

    public Context(Node node) {
        this.setNode(node);
        this.setElement(node);
    }

    public Context(Workspace workspace, Project project) {
        this.setWorkspace(workspace);
        this.setProject(project);
    }

    public Context(View view, Workspace workspace, Project project, Node node) {
        this.setView(view);
        this.setWorkspace(workspace);
        this.setProject(project);
        this.setNode(node);
        this.setSelection(new Element[]{node});
    }

    public static Context newIdeContext() {
        Context context = new Context();
        context.initViewWorkspaceProject();
        View view = context.getView();
        if (view != null) {
            context.setSelection(view.getSelection());
        }
        return context;
    }

    public static Context newIdeContext(Element element) {
        Context context = new Context();
        context.initViewWorkspaceProject();
        context.setElement(element);
        return context;
    }

    public static Context newIdeContext(Node node) {
        Context context = new Context();
        context.initViewWorkspaceProject();
        context.setNode(node);
        context.setElement(node);
        return context;
    }

    public static Context newIdeContext(View view) {
        Context context = new Context();
        context.initWorkspaceProject();
        if (view != null) {
            context.setView(view);
            Element[] selection = view.getSelection();
            if (selection != null) {
                Element[] selectionCopy = (Element[])selection.clone();
                context.setSelection(selectionCopy);
            }
        }
        return context;
    }

    public static Context newIdeContext(View view, EventObject event) {
        Context context = Context.newIdeContext(view);
        context.setEvent(event);
        return context;
    }

    public final boolean equals(Object o) {
        if (o instanceof Context) {
            Context other = (Context)o;
            return this._hash.equals(other._hash);
        }
        return false;
    }

    public final int hashCode() {
        return this._hash.hashCode();
    }

    public final Object getProperty(String name) {
        if (name == null) {
            name = NULL_KEY;
        }
        if (this._hash.get(name) == NULL_KEY) {
            return null;
        }
        return this._hash.get(name);
    }

    public final void setProperty(String name, Object value) {
        if (name == null) {
            name = NULL_KEY;
        }
        if (value == null) {
            value = NULL_KEY;
        }
        this._hash.put(name, value);
    }

    public final void removeProperty(String name) {
        if (name == null) {
            name = NULL_KEY;
        }
        this._hash.remove(name);
    }

    public final boolean containsProperty(String name) {
        if (name == null) {
            name = NULL_KEY;
        }
        return this._hash.containsKey(name);
    }

    public final boolean getBoolean(String name) {
        return Boolean.TRUE.equals(this.getProperty(name));
    }

    public final void setBoolean(String name, boolean value) {
        this.setProperty(name, value);
    }

    public final int getInt(String name) {
        Object num = this.getProperty(name);
        if (num instanceof Number) {
            return ((Number)num).intValue();
        }
        return 0;
    }

    public final void setInt(String name, int value) {
        this.setProperty(name, value);
    }

    public final View getView() {
        return (View)this.getProperty(VIEW);
    }

    public final void setView(View view) {
        this.setProperty(VIEW, view);
    }

    public final Workspace getWorkspace() {
        return (Workspace)this.getProperty(WORKSPACE);
    }

    public final void setWorkspace(Workspace workspace) {
        this.setProperty(WORKSPACE, workspace);
    }

    public final Project getProject() {
        return (Project)this.getProperty(PROJECT);
    }

    public final void setProject(Project project) {
        this.setProperty(PROJECT, project);
    }

    public final EventObject getEvent() {
        return (EventObject)this.getProperty(EVENT);
    }

    public final void setEvent(EventObject event) {
        this.setProperty(EVENT, event);
    }

    public final Element[] getSelection() {
        Object selection = this.getProperty(SELECTION);
        return selection != null ? (Element[])selection : EMPTY_SELECTION;
    }

    public final void setSelection(Element[] selection) {
        Element[] validatedSelection = EMPTY_SELECTION;
        if (selection != null && selection.length > 0) {
            ArrayList<Element> nonNullElements = new ArrayList<Element>(selection.length);
            for (Element element : selection) {
                if (element == null) continue;
                nonNullElements.add(element);
            }
            if (!nonNullElements.isEmpty()) {
                validatedSelection = new Element[nonNullElements.size()];
                validatedSelection = nonNullElements.toArray(validatedSelection);
            }
        }
        this.setProperty(SELECTION, validatedSelection);
    }

    public final Node getNode() {
        if (this.containsProperty(NODE)) {
            return (Node)this.getProperty(NODE);
        }
        Element[] selection = this.getSelection();
        if (selection != null && selection.length > 0 && selection[0] instanceof Node) {
            return (Node)selection[0];
        }
        return null;
    }

    public final void setNode(Node node) {
        this.setProperty(NODE, node);
    }

    public final Element getElement() {
        Element[] selection = this.getSelection();
        return selection != null && selection.length > 0 ? selection[0] : null;
    }

    public final void setElement(Element element) {
        this.setSelection(new Element[]{element});
    }

    private final void initViewWorkspaceProject() {
        IdeMainWindow mw = Ide.getMainWindow();
        if (mw != null) {
            this.setView(mw.getLastActiveView());
        }
        this.initWorkspaceProject();
    }

    private final void initWorkspaceProject() {
        this.setWorkspace(Ide.getActiveWorkspace());
        this.setProject(Ide.getActiveProject());
    }

    public String toString() {
        return "oracle.ide.Context[" + this._hash.toString() + "]";
    }
}

