/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controller;

import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Element;
import oracle.javatools.logging.Diagnostics;

final class ActionLogger {
    private static final boolean LOG_ACTIONS = Boolean.valueOf(System.getProperty("ide.diagnostics.logActions", "true"));
    private static File actionLogFile;

    ActionLogger() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void logActionPerformed(Context context, IdeAction action) {
        if (!LOG_ACTIONS) {
            return;
        }
        boolean writeConfiguration = false;
        if (actionLogFile == null) {
            actionLogFile = Diagnostics.newLockedFile((String)"ACTIONS");
            if (actionLogFile == null) {
                return;
            }
            writeConfiguration = true;
        }
        String name = (String)action.getValue("Name");
        String id = ActionLogger.shortenIdentifiers(ActionLogger.stringId(action));
        StringBuilder logLine = new StringBuilder();
        logLine.append("id=[").append(id).append("]");
        logLine.append(",name=[").append(name).append("],");
        logLine.append(ActionLogger.determineInvokedFrom(context, action));
        logLine.append("\n");
        FileWriter fw = null;
        try {
            fw = new FileWriter(actionLogFile, true);
            if (writeConfiguration) {
                fw.append(Diagnostics.basicConfigurationData());
            }
            fw.append(logLine);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static String shortenIdentifiers(String s) {
        s = s.replaceAll("oracle", "o");
        s = s.replaceAll("jdevimpl", "ji");
        s = s.replaceAll("jdeveloper", "j");
        s = s.replaceAll("ideimpl", "ii");
        s = s.replaceAll("ide", "i");
        return s;
    }

    private static String className(Object o) {
        if (o == null) {
            return "null";
        }
        return ActionLogger.shortenIdentifiers(o.getClass().getName());
    }

    private static String determineInvokedFrom(Context ideContext, IdeAction action) {
        String eventType = "unknown";
        String context = null;
        String contextName = "";
        if (ideContext != null) {
            StringBuilder cnBuilder = new StringBuilder();
            if (ideContext.getView() != null) {
                cnBuilder.append("viewclass=[").append(ActionLogger.className(ideContext.getView())).append("]");
            }
            if (ideContext.getNode() != null) {
                if (cnBuilder.length() > 0) {
                    cnBuilder.append(",");
                }
                cnBuilder.append("nodeclass=[").append(ActionLogger.className(ideContext.getNode())).append("]");
            }
            if (ideContext.getSelection() != null && ideContext.getSelection().length > 0) {
                if (cnBuilder.length() > 0) {
                    cnBuilder.append(",");
                }
                cnBuilder.append("selectionclass=[");
                for (Element element : ideContext.getSelection()) {
                    cnBuilder.append(ActionLogger.className(element));
                    cnBuilder.append(",");
                }
                cnBuilder.setLength(cnBuilder.length() - 1);
                cnBuilder.append("]");
            }
            contextName = cnBuilder.toString();
        }
        if (action.getValue("invokedFrom") != null) {
            context = (String)action.getValue("invokedFrom");
        } else {
            Container parent;
            Object source = action.getValue("eventSource");
            if (source instanceof JMenuItem) {
                parent = ((JMenuItem)source).getParent();
                if (parent instanceof JPopupMenu) {
                    Component invoker = ((JPopupMenu)parent).getInvoker();
                    if (invoker instanceof JMenu) {
                        context = "menu";
                    } else {
                        context = "popup";
                        contextName = contextName + ",popuptargetclass=[" + invoker.getClass().getName() + "]";
                        String componentName = invoker.getName();
                        if (componentName != null && componentName.length() > 0) {
                            contextName = contextName + ",popuptargetname=[" + componentName + "]";
                        }
                    }
                }
            } else if (source instanceof AbstractButton) {
                parent = ((AbstractButton)source).getParent();
                context = parent instanceof JToolBar ? "toolbar" : "button";
            } else if (source instanceof JRootPane) {
                context = "accelerator";
            }
        }
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        eventType = "mouse";
        for (StackTraceElement stackTraceElement : stack) {
            if (stackTraceElement.getMethodName() == null || !stackTraceElement.getMethodName().contains("processKeyEvent")) continue;
            if (context == null) {
                context = "accelerator";
            }
            eventType = "keyboard";
            break;
        }
        if (context == null) {
            context = "programmatic";
        }
        return String.format("type=[%s],context=[%s],%s", eventType, context, contextName);
    }

    private static String stringId(IdeAction action) {
        int id = action.getCommandId();
        String stringId = Ide.findCmdName(id);
        if (stringId == null) {
            return "<unknown: " + id + ">";
        }
        return stringId;
    }
}

