/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controller;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.AsynchronousController;
import oracle.ide.controller.IdeAction;

class AnnotatedController {
    private Map<Integer, CmdInfo> id2info;
    private Map<String, CmdInfo> cmd2info;
    private AsynchronousController controller;

    AnnotatedController(AsynchronousController controller) {
        this.controller = controller;
        this.init(this.controller.getClass());
    }

    boolean handleEvent(IdeAction action, Context context) {
        CmdInfo ci = this.getCmdInfo(action);
        if (ci != null && ci.handlerMethod != null) {
            if (ci.isAsynchronous) {
                return this.controller.handleAsynchronously(action, context, ci.useInterrupt);
            }
            return ci.handle(action, context, null);
        }
        return false;
    }

    void handleEvent(IdeAction action, Context context, AsynchronousController.TaskInfo info) {
        CmdInfo ci = this.getCmdInfo(action);
        if (ci != null && ci.handlerMethod != null) {
            ci.handle(action, context, info);
        }
    }

    public boolean update(IdeAction action, Context context) {
        CmdInfo ci = this.getCmdInfo(action);
        if (ci != null && ci.updaterMethod != null) {
            return ci.update(action, context);
        }
        return false;
    }

    private CmdInfo getCmdInfo(IdeAction action) {
        int id = action.getCommandId();
        CmdInfo info = this.id2info.get(id);
        if (info == null) {
            String cmd = Ide.findCmdName(action.getCommandId());
            return this.cmd2info.get(cmd);
        }
        return info;
    }

    private void init(Class<? extends AsynchronousController> clazz) {
        this.cmd2info = new HashMap<String, CmdInfo>();
        this.id2info = new HashMap<Integer, CmdInfo>();
        while (!AsynchronousController.class.equals(clazz)) {
            this.addFromClass(clazz);
            clazz = clazz.getSuperclass();
        }
    }

    /*
     * Could not resolve type clashes
     */
    private void addFromClass(Class<? extends AsynchronousController> clazz) {
        for (Method m : clazz.getDeclaredMethods()) {
            AsynchronousController.Updater u;
            AsynchronousController.Handler h = m.getAnnotation(AsynchronousController.Handler.class);
            if (h != null) {
                String[] names = h.names();
                int[] ids = h.ids();
                if (names.length == 0 && ids.length == 0) {
                    this.log(Level.WARNING, "No id or command name " + m);
                } else {
                    for (String cmd : names) {
                        this.addInfo(cmd, m, true, h.useThreadInterrupt());
                    }
                    for (String id : (String[])ids) {
                        this.addInfo((int)id, m, true, h.useThreadInterrupt());
                    }
                }
            }
            if ((u = m.getAnnotation(AsynchronousController.Updater.class)) == null) continue;
            String[] names = u.names();
            int[] ids = u.ids();
            if (names.length == 0 && ids.length == 0) {
                this.log(Level.WARNING, "No id or command name " + m);
                continue;
            }
            for (String cmd : names) {
                this.addInfo(cmd, m, false, false);
            }
            for (String id : (String[])ids) {
                this.addInfo((int)id, m, false, false);
            }
        }
    }

    private void addInfo(String cmd, Method m, boolean isHandler, boolean useInterrupt) {
        this.addInfo(cmd, null, m, isHandler, useInterrupt);
    }

    private void addInfo(int id, Method m, boolean isHandler, boolean useInterrupt) {
        this.addInfo(null, id, m, isHandler, useInterrupt);
    }

    private void addInfo(String cmd, Integer id, Method m, boolean isHandler, boolean useInterrupt) {
        CmdInfo cmdInfo;
        if (id == null) {
            cmdInfo = this.cmd2info.get(cmd);
            if (cmdInfo == null) {
                cmdInfo = new CmdInfo();
                this.cmd2info.put(cmd, cmdInfo);
            }
        } else {
            cmdInfo = this.id2info.get(id);
            if (cmdInfo == null) {
                cmdInfo = new CmdInfo();
                this.id2info.put(id, cmdInfo);
            }
        }
        if (isHandler) {
            Class<?>[] pt = m.getParameterTypes();
            if (pt.length < 2 || pt.length > 3) {
                this.log(Level.WARNING, "Handler method should have signature (IdeAction, Context, [TaskInfo]]) but is " + m);
                m = null;
            } else if (pt.length == 2 && !this.checkFirstTwoArgs(pt)) {
                this.log(Level.WARNING, "Synchronous handler method should have signature (IdeAction, Context) but is " + m);
                m = null;
            } else if (!(pt.length != 3 || this.checkFirstTwoArgs(pt) && AsynchronousController.TaskInfo.class.isAssignableFrom(pt[2]))) {
                this.log(Level.WARNING, "Asynchronous handler method should have signature (IdeAction, Context, TaskInfo) but is " + m);
                m = null;
            }
            cmdInfo.isAsynchronous = pt.length == 3;
            cmdInfo.handlerMethod = m;
            cmdInfo.useInterrupt = useInterrupt;
        } else {
            Class<?>[] pt = m.getParameterTypes();
            if (pt.length != 2 || !this.checkFirstTwoArgs(pt)) {
                this.log(Level.WARNING, "Updater method should have signature (IdeAction, Context) but is " + m);
                m = null;
            }
            cmdInfo.updaterMethod = m;
        }
    }

    private boolean checkFirstTwoArgs(Class<?>[] pt) {
        return IdeAction.class.isAssignableFrom(pt[0]) && Context.class.isAssignableFrom(pt[1]);
    }

    private void log(Level level, String message) {
        this.log(level, message, null);
    }

    private void log(Level level, String message, Throwable thrown) {
        Logger logger = Logger.getLogger(this.controller.getClass().getName());
        logger.log(level, message, thrown);
    }

    private class CmdInfo {
        private Method handlerMethod;
        private Method updaterMethod;
        private boolean isAsynchronous;
        private boolean useInterrupt;

        private CmdInfo() {
        }

        boolean update(IdeAction action, Context context) {
            return this.invoke(this.updaterMethod, new Object[]{action, context});
        }

        boolean handle(IdeAction action, Context context, AsynchronousController.TaskInfo info) {
            Object[] objectArray;
            if (info == null) {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = action;
                objectArray = objectArray2;
                objectArray2[1] = context;
            } else {
                Object[] objectArray3 = new Object[3];
                objectArray3[0] = action;
                objectArray3[1] = context;
                objectArray = objectArray3;
                objectArray3[2] = info;
            }
            return this.invoke(this.handlerMethod, objectArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean invoke(Method m, Object[] args) {
            boolean accessible = m.isAccessible();
            try {
                Object ret;
                if (!accessible) {
                    m.setAccessible(true);
                }
                boolean bl = (ret = m.invoke((Object)AnnotatedController.this.controller, args)) != null && ret instanceof Boolean ? (Boolean)ret : false;
                return bl;
            }
            catch (IllegalAccessException ex) {
                AnnotatedController.this.log(Level.SEVERE, "Can not invoke method: " + m, ex);
            }
            catch (IllegalArgumentException ex) {
                AnnotatedController.this.log(Level.SEVERE, "Can not invoke method: " + m, ex);
            }
            catch (InvocationTargetException ex) {
                AnnotatedController.this.log(Level.SEVERE, "Exeption from handle/update method: " + m, ex);
            }
            finally {
                if (!accessible) {
                    m.setAccessible(false);
                }
            }
            return false;
        }
    }
}

