/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controller;

import oracle.ide.Context;
import oracle.ide.controller.AsynchronousController;
import oracle.ide.model.Node;
import org.netbeans.api.progress.ProgressHandle;

public abstract class Command {
    public static final int NORMAL = 0;
    public static final int NO_CHANGE = 1;
    public static final int NO_UNDO = 2;
    public static final int MULTI_NODE = 3;
    public static final int OK = 0;
    public static final int CANCEL = 1;
    public static final int EXECUTING = 1;
    private int cmdId;
    protected int type = 1;
    protected Context context;
    private final String name;
    private Object data;
    private AsynchronousController.TaskInfo taskInfo;

    protected Command(int cmdId) {
        this(cmdId, 1);
    }

    protected Command(int cmdId, int type) {
        this(cmdId, type, "");
    }

    protected Command(int cmdId, int type, String name) {
        this.cmdId = cmdId;
        this.type = type;
        this.name = name != null ? name : "";
    }

    public abstract int doit() throws Exception;

    public int undo() throws Exception {
        return 1;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.cmdId;
    }

    public int getType() {
        return this.type;
    }

    public boolean isGlobal() {
        return false;
    }

    public boolean enableConfirmation() {
        return true;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public Node[] getAffectedNodes() {
        return null;
    }

    public final void setTaskInfo(AsynchronousController.TaskInfo taskInfo) {
        this.taskInfo = taskInfo;
    }

    protected final ProgressHandle getProgressHandle() {
        if (this.taskInfo != null) {
            return this.taskInfo.getHandle();
        }
        return null;
    }
}

