/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controller;

import java.awt.Component;
import java.awt.EventQueue;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import javax.ide.util.MetaClass;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.jcip.annotations.GuardedBy;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.NotImplementedCommandException;
import oracle.ide.cmd.HistoryGeneratingCommand;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.Preferences;
import oracle.ide.controller.Command;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.history.HistoryManager;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.osgi.boot.api.IdeBootProperties;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.Assert;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ArrayPairList;
import oracle.javatools.util.ClosureException;
import oracle.javatools.util.Pair;
import oracle.javatools.util.PairList;
import oracle.javatools.util.SwingClosure;
import org.openide.util.RequestProcessor;

public final class CommandProcessor
implements Observer {
    private static final Logger LOG = Logger.getLogger(CommandProcessor.class.getName());
    private static final boolean DIAGNOSTICS_TO_CONSOLE = false;
    private final TransactionManager _transactionMgr = new TransactionManager();
    @GuardedBy(value="_undoStacks")
    private final Map<Node, UndoStack> _undoStacks = new HashMap<Node, UndoStack>();
    private final MasterStack _masterStack = new MasterStack();
    final RequestProcessor _requestProcessorPool = new RequestProcessor("CommandProcessor-RequestProcessorThread", 1);
    private static final CommandProcessor _INSTANCE = new CommandProcessor();
    private static final int _COMPOUND_COMMAND_ID = Ide.findOrCreateCmdID(CompoundCommand.class.getName());
    private static final int _COMMAND_PART_ID = Ide.findOrCreateCmdID(CommandPart.class.getName());
    private static final boolean CLEAR_UNDO_STACK_ON_CLOSE = false;
    private static final String[] IDE_COMMAND_CLASSES = new String[]{"oracle.ide.cmd.AboutCommand", "oracle.ide.cmd.CopyPath", "oracle.ide.cmd.CloseNodeCommand", "oracle.ide.cmd.IdeSettingsCommand", "oracle.ide.cmd.LogWindowCommand", "oracle.ide.cmd.NotImplementedCommand", "oracle.ide.cmd.RemoveFileCommand", "oracle.ide.cmd.RenameCommand", "oracle.ide.cmd.RevertNodeCommand", "oracle.ide.cmd.SaveAllCommand", "oracle.ide.cmd.SaveAsCommand", "oracle.ide.cmd.SaveCommand", "oracle.ide.cmd.OpenCommand", "oracle.ide.cmd.RedoCommand", "oracle.ide.cmd.UndoCommand", "oracle.ide.cmd.ExitCommand", "oracle.ide.cmd.NewWorkspaceCommand"};

    public static CommandProcessor getInstance() {
        return _INSTANCE;
    }

    private void __debug_printStacks(boolean deep) {
        CommandProcessor.debug("========== UndoStacks ============");
        for (Map.Entry<Node, UndoStack> entry : this._undoStacks.entrySet()) {
            CommandProcessor.debug("Undo Stack for node:" + entry.getKey().getShortLabel());
            entry.getValue()._debugPrint(deep);
        }
        this._masterStack._debugPrint(deep);
    }

    private static void debug(String s) {
        System.out.println(s);
    }

    private CommandProcessor() {
        EnvironOptions environOptions = EnvironOptions.getInstance(Preferences.getPreferences());
        environOptions.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(final ChangeEvent e) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CommandProcessor.this.whenUndoStackChanges((EnvironOptions)((Object)e.getSource()));
                    }
                });
            }
        });
        this.whenUndoStackChanges(environOptions);
    }

    private void diagnostic(String message) {
        if (FeedbackManager.isOn()) {
            FeedbackManager.addFeedback(message);
        }
    }

    public final Future<Integer> invokeAsync(Command cmd, boolean runOnEventDispatchThread) throws IllegalStateException, Exception {
        CPCallable callable = new CPCallable(cmd, runOnEventDispatchThread);
        Future result = this._requestProcessorPool.submit((Callable)callable);
        if (SwingUtilities.isEventDispatchThread() && runOnEventDispatchThread) {
            result = new FutureOnSwingThread(result);
        }
        return result;
    }

    public final Future<Integer> invokeAsync(Command cmd) throws Exception {
        return this.invokeAsync(cmd, false);
    }

    public final int invoke(Command cmd) throws Exception {
        boolean alreadyInProgress = IdeAction.handlerStarting();
        try {
            int status;
            Context context = cmd.getContext();
            if (FeedbackManager.isOn()) {
                String commandName = cmd.getName();
                if (commandName == null) {
                    commandName = cmd.getClass().getName();
                }
                FeedbackManager.addFeedback("Invoking command: " + commandName, context);
            }
            String noStackFeedbackMsg = null;
            switch (cmd.getType()) {
                case 0: {
                    UndoStack stack = this.getUndoStack(context);
                    this.blockIfNotPartOfTransaction();
                    if (stack != null) {
                        if (cmd instanceof HistoryGeneratingCommand) {
                            this.preprocessHistoricalEvent((HistoryGeneratingCommand)((Object)cmd));
                        }
                        if (!this.isTransactionActive()) {
                            status = this._masterStack.doit(cmd, stack);
                            break;
                        }
                        status = this._transactionMgr.addCommandToActiveTransaction(cmd);
                        break;
                    }
                    noStackFeedbackMsg = "CommandProcessor:" + cmd.getName() + " context failed to get undostack may have resulted in batch mode failure ";
                }
                case 2: {
                    UndoStack stack = this.findUndoStack(context);
                    this.blockIfNotPartOfTransaction();
                    if (cmd instanceof HistoryGeneratingCommand) {
                        this.preprocessHistoricalEvent((HistoryGeneratingCommand)((Object)cmd));
                    }
                    if (this.isTransactionActive()) {
                        if (noStackFeedbackMsg != null) {
                            this._masterStack.disable(noStackFeedbackMsg);
                        } else {
                            this._masterStack.disable();
                        }
                    }
                    if ((status = cmd.doit()) != 0) break;
                    if (stack != null) {
                        stack.flush();
                    }
                    this.flush(cmd.getAffectedNodes());
                    break;
                }
                case 3: {
                    this.blockIfNotPartOfTransaction();
                    if (!this.isTransactionActive()) {
                        cmd = new CompoundCommand(cmd);
                        this.preprocessHistoricalEvent((HistoryGeneratingCommand)((Object)cmd));
                        status = this._masterStack.doit(cmd, null);
                        break;
                    }
                    if (cmd instanceof HistoryGeneratingCommand) {
                        this.preprocessHistoricalEvent((HistoryGeneratingCommand)((Object)cmd));
                    }
                    status = this._transactionMgr.addCommandToActiveTransaction(cmd);
                    break;
                }
                case 1: {
                    if (cmd instanceof HistoryGeneratingCommand) {
                        this.preprocessHistoricalEvent((HistoryGeneratingCommand)((Object)cmd));
                    }
                    status = cmd.doit();
                    break;
                }
                default: {
                    throw new Exception("Unrecognized Command type");
                }
            }
            if (status == 0) {
                if (cmd instanceof HistoryGeneratingCommand) {
                    this.persistHistoricalEvent((HistoryGeneratingCommand)((Object)cmd));
                }
                final NavigationManager mgr = NavigationManager.getNavigationManager();
                final Context ctx = cmd.getContext();
                if (mgr != null) {
                    if (!SwingUtilities.isEventDispatchThread()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                mgr.setLastEdit(ctx);
                            }
                        });
                    } else {
                        mgr.setLastEdit(ctx);
                    }
                }
            }
            int n = status;
            return n;
        }
        catch (NotImplementedCommandException e) {
            if (this.isPartOfTransaction()) {
                this.abortTrans();
            }
            throw e;
        }
        catch (Exception e) {
            if (this.isPartOfTransaction()) {
                this.abortTrans();
            }
            FeedbackManager.reportException("Exception while processing command " + (cmd == null ? "cmd is null" : cmd.getName()), e);
            throw e;
        }
        catch (Error e) {
            if (this.isPartOfTransaction()) {
                this.abortTrans();
            }
            FeedbackManager.reportException("Error while processing command " + (cmd == null ? "cmd is null" : cmd.getName()), e);
            throw e;
        }
        finally {
            IdeAction.handlerFinished(alreadyInProgress, Controller.UPDATE_FROM_ACTION_PERFORMED);
        }
    }

    public final int undo(Context context) throws Exception {
        if (this.isTransactionActive()) {
            FeedbackManager.reportException(new IllegalStateException("Attempting to undo while still in batch mode!"));
            return 1;
        }
        if (context == null) {
            return this._masterStack.undo();
        }
        UndoStack stack = this.findUndoStack(context);
        return stack != null && !this.isTransactionActive() ? stack.undo() : 1;
    }

    public final int redo(Context context) throws Exception {
        if (this.isTransactionActive()) {
            IllegalStateException e = new IllegalStateException("Attempting to redo while still in batch mode!");
            e.printStackTrace();
            return 1;
        }
        if (context == null) {
            return this._masterStack.redo();
        }
        UndoStack stack = this.findUndoStack(context);
        return stack != null && !this.isTransactionActive() ? stack.redo() : 1;
    }

    public boolean canUndo(Context context) {
        if (this.isTransactionActive()) {
            return false;
        }
        if (context == null) {
            return this._masterStack.canUndo();
        }
        UndoStack stack = this.findUndoStack(context);
        return stack != null ? stack.canUndo(null) : false;
    }

    public String getUndoLabel(Context context) {
        if (context == null) {
            return this._masterStack.getUndoLabel();
        }
        UndoStack stack = this.findUndoStack(context);
        return stack != null ? stack.getUndoLabel() : "";
    }

    public Command getCommand(Context context) {
        try {
            UndoStack stack = this.findUndoStack(context);
            return stack != null ? stack.peek(0) : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean canRedo(Context context) {
        if (this.isTransactionActive()) {
            return false;
        }
        if (context == null) {
            return this._masterStack.canRedo();
        }
        UndoStack stack = this.findUndoStack(context);
        return stack != null ? stack.canRedo(null) : false;
    }

    public String getRedoLabel(Context context) {
        if (context == null) {
            return this._masterStack.getRedoLabel();
        }
        UndoStack stack = this.findUndoStack(context);
        return stack != null ? stack.getRedoLabel() : "";
    }

    public void flush(Object object) {
        if (object instanceof Node) {
            this.flush((Node)object);
        } else if (object != null) {
            LOG.warning("flush(Object object) is deprecated - " + object.getClass().getName());
        }
    }

    public void flush(Node node) {
        this.flush(node, true);
    }

    private void removeStackIfEmpty(UndoStack undoStack) {
        if (!undoStack.stacksHaveContent()) {
            CommandProcessor.getInstance().flush(undoStack.getNode(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flush(Node node, boolean force) {
        UndoStack undoStack = null;
        Map<Node, UndoStack> map = this._undoStacks;
        synchronized (map) {
            undoStack = this._undoStacks.get(node);
        }
        if (undoStack != null && (force || !this.isPartOfMultNodeCommand(node))) {
            undoStack.release();
            map = this._undoStacks;
            synchronized (map) {
                this._undoStacks.remove(node);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPartOfMultNodeCommand(Node node) {
        UndoStack undoStack = null;
        Map<Node, UndoStack> map = this._undoStacks;
        synchronized (map) {
            undoStack = this._undoStacks.get(node);
        }
        if (undoStack != null && undoStack.stacksHaveContent()) {
            return this._masterStack.isPartOfMultNodeCommand(node);
        }
        return false;
    }

    private void nodeWillClose(Node node) {
        if (!this._transactionMgr.delayNodeCloseUntilAfterTransaction(node)) {
            this.flush(node, false);
        }
    }

    public void flush(Object[] objects) {
        if (objects == null || objects.length == 0) {
            return;
        }
        for (int i = 0; i < objects.length; ++i) {
            this.flush(objects[i]);
        }
    }

    public void flush(Node[] objects) {
        if (objects == null || objects.length == 0) {
            return;
        }
        for (int i = 0; i < objects.length; ++i) {
            this.flush(objects[i]);
        }
    }

    public void beginTrans(String label) {
        try {
            this._transactionMgr.beginTransaction(label);
        }
        catch (InterruptedException e) {
            FeedbackManager.reportException(e);
        }
    }

    public void endTrans() {
        this._transactionMgr.endTransaction();
    }

    public void abortTrans() {
        this._transactionMgr.abortTransaction();
    }

    public boolean isTransactionActive() {
        return this._transactionMgr.isTransactionActive();
    }

    private boolean isPartOfTransaction() {
        return this._transactionMgr.isPartOfTransaction();
    }

    private void blockIfNotPartOfTransaction() throws InterruptedException {
        this._transactionMgr.blockIfNotPartOfTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Object observed, UpdateMessage change) {
        if (change != null && change.getMessageID() == NodeFactory.NODE_UNCACHED) {
            Map<Node, UndoStack> map = this._undoStacks;
            synchronized (map) {
                UndoStack stack = this._undoStacks.get(observed);
                if (stack != null) {
                    stack.release();
                    this._undoStacks.remove(observed);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UndoStack findUndoStack(Context context) {
        if (context != null) {
            Node node = CommandProcessor.getSingleNodeOrNull(context);
            Map<Node, UndoStack> map = this._undoStacks;
            synchronized (map) {
                return this._undoStacks.get(node);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean undoStackExists(Node node) {
        Map<Node, UndoStack> map = this._undoStacks;
        synchronized (map) {
            return this._undoStacks.get(node) != null;
        }
    }

    private UndoStack getUndoStack(Context context) {
        if (context != null) {
            Node node = CommandProcessor.getSingleNodeOrNull(context);
            return this.getUndoStack(node);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UndoStack getUndoStack(Node key) {
        if (key == null) {
            return null;
        }
        Map<Node, UndoStack> map = this._undoStacks;
        synchronized (map) {
            UndoStack undoStack = this._undoStacks.get(key);
            if (undoStack == null) {
                undoStack = new UndoStack(key);
                undoStack.addUndoStackListener(this._masterStack);
                this._undoStacks.put(key, undoStack);
                NodeFactory.attach((Observer)this, key.getClass());
            }
            return undoStack;
        }
    }

    private void preprocessHistoricalEvent(HistoryGeneratingCommand cmd) {
        Node[] nodes = cmd.getHistoriedNodes();
        HistoryManager mgr = HistoryManager.getHistoryManager();
        if (mgr != null) {
            URL[] urls = new URL[nodes.length];
            for (int i = 0; i < nodes.length; ++i) {
                urls[i] = nodes[i].getURL();
            }
            try {
                mgr.persistInitialState(urls);
                if (cmd.isGeneratePrecedingState()) {
                    ArrayList<URL> list = new ArrayList<URL>();
                    for (int i = 0; i < nodes.length; ++i) {
                        if (!nodes[i].isDirty()) continue;
                        list.add(nodes[i].getURL());
                    }
                    int size = list.size();
                    if (size > 0) {
                        urls = new URL[size];
                        list.toArray(urls);
                        mgr.persist(urls, null);
                    }
                }
            }
            catch (Exception e) {
                FeedbackManager.reportException(e);
            }
        }
    }

    private void persistHistoricalEvent(HistoryGeneratingCommand cmd) {
        Node[] nodes = cmd.getHistoriedNodes();
        HistoryManager mgr = HistoryManager.getHistoryManager();
        if (mgr != null) {
            URL[] urls = new URL[nodes.length];
            for (int i = 0; i < nodes.length; ++i) {
                urls[i] = nodes[i].getURL();
            }
            try {
                mgr.persist(urls, cmd.getName());
            }
            catch (Exception e) {
                FeedbackManager.reportException(e);
            }
        }
    }

    private void whenUndoStackChanges(EnvironOptions environOptions) {
        int undoLevel = environOptions.getUndoLevel();
        if (this._masterStack.getStackSize() != undoLevel) {
            this._masterStack.setStackSize(undoLevel);
        }
    }

    @Deprecated
    public static Command createCommand(String cmd, Context context) {
        if (cmd == null) {
            return null;
        }
        for (String cmdId : IDE_COMMAND_CLASSES) {
            if (!cmdId.equals(cmd)) continue;
            return CommandProcessor.createCommandFromMeta(new MetaClass(Ide.class.getClassLoader(), cmd), context);
        }
        return CommandProcessor.createCommandFromMeta(new MetaClass(ExtensionRegistry.getExtensionRegistry().getClassLoader("oracle.ide"), cmd), context);
    }

    public static Command createCommandFromMeta(MetaClass commandMeta, Context context) {
        Command newCmd = null;
        if (commandMeta != null) {
            try {
                Class<?> cls = Class.forName(commandMeta.getClassName(), true, commandMeta.getClassLoader());
                newCmd = (Command)cls.newInstance();
                newCmd.setContext(context);
            }
            catch (ClassNotFoundException cnfe) {
                FeedbackManager.reportException("String '" + commandMeta.getClassName() + "' is not a valid classname or the class was not found on the classpath", cnfe);
            }
            catch (ClassCastException cce) {
                FeedbackManager.reportException("Class '" + commandMeta.getClassName() + "' is not a subclass of " + Command.class, cce);
            }
            catch (Exception e) {
                FeedbackManager.reportException(e);
            }
        }
        return newCmd;
    }

    public static Command createCommandFromAction(int actionId, Context context) {
        return CommandProcessor.createCommandFromAction(IdeAction.find(actionId), context);
    }

    public static Command createCommandFromAction(String commandString, Context context) {
        return CommandProcessor.createCommandFromAction(IdeAction.find(commandString), context);
    }

    public static Command createCommandFromAction(IdeAction action, Context context) {
        MetaClass mc;
        Command cmd = null;
        if (action != null && (mc = action.getCommandMetaClass()) != null) {
            cmd = CommandProcessor.createCommandFromMeta(mc, context);
        }
        return cmd;
    }

    public static Command createCommandFromClass(Class clazz, Context context) {
        Command newCmd = null;
        if (clazz != null) {
            try {
                newCmd = (Command)clazz.newInstance();
                newCmd.setContext(context);
            }
            catch (ClassCastException cce) {
                FeedbackManager.reportException("Class '" + clazz.getName() + "' is not a subclass of " + Command.class, cce);
            }
            catch (Exception e) {
                FeedbackManager.reportException(e);
            }
        }
        return newCmd;
    }

    private static Node getSingleNodeOrNull(Context context) {
        if (!CommandProcessor.areMultipleNodesSelected(context)) {
            return context.getNode();
        }
        return null;
    }

    private static boolean areMultipleNodesSelected(Context context) {
        int n;
        Element[] selection = context.getSelection();
        if (selection != null && selection.length > 1 && (n = selection.length) > 1) {
            int cnt = 0;
            for (int i = 0; i < n; ++i) {
                if (!(selection[i] instanceof Node) || ++cnt <= 1) continue;
                return true;
            }
        }
        return false;
    }

    private static void ensureOpen(Command cmd) {
        Context context = cmd.getContext();
        if (context != null && context.getNode() != null) {
            context.getNode().ensureOpen();
        }
        if (cmd != null && cmd.getAffectedNodes() != null) {
            Node[] affectedNodes;
            for (Node n : affectedNodes = cmd.getAffectedNodes()) {
                n.ensureOpen();
            }
        }
    }

    private class FutureOnSwingThread
    implements Future<Integer> {
        private final Future<Integer> _future;

        private FutureOnSwingThread(Future<Integer> future) {
            this._future = future;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this._future.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this._future.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this._future.isDone();
        }

        @Override
        public Integer get() throws InterruptedException, ExecutionException {
            if (SwingUtilities.isEventDispatchThread() && !this._future.isDone()) {
                throw new IllegalStateException("calling thread and future both running on swing thread");
            }
            return this._future.get();
        }

        @Override
        public Integer get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (SwingUtilities.isEventDispatchThread() && !this._future.isDone()) {
                throw new IllegalStateException("calling thread and future both running on swing thread");
            }
            return this._future.get(timeout, unit);
        }
    }

    private static class CPCallable
    implements Callable<Integer> {
        private Command _cmd;
        private boolean _useEventDispatchThread;

        public CPCallable(Command cmd, boolean useEventDispatchThread) {
            this._cmd = cmd;
            this._useEventDispatchThread = useEventDispatchThread;
        }

        @Override
        public Integer call() throws Exception {
            final AtomicReference<Integer> result = new AtomicReference<Integer>();
            final AtomicReference except = new AtomicReference();
            if (this._useEventDispatchThread) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            result.set(CommandProcessor.getInstance().invoke(_cmd));
                        }
                        catch (Exception e) {
                            except.set(e);
                        }
                    }
                });
            } else {
                result.set(CommandProcessor.getInstance().invoke(this._cmd));
            }
            if (except.get() != null) {
                throw new RuntimeException((Throwable)except.get());
            }
            return (Integer)result.get();
        }
    }

    public static final class InfiniteLoopException
    extends RuntimeException {
        public InfiniteLoopException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static final class ExternalModificationException
    extends RuntimeException {
    }

    private static final class CommandPart
    extends Command {
        private final CompoundCommand _owner;
        @GuardedBy(value="this")
        private boolean _isAddition;
        @GuardedBy(value="this")
        private boolean _isDeletion;
        @GuardedBy(value="this")
        private URL _url;

        CommandPart(CompoundCommand owner) {
            super(_COMMAND_PART_ID, 0, owner.getName());
            this._owner = owner;
        }

        @Override
        public int doit() throws Exception {
            return this._owner.isWorking() ? 0 : this._owner.doit(this);
        }

        @Override
        public int undo() throws Exception {
            return this._owner.isWorking() ? 0 : this._owner.undo(this);
        }

        @Override
        public synchronized Context getContext() {
            if (this._url != null) {
                Context ctx = new Context(this.context);
                try {
                    ctx.setNode(NodeFactory.findOrCreate(this._url));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return ctx;
            }
            return super.getContext();
        }

        synchronized void setAddition(boolean isAddition) {
            this._isAddition = isAddition;
            this._url = this.context.getNode().getURL();
            this.context.setNode(null);
        }

        synchronized boolean isAddition() {
            return this._isAddition;
        }

        synchronized void setDeletion(boolean isDeletion) {
            this._isDeletion = isDeletion;
            this._url = this.context.getNode().getURL();
            this.context.setNode(null);
        }

        synchronized boolean isDeletion() {
            return this._isDeletion;
        }
    }

    private static final class BatchCommand
    extends CompoundCommand {
        BatchCommand(String name) {
            super(name);
            Context ctx = Context.newIdeContext();
            ctx.setView(null);
            ctx.setNode(null);
            ctx.setSelection(null);
            this.setContext(ctx);
        }

        @Override
        protected boolean canDo() {
            return this.isFirstTime() ? true : super.canDo();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected int doCommands() throws Exception {
            Object object = this._lock;
            synchronized (object) {
                if (this.isFirstTime()) {
                    this.setFirstTime(false);
                    this.setDone(true);
                    return 0;
                }
            }
            return super.doCommands();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int add(Command cmd) throws Exception {
            Object object = this._lock;
            synchronized (object) {
                int result;
                Assert.check((boolean)this.isFirstTime(), (String)"Command added to batch Command after doit!");
                Context ctx = new Context(cmd.getContext());
                Node[] nodes = cmd.getAffectedNodes();
                this.addPart(ctx);
                if (nodes != null) {
                    for (int j = 0; j < nodes.length; ++j) {
                        ctx = new Context(ctx);
                        ctx.setNode(nodes[j]);
                        this.addPart(ctx);
                    }
                }
                if ((result = cmd.doit()) == 0) {
                    this.addToCommandList(cmd);
                }
                return result;
            }
        }
    }

    private static class CompoundCommand
    extends Command
    implements HistoryGeneratingCommand,
    UndoStackListener {
        protected final Object _lock = new Object();
        @GuardedBy(value="_lock")
        private final List<Node> _historied = new ArrayList<Node>();
        @GuardedBy(value="_lock")
        private boolean _working;
        @GuardedBy(value="_lock")
        private boolean _adjusted;
        @GuardedBy(value="_lock")
        private boolean _firstTime = true;
        @GuardedBy(value="_lock")
        private boolean _done;
        @GuardedBy(value="_lock")
        private boolean _enableConfirmation;
        @GuardedBy(value="_lock")
        private final Map<Node, CommandPart> _partsMap = new LinkedHashMap<Node, CommandPart>();
        @GuardedBy(value="_lock")
        private final List<Command> _commandList = new ArrayList<Command>();

        CompoundCommand(Command cmd) {
            super(_COMPOUND_COMMAND_ID, 1, cmd.getName());
            this.setContext(cmd.getContext());
            this._commandList.add(cmd);
            this._enableConfirmation = cmd.enableConfirmation();
        }

        protected CompoundCommand(String name) {
            super(_COMPOUND_COMMAND_ID, 1, name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isWorking() {
            Object object = this._lock;
            synchronized (object) {
                return this._working;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setWorking(boolean working) {
            Object object = this._lock;
            synchronized (object) {
                this._working = working;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isDone() {
            Object object = this._lock;
            synchronized (object) {
                return this._done;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setDone(boolean done) {
            Object object = this._lock;
            synchronized (object) {
                this._done = done;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isFirstTime() {
            Object object = this._lock;
            synchronized (object) {
                return this._firstTime;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setFirstTime(boolean firstTime) {
            Object object = this._lock;
            synchronized (object) {
                this._firstTime = firstTime;
            }
        }

        @Override
        public boolean isGlobal() {
            return this.getParts().size() > 1;
        }

        @Override
        public int doit() throws Exception {
            return this.doit(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int doit(CommandPart srcPart) throws Exception {
            boolean isRedo;
            if (!this.canDo()) {
                CompoundCommand.showErrorMessage(false);
                return 1;
            }
            boolean bl = isRedo = !this.isFirstTime();
            if (isRedo && Ide.getIdeArgs().getCreateUI() && this.isGlobal() && this._enableConfirmation && !MessageDialog.optionalConfirm((String)"oracle.ide.controller.CommandProcessor.redoConfirmation", (Component)((Object)Ide.getMainWindow()), (Object)IdeArb.format(461, new String[]{this.getName()}), (String)IdeArb.format(83, new String[]{""}), (String)"f1_javaappdevgeneric_redo_html")) {
                return 1;
            }
            int status = this.doCommands();
            if (status == 0) {
                try {
                    this.setWorking(true);
                    this.adjustParts();
                    CommandProcessor cp = CommandProcessor.getInstance();
                    Collection<CommandPart> list = this.getPartsCopy();
                    for (CommandPart part : list) {
                        if (part == srcPart || part.isDeletion()) continue;
                        try {
                            Context ctx = part.getContext();
                            UndoStack undoStack = cp.getUndoStack(ctx);
                            if (isRedo) {
                                if (part.isAddition()) {
                                    undoStack.flush();
                                    undoStack.addToDoneStack(part);
                                    continue;
                                }
                                undoStack.redo();
                                continue;
                            }
                            undoStack.doit(part);
                        }
                        catch (Exception e) {
                            status = 1;
                        }
                    }
                }
                finally {
                    this.setWorking(false);
                }
            }
            return status;
        }

        protected boolean canDo() {
            Collection<CommandPart> list = this.getPartsCopy();
            for (CommandPart part : list) {
                if (CompoundCommand.canDo(part)) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addToCommandList(Command cmd) {
            Object object = this._lock;
            synchronized (object) {
                this._commandList.add(cmd);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected List<Command> getCommandListCopy() {
            Object object = this._lock;
            synchronized (object) {
                return new ArrayList<Command>(this._commandList);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void clearCommandList() {
            Object object = this._lock;
            synchronized (object) {
                this._commandList.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void abort() {
            List<Command> commandList;
            Object object = this._lock;
            synchronized (object) {
                Assert.check((boolean)this._firstTime, (String)"CompoundCommand aborted after doit!");
                commandList = this.getCommandListCopy();
            }
            for (int i = commandList.size() - 1; i >= 0; --i) {
                try {
                    commandList.get(i).undo();
                    continue;
                }
                catch (Exception e) {
                    Assert.printStackTrace((Throwable)e);
                }
            }
            this.clearCommandList();
        }

        private static boolean canDo(CommandPart cmd) {
            if (cmd == null) {
                return false;
            }
            if (cmd.isAddition()) {
                return true;
            }
            UndoStack stack = CommandProcessor.getInstance().findUndoStack(cmd.getContext());
            if (stack != null) {
                if (stack.isUndone(cmd)) {
                    return stack.canRedo(cmd);
                }
                return !stack.isDone(cmd);
            }
            return false;
        }

        @Override
        public int undo() throws Exception {
            return this.undo(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int undo(CommandPart srcPart) throws Exception {
            Collection<CommandPart> list = this.getPartsCopy();
            for (CommandPart part : list) {
                if (CompoundCommand.canUndo(part)) continue;
                CompoundCommand.showErrorMessage(true);
                return 1;
            }
            if (Ide.getIdeArgs().getCreateUI() && this.isGlobal() && this._enableConfirmation && !MessageDialog.optionalConfirm((String)"oracle.ide.controller.CommandProcessor.undoConfirmation", (Component)((Object)Ide.getMainWindow()), (Object)StringUtils.stripMnemonic((String)IdeArb.format(460, new String[]{this.getName()})), (String)StringUtils.stripMnemonic((String)IdeArb.format(80, new String[]{""})), (String)"f1_javaappdevgeneric_undo_html")) {
                return 1;
            }
            int status = this.undoCommands();
            if (status == 0) {
                try {
                    this.setWorking(true);
                    Collection<CommandPart> parts = this.getPartsCopy();
                    CommandProcessor cp = CommandProcessor.getInstance();
                    for (CommandPart part : parts) {
                        if (part == srcPart || part.isAddition()) continue;
                        try {
                            UndoStack undoStack = cp.getUndoStack(part.getContext());
                            if (part.isDeletion()) {
                                undoStack.flush();
                                undoStack.addToUndoneStack(part);
                                continue;
                            }
                            undoStack.undo();
                        }
                        catch (Exception e) {
                            status = 1;
                        }
                    }
                }
                finally {
                    this.setWorking(false);
                }
            }
            return status;
        }

        private static boolean canUndo(CommandPart cmd) {
            if (cmd == null) {
                return false;
            }
            if (cmd.isDeletion()) {
                return true;
            }
            UndoStack stack = CommandProcessor.getInstance().findUndoStack(cmd.getContext());
            return stack != null && stack.canUndo(cmd);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int doCommands() throws Exception {
            List<Command> commands = this.getCommandListCopy();
            for (int i = 0; i < commands.size(); ++i) {
                try {
                    Command command = commands.get(i);
                    CommandProcessor.ensureOpen(command);
                    if (command.doit() == 0) continue;
                    while (--i >= 0) {
                        try {
                            commands.get(i).undo();
                        }
                        catch (Exception x) {
                            Assert.printStackTrace((Throwable)x);
                        }
                    }
                    return 1;
                }
                catch (Exception e) {
                    while (--i >= 0) {
                        try {
                            commands.get(i).undo();
                        }
                        catch (Exception x) {
                            Assert.printStackTrace((Throwable)x);
                        }
                    }
                    throw e;
                }
            }
            Object object = this._lock;
            synchronized (object) {
                this.setFirstTime(false);
                this.setDone(true);
            }
            return 0;
        }

        protected int undoCommands() throws Exception {
            List<Command> commands = this.getCommandListCopy();
            for (int i = commands.size() - 1; i >= 0; --i) {
                try {
                    Command cmd = commands.get(i);
                    CommandProcessor.ensureOpen(cmd);
                    if (cmd.undo() == 0) continue;
                    while (++i < commands.size()) {
                        try {
                            commands.get(i).doit();
                        }
                        catch (Exception x) {
                            Assert.printStackTrace((Throwable)x);
                        }
                    }
                    return 1;
                }
                catch (Exception e) {
                    while (++i < commands.size()) {
                        try {
                            commands.get(i).doit();
                        }
                        catch (Exception x) {
                            Assert.printStackTrace((Throwable)x);
                        }
                    }
                    throw e;
                }
            }
            this.setDone(false);
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Node[] getHistoriedNodes() {
            Object object = this._lock;
            synchronized (object) {
                if (this._historied.size() == 0 && this._commandList.size() > 0) {
                    for (int i = 0; i < this._commandList.size(); ++i) {
                        Command cmd = this._commandList.get(i);
                        if (!(cmd instanceof HistoryGeneratingCommand)) continue;
                        Context ctx = cmd.getContext();
                        Node node = ctx.getNode();
                        Node[] nodes = cmd.getAffectedNodes();
                        if (node != null && !this._historied.contains(node)) {
                            this._historied.add(node);
                        }
                        if (nodes == null) continue;
                        for (int j = 0; j < nodes.length; ++j) {
                            if (nodes[j] == null || this._historied.contains(nodes[j])) continue;
                            this._historied.add(nodes[j]);
                        }
                    }
                }
                Node[] result = new Node[this._historied.size()];
                this._historied.toArray(result);
                return result;
            }
        }

        @Override
        public boolean isGeneratePrecedingState() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Collection<CommandPart> getPartsCopy() {
            Object object = this._lock;
            synchronized (object) {
                return new ArrayList<CommandPart>(this.getParts());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removePart(Command cmd) {
            Object object = this._lock;
            synchronized (object) {
                this.getParts().remove(cmd);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Collection<CommandPart> getParts() {
            Object object = this._lock;
            synchronized (object) {
                if (this._partsMap.size() == 0 && this._commandList.size() > 0) {
                    for (int i = 0; i < this._commandList.size(); ++i) {
                        Command cmd = this._commandList.get(i);
                        Node[] nodes = cmd.getAffectedNodes();
                        Context ctx = cmd.getContext();
                        ctx = new Context(ctx);
                        this.addPart(ctx);
                        if (nodes == null) continue;
                        for (int j = 0; j < nodes.length; ++j) {
                            ctx = new Context(ctx);
                            ctx.setNode(nodes[j]);
                            this.addPart(ctx);
                        }
                    }
                }
                return this._partsMap.values();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CommandPart addPart(Context ctx) {
            Object object = this._lock;
            synchronized (object) {
                Node node = ctx != null ? ctx.getNode() : null;
                CommandPart part = this.getPart(node);
                if (part == null && (part = this.createPart(ctx)) != null) {
                    this._partsMap.put(node, part);
                }
                return part;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CommandPart getPart(Node node) {
            Object object = this._lock;
            synchronized (object) {
                return this._partsMap.get(node);
            }
        }

        protected CommandPart createPart(Context ctx) {
            Node node = ctx != null ? ctx.getNode() : null;
            UndoStack undoStack = CommandProcessor.getInstance().getUndoStack(node);
            if (undoStack == null) {
                return null;
            }
            CommandPart part = new CommandPart(this);
            ctx.setNode(node);
            ctx.setSelection(null);
            part.setContext(ctx);
            undoStack.addUndoStackListener(this);
            return part;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void adjustParts() {
            Object object = this._lock;
            synchronized (object) {
                Context ctx;
                if (this._adjusted) {
                    return;
                }
                this._adjusted = true;
                ArrayList<Node> additions = new ArrayList<Node>();
                for (int i = 0; i < this._commandList.size(); ++i) {
                    Command command = this._commandList.get(i);
                    ctx = command.getContext();
                    Node[] nodes = command.getAffectedNodes();
                    Node node = ctx.getNode();
                    if (node != null && !additions.contains(node)) {
                        additions.add(node);
                    }
                    if (nodes == null) continue;
                    for (int j = 0; j < nodes.length; ++j) {
                        if (nodes[j] == null || additions.contains(nodes[j])) continue;
                        additions.add(nodes[j]);
                    }
                }
                for (CommandPart commandPart : this.getParts()) {
                    ctx = commandPart.getContext();
                    Node node = ctx.getNode();
                    if (!additions.contains(node)) {
                        commandPart.setDeletion(true);
                        continue;
                    }
                    additions.remove(node);
                }
                for (int i = additions.size() - 1; i >= 0; --i) {
                    CommandPart commandPart = this.addPart(new Context((Node)additions.get(i)));
                    commandPart.setAddition(true);
                }
                additions.clear();
            }
        }

        @Override
        public void commandsDropped(UndoStackEvent e) {
            Collection<CommandPart> partsCopy = this.getPartsCopy();
            HashSet<UndoStack> undoStacks = new HashSet<UndoStack>();
            Command[] commands = e.getCommands();
            for (int i = 0; i < commands.length; ++i) {
                Command dropped = commands[i];
                if (!partsCopy.contains(dropped)) continue;
                UndoStack undoStack = CommandProcessor.getInstance().findUndoStack(dropped.getContext());
                this.removePart(dropped);
                partsCopy.remove(dropped);
                if (undoStack != null) {
                    undoStack.removeUndoStackListener(this);
                    undoStacks.add(undoStack);
                }
                while (partsCopy.size() > 0) {
                    Command part = partsCopy.iterator().next();
                    Context ctx = part != null ? part.getContext() : null;
                    undoStack = CommandProcessor.getInstance().findUndoStack(ctx);
                    this.removePart(part);
                    partsCopy.remove(part);
                    if (undoStack == null) continue;
                    undoStack.removeUndoStackListener(this);
                    undoStack.flush(part);
                    undoStacks.add(undoStack);
                }
                break;
            }
            for (UndoStack stack : undoStacks) {
                CommandProcessor.getInstance().removeStackIfEmpty(stack);
            }
        }

        private static void showErrorMessage(boolean isUndo) {
            String errorMsg;
            String string = errorMsg = isUndo ? IdeArb.getString(432) : IdeArb.getString(433);
            if (Ide.getIdeArgs().getCreateUI()) {
                MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)errorMsg, (String)IdeArb.getString(235), null);
            } else {
                System.err.println(errorMsg);
            }
        }

        private boolean isPartOfMultNodeCommand(Node node) {
            if (this.getContext().getNode() != null && this.getContext().getNode().equals(node)) {
                return true;
            }
            for (Command c : this.getCommandListCopy()) {
                if (c.getContext().getNode() != null && c.getContext().getNode().equals(node)) {
                    return true;
                }
                Node[] affectedNodes = c.getAffectedNodes();
                if (affectedNodes == null) continue;
                for (int i = 0; i < affectedNodes.length; ++i) {
                    Node affectedNnode = affectedNodes[i];
                    if (!node.equals(affectedNnode)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static final class MasterStack
    implements UndoStackListener {
        private final Object _lock = new Object();
        @GuardedBy(value="_lock")
        private int _maxSize;
        @GuardedBy(value="_lock")
        private boolean _enabled = true;
        @GuardedBy(value="_lock")
        private final PairList<Command, UndoStack> _commandStackPairs = new ArrayPairList();

        private MasterStack() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int doit(Command cmd, UndoStack stack) throws Exception {
            int status;
            int n = status = stack != null ? stack.doit(cmd) : cmd.doit();
            if (status == 0) {
                Object object = this._lock;
                synchronized (object) {
                    this._commandStackPairs.add((Object)new Pair((Object)cmd, (Object)stack));
                    try {
                        this.trim();
                    }
                    catch (InfiniteLoopException e) {
                        if (IdeBootProperties.isHeadlessMode()) {
                            try {
                                CommandProcessor.getInstance().__debug_printStacks(true);
                            }
                            catch (Exception ee) {
                                CommandProcessor.debug(e.getMessage());
                            }
                            this.disable(e.getMessage());
                            throw new RuntimeException(e.getMessage(), e.getCause());
                        }
                        this.disable(e.getMessage());
                    }
                }
            }
            return status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean canUndo() {
            Object object = this._lock;
            synchronized (object) {
                for (int i = this._commandStackPairs.size() - 1; i >= 0; --i) {
                    Command cmd = (Command)((Pair)this._commandStackPairs.get(i)).getFirst();
                    if (!cmd.isGlobal()) continue;
                    UndoStack stack = (UndoStack)((Pair)this._commandStackPairs.get(i)).getSecond();
                    if (stack == null) {
                        if (!((CompoundCommand)cmd).isDone()) continue;
                        return true;
                    }
                    if (!stack.isDone(cmd)) continue;
                    return stack.canUndo(cmd);
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String getUndoLabel() {
            Object object = this._lock;
            synchronized (object) {
                for (int i = this._commandStackPairs.size() - 1; i >= 0; --i) {
                    Command cmd = (Command)((Pair)this._commandStackPairs.get(i)).getFirst();
                    if (!cmd.isGlobal()) continue;
                    UndoStack stack = (UndoStack)((Pair)this._commandStackPairs.get(i)).getSecond();
                    if (stack == null) {
                        if (!((CompoundCommand)cmd).isDone()) continue;
                        return cmd.getName();
                    }
                    if (!stack.isDone(cmd)) continue;
                    return stack.canUndo(cmd) ? cmd.getName() : "";
                }
            }
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int undo() throws Exception {
            CommandExecutor exec = null;
            Object object = this._lock;
            synchronized (object) {
                for (int i = this._commandStackPairs.size() - 1; i >= 0; --i) {
                    boolean confirmed;
                    final Command cmd = (Command)((Pair)this._commandStackPairs.get(i)).getFirst();
                    if (!cmd.isGlobal()) continue;
                    final UndoStack stack = (UndoStack)((Pair)this._commandStackPairs.get(i)).getSecond();
                    if (stack == null) {
                        if (!((CompoundCommand)cmd).isDone()) continue;
                        exec = new CommandExecutor(){

                            @Override
                            public int run() throws Exception {
                                return cmd.undo();
                            }
                        };
                        break;
                    }
                    if (!stack.isDone(cmd)) continue;
                    boolean bl = confirmed = !Ide.getIdeArgs().getCreateUI();
                    if (!confirmed && cmd.enableConfirmation()) {
                        confirmed = MessageDialog.confirm((Component)((Object)Ide.getMainWindow()), (Object)StringUtils.stripMnemonic((String)IdeArb.format(460, new String[]{cmd.getName()})), (String)StringUtils.stripMnemonic((String)IdeArb.format(80, "")), null);
                    }
                    if (confirmed) {
                        exec = new CommandExecutor(){

                            @Override
                            public int run() throws Exception {
                                return stack.canUndo(cmd) ? stack.undo() : 1;
                            }
                        };
                        break;
                    }
                    return 1;
                }
            }
            if (exec != null) {
                return exec.run();
            }
            return 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean canRedo() {
            Object object = this._lock;
            synchronized (object) {
                for (int i = this._commandStackPairs.size() - 1; i >= 0; --i) {
                    Command cmd = (Command)((Pair)this._commandStackPairs.get(i)).getFirst();
                    if (!cmd.isGlobal()) continue;
                    UndoStack stack = (UndoStack)((Pair)this._commandStackPairs.get(i)).getSecond();
                    if (stack == null) {
                        if (((CompoundCommand)cmd).isDone()) continue;
                        return true;
                    }
                    if (!stack.isUndone(cmd)) continue;
                    return stack.canRedo(cmd);
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String getRedoLabel() {
            Object object = this._lock;
            synchronized (object) {
                for (int i = this._commandStackPairs.size() - 1; i >= 0; --i) {
                    Command cmd = (Command)((Pair)this._commandStackPairs.get(i)).getFirst();
                    if (!cmd.isGlobal()) continue;
                    UndoStack stack = (UndoStack)((Pair)this._commandStackPairs.get(i)).getSecond();
                    if (stack == null) {
                        if (((CompoundCommand)cmd).isDone()) continue;
                        return cmd.getName();
                    }
                    if (!stack.isUndone(cmd)) continue;
                    return stack.canRedo(cmd) ? cmd.getName() : "";
                }
            }
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int redo() throws Exception {
            CommandExecutor exec = null;
            Object object = this._lock;
            synchronized (object) {
                for (int i = this._commandStackPairs.size() - 1; i >= 0; --i) {
                    boolean confirmed;
                    final Command cmd = (Command)((Pair)this._commandStackPairs.get(i)).getFirst();
                    if (!cmd.isGlobal()) continue;
                    final UndoStack stack = (UndoStack)((Pair)this._commandStackPairs.get(i)).getSecond();
                    if (stack == null) {
                        if (((CompoundCommand)cmd).isDone()) continue;
                        exec = new CommandExecutor(){

                            @Override
                            public int run() throws Exception {
                                return cmd.doit();
                            }
                        };
                        break;
                    }
                    if (!stack.isUndone(cmd)) continue;
                    boolean bl = confirmed = !Ide.getIdeArgs().getCreateUI();
                    if (!confirmed && cmd.enableConfirmation()) {
                        confirmed = MessageDialog.confirm((Component)((Object)Ide.getMainWindow()), (Object)IdeArb.format(461, new String[]{cmd.getName()}), (String)IdeArb.format(83, ""), null);
                    }
                    if (confirmed) {
                        exec = new CommandExecutor(){

                            @Override
                            public int run() throws Exception {
                                return stack.canRedo(cmd) ? stack.redo() : 1;
                            }
                        };
                        break;
                    }
                    return 1;
                }
            }
            if (exec != null) {
                return exec.run();
            }
            return 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int getStackSize() {
            Object object = this._lock;
            synchronized (object) {
                return this._maxSize;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setStackSize(int size) {
            if (!this.isEnabled()) {
                return;
            }
            if (size >= 0) {
                Object object = this._lock;
                synchronized (object) {
                    this._maxSize = size;
                    this.trim();
                }
                IdeAction action = IdeAction.find(5);
                if (action != null) {
                    Ide.getIdeController().update(action, null);
                }
                if ((action = IdeAction.find(6)) != null) {
                    Ide.getIdeController().update(action, null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void enable() {
            Object object = this._lock;
            synchronized (object) {
                if (this._enabled) {
                    return;
                }
                this._enabled = true;
            }
            this.showEnabledDialog(true);
            this.setStackSize(EnvironOptions.getInstance(Preferences.getPreferences()).getUndoLevel());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void disable(String reason) {
            Object object = this._lock;
            synchronized (object) {
                if (!this._enabled) {
                    return;
                }
                this._enabled = false;
            }
            FeedbackManager.reportException(new IllegalStateException(reason));
            this.showEnabledDialog(false);
            this.setStackSize(0);
        }

        void disable() {
            this.disable("Cannot invoke Command from other thread, or with non undoable side effects, while in batch mode\nDisabling Undo support until batch completed.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isEnabled() {
            Object object = this._lock;
            synchronized (object) {
                return this._enabled;
            }
        }

        void showEnabledDialog(final boolean enabled) {
            try {
                new SwingClosure(true){

                    protected void runImpl() {
                        MessageDialog.information((Component)((Object)Ide.getMainWindow()), (Object)(enabled ? StringUtils.stripMnemonic((String)IdeArb.getString(463)) : StringUtils.stripMnemonic((String)IdeArb.getString(462))), (String)StringUtils.stripMnemonic((String)IdeArb.format(80, "")), null);
                    }
                }.run();
            }
            catch (ClosureException closureException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isPartOfMultNodeCommand(Node node) {
            Object object = this._lock;
            synchronized (object) {
                for (Pair pair : this._commandStackPairs) {
                    CompoundCommand command;
                    if (!((Command)pair.getFirst()).isGlobal() || !(command = (CompoundCommand)pair.getFirst()).isPartOfMultNodeCommand(node)) continue;
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void _debugPrint(boolean deep) {
            CommandProcessor.debug("========== MasterStack ===========");
            Object object = this._lock;
            synchronized (object) {
                CommandProcessor.debug("_commandStackPair:size = " + this._commandStackPairs.size());
                if (deep) {
                    for (Pair pair : this._commandStackPairs) {
                        StringBuilder sb = new StringBuilder();
                        if (pair == null) {
                            sb.append("Pair is null.");
                        } else {
                            if (pair.first == null) {
                                sb.append("pair.first is null. ");
                            } else {
                                sb.append("  Command:" + ((Command)pair.first).getName());
                            }
                            if (pair.second == null) {
                                sb.append("pair.second is null.");
                            } else if (((UndoStack)pair.second).getNode() == null) {
                                sb.append("pair.second.getNode() is null");
                            } else {
                                sb.append(" UndoStack:" + ((UndoStack)pair.second).getNode().getShortLabel());
                            }
                        }
                        CommandProcessor.debug(sb.toString());
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void trim() {
            Object object = this._lock;
            synchronized (object) {
                int currentSize = this._commandStackPairs.size();
                while (currentSize > this._maxSize) {
                    Command cmd = (Command)((Pair)this._commandStackPairs.get(0)).getFirst();
                    UndoStack stack = (UndoStack)((Pair)this._commandStackPairs.get(0)).getSecond();
                    if (stack == null) {
                        CompoundCommand wrapper = (CompoundCommand)cmd;
                        boolean isDone = wrapper.isDone();
                        Collection<CommandPart> parts = wrapper.getParts();
                        Iterator<CommandPart> i = parts.iterator();
                        while (stack == null && i.hasNext()) {
                            CommandPart part = i.next();
                            if (part.isDeletion()) {
                                if (isDone || (stack = CommandProcessor.getInstance().getUndoStack(part.getContext())) == null) continue;
                                cmd = part;
                                continue;
                            }
                            if (part.isAddition()) {
                                if (!isDone || (stack = CommandProcessor.getInstance().getUndoStack(part.getContext())) == null) continue;
                                cmd = part;
                                continue;
                            }
                            stack = CommandProcessor.getInstance().getUndoStack(part.getContext());
                            if (stack == null) continue;
                            cmd = part;
                        }
                    }
                    if (stack != null) {
                        if (!stack.flush(cmd)) {
                            this._commandStackPairs.remove(0);
                        }
                        CommandProcessor.getInstance().removeStackIfEmpty(stack);
                    } else {
                        this.commandsDropped(new UndoStackEvent(this, new Command[]{cmd}));
                    }
                    try {
                        Assert.check((this._commandStackPairs.size() != currentSize ? 1 : 0) != 0);
                    }
                    catch (Exception e) {
                        String message = "Infinite Loop Detected";
                        throw new InfiniteLoopException(message, e);
                    }
                    currentSize = this._commandStackPairs.size();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void commandsDropped(UndoStackEvent e) {
            Command[] cmds;
            Command[] commandArray = cmds = e != null ? e.getCommands() : null;
            if (cmds != null) {
                Object object = this._lock;
                synchronized (object) {
                    for (int i = 0; i < cmds.length; ++i) {
                        Pair pair;
                        Command cmd = cmds[i];
                        int index = this._commandStackPairs.indexOfFirstType((Object)cmd);
                        if (index < 0 && cmd instanceof CommandPart) {
                            cmd = ((CommandPart)cmd)._owner;
                            index = this._commandStackPairs.indexOfFirstType((Object)cmd);
                        }
                        if (index < 0 || (pair = (Pair)this._commandStackPairs.remove(index)) == null || pair.getSecond() == null || !((UndoStack)pair.getSecond()).stacksHaveContent()) continue;
                        UndoStack undoStack = (UndoStack)pair.getSecond();
                        undoStack.flush((Command)pair.getFirst());
                        CommandProcessor.getInstance().removeStackIfEmpty(undoStack);
                    }
                }
            }
        }
    }

    private final class Transaction {
        @GuardedBy(value="this")
        private int _batchLevel;
        @GuardedBy(value="this")
        private Thread _batchThread;
        @GuardedBy(value="this")
        private BatchCommand _batchCommand;
        @GuardedBy(value="this")
        private final String _label;

        Transaction(String label) {
            this._label = label;
        }

        public synchronized void begin() {
            this.incrementBatchLevel();
            if (this._batchCommand == null) {
                this._batchCommand = new BatchCommand(this._label);
                this._batchThread = Thread.currentThread();
            } else {
                Assert.precondition((boolean)this.isInCurrentThread(), (String)"Trying to begin a transaction in another thread while a current transaction is executing");
            }
        }

        public synchronized void end() {
            Assert.precondition((boolean)this.isInCurrentThread(), (String)"Trying to abort a transaction created by another thread!");
            this.decrementBatchLevel();
            CommandProcessor.this.diagnostic("Finished CommandProcessor transaction on thread " + Thread.currentThread().getName() + " at batch level " + this._batchLevel);
            if (this.getBatchLevel() == 0) {
                this._batchThread = null;
                if (CommandProcessor.this._masterStack.isEnabled()) {
                    try {
                        CommandProcessor.this._masterStack.doit(this._batchCommand, null);
                        this._batchCommand = null;
                    }
                    catch (Exception e) {
                        FeedbackManager.reportException(e);
                    }
                } else {
                    CommandProcessor.this._masterStack.enable();
                }
            }
        }

        public synchronized boolean ended() {
            return this._batchLevel == 0 && this._batchCommand == null;
        }

        public synchronized void abort() {
            Assert.precondition((boolean)this.isInCurrentThread(), (String)"Trying to abort a transaction created by another thread!");
            CommandProcessor.this.diagnostic("Aborted CommandProcessor transaction on thread " + Thread.currentThread().getName() + " at batch level " + this._batchLevel);
            this._batchLevel = 0;
            this._batchCommand.abort();
            this._batchCommand = null;
            this._batchThread = null;
        }

        public synchronized int add(Command cmd) throws Exception {
            boolean checkAffectedNodes = cmd.getType() != 3;
            Object[] nodes = cmd.getAffectedNodes();
            if (checkAffectedNodes) {
                checkAffectedNodes = nodes != null && nodes.length > 0;
            }
            int status = 0;
            if (this.isInCurrentThread() && !checkAffectedNodes) {
                status = this._batchCommand.add(cmd);
            } else {
                String batchCommandName = this._batchCommand.getName();
                if (checkAffectedNodes) {
                    CommandProcessor.this._masterStack.disable("Command " + cmd + " has affected nodes: " + Arrays.toString(nodes) + ". Current batch command: " + batchCommandName);
                } else {
                    CommandProcessor.this._masterStack.disable("Command " + cmd + " invoked on thread " + Thread.currentThread() + ". Does not match batch thread " + this._batchThread + ". Current batch command: " + batchCommandName);
                }
                status = cmd.doit();
            }
            return status;
        }

        synchronized boolean isInCurrentThread() {
            return this._batchThread == Thread.currentThread();
        }

        synchronized int getBatchLevel() {
            return this._batchLevel;
        }

        synchronized int incrementBatchLevel() {
            return ++this._batchLevel;
        }

        synchronized int decrementBatchLevel() {
            return --this._batchLevel;
        }

        synchronized Thread getBatchThread() {
            return this._batchThread;
        }

        synchronized BatchCommand getBatchCommand() {
            return this._batchCommand;
        }

        synchronized void forcedAbort() {
            this._batchLevel = 0;
            if (this._batchCommand != null) {
                this._batchCommand.abort();
                this._batchCommand = null;
            }
            this._batchThread = null;
            FeedbackManager.addFeedback("Forcing Abort of CommandProcessor transaction on thread " + Thread.currentThread().getName() + " at batch level " + this._batchLevel);
        }
    }

    private final class TransactionManager {
        @GuardedBy(value="this")
        private volatile Transaction _transaction;
        @GuardedBy(value="_closingNodes")
        private final Set<Node> _closingNodes = new HashSet<Node>();

        TransactionManager() {
        }

        synchronized void beginTransaction(String label) throws InterruptedException {
            this.blockIfNotPartOfTransaction();
            if (this._transaction == null) {
                this._transaction = new Transaction(label);
            }
            this._transaction.begin();
        }

        synchronized void endTransaction() {
            Assert.precondition((boolean)this.isTransactionActive(), (String)"Trying to end a non-existent transaction");
            try {
                this._transaction.end();
            }
            finally {
                if (this._transaction.ended()) {
                    this._transaction = null;
                }
                this.notifyAll();
                this.cleanupStacksForClosedNodes();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanupStacksForClosedNodes() {
            HashSet<Node> copy = null;
            Set<Node> set = this._closingNodes;
            synchronized (set) {
                if (!this._closingNodes.isEmpty()) {
                    copy = new HashSet<Node>(this._closingNodes);
                    this._closingNodes.clear();
                }
            }
            if (copy != null) {
                for (Node node : copy) {
                    if (node.isOpen()) continue;
                    CommandProcessor.getInstance().flush(node, true);
                }
            }
        }

        synchronized void abortTransaction() {
            Assert.precondition((boolean)this.isTransactionActive(), (String)"Tyring to abort a non-existent transaction!");
            try {
                this._transaction.abort();
            }
            finally {
                this._transaction = null;
            }
        }

        synchronized int addCommandToActiveTransaction(Command cmd) throws Exception {
            return this._transaction.add(cmd);
        }

        boolean isTransactionActive() {
            return this._transaction != null;
        }

        private synchronized boolean isPartOfTransaction() {
            return this._transaction != null && this._transaction.isInCurrentThread();
        }

        private synchronized void blockIfNotPartOfTransaction() throws InterruptedException {
            long timeWaiting = 0L;
            while (this._transaction != null && !this._transaction.isInCurrentThread()) {
                this.wait(2000L);
                if ((timeWaiting += 2000L) <= 10000L) continue;
                this._transaction.forcedAbort();
                this._transaction = null;
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean delayNodeCloseUntilAfterTransaction(Node node) {
            Set<Node> set = this._closingNodes;
            synchronized (set) {
                if (this._transaction != null) {
                    this._closingNodes.add(node);
                    return true;
                }
                return false;
            }
        }
    }

    private static interface CommandExecutor {
        public int run() throws Exception;
    }

    private static final class UndoStackEvent
    extends EventObject {
        private final Command[] _commands;

        public UndoStackEvent(Object source, Command[] commands) {
            super(source);
            this._commands = commands;
        }

        public Command[] getCommands() {
            return this._commands;
        }
    }

    private static interface UndoStackListener {
        public void commandsDropped(UndoStackEvent var1);
    }

    private static final class UndoStack
    extends NodeListener {
        static final int DONE = 0;
        static final int UNDONE = 1;
        private final Object _stacksLock = new Object();
        @GuardedBy(value="_stacksLock")
        private final Stack<Command> _doneStack = new Stack();
        @GuardedBy(value="_stacksLock")
        private final Stack<Command> _undoneStack = new Stack();
        @GuardedBy(value="_listeners")
        private final List<UndoStackListener> _listeners = new ArrayList<UndoStackListener>();
        private final Node _node;

        UndoStack(Node node) {
            this._node = node;
            node.addNodeListener(this);
        }

        private Node getNode() {
            return this._node;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addToUndoneStack(Command cmd) {
            if (cmd == null) {
                return;
            }
            Object object = this._stacksLock;
            synchronized (object) {
                this._undoneStack.push(cmd);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addToDoneStack(Command cmd) {
            if (cmd == null) {
                return;
            }
            Object object = this._stacksLock;
            synchronized (object) {
                this._doneStack.push(cmd);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int doit(Command cmd) throws Exception {
            int status = this.executeCommand(cmd);
            if (status == 0) {
                Object object = this._stacksLock;
                synchronized (object) {
                    this._doneStack.push(cmd);
                }
                this.trim(1, 0);
            }
            return status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean canUndo(Command cmd) {
            Object object = this._stacksLock;
            synchronized (object) {
                if (!this._doneStack.isEmpty()) {
                    return cmd == null || this._doneStack.get(this._doneStack.size() - 1) == cmd;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String getUndoLabel() {
            Object object = this._stacksLock;
            synchronized (object) {
                Command cmd = !this._doneStack.isEmpty() ? (Command)this._doneStack.get(this._doneStack.size() - 1) : null;
                return cmd != null ? cmd.getName() : "";
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int undo() throws Exception {
            boolean alreadyInProgress = Ide.isQuitting();
            Command cmd = null;
            int status = 1;
            try {
                cmd = this.peek(0);
                if (cmd != null) {
                    alreadyInProgress = alreadyInProgress || IdeAction.handlerStarting();
                    CommandProcessor.ensureOpen(cmd);
                    status = cmd.undo();
                    Object object = this._stacksLock;
                    synchronized (object) {
                        if (status == 0 && !this._doneStack.empty()) {
                            this._undoneStack.push(this._doneStack.pop());
                        }
                    }
                }
                int n = status;
                return n;
            }
            catch (ExternalModificationException e) {
                int n = status;
                return n;
            }
            finally {
                if (cmd != null) {
                    IdeAction.handlerFinished(alreadyInProgress, Controller.UPDATE_FROM_UNDO);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean canRedo(Command cmd) {
            Object object = this._stacksLock;
            synchronized (object) {
                if (!this._undoneStack.isEmpty()) {
                    return cmd == null || this._undoneStack.get(this._undoneStack.size() - 1) == cmd;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String getRedoLabel() {
            Object object = this._stacksLock;
            synchronized (object) {
                Command cmd = !this._undoneStack.isEmpty() ? (Command)this._undoneStack.get(this._undoneStack.size() - 1) : null;
                return cmd != null ? cmd.getName() : null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int redo() throws Exception {
            boolean alreadyInProgress = Ide.isQuitting();
            Command cmd = null;
            int status = 1;
            try {
                cmd = this.peek(1);
                if (cmd != null) {
                    alreadyInProgress = alreadyInProgress || IdeAction.handlerStarting();
                    status = this.executeCommand(cmd);
                    if (status == 0) {
                        Object object = this._stacksLock;
                        synchronized (object) {
                            this._doneStack.push(this._undoneStack.pop());
                        }
                    }
                }
                int n = status;
                return n;
            }
            catch (ExternalModificationException e) {
                int n = status;
                return n;
            }
            finally {
                if (cmd != null) {
                    IdeAction.handlerFinished(alreadyInProgress, Controller.UPDATE_FROM_UNDO);
                }
            }
        }

        int executeCommand(Command cmd) throws Exception {
            int status = cmd.doit();
            if (status == 0) {
                CommandProcessor.getInstance().flush(cmd.getAffectedNodes());
            }
            return status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isDone(Command cmd) {
            Object object = this._stacksLock;
            synchronized (object) {
                if (!this._doneStack.isEmpty()) {
                    return this._doneStack.contains(cmd);
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isUndone(Command cmd) {
            Object object = this._stacksLock;
            synchronized (object) {
                if (!this._undoneStack.isEmpty()) {
                    return this._undoneStack.contains(cmd);
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Command peek(int state) throws Exception {
            Object object = this._stacksLock;
            synchronized (object) {
                Stack<Command> stack = state == 0 ? this._doneStack : this._undoneStack;
                return !stack.isEmpty() ? (Command)stack.lastElement() : null;
            }
        }

        void flush() {
            this.trim(0, 0);
            this.trim(1, 0);
        }

        boolean flush(Command cmd) {
            if (this.stacksHaveContent()) {
                this.trim(1, cmd);
                this.trim(0, cmd);
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void trim(int state, Command cmd) {
            int trimBy = -1;
            Object object = this._stacksLock;
            synchronized (object) {
                Stack<Command> stack = state == 0 ? this._doneStack : this._undoneStack;
                int index = stack.indexOf(cmd);
                trimBy = stack.size() - ++index;
            }
            this.trim(state, trimBy);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void trim(int state, int size) {
            Command[] commands = null;
            Object object = this._stacksLock;
            synchronized (object) {
                Stack<Command> stack;
                Stack<Command> stack2 = stack = state == 0 ? this._doneStack : this._undoneStack;
                if (stack != null && stack.size() > size) {
                    List sublist = stack.subList(0, stack.size() - size);
                    commands = new Command[sublist.size()];
                    sublist.toArray(commands);
                    for (int i = 0; i < commands.length; ++i) {
                        stack.remove(commands[i]);
                    }
                }
            }
            if (commands != null && commands.length > 0) {
                this.fireCommandsDropped(new UndoStackEvent(this, commands));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void release() {
            this.flush();
            List<UndoStackListener> list = this._stacksLock;
            synchronized (list) {
                this._doneStack.clear();
                this._undoneStack.clear();
            }
            list = this._listeners;
            synchronized (list) {
                this._listeners.clear();
            }
            this._node.removeNodeListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addUndoStackListener(UndoStackListener listener) {
            List<UndoStackListener> list = this._listeners;
            synchronized (list) {
                if (!this._listeners.contains(listener)) {
                    this._listeners.add(listener);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeUndoStackListener(UndoStackListener listener) {
            List<UndoStackListener> list = this._listeners;
            synchronized (list) {
                this._listeners.remove(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fireCommandsDropped(UndoStackEvent e) {
            UndoStackListener[] listeners;
            List<UndoStackListener> list = this._listeners;
            synchronized (list) {
                listeners = new UndoStackListener[this._listeners.size()];
                this._listeners.toArray(listeners);
            }
            if (listeners != null) {
                for (int i = 0; i < listeners.length; ++i) {
                    listeners[i].commandsDropped(e);
                }
            }
        }

        @Override
        public void nodeWillClose(NodeEvent e) {
            CommandProcessor.getInstance().nodeWillClose(this._node);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean stacksHaveContent() {
            Object object = this._stacksLock;
            synchronized (object) {
                return this._doneStack.size() > 0 || this._undoneStack.size() > 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void _debugPrint(boolean deep) {
            Object object = this._stacksLock;
            synchronized (object) {
                CommandProcessor.debug("UndoStack:" + this._node.getShortLabel());
                CommandProcessor.debug("  _doneStack:size = " + this._doneStack.size());
                if (deep) {
                    for (Command c : this._doneStack) {
                        CommandProcessor.debug("    Command:" + c.getName());
                    }
                }
                CommandProcessor.debug("  _undoneStack:size = " + this._undoneStack.size());
                if (deep) {
                    for (Command c : this._undoneStack) {
                        CommandProcessor.debug("    Command:" + c.getName());
                    }
                }
            }
        }
    }
}

