/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JDesktopPane;
import oracle.ide.docking.DockableContainer;

public class FocusHierarchyEvent
extends AWTEvent {
    public static final int FOCUS_HIERARCHY_GAINED = 3708;
    public static final int FOCUS_HIERARCHY_LOST = 3709;
    public static final int FOCUS_HIERARCHY_FIRST = 3708;
    public static final int FOCUS_HIERARCHY_LAST = 3709;
    private static final int IDE_CONTAINER_UNDEF = -1;
    public static final int IDE_CONTAINER_UNKNOWN = 0;
    public static final int IDE_CONTAINER_EDITOR = 1;
    public static final int IDE_CONTAINER_DOCKABLE = 2;
    private ArrayList<Component> _hierarchy;
    private HashSet _set;
    private boolean _bIsTemporary;
    private int _ideContainerType = -1;

    public FocusHierarchyEvent(FocusEvent fe) {
        super(fe.getSource(), fe.getID() == 1004 ? 3708 : 3709);
        this.buildHierarchy(fe.getComponent());
        this._bIsTemporary = fe.isTemporary();
    }

    private void buildHierarchy(Component c) {
        ArrayList<Component> list = new ArrayList<Component>(10);
        while (c != null) {
            list.add(c);
            if (c instanceof Window) {
                c = null;
                continue;
            }
            c = c.getParent();
        }
        this.setHierarchy(list);
    }

    public ArrayList<Component> getHierarchy() {
        return this._hierarchy;
    }

    private void setHierarchy(ArrayList<Component> list) {
        this._hierarchy = list;
        this._set = new HashSet<Component>(this._hierarchy);
    }

    public boolean isTemporary() {
        return this._bIsTemporary;
    }

    public boolean contains(Component c) {
        return this._set.contains(c);
    }

    public Window top() {
        int n;
        Component c;
        Window w = null;
        if (!this._hierarchy.isEmpty() && (c = this._hierarchy.get((n = this._hierarchy.size()) - 1)) instanceof Window) {
            w = (Window)c;
        }
        return w;
    }

    public Component getFocusComponent() {
        return this._hierarchy.get(0);
    }

    public int getIdeContainerType() {
        if (this._ideContainerType == -1) {
            int n = this._hierarchy.size();
            for (int i = 0; i < n; ++i) {
                Component c = this._hierarchy.get(i);
                if (c instanceof JDesktopPane) {
                    this._ideContainerType = 1;
                    break;
                }
                if (!(c instanceof DockableContainer)) continue;
                this._ideContainerType = 2;
                break;
            }
            if (this._ideContainerType == -1) {
                this._ideContainerType = 0;
            }
        }
        return this._ideContainerType;
    }
}

