/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls.elementtree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import oracle.ide.controls.elementtree.ElementCellRenderer;
import oracle.ide.controls.elementtree.ElementTree;
import oracle.ide.controls.elementtree.ElementTreeNode;
import oracle.ide.controls.elementtree.ElementTreeRootNode;
import oracle.ide.controls.elementtree.ShowMoreElement;
import oracle.ideimpl.resource.IdeImplArb;
import oracle.javatools.icons.OracleIcons;

final class PagingElementTree
extends ElementTree {
    private static final String SHOWMORE_TOOLTIP = IdeImplArb.getString(99);
    private final Cursor defaultCursor;

    public PagingElementTree(ElementTreeRootNode root) {
        super(root);
        this.setCellRenderer(new PCR());
        this.defaultCursor = this.getCursor();
        this.addMouseMotionListener(new MML());
    }

    private final class MML
    extends MouseMotionAdapter {
        boolean wasSet = false;

        private MML() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            TreePath path;
            int rowLocation = PagingElementTree.this.getRowForLocation(e.getX(), e.getY());
            PagingElementTree tree = PagingElementTree.this;
            if (rowLocation > -1 && (path = PagingElementTree.this.getPathForRow(rowLocation)) != null && ((ElementTreeNode)path.getLastPathComponent()).getElement() instanceof ShowMoreElement) {
                tree.repaint();
                tree.setCursor(Cursor.getPredefinedCursor(12));
                this.wasSet = true;
                return;
            }
            if (this.wasSet) {
                tree.setCursor(tree.defaultCursor);
                tree.repaint();
                this.wasSet = false;
            }
        }
    }

    private class PCR
    extends DefaultTreeCellRenderer {
        private final ElementCellRenderer delegate = new ElementCellRenderer();

        private PCR() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            boolean isPagingNode = ((ElementTreeNode)value).getElement() instanceof ShowMoreElement;
            if (isPagingNode) {
                ShowMoreElement show = (ShowMoreElement)((ElementTreeNode)value).getElement();
                JLabel c = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (!show.loading()) {
                    PagingElementTree t = PagingElementTree.this;
                    if (t.getCursor() != PagingElementTree.this.defaultCursor) {
                        c.setText("<html><u>" + c.getText() + "</u></html>");
                    }
                } else {
                    c.setForeground(this.delegate.getTextNonSelectionColor());
                }
                return c;
            }
            return this.delegate.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        }

        @Override
        public Color getTextNonSelectionColor() {
            return Color.blue;
        }

        @Override
        public Color getBackgroundSelectionColor() {
            return Color.white;
        }

        @Override
        public Color getTextSelectionColor() {
            return Color.blue;
        }

        @Override
        public String getToolTipText() {
            return SHOWMORE_TOOLTIP;
        }

        @Override
        public Icon getIcon() {
            return OracleIcons.getIcon((String)"Empty.gif");
        }
    }
}

