/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.docking;

import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableWindow;
import oracle.ide.docking.DrawerConfig;
import oracle.ide.docking.DrawerWindow;
import oracle.ide.view.View;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.docking.ProxyDockable;

final class DrawerDecorator
extends DockableWindow {
    private String tabName;
    private String uniqueName;
    private DrawerWindow drawerWindow;
    private DrawerConfig config;

    static DrawerDecorator decorate(View toDecorate, DrawerConfig config, DrawerWindow drawerWindow) {
        if (!(toDecorate instanceof DrawerDecorator)) {
            return new DrawerDecorator(toDecorate, config, drawerWindow);
        }
        DrawerDecorator decorator = (DrawerDecorator)toDecorate;
        decorator.applyConfig(config);
        return decorator;
    }

    private DrawerDecorator(View decorated, DrawerConfig config, DrawerWindow drawerWindow) {
        super(decorated);
        this.applyConfig(config);
        this.drawerWindow = drawerWindow;
        this.config = config;
    }

    private void applyConfig(DrawerConfig config) {
        String tabName;
        if (config != null) {
            this.tabName = config.tabName();
            this.uniqueName = config.uniqueName();
        }
        if ((tabName = this.getDecorated().getTabName()) != null) {
            this.tabName = tabName;
        }
    }

    @Override
    public String getTabName() {
        return this.tabName;
    }

    @Override
    public String getTitleName() {
        return null;
    }

    @Override
    public String getUniqueName() {
        return this.uniqueName;
    }

    @Override
    public int getType() {
        return this.getDecorated() instanceof Dockable ? ((Dockable)((Object)this.getDecorated())).getType() : super.getType();
    }

    boolean replaceProxyDrawer() {
        View view = this.getDecorated();
        if (view instanceof ProxyDockable) {
            this.drawerWindow.removeIfPresent(view);
            ((ProxyDockable)view).markAsDrawer(this.drawerWindow);
            View rView = (View)((Object)DockStationImpl.getInstance().swapDockable((Dockable)((Object)view)));
            this.drawerWindow.addDrawer(rView, this.config);
            this.drawerWindow.restore(rView);
            return true;
        }
        return false;
    }
}

