/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.explorer;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ide.util.MetaClass;
import oracle.ide.explorer.IconOverlayCoordinator;
import oracle.ide.explorer.IconOverlayTracker;

public final class IconOverlayRegistry {
    private static final Map<String, IconOverlayCoordinator> _registry = new ConcurrentHashMap<String, IconOverlayCoordinator>();

    private IconOverlayRegistry() {
    }

    public static final IconOverlayCoordinator registerOverlayCoordinator(String extensionId, String infoTypeId, int batchSize, MetaClass<? extends IconOverlayTracker> trackerClass) {
        IconOverlayCoordinator coordinator = new IconOverlayCoordinator(extensionId, infoTypeId, batchSize, trackerClass);
        coordinator.attachToConsumers();
        _registry.put(IconOverlayRegistry.createCoordinatorKey(extensionId, infoTypeId), coordinator);
        return coordinator;
    }

    public static final IconOverlayCoordinator lookupOverlayCoordinator(String extensionId) {
        for (Map.Entry<String, IconOverlayCoordinator> entry : _registry.entrySet()) {
            if (!entry.getKey().startsWith(extensionId + '\u0000')) continue;
            return entry.getValue();
        }
        return null;
    }

    public static final IconOverlayCoordinator lookupOverlayCoordinator(String extensionId, String infoTypeId) {
        return _registry.get(IconOverlayRegistry.createCoordinatorKey(extensionId, infoTypeId));
    }

    private static final String createCoordinatorKey(String extensionId, String infoTypeId) {
        return extensionId + '\u0000' + infoTypeId;
    }
}

