/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.extension;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ElementVisitorFactory;
import javax.ide.extension.spi.ExtensionLogRecord;
import javax.ide.net.URIFactory;
import javax.ide.net.VirtualFileSystem;
import oracle.ide.util.NameValuePair;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;

public final class HashStructureElementVisitor
extends ElementVisitor {
    static final String TEXT_KEY = "#text";
    static final String EXTENSION_ID_KEY = "#__extension-id";
    static final String ELEMENT_COUNT_KEY = "#__element-count";
    private final HashStructure _root;
    private final EV _recursiveVisitor;

    public HashStructureElementVisitor() {
        this(HashStructure.newInstance());
    }

    public HashStructureElementVisitor(HashStructure root) {
        this._root = root != null ? root : HashStructure.newInstance();
        this._recursiveVisitor = new EV(this._root);
    }

    public final HashStructure getHashStructure() {
        return this._root;
    }

    public final void start(ElementStartContext context) {
        this._recursiveVisitor.start(context);
        context.registerVisitorFactory((ElementVisitorFactory)this._recursiveVisitor);
    }

    public final void end(ElementEndContext context) {
        this._recursiveVisitor.end(context);
    }

    public void merge(final HashStructureElementVisitor separateElementVisitor) {
        if (separateElementVisitor == this) {
            throw new IllegalArgumentException("Cannot call visitor.merge() passing the same visitor instance");
        }
        Runnable mergeRunnable = new Runnable(){

            @Override
            public void run() {
                HashStructure newElementData = separateElementVisitor.getHashStructure();
                Set keys = newElementData.keySet();
                for (String key : keys) {
                    Object srcObject = newElementData.getObject(key);
                    ArrayList<Object> childrenToAddForKey = new ArrayList<Object>(2);
                    if (srcObject instanceof ListStructure) {
                        ListStructure srcList = (ListStructure)srcObject;
                        childrenToAddForKey.addAll((Collection<Object>)srcList);
                    } else {
                        childrenToAddForKey.add(srcObject);
                    }
                    for (Object e : childrenToAddForKey) {
                        if (e instanceof HashStructure) {
                            HashStructure childHash = (HashStructure)e;
                            HashStructure childCopy = HashStructure.newInstance();
                            childHash.copyTo(childCopy);
                            if (HashStructureElementVisitor.this._root.containsKey(key)) {
                                Object rootObj = HashStructureElementVisitor.this._root.getObject(key);
                                if (rootObj instanceof ListStructure) {
                                    ListStructure existingList = (ListStructure)rootObj;
                                    existingList.add((Object)childCopy);
                                    continue;
                                }
                                ListStructure newList = ListStructure.newInstance();
                                newList.add(rootObj);
                                newList.add((Object)childCopy);
                                HashStructureElementVisitor.this._root.putListStructure(key, newList);
                                continue;
                            }
                            HashStructureElementVisitor.this._root.putHashStructure(key, childCopy);
                            continue;
                        }
                        boolean copySimpleValue = true;
                        if (HashStructureElementVisitor.TEXT_KEY.equals(key) && HashStructureElementVisitor.this._root.containsKey(HashStructureElementVisitor.TEXT_KEY)) {
                            copySimpleValue = false;
                        }
                        if (!copySimpleValue) continue;
                        String[] keyArr = new String[]{key};
                        newElementData.copyTo(HashStructureElementVisitor.this._root, keyArr);
                    }
                }
            }
        };
        this._root.applyBatchChanges(mergeRunnable);
    }

    boolean isElementCounterOn() {
        return this._recursiveVisitor._elementCounterOn;
    }

    int getElementCount() {
        return this._recursiveVisitor._elementCounter;
    }

    void setElementCount(int count) {
        this._recursiveVisitor._elementCounter = count;
    }

    public void turnElementCounterOn() {
        this._recursiveVisitor._elementCounterOn = true;
    }

    Collection<NameValuePair<HashStructure>> getOrderedElements(HashStructure hash) {
        TreeSet<NameValuePair<HashStructure>> set = new TreeSet<NameValuePair<HashStructure>>(new HashStructureComparator());
        if (!this._recursiveVisitor._elementCounterOn) {
            return set;
        }
        Set keys = hash.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            String key = iter.next().toString();
            List list = hash.getAsList(key);
            if (list == null) continue;
            for (int i = 0; i < list.size(); ++i) {
                Object item = list.get(i);
                if (!(item instanceof HashStructure)) continue;
                set.add(new NameValuePair<HashStructure>(key, (HashStructure)item));
            }
        }
        return set;
    }

    void cleanup() {
        this._recursiveVisitor.cleanup();
    }

    private static final class EV
    extends ElementVisitor
    implements ElementVisitorFactory {
        private int _elementCounter;
        private boolean _elementCounterOn;
        private HashStructure _parent;
        private final LinkedList _stack = new LinkedList();
        private URI _currentSourceURI = null;

        EV(HashStructure root) {
            this._parent = root;
        }

        public final ElementVisitor getVisitor(ElementName name) {
            return this;
        }

        public final void start(ElementStartContext context) {
            HashStructure currentHash;
            URI sourceURI = context.getExtensionSourceURI();
            if (!sourceURI.equals(this._currentSourceURI)) {
                this._stack.clear();
                this._currentSourceURI = sourceURI;
            }
            if (this._stack.isEmpty()) {
                currentHash = this._parent;
                this.countElement(currentHash);
            } else {
                currentHash = HashStructure.newInstance();
                currentHash.putString(HashStructureElementVisitor.EXTENSION_ID_KEY, context.getExtension().getID());
                this.countElement(currentHash);
            }
            Collection attrNames = context.getAttributeNames();
            if (attrNames != null) {
                for (String name : attrNames) {
                    String value = context.getAttributeValue(name);
                    if (value == null) continue;
                    String resolvedValue = value.trim();
                    this.putStringOrURL((ElementContext)context, currentHash, name, resolvedValue);
                }
            }
            if (!this._stack.isEmpty()) {
                ElementName elemName = context.getElementName();
                String localName = elemName.getLocalName();
                if (this._parent.containsKey(localName)) {
                    ListStructure list;
                    Object obj = this._parent.getObject(localName);
                    if (obj instanceof ListStructure) {
                        list = (ListStructure)obj;
                        list.add((Object)currentHash);
                    } else {
                        list = ListStructure.newInstance();
                        list.add(obj);
                        list.add((Object)currentHash);
                        this._parent.putListStructure(localName, list);
                    }
                } else {
                    this._parent.putHashStructure(localName, currentHash);
                }
            }
            this._stack.addLast(this._parent);
            this._parent = currentHash;
        }

        public final void end(ElementEndContext context) {
            String trimmed;
            String text = context.getText();
            if (text != null && text.length() > 0 && !this._parent.containsKey(HashStructureElementVisitor.TEXT_KEY) && (trimmed = text.trim()).length() > 0) {
                this.putStringOrURL((ElementContext)context, this._parent, HashStructureElementVisitor.TEXT_KEY, trimmed);
            }
            if (this._stack.isEmpty()) {
                ExtensionLogRecord message = new ExtensionLogRecord((ElementContext)context, Level.SEVERE, "Unbalanced start/end calls in HashStructureElementVisitor while processing " + context.getElementName() + " in " + context.getExtensionSourceURI());
                context.getLogger().log((LogRecord)message);
            } else {
                this._parent = (HashStructure)this._stack.removeLast();
            }
        }

        void cleanup() {
            this._stack.clear();
            this._currentSourceURI = null;
        }

        private void countElement(HashStructure hash) {
            if (this._elementCounterOn) {
                hash.putInt(HashStructureElementVisitor.ELEMENT_COUNT_KEY, this._elementCounter++);
            }
        }

        private void putStringOrURL(ElementContext context, HashStructure hash, String name, String resolvedValue) {
            if (resolvedValue.startsWith("uri:")) {
                String path = resolvedValue.substring(4);
                URI uri = URIFactory.newURI((String)path);
                if (uri != null) {
                    try {
                        URL url = VirtualFileSystem.getVirtualFileSystem().toURL(uri);
                        hash.putURL(name, url);
                    }
                    catch (MalformedURLException mue) {
                        this.log(context, Level.WARNING, "Malformed URL exception for attribute '" + name + "' using path='" + path + "'.");
                        hash.putString(name, resolvedValue);
                    }
                }
            } else {
                hash.putString(name, resolvedValue);
            }
        }
    }

    static class HashStructureComparator
    implements Comparator<NameValuePair<HashStructure>> {
        HashStructureComparator() {
        }

        @Override
        public int compare(NameValuePair<HashStructure> o1, NameValuePair<HashStructure> o2) {
            int i2;
            int i1 = o1.getValue().getInt(HashStructureElementVisitor.ELEMENT_COUNT_KEY, -1);
            if (i1 < (i2 = o2.getValue().getInt(HashStructureElementVisitor.ELEMENT_COUNT_KEY, -1))) {
                return -1;
            }
            if (i1 > i2) {
                return 1;
            }
            return 0;
        }
    }
}

