/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.extension.rules.functions;

import java.util.List;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.extension.rules.RuleEvaluationContext;
import oracle.ide.extension.rules.RuleEvaluationException;
import oracle.ide.extension.rules.RuleFunction;
import oracle.ide.extension.rules.RuleFunctionParameter;
import oracle.ide.model.ContentSet;
import oracle.ide.model.ContentSetProviderReference;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.util.Assert;

public final class ProjectHasContent
extends RuleFunction {
    private static final String CONTENT_SET_KEY_PARAM_NAME = "content-set-key";

    @Override
    public boolean evaluate(RuleEvaluationContext ruleContext, Map<String, RuleFunctionParameter> parameters) throws RuleEvaluationException {
        RuleFunctionParameter param = this.getRequiredParameterOrThrow(parameters, CONTENT_SET_KEY_PARAM_NAME);
        String contentSetKey = param.getValue();
        if (!this.validKey(contentSetKey)) {
            throw new RuleEvaluationException("RuleFunction: " + this.getClass().getName() + " called with unknown content set provider key: " + contentSetKey);
        }
        Context context = ruleContext.getIdeContext();
        Project project = context.getProject();
        if (project != null) {
            Assert.println((!project.isLoaded() ? 1 : 0) != 0, (String)"ProjectHasContent rule causes project to load.");
            ContentSet contentSet = ProjectContent.getInstance(project).getContentSet(contentSetKey);
            return !contentSet.getFiles("").isEmpty() || this.checkFoldersForContent(contentSet, "");
        }
        return false;
    }

    private boolean checkFoldersForContent(ContentSet contentSet, String relPath) {
        List directories = contentSet.getDirectories(relPath);
        for (String dirPath : directories) {
            if (!contentSet.getFiles(dirPath).isEmpty()) {
                return true;
            }
            if (!this.checkFoldersForContent(contentSet, dirPath)) continue;
            return true;
        }
        return false;
    }

    private boolean validKey(String contentSetKey) {
        ContentSetProviderReference[] refs;
        for (ContentSetProviderReference ref : refs = ProjectContent.getContentSetProviderReferences()) {
            if (!contentSetKey.equals(ref.key())) continue;
            return true;
        }
        return false;
    }
}

