/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.ResKeystrokeContext;
import oracle.ide.keyboard.ResKeystrokeReader;
import oracle.ide.keyboard.XMLKeyStrokeContext;
import oracle.ide.keyboard.XMLKeystrokeContextDefs;
import oracle.ide.util.CollectionEvent;
import oracle.ide.util.CollectionListener;
import oracle.javatools.util.ModelUtil;
import org.xml.sax.SAXException;

public final class KeyStrokeContextRegistry {
    private final List<KeyStrokeContext> _allContexts = new ArrayList<KeyStrokeContext>();
    private final List<ResKeystrokeContext> _resContexts = new ArrayList<ResKeystrokeContext>(50);
    private List<CollectionListener> _listeners;
    private boolean _acceleratorDefinitionFilesLoaded = false;

    public void addListener(CollectionListener l) {
        if (this._listeners == null) {
            this._listeners = new ArrayList<CollectionListener>(1);
        }
        this._listeners.add(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(CollectionListener l) {
        if (this._listeners != null) {
            List<CollectionListener> list = this._listeners;
            synchronized (list) {
                this._listeners.remove(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(int nID, KeyStrokeContext ksc) {
        if (this._listeners != null) {
            CollectionEvent e = null;
            List<CollectionListener> list = this._listeners;
            synchronized (list) {
                for (CollectionListener l : this._listeners) {
                    if (e == null) {
                        e = new CollectionEvent(nID, this, ksc);
                    }
                    switch (nID) {
                        case 1: {
                            l.elementAdded(e);
                            break;
                        }
                        case 2: {
                            l.elementRemoved(e);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContext(KeyStrokeContext ksc) {
        if (!this.isContextInAllContextList(ksc)) {
            XMLKeyStrokeContext xmlKeyStrokeContext;
            String filename;
            List<KeyStrokeContext> list = this._allContexts;
            synchronized (list) {
                this._allContexts.add(ksc);
            }
            if (ksc instanceof XMLKeyStrokeContext && (filename = (xmlKeyStrokeContext = (XMLKeyStrokeContext)ksc).getAcceleratorFile()) != null) {
                XMLKeystrokeContextDefs instance = XMLKeystrokeContextDefs.getInstance();
                Class<?> cls = xmlKeyStrokeContext.getClass();
                ClassLoader classLoader = cls.getClassLoader();
                instance.addAcceleratorFile(classLoader, filename);
            }
            this.fireEvent(1, ksc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContext(KeyStrokeContext ksc) {
        List<KeyStrokeContext> list = this._allContexts;
        synchronized (list) {
            if (this._allContexts.contains(ksc)) {
                this._allContexts.remove(ksc);
                this.fireEvent(2, ksc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAcceleratorDefinitionFile(ClassLoader classLoader, String fileName) {
        ResKeystrokeContext resKeystrokeContext = new ResKeystrokeContext(classLoader, fileName);
        List<ResKeystrokeContext> list = this._resContexts;
        synchronized (list) {
            this._resContexts.add(resKeystrokeContext);
        }
        this.addContext(resKeystrokeContext);
        this._acceleratorDefinitionFilesLoaded = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAcceleratorDefinitionFile(ClassLoader classLoader, String fileName) {
        List<ResKeystrokeContext> list = this._resContexts;
        synchronized (list) {
            for (int i = this._resContexts.size() - 1; i >= 0; --i) {
                ResKeystrokeContext resKeystrokeContext = this._resContexts.get(i);
                if (resKeystrokeContext.getClassLoader() != classLoader || !ModelUtil.areEqual((Object)resKeystrokeContext.getName(), (Object)fileName)) continue;
                ResKeystrokeContext foundContext = this._resContexts.remove(i);
                this.removeContext(foundContext);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadAcceleratorDefinitionFiles() {
        if (!this._acceleratorDefinitionFilesLoaded) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            try {
                SAXParser saxParser = factory.newSAXParser();
                ResKeystrokeReader resKeystrokeReader = new ResKeystrokeReader(saxParser);
                List<ResKeystrokeContext> list = this._resContexts;
                synchronized (list) {
                    for (ResKeystrokeContext resKeystrokeContext : this._resContexts) {
                        resKeystrokeContext.load(resKeystrokeReader);
                    }
                }
                this._acceleratorDefinitionFilesLoaded = true;
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStrokeContext getContext(String sName) {
        List<KeyStrokeContext> list = this._allContexts;
        synchronized (list) {
            for (KeyStrokeContext ksc : this._allContexts) {
                if (!sName.equalsIgnoreCase(ksc.getName())) continue;
                return ksc;
            }
            return null;
        }
    }

    public Stream<KeyStrokeContext> getAllContextsStream() {
        return this._allContexts.stream();
    }

    public Iterator getAllContexts() {
        return this._allContexts.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getAllPresets() {
        HashSet<String> set = new HashSet<String>();
        List<KeyStrokeContext> list = this._allContexts;
        synchronized (list) {
            for (KeyStrokeContext ksc : this._allContexts) {
                List lKscPresets = ksc.getAllPresets();
                if (lKscPresets == null) continue;
                for (Object o : lKscPresets) {
                    String sPreset = o.toString();
                    set.add(sPreset);
                }
            }
        }
        return set;
    }

    static Object searchPreset(KeyStrokeContext ksc, String sName) {
        Object ret = null;
        List list = ksc.getAllPresets();
        if (list != null) {
            int n = list.size();
            for (int i = 0; ret == null && i < n; ++i) {
                Object o = list.get(i);
                if (!o.equals(sName)) continue;
                ret = o;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isContextInAllContextList(KeyStrokeContext ksc) {
        if (this._allContexts != null) {
            String sKscName = ksc.getName();
            List<KeyStrokeContext> list = this._allContexts;
            synchronized (list) {
                for (KeyStrokeContext kscList : this._allContexts) {
                    String sKscListName = kscList.getName();
                    if (!sKscName.equals(sKscListName)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

