/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.KeyStroke;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.keyboard.KeyStroke2String;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.util.Assert;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;

class KeyStrokeProfile
extends HashStructureAdapter {
    private static final String NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"user-defined-keystrokes-profile");
    private static final String ROOT_TAG = "profile";
    private static final String CONTEXT_LIST_KEY = "contexts";
    private static final String CONTEXT_NAME_KEY = "context";
    private static final String CONTEXT_MAPPINGS_KEY = "mappings";
    private static final String ACTION_KEY = "action";
    private static final String GLOBAL_SCOPE_KEY = "global";
    private static final String KEYSTROKES_LIST_KEY = "key-strokes";
    private static final String KEYSTROKE_1_KEY = "key-1";
    private static final String KEYSTROKE_2_KEY = "key-2";

    private KeyStrokeProfile(HashStructure hash) {
        super(hash);
    }

    static KeyStrokeProfile newProfileForExport(KeyStrokeContextRegistry registry, KeyStrokeOptions kso) {
        KeyStrokeProfile profile = new KeyStrokeProfile(HashStructure.newInstance());
        KeyStrokeProfile.buildProfile(registry, kso, profile);
        return profile;
    }

    private static void buildProfile(KeyStrokeContextRegistry registry, KeyStrokeOptions kso, KeyStrokeProfile profile) {
        KeyStrokeMap globalKeyMap = kso.getGlobalKeyMap();
        Iterator contextIterator = registry.getAllContexts();
        while (contextIterator.hasNext()) {
            KeyStrokeContext ksContext = (KeyStrokeContext)contextIterator.next();
            String context = ksContext.getName();
            KeyStrokeMap localKeyMap = kso.getLocalKeyMap(ksContext);
            for (int i = 0; i < 2; ++i) {
                Set actions;
                KeyStrokeMap keyStrokeMap;
                boolean global = i == 0;
                KeyStrokeMap keyStrokeMap2 = keyStrokeMap = global ? globalKeyMap : localKeyMap;
                if (keyStrokeMap == null || (actions = ksContext.getAllActions(global)) == null || actions.isEmpty()) continue;
                for (Action a : actions) {
                    IdeAction ia;
                    int cmdId;
                    if (!(a instanceof IdeAction) || (cmdId = (ia = (IdeAction)a).getCommandId()) == -1) continue;
                    IdeAction ideAction = IdeAction.find(cmdId);
                    if (ideAction != null) {
                        Context aContext = profile.getOrCreateContext(context);
                        String actionName = Ide.findCmdName(ideAction.getCommandId());
                        List<KeyStrokes> keysForAction = keyStrokeMap.getKeyStrokesFor((Integer)cmdId);
                        if (keysForAction.isEmpty()) continue;
                        for (KeyStrokes keystrokes : keysForAction) {
                            if (keystrokes == null || keystrokes.getLength() <= 0) continue;
                            Mapping mapping = aContext.getOrCreateMapping(actionName);
                            mapping.setGlobal(global);
                            mapping.addKeyStrokes(keystrokes);
                        }
                        continue;
                    }
                    System.out.println(a.getValue("Name") + (global ? "" : " (local)") + " was not found by IdeAction.find()");
                }
            }
        }
    }

    private Context getOrCreateContext(String name) {
        ListStructure listStructure = this._hash.getOrCreateListStructure(CONTEXT_LIST_KEY);
        for (int i = 0; i < listStructure.size(); ++i) {
            HashStructure hash = (HashStructure)listStructure.get(i);
            if (hash.containsKey(CONTEXT_NAME_KEY)) {
                if (!name.equals(hash.getString(CONTEXT_NAME_KEY))) continue;
                return Context.getInstance(hash);
            }
            Assert.printStackTrace((String)"HashStructure missing key context");
        }
        HashStructure contextHash = HashStructure.newInstance();
        listStructure.add((Object)contextHash);
        Context instance = Context.getInstance(contextHash);
        instance.setName(name);
        return instance;
    }

    void exportTo(URL url) throws IOException {
        HashStructureIO io = new HashStructureIO(NAMESPACE_URI, ROOT_TAG);
        io.save(url, (Object)this._hash);
    }

    static KeyStrokeProfile importFrom(URL url) throws IOException {
        HashStructureIO io = new HashStructureIO(NAMESPACE_URI, ROOT_TAG);
        KeyStrokeProfile profile = new KeyStrokeProfile((HashStructure)io.load(url));
        return profile;
    }

    List<String> getAllContexts() {
        if (this._hash.containsKey(CONTEXT_LIST_KEY)) {
            ArrayList<String> results = new ArrayList<String>();
            ListStructure contextList = this._hash.getListStructure(CONTEXT_LIST_KEY);
            for (int i = 0; i < contextList.size(); ++i) {
                HashStructure contextHash = (HashStructure)contextList.get(i);
                Context context = Context.getInstance(contextHash);
                results.add(context.getName());
            }
            return results;
        }
        return Collections.emptyList();
    }

    KeyStrokeMap getKeyStrokeMapForContext(Object contextName, boolean global) {
        if (this._hash.containsKey(CONTEXT_LIST_KEY)) {
            KeyStrokeMap map = new KeyStrokeMap();
            ListStructure contextList = this._hash.getListStructure(CONTEXT_LIST_KEY);
            for (int i = 0; i < contextList.size(); ++i) {
                HashStructure contextHash = (HashStructure)contextList.get(i);
                Context context = Context.getInstance(contextHash);
                if (!contextName.equals(context.getName())) continue;
                ListStructure mappingList = context.getMappings();
                for (int j = 0; j < mappingList.size(); ++j) {
                    String actionName;
                    List kssList;
                    HashStructure mappingHash = (HashStructure)mappingList.get(j);
                    Mapping m = Mapping.getInstance(mappingHash);
                    if (m.isGlobal() != global || (kssList = m.getKeyStrokes()).isEmpty() || (actionName = m.getAction()) == null) continue;
                    for (KeyStrokes kss : kssList) {
                        map.addMap(kss, actionName);
                    }
                }
                break;
            }
            if (map.getData().size() > 0) {
                return map;
            }
        }
        return null;
    }

    private static class Context
    extends HashStructureAdapter {
        private Context(HashStructure hash) {
            super(hash);
        }

        static Context getInstance(HashStructure hash) {
            return new Context(hash);
        }

        String getName() {
            return this._hash.getString(KeyStrokeProfile.CONTEXT_NAME_KEY);
        }

        void setName(String name) {
            this._hash.putString(KeyStrokeProfile.CONTEXT_NAME_KEY, name);
        }

        ListStructure getMappings() {
            return this._hash.getOrCreateListStructure(KeyStrokeProfile.CONTEXT_MAPPINGS_KEY);
        }

        private Mapping getOrCreateMapping(String actionName) {
            ListStructure mapList = this.getMappings();
            if (!mapList.isEmpty()) {
                for (int i = 0; i < mapList.size(); ++i) {
                    HashStructure mapHash = (HashStructure)mapList.get(i);
                    if (!mapHash.containsKey(KeyStrokeProfile.ACTION_KEY) || !actionName.equals(mapHash.getString(KeyStrokeProfile.ACTION_KEY))) continue;
                    return Mapping.getInstance(mapHash);
                }
            }
            HashStructure newHash = HashStructure.newInstance();
            mapList.add((Object)newHash);
            Mapping mapping = Mapping.getInstance(newHash);
            mapping.setAction(actionName);
            return mapping;
        }
    }

    private static class Accelerator
    extends HashStructureAdapter {
        private Accelerator(HashStructure hash) {
            super(hash);
        }

        private static Accelerator getInstance(HashStructure hash) {
            return new Accelerator(hash);
        }

        void setKeyStrokes(KeyStrokes keystrokes) {
            int size = keystrokes.getLength();
            if (size >= 1) {
                this._hash.putString(KeyStrokeProfile.KEYSTROKE_1_KEY, KeyStroke2String.toString(keystrokes.getKeyStroke(0)));
            }
            if (size == 2) {
                this._hash.putString(KeyStrokeProfile.KEYSTROKE_2_KEY, KeyStroke2String.toString(keystrokes.getKeyStroke(1)));
            }
        }

        private KeyStrokes getKeyStrokes() {
            KeyStrokes kss = new KeyStrokes();
            this.addKeyStrokes(kss);
            return kss;
        }

        private void addKeyStrokes(KeyStrokes kss) {
            KeyStroke key1 = this.getKeyStroke(KeyStrokeProfile.KEYSTROKE_1_KEY);
            if (key1 != null) {
                kss.add(key1);
                KeyStroke key2 = this.getKeyStroke(KeyStrokeProfile.KEYSTROKE_2_KEY);
                if (key2 != null) {
                    kss.add(key2);
                }
            }
        }

        private KeyStroke getKeyStroke(String whichKey) {
            KeyStroke ks;
            String shortcut = this._hash.getString(whichKey);
            if (shortcut != null && (ks = KeyStroke2String.fromString(shortcut)) != null) {
                return ks;
            }
            return null;
        }
    }

    private static class Mapping
    extends HashStructureAdapter {
        private Mapping(HashStructure hash) {
            super(hash);
        }

        private static Mapping getInstance(HashStructure hash) {
            return new Mapping(hash);
        }

        String getAction() {
            return this._hash.getString(KeyStrokeProfile.ACTION_KEY);
        }

        boolean isGlobal() {
            return this._hash.getBoolean(KeyStrokeProfile.GLOBAL_SCOPE_KEY);
        }

        void setAction(String action) {
            this._hash.putString(KeyStrokeProfile.ACTION_KEY, action);
        }

        void setGlobal(boolean global) {
            this._hash.putBoolean(KeyStrokeProfile.GLOBAL_SCOPE_KEY, global);
        }

        private void addKeyStrokes(KeyStrokes keystrokes) {
            ListStructure listStructure = this._hash.getOrCreateListStructure(KeyStrokeProfile.KEYSTROKES_LIST_KEY);
            HashStructure keyStrokesHash = HashStructure.newInstance();
            listStructure.add((Object)keyStrokesHash);
            Accelerator acc = Accelerator.getInstance(keyStrokesHash);
            acc.setKeyStrokes(keystrokes);
        }

        private List<KeyStrokes> getKeyStrokes() {
            if (!this._hash.containsKey(KeyStrokeProfile.KEYSTROKES_LIST_KEY)) {
                return Collections.emptyList();
            }
            ArrayList<KeyStrokes> results = new ArrayList<KeyStrokes>();
            ListStructure ksList = this._hash.getListStructure(KeyStrokeProfile.KEYSTROKES_LIST_KEY);
            for (int i = 0; i < ksList.size(); ++i) {
                HashStructure keyStrokesHash = (HashStructure)ksList.get(i);
                Accelerator accel = Accelerator.getInstance(keyStrokesHash);
                KeyStrokes kss = accel.getKeyStrokes();
                if (kss == null) continue;
                results.add(kss);
            }
            return results;
        }
    }
}

