/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.log;

import java.awt.Component;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.controller.Controller;
import oracle.ide.docking.DockStation;
import oracle.ide.layout.ViewId;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogOwner;
import oracle.ide.log.LogPage;
import oracle.ide.log.LogWindow;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.View;

public abstract class AbstractLogPage
extends View
implements LogPage {
    private Icon _icon;
    private String _name;

    protected AbstractLogPage(String viewId, String displayName, Icon icon, boolean addPage) {
        super(viewId);
        this._icon = icon;
        this._name = displayName;
        if (addPage) {
            AbstractLogPage._addPage(this);
        }
    }

    protected AbstractLogPage(ViewId viewId, Icon icon, boolean addPage) {
        this(viewId.getId(), viewId.getDisplayName(), icon, addPage);
    }

    protected AbstractLogPage(ViewId viewId, Icon icon) {
        this(viewId, icon, true);
    }

    protected AbstractLogPage(ViewId viewId) {
        this(viewId, null);
    }

    @Override
    public void log(Object msg) {
        this.log(msg, false);
    }

    public void log(Object msg, boolean forceDisplay) {
        this.requestShow(forceDisplay);
        this.logMsg(msg);
    }

    public void logQuietly(Object msg) {
        this.logMsg(msg);
    }

    @Override
    public void clearAll() {
    }

    @Override
    public String getTitleName() {
        return this.getTabName();
    }

    @Override
    public String getTabName() {
        return this._name;
    }

    public void tabNameUpdated() {
        LogWindow lw = LogManager.getIdeLogWindow();
        if (lw != null) {
            lw.updateTitle(null);
            lw.updateTabTitle(this, this.getTabName());
        }
    }

    @Override
    public Icon getTabIcon() {
        return this._icon;
    }

    @Override
    public String getToolTip() {
        return this.getTabName();
    }

    @Override
    public void setOwner(LogOwner owner) {
        View logOwnerView = null;
        if (owner != null) {
            logOwnerView = owner.getLogOwnerView();
        }
        super.setOwner(logOwnerView);
    }

    @Override
    public void addMouseListener(MouseListener listener) {
    }

    @Override
    public void removeMouseListener(MouseListener listener) {
    }

    @Override
    public View getLogPageView() {
        return this;
    }

    public boolean isDisplayComponentScrollable() {
        return false;
    }

    public Component getTopComponent() {
        return this.getLogPageView().getToolbar();
    }

    public Component getBottomComponent() {
        return null;
    }

    protected void logMsg(Object msg) {
    }

    protected void requestShow(final boolean forceDisplay) {
        if (!IdeUtil.isHeadless()) {
            final AbstractLogPage logPage = this;
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    LogOwner logOwner = (LogOwner)((Object)AbstractLogPage.this.owner());
                    LogWindow logWindow = LogManager.getIdeLogWindow();
                    if (!forceDisplay && logOwner != null && (DockStation.getDockStation().isDockableVisible(logWindow) || logWindow.isClosed())) {
                        logOwner.highlightPage(logPage);
                    } else if (forceDisplay || logOwner == null) {
                        AbstractLogPage.this.show();
                    } else {
                        logOwner.highlightPage(logPage);
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runner.run();
            } else {
                SwingUtilities.invokeLater(runner);
            }
        }
    }

    protected void requestShow() {
        this.requestShow(false);
    }

    private static void _addPage(final AbstractLogPage page) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                LogManager logManager = LogManager.getLogManager();
                if (logManager != null) {
                    logManager.addPage(page);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runner.run();
        } else {
            try {
                SwingUtilities.invokeLater(runner);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public Controller getController() {
        if (this.owner() != null) {
            return this.owner().getController();
        }
        return null;
    }

    @Override
    public void show() {
        if (this.owner() == null) {
            LogManager.getLogManager().addPage(this);
        }
        if (!IdeUtil.isHeadless()) {
            ((LogOwner)((Object)this.owner())).selectPage(this);
            LogWindow logWindow = LogManager.getIdeLogWindow();
            LogPage currentLogPage = logWindow.getPage();
            if (currentLogPage != null && currentLogPage == this && logWindow.isVisible()) {
                return;
            }
            DockStation.getDockStation().activateDockable(logWindow);
            GraphicsUtils.focusComponentOrChild((Component)this.getGUI(), (boolean)true);
        }
    }

    @Override
    public void close() {
        if (this.owner() != null) {
            this.owner().close();
        }
    }

    @Override
    public boolean isVisible() {
        if (this.owner() == null) {
            return false;
        }
        return this.owner().isVisible();
    }
}

